
INCLUDE(PackageAddExecutable)
INCLUDE(PackageAddTest)


MACRO(FWD_PARSE_ARG  VAR_TO_SET_OUT  ARGNAME)
  IF (PARSE_${ARGNAME})
    SET(${VAR_TO_SET_OUT} ${${VAR_TO_SET_OUT}} ${ARGNAME} ${PARSE_${ARGNAME}}) 
  ENDIF()
ENDMACRO()


MACRO(FWD_PARSE_OPT  VAR_TO_SET_OUT  OPTNAME)
  IF (PARSE_${OPTNAME})
    SET(${VAR_TO_SET_OUT} ${${VAR_TO_SET_OUT}} ${OPTNAME}) 
  ENDIF()
ENDMACRO()


#
# Add an executable and a test at the same time.
#
# PACKAGE_ADD_EXECUTABLE_AND_TEST(
#   <execName>
#   SOURCES <src1> <src2> ...
#   [NAME <testName> | NAME_POSTFIX <testNamePostfix>]
#   [CATEGORIES <category1>  <category2> ...]
#   [HOST <host1> <host2> ...]
#   [XHOST <host1> <host2> ...]
#   [HOSTTYPE <hosttype1> <hosttype2> ...]
#   [XHOSTTYPE <hosttype1> <hosttype2> ...]
#   [NOEXEPREFIX ]
#   [DIRECTORY <dir> ]
#   [DEPLIBS <lib1> <lib2> ... ]
#   [COMM [serial] [mpi] ]
#   [NUM_MPI_PROCS <numProcs>]
#   [LINKER_LANGUAGE [C|CXX|Fortran] ]
#   [ADD_DIR_TO_NAME ]
#   [DEFINES <-DSOMEDEFINE>]
#   [KEYWORDS <keyword1> <keyword2> ...]
#   [STANDARD_PASS_OUTPUT
#     | PASS_REGULAR_EXPRESSION "<regex1>;<regex2>;..."]
#   [FAIL_REGULAR_EXPRESSION "<regex1>;<regex2>;..."]
#   [WILL_FAIL]
#   )
#
# This function takes a fairly common set of arguments to
# PACKAGE_ADD_EXECUTABLE(...) and PACAKGE_ADD_TEST(...) but not the full set
# passed to PACAKGE_ADD_TEST(...).  See the documentation for
# PACKAGE_ADD_EXECUTABLE(...) and PACKAGE_ADD_TEST(...) to see which arguments
# are accpeted by which functions.
#

FUNCTION(PACKAGE_ADD_EXECUTABLE_AND_TEST EXE_NAME)
   
  #
  # A) Parse the input arguments
  #

  PARSE_ARGUMENTS(
     #prefix
     PARSE
     #lists
     "SOURCES;DEPLIBS;NAME;NAME_POSTFIX;NUM_MPI_PROCS;DIRECTORY;KEYWORDS;COMM;ARGS;NAME;PASS_REGULAR_EXPRESSION;CATEGORIES;HOST;XHOST;HOSTTYPE;XHOSTTYPE;FAIL_REGULAR_EXPRESSION;LINKER_LANGUAGE;DEFINES"
     #options
     "STANDARD_PASS_OUTPUT;WILL_FAIL;ADD_DIR_TO_NAME"
     ${ARGN}
     )

  IF(${PROJECT_NAME}_VERBOSE_CONFIGURE)
    MESSAGE("")
    MESSAGE("PACKAGE_ADD_EXECUTABLE_AND_TEST: ${EXE_NAME} ${ARGN}")
  ENDIF()

  #
  # B) Arguments common to both
  #

  SET(COMMON_CALL_ARGS "")
  FWD_PARSE_ARG(COMMON_CALL_ARGS COMM)
  FWD_PARSE_ARG(COMMON_CALL_ARGS CATEGORIES)
  FWD_PARSE_ARG(COMMON_CALL_ARGS HOST)
  FWD_PARSE_ARG(COMMON_CALL_ARGS XHOST)
  FWD_PARSE_ARG(COMMON_CALL_ARGS HOSTTYPE)
  FWD_PARSE_ARG(COMMON_CALL_ARGS XHOSTTYPE)

  #
  # C) PackageAddExecutable(...)
  #

  SET(CALL_ARGS "")
  FWD_PARSE_ARG(CALL_ARGS SOURCES)
  FWD_PARSE_ARG(CALL_ARGS DEPLIBS)
  FWD_PARSE_ARG(CALL_ARGS DIRECTORY)
  FWD_PARSE_OPT(CALL_ARGS ADD_DIR_TO_NAME)
  FWD_PARSE_ARG(CALL_ARGS LINKER_LANGUAGE)
  FWD_PARSE_ARG(CALL_ARGS DEFINES)

  PACKAGE_ADD_EXECUTABLE(${EXE_NAME} ${COMMON_CALL_ARGS} ${CALL_ARGS})

  #
  # D) PackageAddTest(...)
  #

  SET(CALL_ARGS "")
  FWD_PARSE_ARG(CALL_ARGS NAME)
  FWD_PARSE_ARG(CALL_ARGS NAME_POSTFIX)
  FWD_PARSE_ARG(CALL_ARGS DIRECTORY)
  FWD_PARSE_ARG(CALL_ARGS KEYWORDS)
  FWD_PARSE_ARG(CALL_ARGS NUM_MPI_PROCS)
  FWD_PARSE_ARG(CALL_ARGS ARGS)
  FWD_PARSE_ARG(CALL_ARGS PASS_REGULAR_EXPRESSION)
  FWD_PARSE_ARG(CALL_ARGS FAIL_REGULAR_EXPRESSION)
  FWD_PARSE_OPT(CALL_ARGS STANDARD_PASS_OUTPUT)
  FWD_PARSE_OPT(CALL_ARGS WILL_FAIL)
  FWD_PARSE_OPT(CALL_ARGS ADD_DIR_TO_NAME)

  PACKAGE_ADD_TEST(${EXE_NAME} ${COMMON_CALL_ARGS} ${CALL_ARGS})

ENDFUNCTION()
