# Check whether LAPACK includes the testing routines {S,D,C,Z}ARUV and
# {S,D,C,Z}ARNV, that generate normal(0,1) - distributed pseudorandom
# floating-point numbers (both real and complex).  These routines are
# in the LAPACK SRC/ directory and should be in every LAPACK library,
# whether commercial or built from source.

include (TsqrBlasAndLapack)
include (TsqrCheckLapackRoutine)

message (STATUS "Checking whether LAPACK includes pseudorandom number routines")
set (HAVE_LAPACK_PRNG_ROUTINES "TRUE")

# Do we have _LARUV for LAPACK datatypes {S,D}?  LARUV generates
# uniformly distributed random real numbers, which LARNV
# postprocesses.
foreach (_LAPACK_DATATYPE "D" "S")
  set (_LARUV_ROUTINE_NAME "${_LAPACK_DATATYPE}LARUV")
  set (_HAVE_LARUV "HAVE_LAPACK_${_LARUV_ROUTINE_NAME}")
  TSQR_CHECK_LAPACK_ROUTINE ("${_LARUV_ROUTINE_NAME}" "${_HAVE_LARUV}")
  if (NOT "${_HAVE_LARUV}")
    message (STATUS "${_LARUV_ROUTINE} is NOT in your LAPACK library")
    set (HAVE_LAPACK_PRNG_ROUTINES "FALSE")
  endif ()
endforeach ()

# Do we have _LARNV for LAPACK datatypes {S,D,C,Z}?  LARNV
# postprocesses the random numbers generated by LARUV.
foreach (_LAPACK_DATATYPE "D" "S" "Z" "C")
  set (_LARNV_ROUTINE_NAME "${_LAPACK_DATATYPE}LARNV")
  set (_HAVE_LARNV "HAVE_LAPACK_${_LARNV_ROUTINE_NAME}")
  TSQR_CHECK_LAPACK_ROUTINE ("${_LARUV_ROUTINE_NAME}" "${_HAVE_LARUV}")
  if (NOT "${_HAVE_LARNV}")
    message (STATUS "${_LARNV_ROUTINE} is NOT in your LAPACK library")
    set (HAVE_LAPACK_PRNG_ROUTINES "FALSE")
  endif ()
endforeach ()

if ("${HAVE_LAPACK_PRNG_ROUTINES}")
  message (STATUS "LAPACK includes all necessary pseudorandom number routines")
endif ()
