// $Id$
// $Source$

//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source$
//  $Author$
//  $Date$
//  $Revision$
// ************************************************************************
//@HEADER

// Finite Element Problem Class

#ifndef _FINITEELEMENTPROBLEM_H
#define _FINITEELEMENTPROBLEM_H

// Flag to tell the evaluate routine what objects to fill
enum FillType {F_ONLY, MATRIX_ONLY, ALL}; 

// Finite Element Problem Class
class FiniteElementProblem { 

public:

  // Constructor
  FiniteElementProblem() {}
  
  // Destructor
  virtual ~FiniteElementProblem() {}

  // Evaluates the function (F) and/or the Jacobian using the solution 
  // values in solnVector.
  virtual bool evaluate(FillType f, const Epetra_Vector *solnVector, 
			Epetra_Vector *rhsVector, 
			Epetra_RowMatrix *matrix,
			double jac_coeff = 1.0, 
			double mass_coeff = 0.0) = 0;

  // Return a reference to the Epetra_Vector with the initial guess
  // that is generated by the FiniteElementProblem class.
  virtual Epetra_Vector& getSolution() = 0;
  
  // Return a reference to the Epetra_Vector with the Jacobian
  // that is generated by the FiniteElementProblem class.
  virtual Epetra_CrsMatrix& getJacobian() = 0;

  // Set a bifurcation parameter in the application physics
  virtual bool setParameter(string label, double value) = 0;

};
#endif




