
// File: index.xml

// File: classTeuchos_1_1BadParameterEntryXMLConverterTypeException.xml
%feature("docstring")
Teuchos::BadParameterEntryXMLConverterTypeException "

Thrown when a converter is being used to convert either and XML tag or
ParameterEntry with an innappropriate type.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::BadParameterEntryXMLConverterTypeException::BadParameterEntryXMLConverterTypeException
"Teuchos::BadParameterEntryXMLConverterTypeException::BadParameterEntryXMLConverterTypeException(const
std::string &what_arg)

Constructs a BadParmaeterEntryXMLConverterTypeException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1BadParameterListElementException.xml
%feature("docstring") Teuchos::BadParameterListElementException "

Thrown when an element inside a parameter list is bad.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::BadParameterListElementException::BadParameterListElementException
"Teuchos::BadParameterListElementException::BadParameterListElementException(const
std::string &what_arg)

Constructs a BadParameterListElementException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1BadTagException.xml
%feature("docstring") Teuchos::BadTagException "

Thrown when xml tag is encountered that is either unrecognized or
inappropriate for a given context.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")  Teuchos::BadTagException::BadTagException "Teuchos::BadTagException::BadTagException(const std::string &what_arg)

Constructs a MissingValidatorDefinitionException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1BadValidatorXMLConverterException.xml
%feature("docstring") Teuchos::BadValidatorXMLConverterException "

Thrown when a bad validator xml converter is used.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::BadValidatorXMLConverterException::BadValidatorXMLConverterException
"Teuchos::BadValidatorXMLConverterException::BadValidatorXMLConverterException(const
std::string &what_arg)

Constructs an BadValidatorXMLConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1BadXMLParameterListRootElementException.xml
%feature("docstring") Teuchos::BadXMLParameterListRootElementException
"

Thrown when the root xml tag for a parameter list is incorrect.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::BadXMLParameterListRootElementException::BadXMLParameterListRootElementException
"Teuchos::BadXMLParameterListRootElementException::BadXMLParameterListRootElementException(const
std::string &what_arg)

Constructs a BadXMLParameterListRootElementException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1CantFindConditionConverterException.xml
%feature("docstring") Teuchos::CantFindConditionConverterException "

Thrown when an appropriate Condition Converter can't be found.

C++ includes: Teuchos_XMLConditionExceptions.hpp ";

%feature("docstring")
Teuchos::CantFindConditionConverterException::CantFindConditionConverterException
"Teuchos::CantFindConditionConverterException::CantFindConditionConverterException(const
std::string &what_arg)

Constructs an CantFindConditionConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1CantFindDependencyConverterException.xml
%feature("docstring") Teuchos::CantFindDependencyConverterException "

Thrown when an appropriate Dependency Converter can't be found.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::CantFindDependencyConverterException::CantFindDependencyConverterException
"Teuchos::CantFindDependencyConverterException::CantFindDependencyConverterException(const
std::string &what_arg)

Constructs an CantFindDependencyConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1CantFindFunctionObjectConverterException.xml
%feature("docstring")
Teuchos::CantFindFunctionObjectConverterException "

Thrown when an appropriate FunctionObject Converter can't be found.

C++ includes: Teuchos_XMLFunctionObjectExceptions.hpp ";

%feature("docstring")
Teuchos::CantFindFunctionObjectConverterException::CantFindFunctionObjectConverterException
"Teuchos::CantFindFunctionObjectConverterException::CantFindFunctionObjectConverterException(const
std::string &what_arg)

Constructs an CantFindFunctionObjectConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1CantFindParameterEntryConverterException.xml
%feature("docstring")
Teuchos::CantFindParameterEntryConverterException "

Thrown when an appropriate ParameterEntryXMLConverter can't be found.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::CantFindParameterEntryConverterException::CantFindParameterEntryConverterException
"Teuchos::CantFindParameterEntryConverterException::CantFindParameterEntryConverterException(const
std::string &what_arg)

Constructs an CantFindParameterEntryConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1CantFindValidatorConverterException.xml
%feature("docstring") Teuchos::CantFindValidatorConverterException "

Thrown when the ValidatorXMLConverterDB can't find an appropriate
converter.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::CantFindValidatorConverterException::CantFindValidatorConverterException
"Teuchos::CantFindValidatorConverterException::CantFindValidatorConverterException(const
std::string &what_arg)

Constructs a CantFindValidatorConverterException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1DuplicateParameterIDsException.xml
%feature("docstring") Teuchos::DuplicateParameterIDsException "

Thrown when two parameters in an XML file have the same ID.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::DuplicateParameterIDsException::DuplicateParameterIDsException
"Teuchos::DuplicateParameterIDsException::DuplicateParameterIDsException(const
std::string &what_arg)

Constructs an DuplicateParameterIDsException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1DuplicateValidatorIDsException.xml
%feature("docstring") Teuchos::DuplicateValidatorIDsException "

Constructs a CantFindParameterEntryConverterException.

Thrown when two validators in an XML file have the same ID.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::DuplicateValidatorIDsException::DuplicateValidatorIDsException
"Teuchos::DuplicateValidatorIDsException::DuplicateValidatorIDsException(const
std::string &what_arg)

Constructs an DuplicateValidatorIDsException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1EmptyXMLError.xml
%feature("docstring") Teuchos::EmptyXMLError "

Thrown when attempting to parse an empty XML std::string.

C++ includes: Teuchos_XMLObject.hpp ";

%feature("docstring")  Teuchos::EmptyXMLError::EmptyXMLError "Teuchos::EmptyXMLError::EmptyXMLError(const std::string &what_arg) ";


// File: classTeuchos_1_1FileInputSource.xml
%feature("docstring") Teuchos::FileInputSource "

Instantiation of XMLInputSource class for reading XML from a file.

C++ includes: Teuchos_FileInputSource.hpp ";

%feature("docstring")  Teuchos::FileInputSource::FileInputSource "FileInputSource::FileInputSource(const std::string &filename)

Constructor. ";

%feature("docstring")  Teuchos::FileInputSource::~FileInputSource "virtual Teuchos::FileInputSource::~FileInputSource()

Destructor. ";

%feature("docstring")  Teuchos::FileInputSource::stream "RCP<
XMLInputStream > FileInputSource::stream() const

Create a FileInputStream. ";


// File: classTeuchos_1_1Exceptions_1_1InvalidParameter.xml
%feature("docstring") Teuchos::Exceptions::InvalidParameter "C++
includes: Teuchos_ParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::Exceptions::InvalidParameter::InvalidParameter "Teuchos::Exceptions::InvalidParameter::InvalidParameter(const
std::string &what_arg) ";


// File: classTeuchos_1_1Exceptions_1_1InvalidParameterName.xml
%feature("docstring") Teuchos::Exceptions::InvalidParameterName "C++
includes: Teuchos_ParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::Exceptions::InvalidParameterName::InvalidParameterName "Teuchos::Exceptions::InvalidParameterName::InvalidParameterName(const
std::string &what_arg) ";


// File: classTeuchos_1_1Exceptions_1_1InvalidParameterType.xml
%feature("docstring") Teuchos::Exceptions::InvalidParameterType "C++
includes: Teuchos_ParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::Exceptions::InvalidParameterType::InvalidParameterType "Teuchos::Exceptions::InvalidParameterType::InvalidParameterType(const
std::string &what_arg) ";


// File: classTeuchos_1_1Exceptions_1_1InvalidParameterValue.xml
%feature("docstring") Teuchos::Exceptions::InvalidParameterValue "C++
includes: Teuchos_ParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::Exceptions::InvalidParameterValue::InvalidParameterValue "Teuchos::Exceptions::InvalidParameterValue::InvalidParameterValue(const
std::string &what_arg) ";


// File: classTeuchos_1_1MissingConditionTagException.xml
%feature("docstring") Teuchos::MissingConditionTagException "

Thrown when no condtion tag is found when converting a
ConditionVisualDependency from XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingConditionTagException::MissingConditionTagException "Teuchos::MissingConditionTagException::MissingConditionTagException(const
std::string &what_arg)

Constructs an MissingConditionTagException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingDependeeException.xml
%feature("docstring") Teuchos::MissingDependeeException "

Thrown when no dependes of a dependency can't be found when converting
the dependency to or from XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingDependeeException::MissingDependeeException "Teuchos::MissingDependeeException::MissingDependeeException(const
std::string &what_arg)

Constructs an MissingDependeeException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingDependeesException.xml
%feature("docstring") Teuchos::MissingDependeesException "

Thrown when no dependess of a dependency are specified when converting
the dependency from XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingDependeesException::MissingDependeesException "Teuchos::MissingDependeesException::MissingDependeesException(const
std::string &what_arg)

Constructs an MissingDependeesException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingDependentException.xml
%feature("docstring") Teuchos::MissingDependentException "

Thrown when a dependent of a dependency cant be found when converting
the dependency to or from XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingDependentException::MissingDependentException "Teuchos::MissingDependentException::MissingDependentException(const
std::string &what_arg)

Constructs an MissingDependentException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingDependentsException.xml
%feature("docstring") Teuchos::MissingDependentsException "

Thrown when no dependents of a dependency are specified when
converting the dependency from XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingDependentsException::MissingDependentsException "Teuchos::MissingDependentsException::MissingDependentsException(const
std::string &what_arg)

Constructs an MissingDependentsException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingParameterEntryDefinitionException.xml
%feature("docstring")
Teuchos::MissingParameterEntryDefinitionException "

Thrown when a referenced ParameterEntry can't be found.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::MissingParameterEntryDefinitionException::MissingParameterEntryDefinitionException
"Teuchos::MissingParameterEntryDefinitionException::MissingParameterEntryDefinitionException(const
std::string &what_arg)

Constructs a MissingParameterEntryDefinitionException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingRangesAndValidatorsTagException.xml
%feature("docstring") Teuchos::MissingRangesAndValidatorsTagException
"

Thrown when the rangesAndValidators tag for the
RangeValidatorDepencyConverter can't be found.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingRangesAndValidatorsTagException::MissingRangesAndValidatorsTagException
"Teuchos::MissingRangesAndValidatorsTagException::MissingRangesAndValidatorsTagException(const
std::string &what_arg)

Constructs an MissingRangesAndValidatorsTagException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingValidatorDefinitionException.xml
%feature("docstring") Teuchos::MissingValidatorDefinitionException "

Thrown when a referenced validator can't be found.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::MissingValidatorDefinitionException::MissingValidatorDefinitionException
"Teuchos::MissingValidatorDefinitionException::MissingValidatorDefinitionException(const
std::string &what_arg)

Constructs a MissingValidatorDefinitionException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingValidatorException.xml
%feature("docstring") Teuchos::MissingValidatorException "

Thrown when converting a dependency that has validaotrs to and from
XML. This excetpion indicates that a specified validator could not be
found.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingValidatorException::MissingValidatorException "Teuchos::MissingValidatorException::MissingValidatorException(const
std::string &what_arg)

Constructs an MissingValidatorException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingValuesAndValidatorsTagException.xml
%feature("docstring") Teuchos::MissingValuesAndValidatorsTagException
"

Thrown when converting a StrinvValidatorDependcny from XML and no
valuesAndValidators tag is found.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::MissingValuesAndValidatorsTagException::MissingValuesAndValidatorsTagException
"Teuchos::MissingValuesAndValidatorsTagException::MissingValuesAndValidatorsTagException(const
std::string &what_arg)

Constructs an MissingValuesAndValidatorsTagException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1MissingValuesTagException.xml
%feature("docstring") Teuchos::MissingValuesTagException "

Thrown when a StringConditon is missing it's Value tag.

C++ includes: Teuchos_XMLConditionExceptions.hpp ";

%feature("docstring")
Teuchos::MissingValuesTagException::MissingValuesTagException "Teuchos::MissingValuesTagException::MissingValuesTagException(const
std::string &what_arg)

Constructs an MissingValuesTagException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1NoNameAttributeExecption.xml
%feature("docstring") Teuchos::NoNameAttributeExecption "

Thrown when a parameter entry tag is missing it's name attribute.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::NoNameAttributeExecption::NoNameAttributeExecption "Teuchos::NoNameAttributeExecption::NoNameAttributeExecption(const
std::string &what_arg)

Constructs a NoNameAttributeExecption.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1NoTypeAttributeExecption.xml
%feature("docstring") Teuchos::NoTypeAttributeExecption "

Thrown when a parameter entry tag is missing it's type attribute.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::NoTypeAttributeExecption::NoTypeAttributeExecption "Teuchos::NoTypeAttributeExecption::NoTypeAttributeExecption(const
std::string &what_arg)

Constructs a NoTypeAttributeExecption.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1NoValueAttributeExecption.xml
%feature("docstring") Teuchos::NoValueAttributeExecption "

Thrown when a parameter entry tag is missing it's value attribute.

C++ includes: Teuchos_XMLParameterListExceptions.hpp ";

%feature("docstring")
Teuchos::NoValueAttributeExecption::NoValueAttributeExecption "Teuchos::NoValueAttributeExecption::NoValueAttributeExecption(const
std::string &what_arg)

Constructs a NoValueAttributeExecption.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1ParameterList.xml
%feature("docstring") Teuchos::ParameterList "

Templated parameter list.

Parameters can be added and retreived with the templated \"get\" and
\"set\" functions. These parameters can any data type which uses value
sementics (e.g. double, float, int, *double, *float, *int, ...) which
includes other parameter lists, allowing for a hierarchy of parameter
lists. These parameters can also be pointers to vectors or functions.

Use static_cast<T>() when the type is ambiguous.

Both char* and std::string std::map to are stored as strings
internally.

C++ includes: Teuchos_ParameterList.hpp ";

/*  Public types  */

/*  Constructors/Destructor/Info.  */

%feature("docstring")  Teuchos::ParameterList::ParameterList "Teuchos::ParameterList::ParameterList()

Constructor. ";

%feature("docstring")  Teuchos::ParameterList::ParameterList "Teuchos::ParameterList::ParameterList(const std::string &name)

Constructor. ";

%feature("docstring")  Teuchos::ParameterList::ParameterList "Teuchos::ParameterList::ParameterList(const ParameterList &source)

Copy Constructor. ";

%feature("docstring")  Teuchos::ParameterList::~ParameterList "Teuchos::ParameterList::~ParameterList()

Deconstructor. ";

%feature("docstring")  Teuchos::ParameterList::numParams "Ordinal
Teuchos::ParameterList::numParams() const

Get the number of stored parameters. ";

/*  Set Functions  */

%feature("docstring")  Teuchos::ParameterList::setName "ParameterList
& Teuchos::ParameterList::setName(const std::string &name)

Set the name of *this list. ";

%feature("docstring")  Teuchos::ParameterList::setParameters "ParameterList & Teuchos::ParameterList::setParameters(const
ParameterList &source)

Set the parameters in source.

Note, this function will set the parameters and sublists from source
into *this but will not result in parameters being removed from *this.
Parameters in *this with the same names as those in source will be
overwritten. ";

%feature("docstring")
Teuchos::ParameterList::setParametersNotAlreadySet "ParameterList &
Teuchos::ParameterList::setParametersNotAlreadySet(const ParameterList
&source)

Set the parameters in source that are not already set in *this.

Note, this function will set the parameters and sublists from source
into *this but will not result in parameters being removed from *this
or in parameters already set in *this being overrided. Parameters in
*this with the same names as those in source will not be overwritten.
";

%feature("docstring")
Teuchos::ParameterList::disableRecursiveValidation "ParameterList &
Teuchos::ParameterList::disableRecursiveValidation()

Disallow recusive validation when this sublist is used in a valid
parameter list.

This function should be called when setting a sublist in a valid
parameter list which is broken off to be passed to another object. The
other object should validate its own list. ";

%feature("docstring")  Teuchos::ParameterList::set "ParameterList &
Teuchos::ParameterList::set(std::string const &name, T const &value,
std::string const &docString=\"\", RCP< const ParameterEntryValidator
> const &validator=null)

Sets different types of parameters. The type depends on the second
entry.

Use static_cast<T>() when the type is ambiguous.

Both char* and std::string std::map to are stored as strings
internally.

Sets the parameter as \"unused\". ";

%feature("docstring")  Teuchos::ParameterList::set "ParameterList &
Teuchos::ParameterList::set(std::string const &name, char value[],
std::string const &docString=\"\", RCP< const ParameterEntryValidator
> const &validator=null)

Specialization for the case when a user sets the parameter with a
character std::string in parenthesis. ";

%feature("docstring")  Teuchos::ParameterList::set "ParameterList&
Teuchos::ParameterList::set(std::string const &name, const char
value[], std::string const &docString=\"\", RCP< const
ParameterEntryValidator > const &validator=null)

Specialization for the case when a user sets the parameter with a
character std::string in parenthesis. ";

%feature("docstring")  Teuchos::ParameterList::set "ParameterList &
Teuchos::ParameterList::set(std::string const &name, ParameterList
const &value, std::string const &docString=\"\")

Template specialization for the case when a user sets the parameter
with a ParameterList. ";

%feature("docstring")  Teuchos::ParameterList::setEntry "ParameterList & Teuchos::ParameterList::setEntry(const std::string
&name, const ParameterEntry &entry)

Set a parameter directly as a ParameterEntry.

This is required to preserve the isDefault value when reading back
from XML. KL 7 August 2004 ";

/*  Get Functions  */

%feature("docstring")  Teuchos::ParameterList::get "T &
Teuchos::ParameterList::get(const std::string &name, T def_value)

Retrieves parameter name of type T from list, if it exists, else the
def_value is used to enter a new parameter into the list.

Use the static_cast<T>() when the type is ambiguous.

Both char* and std::string std::map to are stored as strings
internally.

Sets the parameter as \"used\".

Exception is thrown if name exists, but is not of type T. ";

%feature("docstring")  Teuchos::ParameterList::get "std::string &
Teuchos::ParameterList::get(const std::string &name, char def_value[])

Specialization of get, where the nominal value is a character
std::string in parenthesis. Both char* and std::string are stored as
strings and return std::string values. ";

%feature("docstring")  Teuchos::ParameterList::get "std::string&
Teuchos::ParameterList::get(const std::string &name, const char
def_value[])

Specialization of get, where the nominal value is a character
std::string in parenthesis. Both char* and std::string are stored as
strings and return std::string values. ";

%feature("docstring")  Teuchos::ParameterList::get "T &
Teuchos::ParameterList::get(const std::string &name)

Retrieves parameter name of type T from a list, an
Exceptions::InvalidParameter std::exception is thrown if this
parameter doesn't exist (  Exceptions::InvalidParameterName) or is the
wrong type (  Exceptions::InvalidParameterType).

The syntax for calling this method is:  list.template get<int>(
\"Iters\" ) ";

%feature("docstring")  Teuchos::ParameterList::get "const T &
Teuchos::ParameterList::get(const std::string &name) const

Retrieves parameter name of type T from a constant list, an
Exceptions::InvalidParameter std::exception is thrown if this
parameter doesn't exist (  Exceptions::InvalidParameterName) or is the
wrong type (  Exceptions::InvalidParameterType).

The syntax for calling this method is:  list.template get<int>(
\"Iters\" ) ";

%feature("docstring")  Teuchos::ParameterList::getPtr "T *
Teuchos::ParameterList::getPtr(const std::string &name)

Retrieves the pointer for parameter name of type T from a list. A null
pointer is returned if this parameter doesn't exist or is the wrong
type.

The syntax for calling this method is:  list.template getPtr<int>(
\"Iters\" ) ";

%feature("docstring")  Teuchos::ParameterList::getPtr "const T *
Teuchos::ParameterList::getPtr(const std::string &name) const

Retrieves the pointer for parameter name of type T from a constant
list. A null pointer is returned if this parameter doesn't exist or is
the wrong type.

The syntax for calling this method is:  list.template getPtr<int>(
\"Iters\" ) ";

%feature("docstring")  Teuchos::ParameterList::getEntry "ParameterEntry & Teuchos::ParameterList::getEntry(const std::string
&name)

Retrieves an entry with the name name.

Throws  Exceptions::InvalidParameterName if this parameter does not
exist. ";

%feature("docstring")  Teuchos::ParameterList::getEntry "const
ParameterEntry & Teuchos::ParameterList::getEntry(const std::string
&name) const

Retrieves a const entry with the name name.

Throws  Exceptions::InvalidParameterName if this parameter does not
exist. ";

%feature("docstring")  Teuchos::ParameterList::getEntryPtr "ParameterEntry * Teuchos::ParameterList::getEntryPtr(const std::string
&name)

Retrieves the pointer for an entry with the name name if it exists. ";

%feature("docstring")  Teuchos::ParameterList::getEntryPtr "const
ParameterEntry * Teuchos::ParameterList::getEntryPtr(const std::string
&name) const

Retrieves the pointer for a constant entry with the name name if it
exists. ";

%feature("docstring")  Teuchos::ParameterList::getEntryRCP "RCP<
ParameterEntry > Teuchos::ParameterList::getEntryRCP(const std::string
&name)

Retrieves the RCP for an entry with the name name if it exists. ";

%feature("docstring")  Teuchos::ParameterList::getEntryRCP "RCP<
const ParameterEntry > Teuchos::ParameterList::getEntryRCP(const
std::string &name) const

Retrieves the RCP for a constant entry with the name name if it
exists. ";

/*  Parameter removal functions  */

%feature("docstring")  Teuchos::ParameterList::remove "bool
Teuchos::ParameterList::remove(std::string const &name, bool
throwIfNotExists=true)

Remove a parameter (does not depend on the type of the parameter).

Parameters:
-----------

name:  [in] The name of the parameter to remove

throwIfNotExists:  [in] If true then if the parameter with the name
name does not exist then a std::exception will be thrown!

Returns true if the parameter was removed, and false if the parameter
was not removed ( false return value possible only if
throwIfExists==false). ";

/*  Sublist Functions  */

%feature("docstring")  Teuchos::ParameterList::sublist "ParameterList
& Teuchos::ParameterList::sublist(const std::string &name, bool
mustAlreadyExist=false, const std::string &docString=\"\")

Creates an empty sublist and returns a reference to the sublist name.
If the list already exists, returns reference to that sublist. If the
name exists but is not a sublist, an std::exception is thrown. ";

%feature("docstring")  Teuchos::ParameterList::sublist "const
ParameterList & Teuchos::ParameterList::sublist(const std::string
&name) const

Return a const reference to an existing sublist name. If the list does
not already exist or the name exists but is not a sublist, an
std::exception is thrown. ";

/*  Attribute Functions  */

%feature("docstring")  Teuchos::ParameterList::name "const
std::string & Teuchos::ParameterList::name() const

Query the name of this parameter list. ";

%feature("docstring")  Teuchos::ParameterList::isParameter "bool
Teuchos::ParameterList::isParameter(const std::string &name) const

Query the existence of a parameter.

\"true\" if a parameter with this name exists, else \"false\".
Warning, this function should almost never be used! Instead, consider
using getEntryPtr() instead. ";

%feature("docstring")  Teuchos::ParameterList::isSublist "bool
Teuchos::ParameterList::isSublist(const std::string &name) const

Query the existence of a parameter and whether it is a parameter list.

\"true\" if a parameter with this name exists and is itself a
parameter list, else \"false\". Warning, this function should almost
never be used! Instead, consider using getEntryPtr() instead. ";

%feature("docstring")  Teuchos::ParameterList::isType "bool
Teuchos::ParameterList::isType(const std::string &name) const

Query the existence and type of a parameter.

\"true\" is a parameter with this name exists and is of type T, else
\"false\".

The syntax for calling this method is:  list.template isType<int>(
\"Iters\" ). Warning, this function should almost never be used!
Instead, consider using getEntryPtr() instead. ";

%feature("docstring")  Teuchos::ParameterList::isType "bool
Teuchos::ParameterList::isType(const std::string &name, T *ptr) const

Query the existence and type of a parameter.

\"true\" is a parameter with this name exists and is of type T, else
\"false\".

It is not recommended that this method be used directly!  Please use
either the helper function isParameterType or non-nominal isType
method. ";

/*  I/O Functions  */

%feature("docstring")  Teuchos::ParameterList::print "void
Teuchos::ParameterList::print() const

Print function to use in debugging in a debugger.

Prints to *VerboseObjectBase::getDefaultOStream() so it will print
well in parallel. ";

%feature("docstring")  Teuchos::ParameterList::print "std::ostream &
Teuchos::ParameterList::print(std::ostream &os, const PrintOptions
&printOptions) const

Printing method for parameter lists which takes an print options
object. ";

%feature("docstring")  Teuchos::ParameterList::print "std::ostream &
Teuchos::ParameterList::print(std::ostream &os, int indent=0, bool
showTypes=false, bool showFlags=true) const

Printing method for parameter lists. Indenting is used to indicate
parameter list hierarchies. ";

%feature("docstring")  Teuchos::ParameterList::unused "void
Teuchos::ParameterList::unused(std::ostream &os) const

Print out unused parameters in the ParameterList. ";

%feature("docstring")  Teuchos::ParameterList::currentParametersString
"std::string Teuchos::ParameterList::currentParametersString() const

Create a single formated std::string of all of the zero-level
parameters in this list. ";

/*  Read-only access to the iterator  */

%feature("docstring")  Teuchos::ParameterList::begin "ParameterList::ConstIterator Teuchos::ParameterList::begin() const

An iterator pointing to the first entry. ";

%feature("docstring")  Teuchos::ParameterList::end "ParameterList::ConstIterator Teuchos::ParameterList::end() const

An iterator pointing beyond the last entry. ";

%feature("docstring")  Teuchos::ParameterList::name "const
std::string & Teuchos::ParameterList::name(ConstIterator i) const

Access to name (i.e., returns i->first) ";

%feature("docstring")  Teuchos::ParameterList::entry "const
ParameterEntry & Teuchos::ParameterList::entry(ConstIterator i) const

Access to ParameterEntry (i.e., returns i->second) ";

/*  Validation Functions  */

%feature("docstring")  Teuchos::ParameterList::validateParameters "void Teuchos::ParameterList::validateParameters(ParameterList const
&validParamList, int const depth=1000, EValidateUsed const
validateUsed=VALIDATE_USED_ENABLED, EValidateDefaults const
validateDefaults=VALIDATE_DEFAULTS_ENABLED) const

Validate the parameters in this list given valid selections in the
input list.

Parameters:
-----------

validParamList:  [in] This is the list that the parameters and sublist
in *this are compared against.

depth:  [in] Determines the number of levels of depth that the
validation will recurse into. A value of depth=0 means that only the
top level parameters and sublists will be checked. Default: depth =
large number.

validateUsed:  [in] Determines if parameters that have been used are
checked against those in validParamList. Default: validateDefaults =
VALIDATE_DEFAULTS_ENABLED.

validateDefaults:  [in] Determines if parameters set at their default
values using get(name,defaultVal) are checked against those in
validParamList. Default: validateDefaults = VALIDATE_DEFAULTS_ENABLED.

If a parameter in *this is not found in validParamList then an
std::exception of type  Exceptions::InvalidParameterName will be
thrown which will contain an excellent error message returned by
excpt.what(). If the parameter exists but has the wrong type, then an
std::exception type  Exceptions::InvalidParameterType will be thrown.
If the parameter exists and has the right type, but the value is not
valid then an std::exception type  Exceptions::InvalidParameterValue
will be thrown.

Recursive validation stops when: The maxinum depth is reached

A sublist note in validParamList has been marked with the
disableRecursiveValidation() function, or

There are not more parameters or sublists left in *this

A breath-first search is performed to validate all of the parameters
in one sublist before moving into nested subslist. ";

%feature("docstring")
Teuchos::ParameterList::validateParametersAndSetDefaults "void
Teuchos::ParameterList::validateParametersAndSetDefaults(ParameterList
const &validParamList, int const depth=1000)

Validate the parameters in this list given valid selections in the
input list and set defaults for those not set.

Parameters:
-----------

validParamList:  [in] This is the list that the parameters and sublist
in *this are compared against.

depth:  [in] Determines the number of levels of depth that the
validation will recurse into. A value of depth=0 means that only the
top level parameters and sublists will be checked. Default: depth =
large number.

If a parameter in *this is not found in validParamList then an
std::exception of type  Exceptions::InvalidParameterName will be
thrown which will contain an excellent error message returned by
excpt.what(). If the parameter exists but has the wrong type, then an
std::exception type  Exceptions::InvalidParameterType will be thrown.
If the parameter exists and has the right type, but the value is not
valid then an std::exception type  Exceptions::InvalidParameterValue
will be thrown. If a parameter in validParamList does not exist in
*this, then it will be set at its default value as determined by
validParamList.

Recursive validation stops when: The maxinum depth is reached

A sublist note in validParamList has been marked with the
disableRecursiveValidation() function, or

There are not more parameters or sublists left in *this

A breath-first search is performed to validate all of the parameters
in one sublist before moving into nested subslist. ";


// File: classTeuchos_1_1ParameterListAcceptor.xml
%feature("docstring") Teuchos::ParameterListAcceptor "

Base class objects that can accept a parameter list.

ToDo: Finish Documentation!

C++ includes: Teuchos_ParameterListAcceptor.hpp ";

/*  Pure virtual functions that must be overridden in subclasses  */

%feature("docstring")
Teuchos::ParameterListAcceptor::setParameterList "virtual void
Teuchos::ParameterListAcceptor::setParameterList(RCP< ParameterList >
const &paramList)=0

Set parameters from a parameter list and return with default values.

Parameters:
-----------

paramList:  [in] On input contains the parameters set by the client.
Note that *paramList may have parameters set to their default values
added while the list is being parsed either right away or later.

Preconditions:  paramList.get() != NULL

Postconditions:  this-> getParameterList(). get() == paramList.get()

This is parameter list is \"remembered\" by *this object until it is
unset using  unsetParameterList().

Note: When this parameter list is passed in it is assumed that the
client has finished setting all of the values that they want to set so
that the list is completely ready to read (and be validated) by *this
object. If the client is to change this parameter list by adding new
options or changing the value of current options, the behavior of
*this object is undefined. This is because, the object may read the
options from *paramList right away or may wait to read some options
until a later time. There should be no expectation that if an option
is changed by the client that this will automatically be recognized by
*this object. To change even one parameter, this function must be
called again, with the entire sublist. ";

%feature("docstring")
Teuchos::ParameterListAcceptor::getNonconstParameterList "virtual
RCP<ParameterList>
Teuchos::ParameterListAcceptor::getNonconstParameterList()=0

Get the parameter list that was set using  setParameterList(). ";

%feature("docstring")
Teuchos::ParameterListAcceptor::unsetParameterList "virtual
RCP<ParameterList>
Teuchos::ParameterListAcceptor::unsetParameterList()=0

Unset the parameter list that was set using  setParameterList().

This just means that the parameter list that was set using
setParameterList() is detached from this object. This does not mean
that the effect of the parameters is undone.

Postconditions:  this-> getParameterList(). get() == NULL ";

/*  Virtual functions with default implementation  */

%feature("docstring")
Teuchos::ParameterListAcceptor::getParameterList "Teuchos::RCP< const
Teuchos::ParameterList >
Teuchos::ParameterListAcceptor::getParameterList() const

Get const version of the parameter list that was set using
setParameterList().

The default implementation returns: ";

%feature("docstring")
Teuchos::ParameterListAcceptor::getValidParameters "Teuchos::RCP<
const Teuchos::ParameterList >
Teuchos::ParameterListAcceptor::getValidParameters() const

Return a const parameter list of all of the valid parameters that
this->setParameterList(...) will accept.

The default implementation returns Teuchos::null. ";

%feature("docstring")  Teuchos::ParameterListAcceptor::getDependencies
"RCP< const DependencySheet >
Teuchos::ParameterListAcceptor::getDependencies() const

Rreturn a const Dependency Sheet of all the dependencies that should
be applied to the parameter list return by this->
getValidParameters().

The default implementation returns Teuchos::null. ";

%feature("docstring")
Teuchos::ParameterListAcceptor::~ParameterListAcceptor "Teuchos::ParameterListAcceptor::~ParameterListAcceptor() ";


// File: classTeuchos_1_1ParameterListAcceptorDefaultBase.xml
%feature("docstring") Teuchos::ParameterListAcceptorDefaultBase "

Intermediate node base class for objects that accept parameter lists
that implements some of the needed behavior automatically.

Subclasses just need to implement  setParameterList() and
getValidParameters(). The underlying parameter list is accessed using
the non-virtual protected members  setMyParamList() and
getMyParamList().

C++ includes: Teuchos_ParameterListAcceptorDefaultBase.hpp ";

/*  Overridden from ParameterListAcceptor  */

%feature("docstring")
Teuchos::ParameterListAcceptorDefaultBase::getNonconstParameterList "RCP< ParameterList >
Teuchos::ParameterListAcceptorDefaultBase::getNonconstParameterList()
";

%feature("docstring")
Teuchos::ParameterListAcceptorDefaultBase::unsetParameterList "RCP<
ParameterList >
Teuchos::ParameterListAcceptorDefaultBase::unsetParameterList() ";

%feature("docstring")
Teuchos::ParameterListAcceptorDefaultBase::getParameterList "RCP<
const ParameterList >
Teuchos::ParameterListAcceptorDefaultBase::getParameterList() const ";

/*  Protected accessors to actual parameter list object.  */


// File: classTeuchos_1_1ParameterListNonAcceptor.xml
%feature("docstring") Teuchos::ParameterListNonAcceptor "

Mix-in implementation subclass to be inherited by concrete subclasses
who's interface says that they take a parameter list but do not have
any parameters yet.

ToDo: Finish documention.

C++ includes: Teuchos_ParameterListNonAcceptor.hpp ";

/*  Overridden from ParameterListAcceptor  */

%feature("docstring")
Teuchos::ParameterListNonAcceptor::setParameterList "void
Teuchos::ParameterListNonAcceptor::setParameterList(RCP< ParameterList
> const &paramList)

Accepts a parameter list but asserts that it is empty. ";

%feature("docstring")
Teuchos::ParameterListNonAcceptor::getValidParameters "RCP< const
ParameterList >
Teuchos::ParameterListNonAcceptor::getValidParameters() const

Returns a non-null but empty parameter list. ";


// File: classTeuchos_1_1ParameterList_1_1PrintOptions.xml
%feature("docstring") Teuchos::ParameterList::PrintOptions "

Utility class for setting and passing in print options.

C++ includes: Teuchos_ParameterList.hpp ";

%feature("docstring")
Teuchos::ParameterList::PrintOptions::PrintOptions "Teuchos::ParameterList::PrintOptions::PrintOptions() ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::indent "PrintOptions& Teuchos::ParameterList::PrintOptions::indent(int
_indent) ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showTypes
"PrintOptions& Teuchos::ParameterList::PrintOptions::showTypes(bool
_showTypes) ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showFlags
"PrintOptions& Teuchos::ParameterList::PrintOptions::showFlags(bool
_showFlags) ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showDoc "PrintOptions& Teuchos::ParameterList::PrintOptions::showDoc(bool
_showDoc) ";

%feature("docstring")
Teuchos::ParameterList::PrintOptions::incrIndent "PrintOptions&
Teuchos::ParameterList::PrintOptions::incrIndent(int indents) ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::indent "int Teuchos::ParameterList::PrintOptions::indent() const ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showTypes
"bool Teuchos::ParameterList::PrintOptions::showTypes() const ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showFlags
"bool Teuchos::ParameterList::PrintOptions::showFlags() const ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::showDoc "bool Teuchos::ParameterList::PrintOptions::showDoc() const ";

%feature("docstring")  Teuchos::ParameterList::PrintOptions::copy "PrintOptions Teuchos::ParameterList::PrintOptions::copy() const ";


// File: structTeuchos_1_1ScalarTraits_3_01char_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< char > " ";


// File: structTeuchos_1_1ScalarTraits_3_01double_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< double > " ";


// File: structTeuchos_1_1ScalarTraits_3_01float_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< float > " ";


// File: structTeuchos_1_1ScalarTraits_3_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< int > " ";


// File: structTeuchos_1_1ScalarTraits_3_01long_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< long int > " ";


// File: structTeuchos_1_1ScalarTraits_3_01long_01unsigned_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< long unsigned int > " ";


// File: structTeuchos_1_1ScalarTraits_3_01short_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< short int > " ";


// File: structTeuchos_1_1ScalarTraits_3_01unsigned_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< unsigned int > " ";


// File: structTeuchos_1_1ScalarTraits_3_01unsigned_01short_01int_01_4.xml
%feature("docstring") Teuchos::ScalarTraits< unsigned short int > " ";


// File: classTeuchos_1_1StringInputSource.xml
%feature("docstring") Teuchos::StringInputSource "

Instantiation of XMLInputSource class for reading XML from a
std::string.

C++ includes: Teuchos_StringInputSource.hpp ";

%feature("docstring")  Teuchos::StringInputSource::StringInputSource "StringInputSource::StringInputSource(const std::string &text)

Constructor. ";

%feature("docstring")  Teuchos::StringInputSource::~StringInputSource
"virtual Teuchos::StringInputSource::~StringInputSource()

Destructor. ";

%feature("docstring")  Teuchos::StringInputSource::stream "RCP<
XMLInputStream > StringInputSource::stream() const

Create a StringInputStream. ";


// File: classTeuchos_1_1Time.xml
%feature("docstring") Teuchos::Time "

Basic wall-clock timer class.

To time a section of code, place it in between calls to start() and
stop().

For std::exception safety and correct behavior in reentrant code, this
class should generally be used only through the Teuchos::TimeMonitor
mechanism.

C++ includes: Teuchos_Time.hpp ";

%feature("docstring")  Teuchos::Time::Time "Teuchos::Time::Time(const
std::string &name, bool start=false)

Construct with a descriptive name. ";

%feature("docstring")  Teuchos::Time::start "void
Teuchos::Time::start(bool reset=false)

Starts the timer. ";

%feature("docstring")  Teuchos::Time::stop "double
Teuchos::Time::stop()

Stops the timer. ";

%feature("docstring")  Teuchos::Time::totalElapsedTime "double
Teuchos::Time::totalElapsedTime(bool readCurrentTime=false) const

Returns the total time (in seconds) accumulated by this timer.

This should be called only when the clock is stopped. ";

%feature("docstring")  Teuchos::Time::reset "void
Teuchos::Time::reset()

Resets the cummulative time and number of times this timer has been
called. Does not affect any other state. ";

%feature("docstring")  Teuchos::Time::isRunning "bool
Teuchos::Time::isRunning() const

Indicates if this timer is currently running, i.e., if it has been
started but not yet stopped.

It is necessary to know if a timer is running to avoid incorrectly
starting or stopping in reentrant code. ";

%feature("docstring")  Teuchos::Time::name "const std::string&
Teuchos::Time::name() const

Return the name of this timer. ";

%feature("docstring")  Teuchos::Time::incrementNumCalls "void
Teuchos::Time::incrementNumCalls()

Increment the number of times this timer has been called. ";

%feature("docstring")  Teuchos::Time::numCalls "int
Teuchos::Time::numCalls() const

Return the number of times this timer has been called. ";


// File: classTeuchos_1_1TooManyDependeesException.xml
%feature("docstring") Teuchos::TooManyDependeesException "

Thrown when a Dependency has too many dependees specified in its XML.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::TooManyDependeesException::TooManyDependeesException "Teuchos::TooManyDependeesException::TooManyDependeesException(const
std::string &what_arg)

Constructs an TooManyDependeesException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1TypeNameTraits_3_01ParameterList_01_4.xml
%feature("docstring") Teuchos::TypeNameTraits< ParameterList > "

Traits specialization.

C++ includes: Teuchos_ParameterList.hpp ";


// File: classTeuchos_1_1ValuesTagMissingException.xml
%feature("docstring") Teuchos::ValuesTagMissingException "

Thrown when a StringVisualDependency is being converted from XML and
no Values tag is found.

C++ includes: Teuchos_XMLDependencyExceptions.hpp ";

%feature("docstring")
Teuchos::ValuesTagMissingException::ValuesTagMissingException "Teuchos::ValuesTagMissingException::ValuesTagMissingException(const
std::string &what_arg)

Constructs an ValuesTagMissingException.

Parameters:
-----------

what_arg:  The error message to be associated with this error. ";


// File: classTeuchos_1_1XMLInputSource.xml
%feature("docstring") Teuchos::XMLInputSource "

XMLInputSource represents a source of XML input that can be parsed to
produce an XMLObject.

The source might be a file, a socket, a std::string. The XMLObject is
created with a call to the getObject() method.

The source gets its data from a XMLInputStream object that is created
(internally) to work with this source.

getObject() is implemented with EXPAT if Teuchos is configured with
--enable-expat.

C++ includes: Teuchos_XMLInputSource.hpp ";

%feature("docstring")  Teuchos::XMLInputSource::XMLInputSource "Teuchos::XMLInputSource::XMLInputSource()

Empty constructor. ";

%feature("docstring")  Teuchos::XMLInputSource::~XMLInputSource "virtual Teuchos::XMLInputSource::~XMLInputSource()

Destructor. ";

%feature("docstring")  Teuchos::XMLInputSource::stream "virtual
RCP<XMLInputStream> Teuchos::XMLInputSource::stream() const =0

Virtual input source interface. ";

%feature("docstring")  Teuchos::XMLInputSource::getObject "XMLObject
XMLInputSource::getObject() const

Get an object by invoking the TreeBuildingXMLHandler on the input
data. ";


// File: classTeuchos_1_1XMLInputStream.xml
%feature("docstring") Teuchos::XMLInputStream "

XMLInputStream represents an XML input stream that can be used by a
XMLInputSource.

C++ includes: Teuchos_XMLInputStream.hpp ";

%feature("docstring")  Teuchos::XMLInputStream::XMLInputStream "Teuchos::XMLInputStream::XMLInputStream()

Constructor. ";

%feature("docstring")  Teuchos::XMLInputStream::~XMLInputStream "virtual Teuchos::XMLInputStream::~XMLInputStream()

Destructor. ";

%feature("docstring")  Teuchos::XMLInputStream::readBytes "virtual
unsigned int Teuchos::XMLInputStream::readBytes(unsigned char *const
toFill, const unsigned int maxToRead)=0

Read up to maxToRead bytes from the stream. ";

%feature("docstring")  Teuchos::XMLInputStream::curPos "unsigned int
XMLInputStream::curPos() const

Identify current position. ";


// File: classTeuchos_1_1XMLObject.xml
%feature("docstring") Teuchos::XMLObject "

Representation of an XML data tree. XMLObject is a ref-counted handle
to a XMLObjectImplem object, allowing storage by reference.

C++ includes: Teuchos_XMLObject.hpp ";

/*  Constructors  */

%feature("docstring")  Teuchos::XMLObject::XMLObject "Teuchos::XMLObject::XMLObject()

Empty constructor. ";

%feature("docstring")  Teuchos::XMLObject::XMLObject "Teuchos::XMLObject::XMLObject(const std::string &tag)

Construct using a node labeled by tag. ";

%feature("docstring")  Teuchos::XMLObject::XMLObject "Teuchos::XMLObject::XMLObject(XMLObjectImplem *ptr)

Construct with a pointer to the low-level representation.

This is used to allow construction of an XMLObject from the
XMLObjectImplem* return value of ExceptionBase::toXML(). ";

/*  Copy methods  */

%feature("docstring")  Teuchos::XMLObject::deepCopy "XMLObject
Teuchos::XMLObject::deepCopy() const

Make a deep copy of this object. ";

/*  Data Access methods  */

%feature("docstring")  Teuchos::XMLObject::getTag "const std::string
& Teuchos::XMLObject::getTag() const

Return the tag of the current node. ";

%feature("docstring")  Teuchos::XMLObject::hasAttribute "bool
Teuchos::XMLObject::hasAttribute(const std::string &name) const

Find out if the current node has an attribute of the specified name.
";

%feature("docstring")  Teuchos::XMLObject::getAttribute "const
std::string & Teuchos::XMLObject::getAttribute(const std::string
&name) const

Return the value of the attribute with the specified name. ";

%feature("docstring")  Teuchos::XMLObject::getRequired "TEUCHOS_LIB_DLL_EXPORT std::string Teuchos::XMLObject::getRequired<
std::string >(const std::string &name) const

Get an attribute, throwing an std::exception if it is not found. ";

%feature("docstring")  Teuchos::XMLObject::getRequiredDouble "double
Teuchos::XMLObject::getRequiredDouble(const std::string &name) const

Get a required attribute, returning it as a double. ";

%feature("docstring")  Teuchos::XMLObject::getRequiredInt "int
Teuchos::XMLObject::getRequiredInt(const std::string &name) const

Get a required attribute, returning it as an int. ";

%feature("docstring")  Teuchos::XMLObject::getRequired "T
Teuchos::XMLObject::getRequired(const std::string &name) const

Get a required attribute, returning it as T. ";

%feature("docstring")  Teuchos::XMLObject::getRequiredBool "bool
Teuchos::XMLObject::getRequiredBool(const std::string &name) const

Get a required attribute, returning it as a bool. ";

%feature("docstring")  Teuchos::XMLObject::getWithDefault "T
Teuchos::XMLObject::getWithDefault(const std::string &name, const T
&defaultValue) const

Get an attribute, assigning a default value if the requested attribute
does not exist. ";

%feature("docstring")  Teuchos::XMLObject::numChildren "int
Teuchos::XMLObject::numChildren() const

Return the number of child nodes owned by this node. ";

%feature("docstring")  Teuchos::XMLObject::getChild "const XMLObject
& Teuchos::XMLObject::getChild(int i) const

Return the i-th child node. ";

%feature("docstring")  Teuchos::XMLObject::findFirstChild "int
Teuchos::XMLObject::findFirstChild(std::string tagName) const

Returns the index of the first child found with the given tag name.
Returns -1 if no child is found. ";

%feature("docstring")  Teuchos::XMLObject::numContentLines "int
Teuchos::XMLObject::numContentLines() const

Return the number of lines of character content stored in this node.
";

%feature("docstring")  Teuchos::XMLObject::getContentLine "const
std::string & Teuchos::XMLObject::getContentLine(int i) const

Return the i-th line of character content stored in this node. ";

%feature("docstring")  Teuchos::XMLObject::toString "std::string
Teuchos::XMLObject::toString() const

Represent this node and its children as a std::string. ";

%feature("docstring")  Teuchos::XMLObject::print "void
Teuchos::XMLObject::print(std::ostream &os, int indent) const

Print this node and its children to stream with the given indentation.
";

%feature("docstring")  Teuchos::XMLObject::header "std::string
Teuchos::XMLObject::header() const

Write the header for this object to a std::string. ";

%feature("docstring")  Teuchos::XMLObject::terminatedHeader "std::string Teuchos::XMLObject::terminatedHeader() const

Write the header for this object to a std::string. ";

%feature("docstring")  Teuchos::XMLObject::footer "std::string
Teuchos::XMLObject::footer() const

Write the footer for this object to a std::string. ";

%feature("docstring")  Teuchos::XMLObject::isEmpty "bool
Teuchos::XMLObject::isEmpty() const

Find out if a node is empty. ";

%feature("docstring")  Teuchos::XMLObject::checkTag "void
Teuchos::XMLObject::checkTag(const std::string &expected) const

Check that a tag is equal to an expected std::string. ";

/*  Tree-Assembly methods  */

%feature("docstring")  Teuchos::XMLObject::addDouble "void
Teuchos::XMLObject::addDouble(const std::string &name, double val)

Add a double as an attribute. ";

%feature("docstring")  Teuchos::XMLObject::addInt "void
Teuchos::XMLObject::addInt(const std::string &name, int val)

Add an int as an attribute. ";

%feature("docstring")  Teuchos::XMLObject::addBool "void
Teuchos::XMLObject::addBool(const std::string &name, bool val)

Add a bool as an attribute. ";

%feature("docstring")  Teuchos::XMLObject::addAttribute "void
Teuchos::XMLObject::addAttribute(const std::string &name, T value)

Lookup whether or not Doubles are allowed. ";

%feature("docstring")  Teuchos::XMLObject::addChild "void
Teuchos::XMLObject::addChild(const XMLObject &child)

Add a child node to the node. ";

%feature("docstring")  Teuchos::XMLObject::addContent "void
Teuchos::XMLObject::addContent(const std::string &contentLine)

Add a line of character content. ";

%feature("docstring")  Teuchos::XMLObject::addAttribute "TEUCHOS_LIB_DLL_EXPORT void Teuchos::XMLObject::addAttribute(const
std::string &name, const std::string &value) ";


// File: classTeuchos_1_1XMLObjectImplem.xml
%feature("docstring") Teuchos::XMLObjectImplem "

The XMLObjectImplem class takes care of the low-level implementation
details of XMLObject.

C++ includes: Teuchos_XMLObjectImplem.hpp ";

%feature("docstring")  Teuchos::XMLObjectImplem::XMLObjectImplem "XMLObjectImplem::XMLObjectImplem(const std::string &tag)

Construct with a 'tag'. ";

%feature("docstring")  Teuchos::XMLObjectImplem::deepCopy "XMLObjectImplem * XMLObjectImplem::deepCopy() const

Deep copy. ";

%feature("docstring")  Teuchos::XMLObjectImplem::addAttribute "void
XMLObjectImplem::addAttribute(const std::string &name, const
std::string &value)

Add a [name, value] attribute. ";

%feature("docstring")  Teuchos::XMLObjectImplem::addChild "void
XMLObjectImplem::addChild(const XMLObject &child)

Add a child XMLObject. ";

%feature("docstring")  Teuchos::XMLObjectImplem::addContent "void
XMLObjectImplem::addContent(const std::string &contentLine)

Add a content line. ";

%feature("docstring")  Teuchos::XMLObjectImplem::getTag "const
std::string& Teuchos::XMLObjectImplem::getTag() const

Return the tag std::string. ";

%feature("docstring")  Teuchos::XMLObjectImplem::hasAttribute "bool
Teuchos::XMLObjectImplem::hasAttribute(const std::string &name) const

Determine whether an attribute exists. ";

%feature("docstring")  Teuchos::XMLObjectImplem::getAttribute "const
std::string& Teuchos::XMLObjectImplem::getAttribute(const std::string
&name) const

Look up an attribute by name. ";

%feature("docstring")  Teuchos::XMLObjectImplem::numChildren "int
XMLObjectImplem::numChildren() const

Return the number of children. ";

%feature("docstring")  Teuchos::XMLObjectImplem::getChild "const
XMLObject & XMLObjectImplem::getChild(int i) const

Look up a child by its index. ";

%feature("docstring")  Teuchos::XMLObjectImplem::numContentLines "int
Teuchos::XMLObjectImplem::numContentLines() const

Get the number of content lines. ";

%feature("docstring")  Teuchos::XMLObjectImplem::getAttributes "const
Map& Teuchos::XMLObjectImplem::getAttributes() const

Get all attributes. ";

%feature("docstring")  Teuchos::XMLObjectImplem::getContentLine "const std::string& Teuchos::XMLObjectImplem::getContentLine(int i)
const

Look up a content line by index. ";

%feature("docstring")  Teuchos::XMLObjectImplem::print "void
XMLObjectImplem::print(std::ostream &os, int indent) const

Print to stream with the given indentation level. Output will be well-
formed XML. ";

%feature("docstring")  Teuchos::XMLObjectImplem::toString "std::string XMLObjectImplem::toString() const

Write as a std::string. Output may be ill-formed XML. ";

%feature("docstring")  Teuchos::XMLObjectImplem::header "std::string
XMLObjectImplem::header(bool strictXML=false) const

Write the header. ";

%feature("docstring")  Teuchos::XMLObjectImplem::terminatedHeader "std::string XMLObjectImplem::terminatedHeader(bool strictXML=false)
const

Write the header terminated as <Header> ";

%feature("docstring")  Teuchos::XMLObjectImplem::footer "std::string
Teuchos::XMLObjectImplem::footer() const

Write the footer. ";


// File: classTeuchos_1_1XMLParameterListReader.xml
%feature("docstring") Teuchos::XMLParameterListReader "

Writes an XML object to a parameter list.

C++ includes: Teuchos_XMLParameterListReader.hpp ";

/*  Public Types  */

/*  Constructors  */

%feature("docstring")
Teuchos::XMLParameterListReader::XMLParameterListReader "Teuchos::XMLParameterListReader::XMLParameterListReader() ";

%feature("docstring")
Teuchos::XMLParameterListReader::toParameterList "RCP< ParameterList
> Teuchos::XMLParameterListReader::toParameterList(const XMLObject
&xml, RCP< DependencySheet > depSheet) const

Write the given XML object to a parameter list ";

%feature("docstring")
Teuchos::XMLParameterListReader::toParameterList "ParameterList
Teuchos::XMLParameterListReader::toParameterList(const XMLObject &xml)
const

Write the given XML object to a parameter list ";

%feature("docstring")
Teuchos::XMLParameterListReader::setAllowsDuplicateSublists "void
Teuchos::XMLParameterListReader::setAllowsDuplicateSublists(bool
policy)

Set policy regarding duplicated sublists.

The default behavior of this class is to allow duplicated sublists,
although the resulting ParameterList is undefined for the duplicated
sublists (in most cases, they will be merged in the order they are
encountered in the XML character stream).

If set false, then duplicated sublists in the XML tree will result in
the Teuchos::DuplicateParameterSublist exception being thrown.

If set true, the default behavior is restored. ";

%feature("docstring")
Teuchos::XMLParameterListReader::getAllowsDuplicateSublists "bool
Teuchos::XMLParameterListReader::getAllowsDuplicateSublists() const

Specifies the current policy regarding duplicated sublists. See
setAllowsDuplicateSublists() for more details. ";


// File: classTeuchos_1_1XMLParameterListWriter.xml
%feature("docstring") Teuchos::XMLParameterListWriter "

Writes a ParameterList to an XML object.

C++ includes: Teuchos_XMLParameterListWriter.hpp ";

/*  Public Types  */

/*  Constructors  */

%feature("docstring")
Teuchos::XMLParameterListWriter::XMLParameterListWriter "Teuchos::XMLParameterListWriter::XMLParameterListWriter()

Construct a writer ";

%feature("docstring")  Teuchos::XMLParameterListWriter::toXML "XMLObject Teuchos::XMLParameterListWriter::toXML(const ParameterList
&p, RCP< const DependencySheet > depSheet=null) const

Write the given list to an XML object ";


// File: classTeuchos_1_1XMLParser.xml
%feature("docstring") Teuchos::XMLParser "

XMLParser consumes characters from an XMLInputStream object, parsing
the XML and using a TreeBuildingXMLHandler to construct an XMLObject.

C++ includes: Teuchos_XMLParser.hpp ";

%feature("docstring")  Teuchos::XMLParser::XMLParser "Teuchos::XMLParser::XMLParser(RCP< XMLInputStream > is)

Constructor. ";

%feature("docstring")  Teuchos::XMLParser::~XMLParser "Teuchos::XMLParser::~XMLParser()

Destructor. ";

%feature("docstring")  Teuchos::XMLParser::parse "XMLObject
XMLParser::parse()

Consume the XMLInputStream to build an XMLObject. ";


// File: namespace@13.xml


// File: namespace@2.xml


// File: namespaceTeuchos.xml
%feature("docstring")  Teuchos::Exceptions::printValidParameters "void Teuchos::printValidParameters(const ParameterListAcceptor
&paramListAccpetor, std::ostream &out, const bool showDoc=true)

Pretty print the valid parameters from a ParameterListAccpetor object.
";

%feature("docstring")
Teuchos::Exceptions::throwScalarTraitsNanInfError "void
Teuchos::throwScalarTraitsNanInfError(const std::string &errMsg) ";

%feature("docstring")  Teuchos::Exceptions::generic_real_isnaninf "bool Teuchos::generic_real_isnaninf(const Scalar &x) ";

%feature("docstring")  Teuchos::Exceptions::XMLObject::getRequired<
std::string > " std::string Teuchos::XMLObject::getRequired<
std::string >(const std::string &name) const ";

%feature("docstring")  Teuchos::Exceptions::XMLObject::addAttribute<
const std::string & > " void Teuchos::XMLObject::addAttribute< const
std::string & >(const std::string &name, const std::string &value) ";


// File: namespaceTeuchos_1_1Exceptions.xml


// File: Teuchos__FileInputSource_8cpp.xml


// File: Teuchos__FileInputSource_8hpp.xml


// File: Teuchos__ParameterList_8cpp.xml


// File: Teuchos__ParameterList_8hpp.xml


// File: Teuchos__ParameterListAcceptor_8cpp.xml


// File: Teuchos__ParameterListAcceptor_8hpp.xml


// File: Teuchos__ParameterListAcceptorDefaultBase_8cpp.xml


// File: Teuchos__ParameterListAcceptorDefaultBase_8hpp.xml


// File: Teuchos__ParameterListAcceptorHelpers_8cpp.xml


// File: Teuchos__ParameterListAcceptorHelpers_8hpp.xml


// File: Teuchos__ParameterListExceptions_8hpp.xml


// File: Teuchos__ParameterListNonAcceptor_8cpp.xml


// File: Teuchos__ParameterListNonAcceptor_8hpp.xml


// File: Teuchos__ScalarTraits_8cpp.xml


// File: Teuchos__ScalarTraits_8hpp.xml


// File: Teuchos__StringInputSource_8cpp.xml


// File: Teuchos__StringInputSource_8hpp.xml


// File: Teuchos__Time_8cpp.xml


// File: Teuchos__Time_8hpp.xml


// File: Teuchos__XMLConditionExceptions_8hpp.xml


// File: Teuchos__XMLDependencyExceptions_8hpp.xml


// File: Teuchos__XMLFunctionObjectExceptions_8hpp.xml


// File: Teuchos__XMLInputSource_8cpp.xml


// File: Teuchos__XMLInputSource_8hpp.xml


// File: Teuchos__XMLInputStream_8cpp.xml


// File: Teuchos__XMLInputStream_8hpp.xml


// File: Teuchos__XMLObject_8cpp.xml


// File: Teuchos__XMLObject_8hpp.xml


// File: Teuchos__XMLObjectImplem_8cpp.xml


// File: Teuchos__XMLObjectImplem_8hpp.xml


// File: Teuchos__XMLParameterListExceptions_8hpp.xml


// File: Teuchos__XMLParameterListHelpers_8cpp.xml


// File: Teuchos__XMLParameterListHelpers_8hpp.xml


// File: Teuchos__XMLParameterListReader_8cpp.xml


// File: Teuchos__XMLParameterListReader_8hpp.xml


// File: Teuchos__XMLParameterListWriter_8cpp.xml


// File: Teuchos__XMLParameterListWriter_8hpp.xml


// File: Teuchos__XMLParser_8cpp.xml


// File: Teuchos__XMLParser_8hpp.xml


// File: dir_3e7ac0723db077e4460d28d277456290.xml


// File: dir_ccb49250c8a2ae42b75bc28c0fcd3e62.xml


// File: ParameterList_2cxx_main_8cpp-example.xml

