/*
//@HEADER
// ************************************************************************
// 
//   KokkosArray: Manycore Performance-Portable Multidimensional Arrays
//              Copyright (2012) Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact  H. Carter Edwards (hcedwar@sandia.gov) 
// 
// ************************************************************************
//@HEADER
*/


#include <sstream>
#include <stdexcept>

#include <KokkosArray_LegendrePolynomial.hpp>


namespace KokkosArray {
namespace Impl {

namespace {

const double points_n1[] = { 0 };
const double weights_n1[] = { 2 };

const double points_n2[] = {
       -0.5773502691896257 ,
        0.5773502691896257 };
const double weights_n2[] = {
        1.0000000000000000 ,
        1.0000000000000000 } /* 2.000000000000000 */ ;

const double points_n3[] = {
       -0.7745966692414834 ,
        0.0000000000000000 ,
        0.7745966692414834 };
const double weights_n3[] = {
        0.5555555555555556 ,
        0.8888888888888888 ,
        0.5555555555555556 } /* 2.000000000000000 */ ;

const double points_n4[] = {
       -0.8611363115940526 ,
       -0.3399810435848563 ,
        0.3399810435848563 ,
        0.8611363115940526 };
const double weights_n4[] = {
        0.3478548451374538 ,
        0.6521451548625461 ,
        0.6521451548625461 ,
        0.3478548451374538 } /* 2.000000000000000 */ ;

const double points_n5[] = {
       -0.9061798459386640 ,
       -0.5384693101056831 ,
        0.0000000000000000 ,
        0.5384693101056831 ,
        0.9061798459386640 };
const double weights_n5[] = {
        0.2369268850561891 ,
        0.4786286704993665 ,
        0.5688888888888889 ,
        0.4786286704993665 ,
        0.2369268850561891 } /* 2.000000000000000 */ ;

const double points_n6[] = {
       -0.9324695142031521 ,
       -0.6612093864662645 ,
       -0.2386191860831969 ,
        0.2386191860831969 ,
        0.6612093864662645 ,
        0.9324695142031521 };
const double weights_n6[] = {
        0.1713244923791704 ,
        0.3607615730481386 ,
        0.4679139345726910 ,
        0.4679139345726910 ,
        0.3607615730481386 ,
        0.1713244923791704 } /* 2.000000000000000 */ ;

const double points_n7[] = {
       -0.9491079123427585 ,
       -0.7415311855993945 ,
       -0.4058451513773972 ,
        0.0000000000000000 ,
        0.4058451513773972 ,
        0.7415311855993945 ,
        0.9491079123427585 };
const double weights_n7[] = {
        0.1294849661688697 ,
        0.2797053914892766 ,
        0.3818300505051189 ,
        0.4179591836734694 ,
        0.3818300505051189 ,
        0.2797053914892766 ,
        0.1294849661688697 } /* 2.000000000000000 */ ;

const double points_n8[] = {
       -0.9602898564975363 ,
       -0.7966664774136267 ,
       -0.5255324099163290 ,
       -0.1834346424956498 ,
        0.1834346424956498 ,
        0.5255324099163290 ,
        0.7966664774136267 ,
        0.9602898564975363 };
const double weights_n8[] = {
        0.1012285362903763 ,
        0.2223810344533745 ,
        0.3137066458778873 ,
        0.3626837833783620 ,
        0.3626837833783620 ,
        0.3137066458778873 ,
        0.2223810344533745 ,
        0.1012285362903763 } /* 2.000000000000000 */ ;

const double points_n9[] = {
       -0.9681602395076261 ,
       -0.8360311073266358 ,
       -0.6133714327005904 ,
       -0.3242534234038089 ,
        0.0000000000000000 ,
        0.3242534234038089 ,
        0.6133714327005904 ,
        0.8360311073266358 ,
        0.9681602395076261 };
const double weights_n9[] = {
        0.0812743883615744 ,
        0.1806481606948574 ,
        0.2606106964029354 ,
        0.3123470770400029 ,
        0.3302393550012598 ,
        0.3123470770400029 ,
        0.2606106964029354 ,
        0.1806481606948574 ,
        0.0812743883615744 } /* 2.000000000000000 */ ;

const double points_n10[] = {
       -0.9739065285171717 ,
       -0.8650633666889845 ,
       -0.6794095682990244 ,
       -0.4333953941292472 ,
       -0.1488743389816312 ,
        0.1488743389816312 ,
        0.4333953941292472 ,
        0.6794095682990244 ,
        0.8650633666889845 ,
        0.9739065285171717 };
const double weights_n10[] = {
        0.0666713443086881 ,
        0.1494513491505806 ,
        0.2190863625159820 ,
        0.2692667193099963 ,
        0.2955242247147529 ,
        0.2955242247147529 ,
        0.2692667193099963 ,
        0.2190863625159820 ,
        0.1494513491505806 ,
        0.0666713443086881 } /* 2.000000000000000 */ ;

const double points_n11[] = {
       -0.9782286581460570 ,
       -0.8870625997680953 ,
       -0.7301520055740494 ,
       -0.5190961292068118 ,
       -0.2695431559523450 ,
        0.0000000000000000 ,
        0.2695431559523450 ,
        0.5190961292068118 ,
        0.7301520055740494 ,
        0.8870625997680953 ,
        0.9782286581460570 };
const double weights_n11[] = {
        0.0556685671161737 ,
        0.1255803694649046 ,
        0.1862902109277343 ,
        0.2331937645919905 ,
        0.2628045445102467 ,
        0.2729250867779006 ,
        0.2628045445102467 ,
        0.2331937645919905 ,
        0.1862902109277343 ,
        0.1255803694649046 ,
        0.0556685671161737 } /* 2.000000000000000 */ ;

const double points_n12[] = {
       -0.9815606342467192 ,
       -0.9041172563704749 ,
       -0.7699026741943047 ,
       -0.5873179542866175 ,
       -0.3678314989981802 ,
       -0.1252334085114689 ,
        0.1252334085114689 ,
        0.3678314989981802 ,
        0.5873179542866175 ,
        0.7699026741943047 ,
        0.9041172563704749 ,
        0.9815606342467192 };
const double weights_n12[] = {
        0.0471753363865118 ,
        0.1069393259953184 ,
        0.1600783285433462 ,
        0.2031674267230659 ,
        0.2334925365383548 ,
        0.2491470458134028 ,
        0.2491470458134028 ,
        0.2334925365383548 ,
        0.2031674267230659 ,
        0.1600783285433462 ,
        0.1069393259953184 ,
        0.0471753363865118 } /* 2.000000000000000 */ ;

const double points_n13[] = {
       -0.9841830547185881 ,
       -0.9175983992229779 ,
       -0.8015780907333099 ,
       -0.6423493394403402 ,
       -0.4484927510364469 ,
       -0.2304583159551348 ,
        0.0000000000000000 ,
        0.2304583159551348 ,
        0.4484927510364469 ,
        0.6423493394403402 ,
        0.8015780907333099 ,
        0.9175983992229779 ,
        0.9841830547185881 };
const double weights_n13[] = {
        0.0404840047653159 ,
        0.0921214998377285 ,
        0.1388735102197872 ,
        0.1781459807619457 ,
        0.2078160475368885 ,
        0.2262831802628972 ,
        0.2325515532308739 ,
        0.2262831802628972 ,
        0.2078160475368885 ,
        0.1781459807619457 ,
        0.1388735102197872 ,
        0.0921214998377285 ,
        0.0404840047653159 } /* 2.000000000000000 */ ;

const double points_n14[] = {
       -0.9862838086968123 ,
       -0.9284348836635735 ,
       -0.8272013150697650 ,
       -0.6872929048116855 ,
       -0.5152486363581541 ,
       -0.3191123689278897 ,
       -0.1080549487073437 ,
        0.1080549487073437 ,
        0.3191123689278897 ,
        0.5152486363581541 ,
        0.6872929048116855 ,
        0.8272013150697650 ,
        0.9284348836635735 ,
        0.9862838086968123 };
const double weights_n14[] = {
        0.0351194603317519 ,
        0.0801580871597602 ,
        0.1215185706879032 ,
        0.1572031671581935 ,
        0.1855383974779378 ,
        0.2051984637212956 ,
        0.2152638534631578 ,
        0.2152638534631578 ,
        0.2051984637212956 ,
        0.1855383974779378 ,
        0.1572031671581935 ,
        0.1215185706879032 ,
        0.0801580871597602 ,
        0.0351194603317519 } /* 2.000000000000000 */ ;

const double points_n15[] = {
       -0.9879925180204854 ,
       -0.9372733924007060 ,
       -0.8482065834104272 ,
       -0.7244177313601701 ,
       -0.5709721726085388 ,
       -0.3941513470775634 ,
       -0.2011940939974345 ,
        0.0000000000000000 ,
        0.2011940939974345 ,
        0.3941513470775634 ,
        0.5709721726085388 ,
        0.7244177313601701 ,
        0.8482065834104272 ,
        0.9372733924007060 ,
        0.9879925180204854 };
const double weights_n15[] = {
        0.0307532419961173 ,
        0.0703660474881081 ,
        0.1071592204671719 ,
        0.1395706779261543 ,
        0.1662692058169939 ,
        0.1861610000155622 ,
        0.1984314853271116 ,
        0.2025782419255613 ,
        0.1984314853271116 ,
        0.1861610000155622 ,
        0.1662692058169939 ,
        0.1395706779261543 ,
        0.1071592204671719 ,
        0.0703660474881081 ,
        0.0307532419961173 } /* 2.000000000000000 */ ;

const double points_n16[] = {
       -0.9894009349916499 ,
       -0.9445750230732326 ,
       -0.8656312023878318 ,
       -0.7554044083550030 ,
       -0.6178762444026438 ,
       -0.4580167776572274 ,
       -0.2816035507792589 ,
       -0.0950125098376374 ,
        0.0950125098376374 ,
        0.2816035507792589 ,
        0.4580167776572274 ,
        0.6178762444026438 ,
        0.7554044083550030 ,
        0.8656312023878318 ,
        0.9445750230732326 ,
        0.9894009349916499 };
const double weights_n16[] = {
        0.0271524594117541 ,
        0.0622535239386479 ,
        0.0951585116824928 ,
        0.1246289712555339 ,
        0.1495959888165767 ,
        0.1691565193950025 ,
        0.1826034150449236 ,
        0.1894506104550685 ,
        0.1894506104550685 ,
        0.1826034150449236 ,
        0.1691565193950025 ,
        0.1495959888165767 ,
        0.1246289712555339 ,
        0.0951585116824928 ,
        0.0622535239386479 ,
        0.0271524594117541 } /* 2.000000000000000 */ ;

const double points_n17[] = {
       -0.9905754753144174 ,
       -0.9506755217687678 ,
       -0.8802391537269859 ,
       -0.7815140038968014 ,
       -0.6576711592166907 ,
       -0.5126905370864769 ,
       -0.3512317634538763 ,
       -0.1784841814958479 ,
        0.0000000000000000 ,
        0.1784841814958479 ,
        0.3512317634538763 ,
        0.5126905370864769 ,
        0.6576711592166907 ,
        0.7815140038968014 ,
        0.8802391537269859 ,
        0.9506755217687678 ,
        0.9905754753144174 };
const double weights_n17[] = {
        0.0241483028685479 ,
        0.0554595293739872 ,
        0.0850361483171792 ,
        0.1118838471934040 ,
        0.1351363684685255 ,
        0.1540457610768103 ,
        0.1680041021564500 ,
        0.1765627053669926 ,
        0.1794464703562065 ,
        0.1765627053669926 ,
        0.1680041021564500 ,
        0.1540457610768103 ,
        0.1351363684685255 ,
        0.1118838471934040 ,
        0.0850361483171792 ,
        0.0554595293739872 ,
        0.0241483028685479 } /* 2.000000000000000 */ ;

const double points_n18[] = {
       -0.9915651684209309 ,
       -0.9558239495713977 ,
       -0.8926024664975557 ,
       -0.8037049589725231 ,
       -0.6916870430603532 ,
       -0.5597708310739475 ,
       -0.4117511614628426 ,
       -0.2518862256915055 ,
       -0.0847750130417353 ,
        0.0847750130417353 ,
        0.2518862256915055 ,
        0.4117511614628426 ,
        0.5597708310739475 ,
        0.6916870430603532 ,
        0.8037049589725231 ,
        0.8926024664975557 ,
        0.9558239495713977 ,
        0.9915651684209309 };
const double weights_n18[] = {
        0.0216160135264833 ,
        0.0497145488949698 ,
        0.0764257302548891 ,
        0.1009420441062872 ,
        0.1225552067114785 ,
        0.1406429146706507 ,
        0.1546846751262652 ,
        0.1642764837458327 ,
        0.1691423829631436 ,
        0.1691423829631436 ,
        0.1642764837458327 ,
        0.1546846751262652 ,
        0.1406429146706507 ,
        0.1225552067114785 ,
        0.1009420441062872 ,
        0.0764257302548891 ,
        0.0497145488949698 ,
        0.0216160135264833 } /* 2.000000000000000 */ ;

const double points_n19[] = {
       -0.9924068438435844 ,
       -0.9602081521348300 ,
       -0.9031559036148179 ,
       -0.8227146565371428 ,
       -0.7209661773352294 ,
       -0.6005453046616810 ,
       -0.4645707413759609 ,
       -0.3165640999636298 ,
       -0.1603586456402254 ,
        0.0000000000000000 ,
        0.1603586456402254 ,
        0.3165640999636298 ,
        0.4645707413759609 ,
        0.6005453046616810 ,
        0.7209661773352294 ,
        0.8227146565371428 ,
        0.9031559036148179 ,
        0.9602081521348300 ,
        0.9924068438435844 };
const double weights_n19[] = {
        0.0194617882297265 ,
        0.0448142267656996 ,
        0.0690445427376412 ,
        0.0914900216224500 ,
        0.1115666455473340 ,
        0.1287539625393362 ,
        0.1426067021736066 ,
        0.1527660420658597 ,
        0.1589688433939543 ,
        0.1610544498487837 ,
        0.1589688433939543 ,
        0.1527660420658597 ,
        0.1426067021736066 ,
        0.1287539625393362 ,
        0.1115666455473340 ,
        0.0914900216224500 ,
        0.0690445427376412 ,
        0.0448142267656996 ,
        0.0194617882297265 } /* 2.000000000000000 */ ;

const double points_n20[] = {
       -0.9931285991850949 ,
       -0.9639719272779138 ,
       -0.9122344282513259 ,
       -0.8391169718222188 ,
       -0.7463319064601508 ,
       -0.6360536807265150 ,
       -0.5108670019508271 ,
       -0.3737060887154195 ,
       -0.2277858511416451 ,
       -0.0765265211334973 ,
        0.0765265211334973 ,
        0.2277858511416451 ,
        0.3737060887154195 ,
        0.5108670019508271 ,
        0.6360536807265150 ,
        0.7463319064601508 ,
        0.8391169718222188 ,
        0.9122344282513259 ,
        0.9639719272779138 ,
        0.9931285991850949 };
const double weights_n20[] = {
        0.0176140071391521 ,
        0.0406014298003869 ,
        0.0626720483341091 ,
        0.0832767415767048 ,
        0.1019301198172404 ,
        0.1181945319615184 ,
        0.1316886384491766 ,
        0.1420961093183820 ,
        0.1491729864726037 ,
        0.1527533871307258 ,
        0.1527533871307258 ,
        0.1491729864726037 ,
        0.1420961093183820 ,
        0.1316886384491766 ,
        0.1181945319615184 ,
        0.1019301198172404 ,
        0.0832767415767048 ,
        0.0626720483341091 ,
        0.0406014298003869 ,
        0.0176140071391521 } /* 2.000000000000000 */ ;

const double points_n32[] = {
       -0.9972638618494816 ,
       -0.9856115115452684 ,
       -0.9647622555875064 ,
       -0.9349060759377397 ,
       -0.8963211557660521 ,
       -0.8493676137325700 ,
       -0.7944837959679424 ,
       -0.7321821187402897 ,
       -0.6630442669302152 ,
       -0.5877157572407623 ,
       -0.5068999089322294 ,
       -0.4213512761306353 ,
       -0.3318686022821277 ,
       -0.2392873622521371 ,
       -0.1444719615827965 ,
       -0.0483076656877383 ,
        0.0483076656877383 ,
        0.1444719615827965 ,
        0.2392873622521371 ,
        0.3318686022821277 ,
        0.4213512761306353 ,
        0.5068999089322294 ,
        0.5877157572407623 ,
        0.6630442669302152 ,
        0.7321821187402897 ,
        0.7944837959679424 ,
        0.8493676137325700 ,
        0.8963211557660521 ,
        0.9349060759377397 ,
        0.9647622555875064 ,
        0.9856115115452684 ,
        0.9972638618494816 };
const double weights_n32[] = {
        0.0070186100094701 ,
        0.0162743947309057 ,
        0.0253920653092621 ,
        0.0342738629130214 ,
        0.0428358980222267 ,
        0.0509980592623762 ,
        0.0586840934785355 ,
        0.0658222227763618 ,
        0.0723457941088485 ,
        0.0781938957870703 ,
        0.0833119242269467 ,
        0.0876520930044038 ,
        0.0911738786957639 ,
        0.0938443990808046 ,
        0.0956387200792749 ,
        0.0965400885147278 ,
        0.0965400885147278 ,
        0.0956387200792749 ,
        0.0938443990808046 ,
        0.0911738786957639 ,
        0.0876520930044038 ,
        0.0833119242269467 ,
        0.0781938957870703 ,
        0.0723457941088485 ,
        0.0658222227763618 ,
        0.0586840934785355 ,
        0.0509980592623762 ,
        0.0428358980222267 ,
        0.0342738629130214 ,
        0.0253920653092621 ,
        0.0162743947309057 ,
        0.0070186100094701 } /* 2.000000000000000 */ ;

const double points_n64[] = {
       -0.9993050417357722 ,
       -0.9963401167719553 ,
       -0.9910133714767443 ,
       -0.9833362538846260 ,
       -0.9733268277899110 ,
       -0.9610087996520538 ,
       -0.9464113748584028 ,
       -0.9295691721319396 ,
       -0.9105221370785028 ,
       -0.8893154459951141 ,
       -0.8659993981540928 ,
       -0.8406292962525803 ,
       -0.8132653151227975 ,
       -0.7839723589433414 ,
       -0.7528199072605319 ,
       -0.7198818501716109 ,
       -0.6852363130542333 ,
       -0.6489654712546573 ,
       -0.6111553551723933 ,
       -0.5718956462026340 ,
       -0.5312794640198946 ,
       -0.4894031457070530 ,
       -0.4463660172534641 ,
       -0.4022701579639916 ,
       -0.3572201583376681 ,
       -0.3113228719902110 ,
       -0.2646871622087674 ,
       -0.2174236437400071 ,
       -0.1696444204239928 ,
       -0.1214628192961206 ,
       -0.0729931217877990 ,
       -0.0243502926634244 ,
        0.0243502926634244 ,
        0.0729931217877990 ,
        0.1214628192961206 ,
        0.1696444204239928 ,
        0.2174236437400071 ,
        0.2646871622087674 ,
        0.3113228719902110 ,
        0.3572201583376681 ,
        0.4022701579639916 ,
        0.4463660172534641 ,
        0.4894031457070530 ,
        0.5312794640198946 ,
        0.5718956462026340 ,
        0.6111553551723933 ,
        0.6489654712546573 ,
        0.6852363130542333 ,
        0.7198818501716109 ,
        0.7528199072605319 ,
        0.7839723589433414 ,
        0.8132653151227975 ,
        0.8406292962525803 ,
        0.8659993981540928 ,
        0.8893154459951141 ,
        0.9105221370785028 ,
        0.9295691721319396 ,
        0.9464113748584028 ,
        0.9610087996520538 ,
        0.9733268277899110 ,
        0.9833362538846260 ,
        0.9910133714767443 ,
        0.9963401167719553 ,
        0.9993050417357722 };
const double weights_n64[] = {
        0.0017832807216964 ,
        0.0041470332605625 ,
        0.0065044579689784 ,
        0.0088467598263639 ,
        0.0111681394601311 ,
        0.0134630478967186 ,
        0.0157260304760247 ,
        0.0179517157756973 ,
        0.0201348231535302 ,
        0.0222701738083833 ,
        0.0243527025687109 ,
        0.0263774697150547 ,
        0.0283396726142595 ,
        0.0302346570724025 ,
        0.0320579283548516 ,
        0.0338051618371416 ,
        0.0354722132568824 ,
        0.0370551285402400 ,
        0.0385501531786156 ,
        0.0399537411327203 ,
        0.0412625632426235 ,
        0.0424735151236536 ,
        0.0435837245293235 ,
        0.0445905581637566 ,
        0.0454916279274181 ,
        0.0462847965813144 ,
        0.0469681828162100 ,
        0.0475401657148303 ,
        0.0479993885964583 ,
        0.0483447622348030 ,
        0.0485754674415034 ,
        0.0486909570091397 ,
        0.0486909570091397 ,
        0.0485754674415034 ,
        0.0483447622348030 ,
        0.0479993885964583 ,
        0.0475401657148303 ,
        0.0469681828162100 ,
        0.0462847965813144 ,
        0.0454916279274181 ,
        0.0445905581637566 ,
        0.0435837245293235 ,
        0.0424735151236536 ,
        0.0412625632426235 ,
        0.0399537411327203 ,
        0.0385501531786156 ,
        0.0370551285402400 ,
        0.0354722132568824 ,
        0.0338051618371416 ,
        0.0320579283548516 ,
        0.0302346570724025 ,
        0.0283396726142595 ,
        0.0263774697150547 ,
        0.0243527025687109 ,
        0.0222701738083833 ,
        0.0201348231535302 ,
        0.0179517157756973 ,
        0.0157260304760247 ,
        0.0134630478967186 ,
        0.0111681394601311 ,
        0.0088467598263639 ,
        0.0065044579689784 ,
        0.0041470332605625 ,
        0.0017832807216964 } /* 2.000000000000000 */ ;

const double points_n96[] = {
       -0.9996895038832307 ,
       -0.9983643758631817 ,
       -0.9959818429872093 ,
       -0.9925439003237626 ,
       -0.9880541263296237 ,
       -0.9825172635630147 ,
       -0.9759391745851365 ,
       -0.9683268284632642 ,
       -0.9596882914487426 ,
       -0.9500327177844377 ,
       -0.9393703397527552 ,
       -0.9277124567223087 ,
       -0.9150714231208981 ,
       -0.9014606353158523 ,
       -0.8868945174024204 ,
       -0.8713885059092965 ,
       -0.8549590334346014 ,
       -0.8376235112281871 ,
       -0.8194003107379316 ,
       -0.8003087441391408 ,
       -0.7803690438674332 ,
       -0.7596023411766475 ,
       -0.7380306437444001 ,
       -0.7156768123489676 ,
       -0.6925645366421715 ,
       -0.6687183100439161 ,
       -0.6441634037849671 ,
       -0.6189258401254686 ,
       -0.5930323647775720 ,
       -0.5665104185613972 ,
       -0.5393881083243575 ,
       -0.5116941771546677 ,
       -0.4834579739205964 ,
       -0.4547094221677430 ,
       -0.4254789884073005 ,
       -0.3957976498289086 ,
       -0.3656968614723136 ,
       -0.3352085228926254 ,
       -0.3043649443544963 ,
       -0.2731988125910492 ,
       -0.2417431561638400 ,
       -0.2100313104605672 ,
       -0.1780968823676186 ,
       -0.1459737146548969 ,
       -0.1136958501106659 ,
       -0.0812974954644256 ,
       -0.0488129851360497 ,
       -0.0162767448496030 ,
        0.0162767448496030 ,
        0.0488129851360497 ,
        0.0812974954644256 ,
        0.1136958501106659 ,
        0.1459737146548969 ,
        0.1780968823676186 ,
        0.2100313104605672 ,
        0.2417431561638400 ,
        0.2731988125910492 ,
        0.3043649443544963 ,
        0.3352085228926254 ,
        0.3656968614723136 ,
        0.3957976498289086 ,
        0.4254789884073005 ,
        0.4547094221677430 ,
        0.4834579739205964 ,
        0.5116941771546677 ,
        0.5393881083243575 ,
        0.5665104185613972 ,
        0.5930323647775720 ,
        0.6189258401254686 ,
        0.6441634037849671 ,
        0.6687183100439161 ,
        0.6925645366421715 ,
        0.7156768123489676 ,
        0.7380306437444001 ,
        0.7596023411766475 ,
        0.7803690438674332 ,
        0.8003087441391408 ,
        0.8194003107379316 ,
        0.8376235112281871 ,
        0.8549590334346014 ,
        0.8713885059092965 ,
        0.8868945174024204 ,
        0.9014606353158523 ,
        0.9150714231208981 ,
        0.9277124567223087 ,
        0.9393703397527552 ,
        0.9500327177844377 ,
        0.9596882914487426 ,
        0.9683268284632642 ,
        0.9759391745851365 ,
        0.9825172635630147 ,
        0.9880541263296237 ,
        0.9925439003237626 ,
        0.9959818429872093 ,
        0.9983643758631817 ,
        0.9996895038832307 };
const double weights_n96[] = {
        0.0007967920655520 ,
        0.0018539607889469 ,
        0.0029107318179349 ,
        0.0039645543384447 ,
        0.0050142027429275 ,
        0.0060585455042360 ,
        0.0070964707911539 ,
        0.0081268769256988 ,
        0.0091486712307834 ,
        0.0101607705350084 ,
        0.0111621020998385 ,
        0.0121516046710883 ,
        0.0131282295669616 ,
        0.0140909417723149 ,
        0.0150387210269949 ,
        0.0159705629025623 ,
        0.0168854798642452 ,
        0.0177825023160453 ,
        0.0186606796274115 ,
        0.0195190811401450 ,
        0.0203567971543333 ,
        0.0211729398921913 ,
        0.0219666444387444 ,
        0.0227370696583294 ,
        0.0234833990859262 ,
        0.0242048417923647 ,
        0.0249006332224836 ,
        0.0255700360053494 ,
        0.0262123407356724 ,
        0.0268268667255918 ,
        0.0274129627260292 ,
        0.0279700076168483 ,
        0.0284974110650854 ,
        0.0289946141505552 ,
        0.0294610899581679 ,
        0.0298963441363284 ,
        0.0302999154208276 ,
        0.0306713761236691 ,
        0.0310103325863138 ,
        0.0313164255968614 ,
        0.0315893307707272 ,
        0.0318287588944110 ,
        0.0320344562319927 ,
        0.0322062047940303 ,
        0.0323438225685759 ,
        0.0324471637140643 ,
        0.0325161187138688 ,
        0.0325506144923632 ,
        0.0325506144923632 ,
        0.0325161187138688 ,
        0.0324471637140643 ,
        0.0323438225685759 ,
        0.0322062047940303 ,
        0.0320344562319927 ,
        0.0318287588944110 ,
        0.0315893307707272 ,
        0.0313164255968614 ,
        0.0310103325863138 ,
        0.0306713761236691 ,
        0.0302999154208276 ,
        0.0298963441363284 ,
        0.0294610899581679 ,
        0.0289946141505552 ,
        0.0284974110650854 ,
        0.0279700076168483 ,
        0.0274129627260292 ,
        0.0268268667255918 ,
        0.0262123407356724 ,
        0.0255700360053494 ,
        0.0249006332224836 ,
        0.0242048417923647 ,
        0.0234833990859262 ,
        0.0227370696583294 ,
        0.0219666444387444 ,
        0.0211729398921913 ,
        0.0203567971543333 ,
        0.0195190811401450 ,
        0.0186606796274115 ,
        0.0177825023160453 ,
        0.0168854798642452 ,
        0.0159705629025623 ,
        0.0150387210269949 ,
        0.0140909417723149 ,
        0.0131282295669616 ,
        0.0121516046710883 ,
        0.0111621020998385 ,
        0.0101607705350084 ,
        0.0091486712307834 ,
        0.0081268769256988 ,
        0.0070964707911539 ,
        0.0060585455042360 ,
        0.0050142027429275 ,
        0.0039645543384447 ,
        0.0029107318179349 ,
        0.0018539607889469 ,
        0.0007967920655520 } /* 2.000000000000000 */ ;

const double points_n100[] = {
       -0.9997137267734413 ,
       -0.9984919506395958 ,
       -0.9962951347331251 ,
       -0.9931249370374434 ,
       -0.9889843952429918 ,
       -0.9838775407060570 ,
       -0.9778093584869183 ,
       -0.9707857757637063 ,
       -0.9628136542558156 ,
       -0.9539007829254917 ,
       -0.9440558701362560 ,
       -0.9332885350430795 ,
       -0.9216092981453340 ,
       -0.9090295709825297 ,
       -0.8955616449707270 ,
       -0.8812186793850184 ,
       -0.8660146884971647 ,
       -0.8499645278795913 ,
       -0.8330838798884008 ,
       -0.8153892383391762 ,
       -0.7968978923903145 ,
       -0.7776279096494955 ,
       -0.7575981185197072 ,
       -0.7368280898020207 ,
       -0.7153381175730564 ,
       -0.6931491993558020 ,
       -0.6702830156031410 ,
       -0.6467619085141293 ,
       -0.6226088602037078 ,
       -0.5978474702471788 ,
       -0.5725019326213812 ,
       -0.5465970120650941 ,
       -0.5201580198817630 ,
       -0.4932107892081909 ,
       -0.4657816497733581 ,
       -0.4378974021720315 ,
       -0.4095852916783015 ,
       -0.3808729816246300 ,
       -0.3517885263724217 ,
       -0.3223603439005291 ,
       -0.2926171880384720 ,
       -0.2625881203715035 ,
       -0.2323024818449740 ,
       -0.2017898640957360 ,
       -0.1710800805386033 ,
       -0.1402031372361140 ,
       -0.1091892035800611 ,
       -0.0780685828134366 ,
       -0.0468716824215916 ,
       -0.0156289844215431 ,
        0.0156289844215431 ,
        0.0468716824215916 ,
        0.0780685828134366 ,
        0.1091892035800611 ,
        0.1402031372361140 ,
        0.1710800805386033 ,
        0.2017898640957360 ,
        0.2323024818449740 ,
        0.2625881203715035 ,
        0.2926171880384720 ,
        0.3223603439005291 ,
        0.3517885263724217 ,
        0.3808729816246300 ,
        0.4095852916783015 ,
        0.4378974021720315 ,
        0.4657816497733581 ,
        0.4932107892081909 ,
        0.5201580198817630 ,
        0.5465970120650941 ,
        0.5725019326213812 ,
        0.5978474702471788 ,
        0.6226088602037078 ,
        0.6467619085141293 ,
        0.6702830156031410 ,
        0.6931491993558020 ,
        0.7153381175730564 ,
        0.7368280898020207 ,
        0.7575981185197072 ,
        0.7776279096494955 ,
        0.7968978923903145 ,
        0.8153892383391762 ,
        0.8330838798884008 ,
        0.8499645278795913 ,
        0.8660146884971647 ,
        0.8812186793850184 ,
        0.8955616449707270 ,
        0.9090295709825297 ,
        0.9216092981453340 ,
        0.9332885350430795 ,
        0.9440558701362560 ,
        0.9539007829254917 ,
        0.9628136542558156 ,
        0.9707857757637063 ,
        0.9778093584869183 ,
        0.9838775407060570 ,
        0.9889843952429918 ,
        0.9931249370374434 ,
        0.9962951347331251 ,
        0.9984919506395958 ,
        0.9997137267734413 };
const double weights_n100[] = {
        0.0007346344905057 ,
        0.0017093926535181 ,
        0.0026839253715535 ,
        0.0036559612013264 ,
        0.0046244500634221 ,
        0.0055884280038655 ,
        0.0065469484508453 ,
        0.0074990732554647 ,
        0.0084438714696690 ,
        0.0093804196536945 ,
        0.0103078025748690 ,
        0.0112251140231860 ,
        0.0121314576629795 ,
        0.0130259478929715 ,
        0.0139077107037188 ,
        0.0147758845274413 ,
        0.0156296210775460 ,
        0.0164680861761452 ,
        0.0172904605683236 ,
        0.0180959407221281 ,
        0.0188837396133749 ,
        0.0196530874944353 ,
        0.0204032326462094 ,
        0.0211334421125276 ,
        0.0218430024162474 ,
        0.0225312202563363 ,
        0.0231974231852541 ,
        0.0238409602659682 ,
        0.0244612027079571 ,
        0.0250575444815796 ,
        0.0256294029102081 ,
        0.0261762192395457 ,
        0.0266974591835710 ,
        0.0271926134465769 ,
        0.0276611982207924 ,
        0.0281027556591012 ,
        0.0285168543223951 ,
        0.0289030896011252 ,
        0.0292610841106383 ,
        0.0295904880599126 ,
        0.0298909795933328 ,
        0.0301622651051691 ,
        0.0304040795264548 ,
        0.0306161865839804 ,
        0.0307983790311526 ,
        0.0309504788504910 ,
        0.0310723374275665 ,
        0.0311638356962099 ,
        0.0312248842548494 ,
        0.0312554234538634 ,
        0.0312554234538634 ,
        0.0312248842548494 ,
        0.0311638356962099 ,
        0.0310723374275665 ,
        0.0309504788504910 ,
        0.0307983790311526 ,
        0.0306161865839804 ,
        0.0304040795264548 ,
        0.0301622651051691 ,
        0.0298909795933328 ,
        0.0295904880599126 ,
        0.0292610841106383 ,
        0.0289030896011252 ,
        0.0285168543223951 ,
        0.0281027556591012 ,
        0.0276611982207924 ,
        0.0271926134465769 ,
        0.0266974591835710 ,
        0.0261762192395457 ,
        0.0256294029102081 ,
        0.0250575444815796 ,
        0.0244612027079571 ,
        0.0238409602659682 ,
        0.0231974231852541 ,
        0.0225312202563363 ,
        0.0218430024162474 ,
        0.0211334421125276 ,
        0.0204032326462094 ,
        0.0196530874944353 ,
        0.0188837396133749 ,
        0.0180959407221281 ,
        0.0172904605683236 ,
        0.0164680861761452 ,
        0.0156296210775460 ,
        0.0147758845274413 ,
        0.0139077107037188 ,
        0.0130259478929715 ,
        0.0121314576629795 ,
        0.0112251140231860 ,
        0.0103078025748690 ,
        0.0093804196536945 ,
        0.0084438714696690 ,
        0.0074990732554647 ,
        0.0065469484508453 ,
        0.0055884280038655 ,
        0.0046244500634221 ,
        0.0036559612013264 ,
        0.0026839253715535 ,
        0.0017093926535181 ,
        0.0007346344905057 } /* 2.000000000000000 */ ;

const double points_n128[] = {
       -0.9998248879471319 ,
       -0.9990774599773758 ,
       -0.9977332486255140 ,
       -0.9957927585349812 ,
       -0.9932571129002129 ,
       -0.9901278184917344 ,
       -0.9864067427245862 ,
       -0.9820961084357185 ,
       -0.9771984914639074 ,
       -0.9717168187471366 ,
       -0.9656543664319652 ,
       -0.9590147578536999 ,
       -0.9518019613412644 ,
       -0.9440202878302202 ,
       -0.9356743882779164 ,
       -0.9267692508789478 ,
       -0.9173101980809605 ,
       -0.9073028834017568 ,
       -0.8967532880491582 ,
       -0.8856677173453972 ,
       -0.8740527969580318 ,
       -0.8619154689395485 ,
       -0.8492629875779689 ,
       -0.8361029150609068 ,
       -0.8224431169556439 ,
       -0.8082917575079137 ,
       -0.7936572947621933 ,
       -0.7785484755064119 ,
       -0.7629743300440948 ,
       -0.7469441667970620 ,
       -0.7304675667419088 ,
       -0.7135543776835874 ,
       -0.6962147083695144 ,
       -0.6784589224477192 ,
       -0.6602976322726460 ,
       -0.6417416925623075 ,
       -0.6228021939105849 ,
       -0.6034904561585486 ,
       -0.5838180216287631 ,
       -0.5637966482266181 ,
       -0.5434383024128103 ,
       -0.5227551520511755 ,
       -0.5017595591361445 ,
       -0.4804640724041720 ,
       -0.4588814198335522 ,
       -0.4370245010371042 ,
       -0.4149063795522750 ,
       -0.3925402750332674 ,
       -0.3699395553498590 ,
       -0.3471177285976355 ,
       -0.3240884350244134 ,
       -0.3008654388776772 ,
       -0.2774626201779044 ,
       -0.2538939664226943 ,
       -0.2301735642266600 ,
       -0.2063155909020792 ,
       -0.1823343059853372 ,
       -0.1582440427142249 ,
       -0.1340591994611878 ,
       -0.1097942311276437 ,
       -0.0854636405045155 ,
       -0.0610819696041396 ,
       -0.0366637909687335 ,
       -0.0122236989606158 ,
        0.0122236989606158 ,
        0.0366637909687335 ,
        0.0610819696041396 ,
        0.0854636405045155 ,
        0.1097942311276437 ,
        0.1340591994611878 ,
        0.1582440427142249 ,
        0.1823343059853372 ,
        0.2063155909020792 ,
        0.2301735642266600 ,
        0.2538939664226943 ,
        0.2774626201779044 ,
        0.3008654388776772 ,
        0.3240884350244134 ,
        0.3471177285976355 ,
        0.3699395553498590 ,
        0.3925402750332674 ,
        0.4149063795522750 ,
        0.4370245010371042 ,
        0.4588814198335522 ,
        0.4804640724041720 ,
        0.5017595591361445 ,
        0.5227551520511755 ,
        0.5434383024128103 ,
        0.5637966482266181 ,
        0.5838180216287631 ,
        0.6034904561585486 ,
        0.6228021939105849 ,
        0.6417416925623075 ,
        0.6602976322726460 ,
        0.6784589224477192 ,
        0.6962147083695144 ,
        0.7135543776835874 ,
        0.7304675667419088 ,
        0.7469441667970620 ,
        0.7629743300440948 ,
        0.7785484755064119 ,
        0.7936572947621933 ,
        0.8082917575079137 ,
        0.8224431169556439 ,
        0.8361029150609068 ,
        0.8492629875779689 ,
        0.8619154689395485 ,
        0.8740527969580318 ,
        0.8856677173453972 ,
        0.8967532880491582 ,
        0.9073028834017568 ,
        0.9173101980809605 ,
        0.9267692508789478 ,
        0.9356743882779164 ,
        0.9440202878302202 ,
        0.9518019613412644 ,
        0.9590147578536999 ,
        0.9656543664319652 ,
        0.9717168187471366 ,
        0.9771984914639074 ,
        0.9820961084357185 ,
        0.9864067427245862 ,
        0.9901278184917344 ,
        0.9932571129002129 ,
        0.9957927585349812 ,
        0.9977332486255140 ,
        0.9990774599773758 ,
        0.9998248879471319 };
const double weights_n128[] = {
        0.0004493809602921 ,
        0.0010458126793403 ,
        0.0016425030186690 ,
        0.0022382884309626 ,
        0.0028327514714580 ,
        0.0034255260409102 ,
        0.0040162549837386 ,
        0.0046045842567030 ,
        0.0051901618326763 ,
        0.0057726375428657 ,
        0.0063516631617072 ,
        0.0069268925668988 ,
        0.0074979819256347 ,
        0.0080645898904861 ,
        0.0086263777986168 ,
        0.0091830098716609 ,
        0.0097341534150068 ,
        0.0102794790158322 ,
        0.0108186607395031 ,
        0.0113513763240804 ,
        0.0118773073727403 ,
        0.0123961395439509 ,
        0.0129075627392673 ,
        0.0134112712886163 ,
        0.0139069641329520 ,
        0.0143943450041668 ,
        0.0148731226021473 ,
        0.0153430107688651 ,
        0.0158037286593993 ,
        0.0162550009097852 ,
        0.0166965578015892 ,
        0.0171281354231114 ,
        0.0175494758271177 ,
        0.0179603271850087 ,
        0.0183604439373313 ,
        0.0187495869405447 ,
        0.0191275236099509 ,
        0.0194940280587066 ,
        0.0198488812328309 ,
        0.0201918710421300 ,
        0.0205227924869601 ,
        0.0208414477807512 ,
        0.0211476464682213 ,
        0.0214412055392085 ,
        0.0217219495380521 ,
        0.0219897106684605 ,
        0.0222443288937998 ,
        0.0224856520327450 ,
        0.0227135358502365 ,
        0.0229278441436868 ,
        0.0231284488243870 ,
        0.0233152299940628 ,
        0.0234880760165359 ,
        0.0236468835844476 ,
        0.0237915577810034 ,
        0.0239220121367035 ,
        0.0240381686810241 ,
        0.0241399579890193 ,
        0.0242273192228152 ,
        0.0243002001679719 ,
        0.0243585572646906 ,
        0.0244023556338496 ,
        0.0244315690978500 ,
        0.0244461801962625 ,
        0.0244461801962625 ,
        0.0244315690978500 ,
        0.0244023556338496 ,
        0.0243585572646906 ,
        0.0243002001679719 ,
        0.0242273192228152 ,
        0.0241399579890193 ,
        0.0240381686810241 ,
        0.0239220121367035 ,
        0.0237915577810034 ,
        0.0236468835844476 ,
        0.0234880760165359 ,
        0.0233152299940628 ,
        0.0231284488243870 ,
        0.0229278441436868 ,
        0.0227135358502365 ,
        0.0224856520327450 ,
        0.0222443288937998 ,
        0.0219897106684605 ,
        0.0217219495380521 ,
        0.0214412055392085 ,
        0.0211476464682213 ,
        0.0208414477807512 ,
        0.0205227924869601 ,
        0.0201918710421300 ,
        0.0198488812328309 ,
        0.0194940280587066 ,
        0.0191275236099509 ,
        0.0187495869405447 ,
        0.0183604439373313 ,
        0.0179603271850087 ,
        0.0175494758271177 ,
        0.0171281354231114 ,
        0.0166965578015892 ,
        0.0162550009097852 ,
        0.0158037286593993 ,
        0.0153430107688651 ,
        0.0148731226021473 ,
        0.0143943450041668 ,
        0.0139069641329520 ,
        0.0134112712886163 ,
        0.0129075627392673 ,
        0.0123961395439509 ,
        0.0118773073727403 ,
        0.0113513763240804 ,
        0.0108186607395031 ,
        0.0102794790158322 ,
        0.0097341534150068 ,
        0.0091830098716609 ,
        0.0086263777986168 ,
        0.0080645898904861 ,
        0.0074979819256347 ,
        0.0069268925668988 ,
        0.0063516631617072 ,
        0.0057726375428657 ,
        0.0051901618326763 ,
        0.0046045842567030 ,
        0.0040162549837386 ,
        0.0034255260409102 ,
        0.0028327514714580 ,
        0.0022382884309626 ,
        0.0016425030186690 ,
        0.0010458126793403 ,
        0.0004493809602921 } /* 2.000000000000000 */ ;

const double points_n256[] = {
       -0.9999560500189922 ,
       -0.9997684374092631 ,
       -0.9994309374662614 ,
       -0.9989435258434088 ,
       -0.9983062664730065 ,
       -0.9975192527567208 ,
       -0.9965826020233816 ,
       -0.9954964544810964 ,
       -0.9942609729224097 ,
       -0.9928763426088221 ,
       -0.9913427712075831 ,
       -0.9896604887450652 ,
       -0.9878297475648606 ,
       -0.9858508222861260 ,
       -0.9837240097603155 ,
       -0.9814496290254644 ,
       -0.9790280212576220 ,
       -0.9764595497192342 ,
       -0.9737445997043704 ,
       -0.9708835784807430 ,
       -0.9678769152284895 ,
       -0.9647250609757064 ,
       -0.9614284885307322 ,
       -0.9579876924111781 ,
       -0.9544031887697162 ,
       -0.9506755153166283 ,
       -0.9468052312391275 ,
       -0.9427929171174625 ,
       -0.9386391748378148 ,
       -0.9343446275020031 ,
       -0.9299099193340057 ,
       -0.9253357155833162 ,
       -0.9206227024251465 ,
       -0.9157715868574904 ,
       -0.9107830965950651 ,
       -0.9056579799601446 ,
       -0.9003970057703036 ,
       -0.8950009632230845 ,
       -0.8894706617776109 ,
       -0.8838069310331583 ,
       -0.8780106206047066 ,
       -0.8720825999954883 ,
       -0.8660237584665545 ,
       -0.8598350049033764 ,
       -0.8535172676795030 ,
       -0.8470714945172962 ,
       -0.8404986523457627 ,
       -0.8337997271555049 ,
       -0.8269757238508125 ,
       -0.8200276660989171 ,
       -0.8129565961764316 ,
       -0.8057635748129987 ,
       -0.7984496810321707 ,
       -0.7910160119895460 ,
       -0.7834636828081838 ,
       -0.7757938264113258 ,
       -0.7680075933524456 ,
       -0.7601061516426555 ,
       -0.7520906865754921 ,
       -0.7439624005491116 ,
       -0.7357225128859178 ,
       -0.7273722596496521 ,
       -0.7189128934599714 ,
       -0.7103456833045433 ,
       -0.7016719143486851 ,
       -0.6928928877425770 ,
       -0.6840099204260760 ,
       -0.6750243449311628 ,
       -0.6659375091820485 ,
       -0.6567507762929732 ,
       -0.6474655243637248 ,
       -0.6380831462729114 ,
       -0.6286050494690150 ,
       -0.6190326557592613 ,
       -0.6093674010963339 ,
       -0.5996107353629683 ,
       -0.5897641221544543 ,
       -0.5798290385590830 ,
       -0.5698069749365687 ,
       -0.5596994346944811 ,
       -0.5495079340627186 ,
       -0.5392340018660592 ,
       -0.5288791792948223 ,
       -0.5184450196736745 ,
       -0.5079330882286160 ,
       -0.4973449618521815 ,
       -0.4866822288668903 ,
       -0.4759464887869833 ,
       -0.4651393520784793 ,
       -0.4542624399175900 ,
       -0.4433173839475273 ,
       -0.4323058260337413 ,
       -0.4212294180176238 ,
       -0.4100898214687165 ,
       -0.3988887074354591 ,
       -0.3876277561945156 ,
       -0.3763086569987164 ,
       -0.3649331078236540 ,
       -0.3535028151129700 ,
       -0.3420194935223717 ,
       -0.3304848656624170 ,
       -0.3189006618401063 ,
       -0.3072686197993191 ,
       -0.2955904844601356 ,
       -0.2838680076570818 ,
       -0.2721029478763366 ,
       -0.2602970699919425 ,
       -0.2484521450010567 ,
       -0.2365699497582840 ,
       -0.2246522667091320 ,
       -0.2127008836226260 ,
       -0.2007175933231267 ,
       -0.1887041934213888 ,
       -0.1766624860449020 ,
       -0.1645942775675538 ,
       -0.1525013783386564 ,
       -0.1403856024113759 ,
       -0.1282487672706071 ,
       -0.1160926935603328 ,
       -0.1039192048105094 ,
       -0.0917301271635196 ,
       -0.0795272891002330 ,
       -0.0673125211657164 ,
       -0.0550876556946340 ,
       -0.0428545265363791 ,
       -0.0306149687799790 ,
       -0.0183708184788137 ,
       -0.0061239123751895 ,
        0.0061239123751895 ,
        0.0183708184788137 ,
        0.0306149687799790 ,
        0.0428545265363791 ,
        0.0550876556946340 ,
        0.0673125211657164 ,
        0.0795272891002330 ,
        0.0917301271635196 ,
        0.1039192048105094 ,
        0.1160926935603328 ,
        0.1282487672706071 ,
        0.1403856024113759 ,
        0.1525013783386564 ,
        0.1645942775675538 ,
        0.1766624860449020 ,
        0.1887041934213888 ,
        0.2007175933231267 ,
        0.2127008836226260 ,
        0.2246522667091320 ,
        0.2365699497582840 ,
        0.2484521450010567 ,
        0.2602970699919425 ,
        0.2721029478763366 ,
        0.2838680076570818 ,
        0.2955904844601356 ,
        0.3072686197993191 ,
        0.3189006618401063 ,
        0.3304848656624170 ,
        0.3420194935223717 ,
        0.3535028151129700 ,
        0.3649331078236540 ,
        0.3763086569987164 ,
        0.3876277561945156 ,
        0.3988887074354591 ,
        0.4100898214687165 ,
        0.4212294180176238 ,
        0.4323058260337413 ,
        0.4433173839475273 ,
        0.4542624399175900 ,
        0.4651393520784793 ,
        0.4759464887869833 ,
        0.4866822288668903 ,
        0.4973449618521815 ,
        0.5079330882286160 ,
        0.5184450196736745 ,
        0.5288791792948223 ,
        0.5392340018660592 ,
        0.5495079340627186 ,
        0.5596994346944811 ,
        0.5698069749365687 ,
        0.5798290385590830 ,
        0.5897641221544543 ,
        0.5996107353629683 ,
        0.6093674010963339 ,
        0.6190326557592613 ,
        0.6286050494690150 ,
        0.6380831462729114 ,
        0.6474655243637248 ,
        0.6567507762929732 ,
        0.6659375091820485 ,
        0.6750243449311628 ,
        0.6840099204260760 ,
        0.6928928877425770 ,
        0.7016719143486851 ,
        0.7103456833045433 ,
        0.7189128934599714 ,
        0.7273722596496521 ,
        0.7357225128859178 ,
        0.7439624005491116 ,
        0.7520906865754921 ,
        0.7601061516426555 ,
        0.7680075933524456 ,
        0.7757938264113258 ,
        0.7834636828081838 ,
        0.7910160119895460 ,
        0.7984496810321707 ,
        0.8057635748129987 ,
        0.8129565961764316 ,
        0.8200276660989171 ,
        0.8269757238508125 ,
        0.8337997271555049 ,
        0.8404986523457627 ,
        0.8470714945172962 ,
        0.8535172676795030 ,
        0.8598350049033764 ,
        0.8660237584665545 ,
        0.8720825999954883 ,
        0.8780106206047066 ,
        0.8838069310331583 ,
        0.8894706617776109 ,
        0.8950009632230845 ,
        0.9003970057703036 ,
        0.9056579799601446 ,
        0.9107830965950651 ,
        0.9157715868574904 ,
        0.9206227024251465 ,
        0.9253357155833162 ,
        0.9299099193340057 ,
        0.9343446275020031 ,
        0.9386391748378148 ,
        0.9427929171174625 ,
        0.9468052312391275 ,
        0.9506755153166283 ,
        0.9544031887697162 ,
        0.9579876924111781 ,
        0.9614284885307322 ,
        0.9647250609757064 ,
        0.9678769152284895 ,
        0.9708835784807430 ,
        0.9737445997043704 ,
        0.9764595497192342 ,
        0.9790280212576220 ,
        0.9814496290254644 ,
        0.9837240097603155 ,
        0.9858508222861260 ,
        0.9878297475648606 ,
        0.9896604887450652 ,
        0.9913427712075831 ,
        0.9928763426088221 ,
        0.9942609729224097 ,
        0.9954964544810964 ,
        0.9965826020233816 ,
        0.9975192527567208 ,
        0.9983062664730065 ,
        0.9989435258434088 ,
        0.9994309374662614 ,
        0.9997684374092631 ,
        0.9999560500189922 };
const double weights_n256[] = {
        0.0001127890178223 ,
        0.0002625349442964 ,
        0.0004124632544262 ,
        0.0005623489540314 ,
        0.0007121541634733 ,
        0.0008618537014201 ,
        0.0010114243932084 ,
        0.0011608435575677 ,
        0.0013100886819025 ,
        0.0014591373333107 ,
        0.0016079671307493 ,
        0.0017565557363307 ,
        0.0019048808534997 ,
        0.0020529202279661 ,
        0.0022006516498399 ,
        0.0023480529563273 ,
        0.0024951020347037 ,
        0.0026417768254275 ,
        0.0027880553253277 ,
        0.0029339155908297 ,
        0.0030793357411993 ,
        0.0032242939617942 ,
        0.0033687685073156 ,
        0.0035127377050563 ,
        0.0036561799581425 ,
        0.0037990737487663 ,
        0.0039413976414088 ,
        0.0040831302860527 ,
        0.0042242504213815 ,
        0.0043647368779681 ,
        0.0045045685814479 ,
        0.0046437245556801 ,
        0.0047821839258927 ,
        0.0049199259218139 ,
        0.0050569298807868 ,
        0.0051931752508693 ,
        0.0053286415939159 ,
        0.0054633085886443 ,
        0.0055971560336829 ,
        0.0057301638506014 ,
        0.0058623120869227 ,
        0.0059935809191153 ,
        0.0061239506555679 ,
        0.0062534017395424 ,
        0.0063819147521079 ,
        0.0065094704150537 ,
        0.0066360495937811 ,
        0.0067616333001738 ,
        0.0068862026954463 ,
        0.0070097390929698 ,
        0.0071322239610754 ,
        0.0072536389258339 ,
        0.0073739657738123 ,
        0.0074931864548059 ,
        0.0076112830845457 ,
        0.0077282379473816 ,
        0.0078440334989397 ,
        0.0079586523687543 ,
        0.0080720773628735 ,
        0.0081842914664383 ,
        0.0082952778462352 ,
        0.0084050198532215 ,
        0.0085135010250225 ,
        0.0086207050884010 ,
        0.0087266159616988 ,
        0.0088312177572488 ,
        0.0089344947837582 ,
        0.0090364315486629 ,
        0.0091370127604508 ,
        0.0092362233309563 ,
        0.0093340483776233 ,
        0.0094304732257378 ,
        0.0095254834106293 ,
        0.0096190646798407 ,
        0.0097112029952663 ,
        0.0098018845352573 ,
        0.0098910956966958 ,
        0.0099788230970349 ,
        0.0100650535763064 ,
        0.0101497741990949 ,
        0.0102329722564782 ,
        0.0103146352679340 ,
        0.0103947509832117 ,
        0.0104733073841704 ,
        0.0105502926865815 ,
        0.0106256953418966 ,
        0.0106995040389798 ,
        0.0107717077058046 ,
        0.0108422955111148 ,
        0.0109112568660490 ,
        0.0109785814257296 ,
        0.0110442590908139 ,
        0.0111082800090098 ,
        0.0111706345765534 ,
        0.0112313134396497 ,
        0.0112903074958755 ,
        0.0113476078955455 ,
        0.0114032060430392 ,
        0.0114570935980906 ,
        0.0115092624770395 ,
        0.0115597048540436 ,
        0.0116084131622531 ,
        0.0116553800949452 ,
        0.0117005986066207 ,
        0.0117440619140605 ,
        0.0117857634973434 ,
        0.0118256971008240 ,
        0.0118638567340711 ,
        0.0119002366727665 ,
        0.0119348314595636 ,
        0.0119676359049059 ,
        0.0119986450878058 ,
        0.0120278543565826 ,
        0.0120552593295602 ,
        0.0120808558957245 ,
        0.0121046402153405 ,
        0.0121266087205273 ,
        0.0121467581157945 ,
        0.0121650853785355 ,
        0.0121815877594818 ,
        0.0121962627831147 ,
        0.0122091082480372 ,
        0.0122201222273040 ,
        0.0122293030687103 ,
        0.0122366493950402 ,
        0.0122421601042728 ,
        0.0122458343697479 ,
        0.0122476716402898 ,
        0.0122476716402898 ,
        0.0122458343697479 ,
        0.0122421601042728 ,
        0.0122366493950402 ,
        0.0122293030687103 ,
        0.0122201222273040 ,
        0.0122091082480372 ,
        0.0121962627831147 ,
        0.0121815877594818 ,
        0.0121650853785355 ,
        0.0121467581157945 ,
        0.0121266087205273 ,
        0.0121046402153405 ,
        0.0120808558957245 ,
        0.0120552593295602 ,
        0.0120278543565826 ,
        0.0119986450878058 ,
        0.0119676359049059 ,
        0.0119348314595636 ,
        0.0119002366727665 ,
        0.0118638567340711 ,
        0.0118256971008240 ,
        0.0117857634973434 ,
        0.0117440619140605 ,
        0.0117005986066207 ,
        0.0116553800949452 ,
        0.0116084131622531 ,
        0.0115597048540436 ,
        0.0115092624770395 ,
        0.0114570935980906 ,
        0.0114032060430392 ,
        0.0113476078955455 ,
        0.0112903074958755 ,
        0.0112313134396497 ,
        0.0111706345765534 ,
        0.0111082800090098 ,
        0.0110442590908139 ,
        0.0109785814257296 ,
        0.0109112568660490 ,
        0.0108422955111148 ,
        0.0107717077058046 ,
        0.0106995040389798 ,
        0.0106256953418966 ,
        0.0105502926865815 ,
        0.0104733073841704 ,
        0.0103947509832117 ,
        0.0103146352679340 ,
        0.0102329722564782 ,
        0.0101497741990949 ,
        0.0100650535763064 ,
        0.0099788230970349 ,
        0.0098910956966958 ,
        0.0098018845352573 ,
        0.0097112029952663 ,
        0.0096190646798407 ,
        0.0095254834106293 ,
        0.0094304732257378 ,
        0.0093340483776233 ,
        0.0092362233309563 ,
        0.0091370127604508 ,
        0.0090364315486629 ,
        0.0089344947837582 ,
        0.0088312177572488 ,
        0.0087266159616988 ,
        0.0086207050884010 ,
        0.0085135010250225 ,
        0.0084050198532215 ,
        0.0082952778462352 ,
        0.0081842914664383 ,
        0.0080720773628735 ,
        0.0079586523687543 ,
        0.0078440334989397 ,
        0.0077282379473816 ,
        0.0076112830845457 ,
        0.0074931864548059 ,
        0.0073739657738123 ,
        0.0072536389258339 ,
        0.0071322239610754 ,
        0.0070097390929698 ,
        0.0068862026954463 ,
        0.0067616333001738 ,
        0.0066360495937811 ,
        0.0065094704150537 ,
        0.0063819147521079 ,
        0.0062534017395424 ,
        0.0061239506555679 ,
        0.0059935809191153 ,
        0.0058623120869227 ,
        0.0057301638506014 ,
        0.0055971560336829 ,
        0.0054633085886443 ,
        0.0053286415939159 ,
        0.0051931752508693 ,
        0.0050569298807868 ,
        0.0049199259218139 ,
        0.0047821839258927 ,
        0.0046437245556801 ,
        0.0045045685814479 ,
        0.0043647368779681 ,
        0.0042242504213815 ,
        0.0040831302860527 ,
        0.0039413976414088 ,
        0.0037990737487663 ,
        0.0036561799581425 ,
        0.0035127377050563 ,
        0.0033687685073156 ,
        0.0032242939617942 ,
        0.0030793357411993 ,
        0.0029339155908297 ,
        0.0027880553253277 ,
        0.0026417768254275 ,
        0.0024951020347037 ,
        0.0023480529563273 ,
        0.0022006516498399 ,
        0.0020529202279661 ,
        0.0019048808534997 ,
        0.0017565557363307 ,
        0.0016079671307493 ,
        0.0014591373333107 ,
        0.0013100886819025 ,
        0.0011608435575677 ,
        0.0010114243932084 ,
        0.0008618537014201 ,
        0.0007121541634733 ,
        0.0005623489540314 ,
        0.0004124632544262 ,
        0.0002625349442964 ,
        0.0001127890178223 } /* 2.000000000000000 */ ;

const double points_n512[] = {
       -0.9999889909843819 ,
       -0.9999419946068456 ,
       -0.9998574463699794 ,
       -0.9997353306710427 ,
       -0.9995756497983108 ,
       -0.9993784092025992 ,
       -0.9991436161123782 ,
       -0.9988712792754494 ,
       -0.9985614088900397 ,
       -0.9982140165816128 ,
       -0.9978291153935629 ,
       -0.9974067197828498 ,
       -0.9969468456176038 ,
       -0.9964495101755774 ,
       -0.9959147321429772 ,
       -0.9953425316134658 ,
       -0.9947329300872282 ,
       -0.9940859504700559 ,
       -0.9934016170724148 ,
       -0.9926799556084865 ,
       -0.9919209931951715 ,
       -0.9911247583510481 ,
       -0.9902912809952868 ,
       -0.9894205924465157 ,
       -0.9885127254216350 ,
       -0.9875677140345829 ,
       -0.9865855937950492 ,
       -0.9855664016071379 ,
       -0.9845101757679784 ,
       -0.9834169559662840 ,
       -0.9822867832808596 ,
       -0.9811197001790571 ,
       -0.9799157505151782 ,
       -0.9786749795288263 ,
       -0.9773974338432059 ,
       -0.9760831614633703 ,
       -0.9747322117744170 ,
       -0.9733446355396325 ,
       -0.9719204848985836 ,
       -0.9704598133651587 ,
       -0.9689626758255566 ,
       -0.9674291285362238 ,
       -0.9658592291217407 ,
       -0.9642530365726560 ,
       -0.9626106112432703 ,
       -0.9609320148493677 ,
       -0.9592173104658972 ,
       -0.9574665625246019 ,
       -0.9556798368115988 ,
       -0.9538572004649060 ,
       -0.9519987219719198 ,
       -0.9501044711668419 ,
       -0.9481745192280551 ,
       -0.9462089386754480 ,
       -0.9442078033676905 ,
       -0.9421711884994589 ,
       -0.9400991705986094 ,
       -0.9379918275233031 ,
       -0.9358492384590805 ,
       -0.9336714839158854 ,
       -0.9314586457250403 ,
       -0.9292108070361711 ,
       -0.9269280523140828 ,
       -0.9246104673355856 ,
       -0.9222581391862719 ,
       -0.9198711562572436 ,
       -0.9174496082417911 ,
       -0.9149935861320229 ,
       -0.9125031822154460 ,
       -0.9099784900714992 ,
       -0.9074196045680355 ,
       -0.9048266218577580 ,
       -0.9021996393746068 ,
       -0.8995387558300979 ,
       -0.8968440712096138 ,
       -0.8941156867686465 ,
       -0.8913537050289927 ,
       -0.8885582297749018 ,
       -0.8857293660491754 ,
       -0.8828672201492210 ,
       -0.8799718996230571 ,
       -0.8770435132652723 ,
       -0.8740821711129373 ,
       -0.8710879844414698 ,
       -0.8680610657604539 ,
       -0.8650015288094115 ,
       -0.8619094885535290 ,
       -0.8587850611793374 ,
       -0.8556283640903465 ,
       -0.8524395159026327 ,
       -0.8492186364403826 ,
       -0.8459658467313906 ,
       -0.8426812690025105 ,
       -0.8393650266750627 ,
       -0.8360172443601974 ,
       -0.8326380478542114 ,
       -0.8292275641338213 ,
       -0.8257859213513925 ,
       -0.8223132488301236 ,
       -0.8188096770591868 ,
       -0.8152753376888249 ,
       -0.8117103635254043 ,
       -0.8081148885264243 ,
       -0.8044890477954846 ,
       -0.8008329775772071 ,
       -0.7971468152521175 ,
       -0.7934306993314830 ,
       -0.7896847694521072 ,
       -0.7859091663710830 ,
       -0.7821040319605042 ,
       -0.7782695092021338 ,
       -0.7744057421820317 ,
       -0.7705128760851405 ,
       -0.7665910571898299 ,
       -0.7626404328624002 ,
       -0.7586611515515449 ,
       -0.7546533627827725 ,
       -0.7506172171527881 ,
       -0.7465528663238341 ,
       -0.7424604630179923 ,
       -0.7383401610114442 ,
       -0.7341921151286930 ,
       -0.7300164812367466 ,
       -0.7258134162392593 ,
       -0.7215830780706379 ,
       -0.7173256256901053 ,
       -0.7130412190757285 ,
       -0.7087300192184071 ,
       -0.7043921881158238 ,
       -0.7000278887663572 ,
       -0.6956372851629570 ,
       -0.6912205422869816 ,
       -0.6867778261019991 ,
       -0.6823093035475509 ,
       -0.6778151425328788 ,
       -0.6732955119306152 ,
       -0.6687505815704384 ,
       -0.6641805222326905 ,
       -0.6595855056419603 ,
       -0.6549657044606303 ,
       -0.6503212922823893 ,
       -0.6456524436257089 ,
       -0.6409593339272864 ,
       -0.6362421395354517 ,
       -0.6315010377035416 ,
       -0.6267362065832393 ,
       -0.6219478252178794 ,
       -0.6171360735357212 ,
       -0.6123011323431869 ,
       -0.6074431833180683 ,
       -0.6025624090026994 ,
       -0.5976589927970977 ,
       -0.5927331189520721 ,
       -0.5877849725623008 ,
       -0.5828147395593745 ,
       -0.5778226067048111 ,
       -0.5728087615830374 ,
       -0.5677733925943407 ,
       -0.5627166889477890 ,
       -0.5576388406541219 ,
       -0.5525400385186102 ,
       -0.5474204741338866 ,
       -0.5422803398727462 ,
       -0.5371198288809178 ,
       -0.5319391350698066 ,
       -0.5267384531092077 ,
       -0.5215179784199908 ,
       -0.5162779071667575 ,
       -0.5110184362504699 ,
       -0.5057397633010522 ,
       -0.5004420866699644 ,
       -0.4951256054227486 ,
       -0.4897905193315499 ,
       -0.4844370288676086 ,
       -0.4790653351937285 ,
       -0.4736756401567166 ,
       -0.4682681462798001 ,
       -0.4628430567550148 ,
       -0.4574005754355713 ,
       -0.4519409068281941 ,
       -0.4464642560854375 ,
       -0.4409708289979767 ,
       -0.4354608319868747 ,
       -0.4299344720958266 ,
       -0.4243919569833787 ,
       -0.4188334949151263 ,
       -0.4132592947558876 ,
       -0.4076695659618556 ,
       -0.4020645185727270 ,
       -0.3964443632038105 ,
       -0.3908093110381125 ,
       -0.3851595738184011 ,
       -0.3794953638392505 ,
       -0.3738168939390634 ,
       -0.3681243774920731 ,
       -0.3624180284003264 ,
       -0.3566980610856456 ,
       -0.3509646904815714 ,
       -0.3452181320252867 ,
       -0.3394586016495210 ,
       -0.3336863157744371 ,
       -0.3279014912994984 ,
       -0.3221043455953188 ,
       -0.3162950964954949 ,
       -0.3104739622884204 ,
       -0.3046411617090842 ,
       -0.2987969139308507 ,
       -0.2929414385572244 ,
       -0.2870749556135980 ,
       -0.2811976855389847 ,
       -0.2753098491777350 ,
       -0.2694116677712386 ,
       -0.2635033629496103 ,
       -0.2575851567233626 ,
       -0.2516572714750633 ,
       -0.2457199299509792 ,
       -0.2397733552527062 ,
       -0.2338177708287859 ,
       -0.2278534004663096 ,
       -0.2218804682825090 ,
       -0.2158991987163350 ,
       -0.2099098165200239 ,
       -0.2039125467506524 ,
       -0.1979076147616805 ,
       -0.1918952461944840 ,
       -0.1858756669698757 ,
       -0.1798491032796159 ,
       -0.1738157815779134 ,
       -0.1677759285729161 ,
       -0.1617297712181921 ,
       -0.1556775367042019 ,
       -0.1496194524497613 ,
       -0.1435557460934960 ,
       -0.1374866454852881 ,
       -0.1314123786777137 ,
       -0.1253331739174745 ,
       -0.1192492596368204 ,
       -0.1131608644449665 ,
       -0.1070682171195027 ,
       -0.1009715465977968 ,
       -0.0948710819683925 ,
       -0.0887670524624010 ,
       -0.0826596874448872 ,
       -0.0765492164062510 ,
       -0.0704358689536047 ,
       -0.0643198748021442 ,
       -0.0582014637665182 ,
       -0.0520808657521921 ,
       -0.0459583107468091 ,
       -0.0398340288115484 ,
       -0.0337082500724806 ,
       -0.0275812047119198 ,
       -0.0214531229597749 ,
       -0.0153242350848982 ,
       -0.0091947713864329 ,
       -0.0030649621851594 ,
        0.0030649621851594 ,
        0.0091947713864329 ,
        0.0153242350848982 ,
        0.0214531229597749 ,
        0.0275812047119198 ,
        0.0337082500724806 ,
        0.0398340288115484 ,
        0.0459583107468091 ,
        0.0520808657521921 ,
        0.0582014637665182 ,
        0.0643198748021442 ,
        0.0704358689536047 ,
        0.0765492164062510 ,
        0.0826596874448872 ,
        0.0887670524624010 ,
        0.0948710819683925 ,
        0.1009715465977968 ,
        0.1070682171195027 ,
        0.1131608644449665 ,
        0.1192492596368204 ,
        0.1253331739174745 ,
        0.1314123786777137 ,
        0.1374866454852881 ,
        0.1435557460934960 ,
        0.1496194524497613 ,
        0.1556775367042019 ,
        0.1617297712181921 ,
        0.1677759285729161 ,
        0.1738157815779134 ,
        0.1798491032796159 ,
        0.1858756669698757 ,
        0.1918952461944840 ,
        0.1979076147616805 ,
        0.2039125467506524 ,
        0.2099098165200239 ,
        0.2158991987163350 ,
        0.2218804682825090 ,
        0.2278534004663096 ,
        0.2338177708287859 ,
        0.2397733552527062 ,
        0.2457199299509792 ,
        0.2516572714750633 ,
        0.2575851567233626 ,
        0.2635033629496103 ,
        0.2694116677712386 ,
        0.2753098491777350 ,
        0.2811976855389847 ,
        0.2870749556135980 ,
        0.2929414385572244 ,
        0.2987969139308507 ,
        0.3046411617090842 ,
        0.3104739622884204 ,
        0.3162950964954949 ,
        0.3221043455953188 ,
        0.3279014912994984 ,
        0.3336863157744371 ,
        0.3394586016495210 ,
        0.3452181320252867 ,
        0.3509646904815714 ,
        0.3566980610856456 ,
        0.3624180284003264 ,
        0.3681243774920731 ,
        0.3738168939390634 ,
        0.3794953638392505 ,
        0.3851595738184011 ,
        0.3908093110381125 ,
        0.3964443632038105 ,
        0.4020645185727270 ,
        0.4076695659618556 ,
        0.4132592947558876 ,
        0.4188334949151263 ,
        0.4243919569833787 ,
        0.4299344720958266 ,
        0.4354608319868747 ,
        0.4409708289979767 ,
        0.4464642560854375 ,
        0.4519409068281941 ,
        0.4574005754355713 ,
        0.4628430567550148 ,
        0.4682681462798001 ,
        0.4736756401567166 ,
        0.4790653351937285 ,
        0.4844370288676086 ,
        0.4897905193315499 ,
        0.4951256054227486 ,
        0.5004420866699644 ,
        0.5057397633010522 ,
        0.5110184362504699 ,
        0.5162779071667575 ,
        0.5215179784199908 ,
        0.5267384531092077 ,
        0.5319391350698066 ,
        0.5371198288809178 ,
        0.5422803398727462 ,
        0.5474204741338866 ,
        0.5525400385186102 ,
        0.5576388406541219 ,
        0.5627166889477890 ,
        0.5677733925943407 ,
        0.5728087615830374 ,
        0.5778226067048111 ,
        0.5828147395593745 ,
        0.5877849725623008 ,
        0.5927331189520721 ,
        0.5976589927970977 ,
        0.6025624090026994 ,
        0.6074431833180683 ,
        0.6123011323431869 ,
        0.6171360735357212 ,
        0.6219478252178794 ,
        0.6267362065832393 ,
        0.6315010377035416 ,
        0.6362421395354517 ,
        0.6409593339272864 ,
        0.6456524436257089 ,
        0.6503212922823893 ,
        0.6549657044606303 ,
        0.6595855056419603 ,
        0.6641805222326905 ,
        0.6687505815704384 ,
        0.6732955119306152 ,
        0.6778151425328788 ,
        0.6823093035475509 ,
        0.6867778261019991 ,
        0.6912205422869816 ,
        0.6956372851629570 ,
        0.7000278887663572 ,
        0.7043921881158238 ,
        0.7087300192184071 ,
        0.7130412190757285 ,
        0.7173256256901053 ,
        0.7215830780706379 ,
        0.7258134162392593 ,
        0.7300164812367466 ,
        0.7341921151286930 ,
        0.7383401610114442 ,
        0.7424604630179923 ,
        0.7465528663238341 ,
        0.7506172171527881 ,
        0.7546533627827725 ,
        0.7586611515515449 ,
        0.7626404328624002 ,
        0.7665910571898299 ,
        0.7705128760851405 ,
        0.7744057421820317 ,
        0.7782695092021338 ,
        0.7821040319605042 ,
        0.7859091663710830 ,
        0.7896847694521072 ,
        0.7934306993314830 ,
        0.7971468152521175 ,
        0.8008329775772071 ,
        0.8044890477954846 ,
        0.8081148885264243 ,
        0.8117103635254043 ,
        0.8152753376888249 ,
        0.8188096770591868 ,
        0.8223132488301236 ,
        0.8257859213513925 ,
        0.8292275641338213 ,
        0.8326380478542114 ,
        0.8360172443601974 ,
        0.8393650266750627 ,
        0.8426812690025105 ,
        0.8459658467313906 ,
        0.8492186364403826 ,
        0.8524395159026327 ,
        0.8556283640903465 ,
        0.8587850611793374 ,
        0.8619094885535290 ,
        0.8650015288094115 ,
        0.8680610657604539 ,
        0.8710879844414698 ,
        0.8740821711129373 ,
        0.8770435132652723 ,
        0.8799718996230571 ,
        0.8828672201492210 ,
        0.8857293660491754 ,
        0.8885582297749018 ,
        0.8913537050289927 ,
        0.8941156867686465 ,
        0.8968440712096138 ,
        0.8995387558300979 ,
        0.9021996393746068 ,
        0.9048266218577580 ,
        0.9074196045680355 ,
        0.9099784900714992 ,
        0.9125031822154460 ,
        0.9149935861320229 ,
        0.9174496082417911 ,
        0.9198711562572436 ,
        0.9222581391862719 ,
        0.9246104673355856 ,
        0.9269280523140828 ,
        0.9292108070361711 ,
        0.9314586457250403 ,
        0.9336714839158854 ,
        0.9358492384590805 ,
        0.9379918275233031 ,
        0.9400991705986094 ,
        0.9421711884994589 ,
        0.9442078033676905 ,
        0.9462089386754480 ,
        0.9481745192280551 ,
        0.9501044711668419 ,
        0.9519987219719198 ,
        0.9538572004649060 ,
        0.9556798368115988 ,
        0.9574665625246019 ,
        0.9592173104658972 ,
        0.9609320148493677 ,
        0.9626106112432703 ,
        0.9642530365726560 ,
        0.9658592291217407 ,
        0.9674291285362238 ,
        0.9689626758255566 ,
        0.9704598133651587 ,
        0.9719204848985836 ,
        0.9733446355396325 ,
        0.9747322117744170 ,
        0.9760831614633703 ,
        0.9773974338432059 ,
        0.9786749795288263 ,
        0.9799157505151782 ,
        0.9811197001790571 ,
        0.9822867832808596 ,
        0.9834169559662840 ,
        0.9845101757679784 ,
        0.9855664016071379 ,
        0.9865855937950492 ,
        0.9875677140345829 ,
        0.9885127254216350 ,
        0.9894205924465157 ,
        0.9902912809952868 ,
        0.9911247583510481 ,
        0.9919209931951715 ,
        0.9926799556084865 ,
        0.9934016170724148 ,
        0.9940859504700559 ,
        0.9947329300872282 ,
        0.9953425316134658 ,
        0.9959147321429772 ,
        0.9964495101755774 ,
        0.9969468456176038 ,
        0.9974067197828498 ,
        0.9978291153935629 ,
        0.9982140165816128 ,
        0.9985614088900397 ,
        0.9988712792754494 ,
        0.9991436161123782 ,
        0.9993784092025992 ,
        0.9995756497983108 ,
        0.9997353306710427 ,
        0.9998574463699794 ,
        0.9999419946068456 ,
        0.9999889909843819 };
const double weights_n512[] = {
        0.0000282526373739 ,
        0.0000657657316592 ,
        0.0001033319034969 ,
        0.0001408990173882 ,
        0.0001784618055460 ,
        0.0002160181779770 ,
        0.0002535665435706 ,
        0.0002911054302515 ,
        0.0003286334028523 ,
        0.0003661490400356 ,
        0.0004036509265333 ,
        0.0004411376501795 ,
        0.0004786078006680 ,
        0.0005160599690008 ,
        0.0005534927472404 ,
        0.0005909047284032 ,
        0.0006282945064244 ,
        0.0006656606761599 ,
        0.0007030018334087 ,
        0.0007403165749470 ,
        0.0007776034985687 ,
        0.0008148612031308 ,
        0.0008520882886005 ,
        0.0008892833561045 ,
        0.0009264450079792 ,
        0.0009635718478212 ,
        0.0010006624805391 ,
        0.0010377155124045 ,
        0.0010747295511041 ,
        0.0011117032057914 ,
        0.0011486350871387 ,
        0.0011855238073887 ,
        0.0012223679804070 ,
        0.0012591662217336 ,
        0.0012959171486349 ,
        0.0013326193801558 ,
        0.0013692715371711 ,
        0.0014058722424375 ,
        0.0014424201206454 ,
        0.0014789137984702 ,
        0.0015153519046244 ,
        0.0015517330699084 ,
        0.0015880559272627 ,
        0.0016243191118187 ,
        0.0016605212609501 ,
        0.0016966610143241 ,
        0.0017327370139528 ,
        0.0017687479042436 ,
        0.0018046923320508 ,
        0.0018405689467260 ,
        0.0018763764001690 ,
        0.0019121133468783 ,
        0.0019477784440019 ,
        0.0019833703513878 ,
        0.0020188877316339 ,
        0.0020543292501387 ,
        0.0020896935751513 ,
        0.0021249793778215 ,
        0.0021601853322494 ,
        0.0021953101155358 ,
        0.0022303524078314 ,
        0.0022653108923866 ,
        0.0023001842556012 ,
        0.0023349711870732 ,
        0.0023696703796486 ,
        0.0024042805294701 ,
        0.0024388003360265 ,
        0.0024732285022011 ,
        0.0025075637343208 ,
        0.0025418047422046 ,
        0.0025759502392121 ,
        0.0026099989422918 ,
        0.0026439495720293 ,
        0.0026778008526954 ,
        0.0027115515122941 ,
        0.0027452002826102 ,
        0.0027787458992574 ,
        0.0028121871017251 ,
        0.0028455226334265 ,
        0.0028787512417453 ,
        0.0029118716780830 ,
        0.0029448826979059 ,
        0.0029777830607915 ,
        0.0030105715304755 ,
        0.0030432468748982 ,
        0.0030758078662504 ,
        0.0031082532810200 ,
        0.0031405819000379 ,
        0.0031727925085237 ,
        0.0032048838961311 ,
        0.0032368548569940 ,
        0.0032687041897712 ,
        0.0033004306976919 ,
        0.0033320331886006 ,
        0.0033635104750018 ,
        0.0033948613741047 ,
        0.0034260847078677 ,
        0.0034571793030425 ,
        0.0034881439912183 ,
        0.0035189776088657 ,
        0.0035496789973805 ,
        0.0035802470031270 ,
        0.0036106804774816 ,
        0.0036409782768757 ,
        0.0036711392628390 ,
        0.0037011623020421 ,
        0.0037310462663388 ,
        0.0037607900328093 ,
        0.0037903924838013 ,
        0.0038198525069730 ,
        0.0038491689953343 ,
        0.0038783408472885 ,
        0.0039073669666740 ,
        0.0039362462628049 ,
        0.0039649776505126 ,
        0.0039935600501863 ,
        0.0040219923878134 ,
        0.0040502735950202 ,
        0.0040784026091117 ,
        0.0041063783731120 ,
        0.0041341998358035 ,
        0.0041618659517666 ,
        0.0041893756814191 ,
        0.0042167279910552 ,
        0.0042439218528843 ,
        0.0042709562450696 ,
        0.0042978301517665 ,
        0.0043245425631610 ,
        0.0043510924755071 ,
        0.0043774788911651 ,
        0.0044037008186390 ,
        0.0044297572726132 ,
        0.0044556472739903 ,
        0.0044813698499273 ,
        0.0045069240338726 ,
        0.0045323088656018 ,
        0.0045575233912544 ,
        0.0045825666633690 ,
        0.0046074377409196 ,
        0.0046321356893502 ,
        0.0046566595806105 ,
        0.0046810084931907 ,
        0.0047051815121557 ,
        0.0047291777291799 ,
        0.0047529962425814 ,
        0.0047766361573555 ,
        0.0048000965852084 ,
        0.0048233766445910 ,
        0.0048464754607316 ,
        0.0048693921656689 ,
        0.0048921258982845 ,
        0.0049146758043355 ,
        0.0049370410364865 ,
        0.0049592207543413 ,
        0.0049812141244747 ,
        0.0050030203204635 ,
        0.0050246385229179 ,
        0.0050460679195123 ,
        0.0050673077050154 ,
        0.0050883570813209 ,
        0.0051092152574771 ,
        0.0051298814497172 ,
        0.0051503548814880 ,
        0.0051706347834798 ,
        0.0051907203936547 ,
        0.0052106109572758 ,
        0.0052303057269349 ,
        0.0052498039625814 ,
        0.0052691049315493 ,
        0.0052882079085852 ,
        0.0053071121758755 ,
        0.0053258170230733 ,
        0.0053443217473252 ,
        0.0053626256532973 ,
        0.0053807280532021 ,
        0.0053986282668235 ,
        0.0054163256215431 ,
        0.0054338194523647 ,
        0.0054511091019401 ,
        0.0054681939205934 ,
        0.0054850732663451 ,
        0.0055017465049368 ,
        0.0055182130098549 ,
        0.0055344721623537 ,
        0.0055505233514792 ,
        0.0055663659740918 ,
        0.0055819994348889 ,
        0.0055974231464276 ,
        0.0056126365291462 ,
        0.0056276390113867 ,
        0.0056424300294155 ,
        0.0056570090274453 ,
        0.0056713754576555 ,
        0.0056855287802130 ,
        0.0056994684632925 ,
        0.0057131939830962 ,
        0.0057267048238740 ,
        0.0057400004779424 ,
        0.0057530804457037 ,
        0.0057659442356650 ,
        0.0057785913644564 ,
        0.0057910213568492 ,
        0.0058032337457741 ,
        0.0058152280723381 ,
        0.0058270038858423 ,
        0.0058385607437987 ,
        0.0058498982119467 ,
        0.0058610158642694 ,
        0.0058719132830099 ,
        0.0058825900586867 ,
        0.0058930457901091 ,
        0.0059032800843925 ,
        0.0059132925569730 ,
        0.0059230828316218 ,
        0.0059326505404595 ,
        0.0059419953239697 ,
        0.0059511168310128 ,
        0.0059600147188391 ,
        0.0059686886531012 ,
        0.0059771383078675 ,
        0.0059853633656337 ,
        0.0059933635173348 ,
        0.0060011384623572 ,
        0.0060086879085493 ,
        0.0060160115722333 ,
        0.0060231091782150 ,
        0.0060299804597947 ,
        0.0060366251587770 ,
        0.0060430430254808 ,
        0.0060492338187482 ,
        0.0060551973059539 ,
        0.0060609332630138 ,
        0.0060664414743936 ,
        0.0060717217331168 ,
        0.0060767738407721 ,
        0.0060815976075216 ,
        0.0060861928521075 ,
        0.0060905594018587 ,
        0.0060946970926977 ,
        0.0060986057691467 ,
        0.0061022852843331 ,
        0.0061057354999955 ,
        0.0061089562864885 ,
        0.0061119475227879 ,
        0.0061147090964949 ,
        0.0061172409038406 ,
        0.0061195428496898 ,
        0.0061216148475446 ,
        0.0061234568195475 ,
        0.0061250686964846 ,
        0.0061264504177879 ,
        0.0061276019315380 ,
        0.0061285231944655 ,
        0.0061292141719531 ,
        0.0061296748380365 ,
        0.0061299051754058 ,
        0.0061299051754058 ,
        0.0061296748380365 ,
        0.0061292141719531 ,
        0.0061285231944655 ,
        0.0061276019315380 ,
        0.0061264504177879 ,
        0.0061250686964846 ,
        0.0061234568195475 ,
        0.0061216148475446 ,
        0.0061195428496898 ,
        0.0061172409038406 ,
        0.0061147090964949 ,
        0.0061119475227879 ,
        0.0061089562864885 ,
        0.0061057354999955 ,
        0.0061022852843331 ,
        0.0060986057691467 ,
        0.0060946970926977 ,
        0.0060905594018587 ,
        0.0060861928521075 ,
        0.0060815976075216 ,
        0.0060767738407721 ,
        0.0060717217331168 ,
        0.0060664414743936 ,
        0.0060609332630138 ,
        0.0060551973059539 ,
        0.0060492338187482 ,
        0.0060430430254808 ,
        0.0060366251587770 ,
        0.0060299804597947 ,
        0.0060231091782150 ,
        0.0060160115722333 ,
        0.0060086879085493 ,
        0.0060011384623572 ,
        0.0059933635173348 ,
        0.0059853633656337 ,
        0.0059771383078675 ,
        0.0059686886531012 ,
        0.0059600147188391 ,
        0.0059511168310128 ,
        0.0059419953239697 ,
        0.0059326505404595 ,
        0.0059230828316218 ,
        0.0059132925569730 ,
        0.0059032800843925 ,
        0.0058930457901091 ,
        0.0058825900586867 ,
        0.0058719132830099 ,
        0.0058610158642694 ,
        0.0058498982119467 ,
        0.0058385607437987 ,
        0.0058270038858423 ,
        0.0058152280723381 ,
        0.0058032337457741 ,
        0.0057910213568492 ,
        0.0057785913644564 ,
        0.0057659442356650 ,
        0.0057530804457037 ,
        0.0057400004779424 ,
        0.0057267048238740 ,
        0.0057131939830962 ,
        0.0056994684632925 ,
        0.0056855287802130 ,
        0.0056713754576555 ,
        0.0056570090274453 ,
        0.0056424300294155 ,
        0.0056276390113867 ,
        0.0056126365291462 ,
        0.0055974231464276 ,
        0.0055819994348889 ,
        0.0055663659740918 ,
        0.0055505233514792 ,
        0.0055344721623537 ,
        0.0055182130098549 ,
        0.0055017465049368 ,
        0.0054850732663451 ,
        0.0054681939205934 ,
        0.0054511091019401 ,
        0.0054338194523647 ,
        0.0054163256215431 ,
        0.0053986282668235 ,
        0.0053807280532021 ,
        0.0053626256532973 ,
        0.0053443217473252 ,
        0.0053258170230733 ,
        0.0053071121758755 ,
        0.0052882079085852 ,
        0.0052691049315493 ,
        0.0052498039625814 ,
        0.0052303057269349 ,
        0.0052106109572758 ,
        0.0051907203936547 ,
        0.0051706347834798 ,
        0.0051503548814880 ,
        0.0051298814497172 ,
        0.0051092152574771 ,
        0.0050883570813209 ,
        0.0050673077050154 ,
        0.0050460679195123 ,
        0.0050246385229179 ,
        0.0050030203204635 ,
        0.0049812141244747 ,
        0.0049592207543413 ,
        0.0049370410364865 ,
        0.0049146758043355 ,
        0.0048921258982845 ,
        0.0048693921656689 ,
        0.0048464754607316 ,
        0.0048233766445910 ,
        0.0048000965852084 ,
        0.0047766361573555 ,
        0.0047529962425814 ,
        0.0047291777291799 ,
        0.0047051815121557 ,
        0.0046810084931907 ,
        0.0046566595806105 ,
        0.0046321356893502 ,
        0.0046074377409196 ,
        0.0045825666633690 ,
        0.0045575233912544 ,
        0.0045323088656018 ,
        0.0045069240338726 ,
        0.0044813698499273 ,
        0.0044556472739903 ,
        0.0044297572726132 ,
        0.0044037008186390 ,
        0.0043774788911651 ,
        0.0043510924755071 ,
        0.0043245425631610 ,
        0.0042978301517665 ,
        0.0042709562450696 ,
        0.0042439218528843 ,
        0.0042167279910552 ,
        0.0041893756814191 ,
        0.0041618659517666 ,
        0.0041341998358035 ,
        0.0041063783731120 ,
        0.0040784026091117 ,
        0.0040502735950202 ,
        0.0040219923878134 ,
        0.0039935600501863 ,
        0.0039649776505126 ,
        0.0039362462628049 ,
        0.0039073669666740 ,
        0.0038783408472885 ,
        0.0038491689953343 ,
        0.0038198525069730 ,
        0.0037903924838013 ,
        0.0037607900328093 ,
        0.0037310462663388 ,
        0.0037011623020421 ,
        0.0036711392628390 ,
        0.0036409782768757 ,
        0.0036106804774816 ,
        0.0035802470031270 ,
        0.0035496789973805 ,
        0.0035189776088657 ,
        0.0034881439912183 ,
        0.0034571793030425 ,
        0.0034260847078677 ,
        0.0033948613741047 ,
        0.0033635104750018 ,
        0.0033320331886006 ,
        0.0033004306976919 ,
        0.0032687041897712 ,
        0.0032368548569940 ,
        0.0032048838961311 ,
        0.0031727925085237 ,
        0.0031405819000379 ,
        0.0031082532810200 ,
        0.0030758078662504 ,
        0.0030432468748982 ,
        0.0030105715304755 ,
        0.0029777830607915 ,
        0.0029448826979059 ,
        0.0029118716780830 ,
        0.0028787512417453 ,
        0.0028455226334265 ,
        0.0028121871017251 ,
        0.0027787458992574 ,
        0.0027452002826102 ,
        0.0027115515122941 ,
        0.0026778008526954 ,
        0.0026439495720293 ,
        0.0026099989422918 ,
        0.0025759502392121 ,
        0.0025418047422046 ,
        0.0025075637343208 ,
        0.0024732285022011 ,
        0.0024388003360265 ,
        0.0024042805294701 ,
        0.0023696703796486 ,
        0.0023349711870732 ,
        0.0023001842556012 ,
        0.0022653108923866 ,
        0.0022303524078314 ,
        0.0021953101155358 ,
        0.0021601853322494 ,
        0.0021249793778215 ,
        0.0020896935751513 ,
        0.0020543292501387 ,
        0.0020188877316339 ,
        0.0019833703513878 ,
        0.0019477784440019 ,
        0.0019121133468783 ,
        0.0018763764001690 ,
        0.0018405689467260 ,
        0.0018046923320508 ,
        0.0017687479042436 ,
        0.0017327370139528 ,
        0.0016966610143241 ,
        0.0016605212609501 ,
        0.0016243191118187 ,
        0.0015880559272627 ,
        0.0015517330699084 ,
        0.0015153519046244 ,
        0.0014789137984702 ,
        0.0014424201206454 ,
        0.0014058722424375 ,
        0.0013692715371711 ,
        0.0013326193801558 ,
        0.0012959171486349 ,
        0.0012591662217336 ,
        0.0012223679804070 ,
        0.0011855238073887 ,
        0.0011486350871387 ,
        0.0011117032057914 ,
        0.0010747295511041 ,
        0.0010377155124045 ,
        0.0010006624805391 ,
        0.0009635718478212 ,
        0.0009264450079792 ,
        0.0008892833561045 ,
        0.0008520882886005 ,
        0.0008148612031308 ,
        0.0007776034985687 ,
        0.0007403165749470 ,
        0.0007030018334087 ,
        0.0006656606761599 ,
        0.0006282945064244 ,
        0.0005909047284032 ,
        0.0005534927472404 ,
        0.0005160599690008 ,
        0.0004786078006680 ,
        0.0004411376501795 ,
        0.0004036509265333 ,
        0.0003661490400356 ,
        0.0003286334028523 ,
        0.0002911054302515 ,
        0.0002535665435706 ,
        0.0002160181779770 ,
        0.0001784618055460 ,
        0.0001408990173882 ,
        0.0001033319034969 ,
        0.0000657657316592 ,
        0.0000282526373739 } /* 1.999999999999998 */ ;

const double points_n1024[] = {
       -0.9999972450545584 ,
       -0.9999854843850284 ,
       -0.9999643261538894 ,
       -0.9999337658606178 ,
       -0.9998938032169420 ,
       -0.9998444384611712 ,
       -0.9997856720116890 ,
       -0.9997175044023747 ,
       -0.9996399362654382 ,
       -0.9995529683257071 ,
       -0.9994566013984001 ,
       -0.9993508363881507 ,
       -0.9992356742885348 ,
       -0.9991111161818228 ,
       -0.9989771632388403 ,
       -0.9988338167188826 ,
       -0.9986810779696582 ,
       -0.9985189484272492 ,
       -0.9983474296160800 ,
       -0.9981665231488915 ,
       -0.9979762307267186 ,
       -0.9977765541388681 ,
       -0.9975674952628989 ,
       -0.9973490560646014 ,
       -0.9971212385979773 ,
       -0.9968840450052184 ,
       -0.9966374775166863 ,
       -0.9963815384508895 ,
       -0.9961162302144619 ,
       -0.9958415553021396 ,
       -0.9955575162967363 ,
       -0.9952641158691200 ,
       -0.9949613567781865 ,
       -0.9946492418708341 ,
       -0.9943277740819362 ,
       -0.9939969564343137 ,
       -0.9936567920387066 ,
       -0.9933072840937446 ,
       -0.9929484358859171 ,
       -0.9925802507895418 ,
       -0.9922027322667337 ,
       -0.9918158838673715 ,
       -0.9914197092290653 ,
       -0.9910142120771213 ,
       -0.9905993962245077 ,
       -0.9901752655718179 ,
       -0.9897418241072349 ,
       -0.9892990759064927 ,
       -0.9888470251328386 ,
       -0.9883856760369940 ,
       -0.9879150329571141 ,
       -0.9874351003187474 ,
       -0.9869458826347941 ,
       -0.9864473845054632 ,
       -0.9859396106182301 ,
       -0.9854225657477916 ,
       -0.9848962547560215 ,
       -0.9843606825919249 ,
       -0.9838158542915914 ,
       -0.9832617749781478 ,
       -0.9826984498617104 ,
       -0.9821258842393351 ,
       -0.9815440834949686 ,
       -0.9809530530993970 ,
       -0.9803527986101944 ,
       -0.9797433256716714 ,
       -0.9791246400148212 ,
       -0.9784967474572661 ,
       -0.9778596539032024 ,
       -0.9772133653433457 ,
       -0.9765578878548735 ,
       -0.9758932276013692 ,
       -0.9752193908327629 ,
       -0.9745363838852737 ,
       -0.9738442131813496 ,
       -0.9731428852296072 ,
       -0.9724324066247705 ,
       -0.9717127840476089 ,
       -0.9709840242648741 ,
       -0.9702461341292372 ,
       -0.9694991205792236 ,
       -0.9687429906391477 ,
       -0.9679777514190476 ,
       -0.9672034101146173 ,
       -0.9664199740071397 ,
       -0.9656274504634180 ,
       -0.9648258469357061 ,
       -0.9640151709616388 ,
       -0.9631954301641612 ,
       -0.9623666322514564 ,
       -0.9615287850168734 ,
       -0.9606818963388538 ,
       -0.9598259741808576 ,
       -0.9589610265912885 ,
       -0.9580870617034180 ,
       -0.9572040877353089 ,
       -0.9563121129897385 ,
       -0.9554111458541198 ,
       -0.9545011948004233 ,
       -0.9535822683850969 ,
       -0.9526543752489854 ,
       -0.9517175241172499 ,
       -0.9507717237992849 ,
       -0.9498169831886358 ,
       -0.9488533112629158 ,
       -0.9478807170837206 ,
       -0.9468992097965435 ,
       -0.9459087986306899 ,
       -0.9449094928991898 ,
       -0.9439013019987107 ,
       -0.9428842354094690 ,
       -0.9418583026951410 ,
       -0.9408235135027729 ,
       -0.9397798775626901 ,
       -0.9387274046884055 ,
       -0.9376661047765279 ,
       -0.9365959878066681 ,
       -0.9355170638413453 ,
       -0.9344293430258929 ,
       -0.9333328355883627 ,
       -0.9322275518394288 ,
       -0.9311135021722909 ,
       -0.9299906970625760 ,
       -0.9288591470682402 ,
       -0.9277188628294700 ,
       -0.9265698550685812 ,
       -0.9254121345899188 ,
       -0.9242457122797550 ,
       -0.9230705991061873 ,
       -0.9218868061190350 ,
       -0.9206943444497352 ,
       -0.9194932253112384 ,
       -0.9182834599979034 ,
       -0.9170650598853900 ,
       -0.9158380364305532 ,
       -0.9146024011713345 ,
       -0.9133581657266545 ,
       -0.9121053417963026 ,
       -0.9108439411608276 ,
       -0.9095739756814265 ,
       -0.9082954572998335 ,
       -0.9070083980382072 ,
       -0.9057128099990178 ,
       -0.9044087053649336 ,
       -0.9030960963987054 ,
       -0.9017749954430525 ,
       -0.9004454149205460 ,
       -0.8991073673334917 ,
       -0.8977608652638133 ,
       -0.8964059213729331 ,
       -0.8950425484016540 ,
       -0.8936707591700388 ,
       -0.8922905665772906 ,
       -0.8909019836016303 ,
       -0.8895050233001756 ,
       -0.8880996988088177 ,
       -0.8866860233420980 ,
       -0.8852640101930838 ,
       -0.8838336727332431 ,
       -0.8823950244123190 ,
       -0.8809480787582035 ,
       -0.8794928493768098 ,
       -0.8780293499519449 ,
       -0.8765575942451802 ,
       -0.8750775960957229 ,
       -0.8735893694202854 ,
       -0.8720929282129546 ,
       -0.8705882865450599 ,
       -0.8690754585650419 ,
       -0.8675544584983180 ,
       -0.8660253006471499 ,
       -0.8644879993905080 ,
       -0.8629425691839373 ,
       -0.8613890245594206 ,
       -0.8598273801252420 ,
       -0.8582576505658500 ,
       -0.8566798506417190 ,
       -0.8550939951892107 ,
       -0.8535000991204343 ,
       -0.8518981774231068 ,
       -0.8502882451604115 ,
       -0.8486703174708565 ,
       -0.8470444095681330 ,
       -0.8454105367409712 ,
       -0.8437687143529972 ,
       -0.8421189578425884 ,
       -0.8404612827227282 ,
       -0.8387957045808606 ,
       -0.8371222390787428 ,
       -0.8354409019522987 ,
       -0.8337517090114703 ,
       -0.8320546761400698 ,
       -0.8303498192956295 ,
       -0.8286371545092520 ,
       -0.8269166978854597 ,
       -0.8251884656020433 ,
       -0.8234524739099092 ,
       -0.8217087391329272 ,
       -0.8199572776677768 ,
       -0.8181981059837932 ,
       -0.8164312406228120 ,
       -0.8146566981990144 ,
       -0.8128744953987702 ,
       -0.8110846489804812 ,
       -0.8092871757744238 ,
       -0.8074820926825905 ,
       -0.8056694166785310 ,
       -0.8038491648071928 ,
       -0.8020213541847606 ,
       -0.8001860019984957 ,
       -0.7983431255065738 ,
       -0.7964927420379235 ,
       -0.7946348689920631 ,
       -0.7927695238389364 ,
       -0.7908967241187492 ,
       -0.7890164874418039 ,
       -0.7871288314883342 ,
       -0.7852337740083386 ,
       -0.7833313328214137 ,
       -0.7814215258165864 ,
       -0.7795043709521460 ,
       -0.7775798862554750 ,
       -0.7756480898228799 ,
       -0.7737089998194209 ,
       -0.7717626344787407 ,
       -0.7698090121028939 ,
       -0.7678481510621742 ,
       -0.7658800697949419 ,
       -0.7639047868074506 ,
       -0.7619223206736728 ,
       -0.7599326900351260 ,
       -0.7579359136006965 ,
       -0.7559320101464641 ,
       -0.7539209985155253 ,
       -0.7519028976178163 ,
       -0.7498777264299350 ,
       -0.7478455039949627 ,
       -0.7458062494222848 ,
       -0.7437599818874112 ,
       -0.7417067206317964 ,
       -0.7396464849626581 ,
       -0.7375792942527953 ,
       -0.7355051679404074 ,
       -0.7334241255289101 ,
       -0.7313361865867526 ,
       -0.7292413707472337 ,
       -0.7271396977083170 ,
       -0.7250311872324454 ,
       -0.7229158591463559 ,
       -0.7207937333408926 ,
       -0.7186648297708200 ,
       -0.7165291684546352 ,
       -0.7143867694743797 ,
       -0.7122376529754508 ,
       -0.7100818391664115 ,
       -0.7079193483188013 ,
       -0.7057502007669451 ,
       -0.7035744169077619 ,
       -0.7013920172005735 ,
       -0.6992030221669115 ,
       -0.6970074523903251 ,
       -0.6948053285161866 ,
       -0.6925966712514979 ,
       -0.6903815013646960 ,
       -0.6881598396854568 ,
       -0.6859317071045004 ,
       -0.6836971245733933 ,
       -0.6814561131043529 ,
       -0.6792086937700489 ,
       -0.6769548877034052 ,
       -0.6746947160974015 ,
       -0.6724282002048740 ,
       -0.6701553613383155 ,
       -0.6678762208696750 ,
       -0.6655908002301564 ,
       -0.6632991209100174 ,
       -0.6610012044583676 ,
       -0.6586970724829653 ,
       -0.6563867466500144 ,
       -0.6540702486839614 ,
       -0.6517476003672900 ,
       -0.6494188235403172 ,
       -0.6470839401009875 ,
       -0.6447429720046670 ,
       -0.6423959412639373 ,
       -0.6400428699483877 ,
       -0.6376837801844086 ,
       -0.6353186941549832 ,
       -0.6329476340994783 ,
       -0.6305706223134360 ,
       -0.6281876811483634 ,
       -0.6257988330115231 ,
       -0.6234041003657216 ,
       -0.6210035057290989 ,
       -0.6185970716749167 ,
       -0.6161848208313454 ,
       -0.6137667758812519 ,
       -0.6113429595619866 ,
       -0.6089133946651687 ,
       -0.6064781040364728 ,
       -0.6040371105754135 ,
       -0.6015904372351302 ,
       -0.5991381070221715 ,
       -0.5966801429962784 ,
       -0.5942165682701681 ,
       -0.5917474060093160 ,
       -0.5892726794317383 ,
       -0.5867924118077738 ,
       -0.5843066264598643 ,
       -0.5818153467623364 ,
       -0.5793185961411806 ,
       -0.5768163980738323 ,
       -0.5743087760889496 ,
       -0.5717957537661930 ,
       -0.5692773547360035 ,
       -0.5667536026793804 ,
       -0.5642245213276582 ,
       -0.5616901344622843 ,
       -0.5591504659145947 ,
       -0.5566055395655898 ,
       -0.5540553793457105 ,
       -0.5515000092346126 ,
       -0.5489394532609416 ,
       -0.5463737355021069 ,
       -0.5438028800840546 ,
       -0.5412269111810420 ,
       -0.5386458530154088 ,
       -0.5360597298573503 ,
       -0.5334685660246892 ,
       -0.5308723858826460 ,
       -0.5282712138436112 ,
       -0.5256650743669147 ,
       -0.5230539919585964 ,
       -0.5204379911711752 ,
       -0.5178170966034189 ,
       -0.5151913329001124 ,
       -0.5125607247518258 ,
       -0.5099252968946826 ,
       -0.5072850741101270 ,
       -0.5046400812246908 ,
       -0.5019903431097602 ,
       -0.4993358846813412 ,
       -0.4966767308998263 ,
       -0.4940129067697591 ,
       -0.4913444373395997 ,
       -0.4886713477014885 ,
       -0.4859936629910107 ,
       -0.4833114083869601 ,
       -0.4806246091111018 ,
       -0.4779332904279356 ,
       -0.4752374776444580 ,
       -0.4725371961099244 ,
       -0.4698324712156108 ,
       -0.4671233283945751 ,
       -0.4644097931214176 ,
       -0.4616918909120419 ,
       -0.4589696473234145 ,
       -0.4562430879533250 ,
       -0.4535122384401449 ,
       -0.4507771244625871 ,
       -0.4480377717394637 ,
       -0.4452942060294449 ,
       -0.4425464531308161 ,
       -0.4397945388812359 ,
       -0.4370384891574928 ,
       -0.4342783298752620 ,
       -0.4315140869888618 ,
       -0.4287457864910092 ,
       -0.4259734544125758 ,
       -0.4231971168223430 ,
       -0.4204167998267569 ,
       -0.4176325295696824 ,
       -0.4148443322321581 ,
       -0.4120522340321493 ,
       -0.4092562612243023 ,
       -0.4064564400996967 ,
       -0.4036527969855987 ,
       -0.4008453582452138 ,
       -0.3980341502774379 ,
       -0.3952191995166100 ,
       -0.3924005324322634 ,
       -0.3895781755288765 ,
       -0.3867521553456238 ,
       -0.3839224984561267 ,
       -0.3810892314682028 ,
       -0.3782523810236164 ,
       -0.3754119737978276 ,
       -0.3725680364997420 ,
       -0.3697205958714585 ,
       -0.3668696786880191 ,
       -0.3640153117571563 ,
       -0.3611575219190411 ,
       -0.3582963360460311 ,
       -0.3554317810424171 ,
       -0.3525638838441709 ,
       -0.3496926714186912 ,
       -0.3468181707645508 ,
       -0.3439404089112421 ,
       -0.3410594129189233 ,
       -0.3381752098781638 ,
       -0.3352878269096896 ,
       -0.3323972911641281 ,
       -0.3295036298217529 ,
       -0.3266068700922282 ,
       -0.3237070392143528 ,
       -0.3208041644558044 ,
       -0.3178982731128827 ,
       -0.3149893925102530 ,
       -0.3120775500006892 ,
       -0.3091627729648165 ,
       -0.3062450888108542 ,
       -0.3033245249743575 ,
       -0.3004011089179602 ,
       -0.2974748681311158 ,
       -0.2945458301298395 ,
       -0.2916140224564491 ,
       -0.2886794726793061 ,
       -0.2857422083925568 ,
       -0.2828022572158723 ,
       -0.2798596467941893 ,
       -0.2769144047974497 ,
       -0.2739665589203406 ,
       -0.2710161368820341 ,
       -0.2680631664259264 ,
       -0.2651076753193767 ,
       -0.2621496913534467 ,
       -0.2591892423426388 ,
       -0.2562263561246347 ,
       -0.2532610605600337 ,
       -0.2502933835320906 ,
       -0.2473233529464536 ,
       -0.2443509967309017 ,
       -0.2413763428350826 ,
       -0.2383994192302492 ,
       -0.2354202539089970 ,
       -0.2324388748850010 ,
       -0.2294553101927519 ,
       -0.2264695878872927 ,
       -0.2234817360439547 ,
       -0.2204917827580940 ,
       -0.2174997561448267 ,
       -0.2145056843387650 ,
       -0.2115095954937522 ,
       -0.2085115177825984 ,
       -0.2055114793968154 ,
       -0.2025095085463516 ,
       -0.1995056334593266 ,
       -0.1964998823817662 ,
       -0.1934922835773361 ,
       -0.1904828653270768 ,
       -0.1874716559291374 ,
       -0.1844586836985096 ,
       -0.1814439769667611 ,
       -0.1784275640817696 ,
       -0.1754094734074561 ,
       -0.1723897333235182 ,
       -0.1693683722251632 ,
       -0.1663454185228410 ,
       -0.1633209006419773 ,
       -0.1602948470227058 ,
       -0.1572672861196013 ,
       -0.1542382464014118 ,
       -0.1512077563507909 ,
       -0.1481758444640298 ,
       -0.1451425392507897 ,
       -0.1421078692338334 ,
       -0.1390718629487574 ,
       -0.1360345489437232 ,
       -0.1329959557791890 ,
       -0.1299561120276415 ,
       -0.1269150462733266 ,
       -0.1238727871119810 ,
       -0.1208293631505633 ,
       -0.1177848030069850 ,
       -0.1147391353098412 ,
       -0.1116923886981417 ,
       -0.1086445918210413 ,
       -0.1055957733375710 ,
       -0.1025459619163678 ,
       -0.0994951862354058 ,
       -0.0964434749817259 ,
       -0.0933908568511668 ,
       -0.0903373605480943 ,
       -0.0872830147851321 ,
       -0.0842278482828915 ,
       -0.0811718897697013 ,
       -0.0781151679813378 ,
       -0.0750577116607544 ,
       -0.0719995495578116 ,
       -0.0689407104290065 ,
       -0.0658812230372023 ,
       -0.0628211161513581 ,
       -0.0597604185462580 ,
       -0.0566991590022410 ,
       -0.0536373663049299 ,
       -0.0505750692449611 ,
       -0.0475122966177133 ,
       -0.0444490772230372 ,
       -0.0413854398649847 ,
       -0.0383214133515377 ,
       -0.0352570264943375 ,
       -0.0321923081084136 ,
       -0.0291272870119132 ,
       -0.0260619920258297 ,
       -0.0229964519737322 ,
       -0.0199306956814940 ,
       -0.0168647519770217 ,
       -0.0137986496899844 ,
       -0.0107324176515423 ,
       -0.0076660846940755 ,
       -0.0045996796509133 ,
       -0.0015332313560626 ,
        0.0015332313560626 ,
        0.0045996796509133 ,
        0.0076660846940755 ,
        0.0107324176515423 ,
        0.0137986496899844 ,
        0.0168647519770217 ,
        0.0199306956814940 ,
        0.0229964519737322 ,
        0.0260619920258297 ,
        0.0291272870119132 ,
        0.0321923081084136 ,
        0.0352570264943375 ,
        0.0383214133515377 ,
        0.0413854398649847 ,
        0.0444490772230372 ,
        0.0475122966177133 ,
        0.0505750692449611 ,
        0.0536373663049299 ,
        0.0566991590022410 ,
        0.0597604185462580 ,
        0.0628211161513581 ,
        0.0658812230372023 ,
        0.0689407104290065 ,
        0.0719995495578116 ,
        0.0750577116607544 ,
        0.0781151679813378 ,
        0.0811718897697013 ,
        0.0842278482828915 ,
        0.0872830147851321 ,
        0.0903373605480943 ,
        0.0933908568511668 ,
        0.0964434749817259 ,
        0.0994951862354058 ,
        0.1025459619163678 ,
        0.1055957733375710 ,
        0.1086445918210413 ,
        0.1116923886981417 ,
        0.1147391353098412 ,
        0.1177848030069850 ,
        0.1208293631505633 ,
        0.1238727871119810 ,
        0.1269150462733266 ,
        0.1299561120276415 ,
        0.1329959557791890 ,
        0.1360345489437232 ,
        0.1390718629487574 ,
        0.1421078692338334 ,
        0.1451425392507897 ,
        0.1481758444640298 ,
        0.1512077563507909 ,
        0.1542382464014118 ,
        0.1572672861196013 ,
        0.1602948470227058 ,
        0.1633209006419773 ,
        0.1663454185228410 ,
        0.1693683722251632 ,
        0.1723897333235182 ,
        0.1754094734074561 ,
        0.1784275640817696 ,
        0.1814439769667611 ,
        0.1844586836985096 ,
        0.1874716559291374 ,
        0.1904828653270768 ,
        0.1934922835773361 ,
        0.1964998823817662 ,
        0.1995056334593266 ,
        0.2025095085463516 ,
        0.2055114793968154 ,
        0.2085115177825984 ,
        0.2115095954937522 ,
        0.2145056843387650 ,
        0.2174997561448267 ,
        0.2204917827580940 ,
        0.2234817360439547 ,
        0.2264695878872927 ,
        0.2294553101927519 ,
        0.2324388748850010 ,
        0.2354202539089970 ,
        0.2383994192302492 ,
        0.2413763428350826 ,
        0.2443509967309017 ,
        0.2473233529464536 ,
        0.2502933835320906 ,
        0.2532610605600337 ,
        0.2562263561246347 ,
        0.2591892423426388 ,
        0.2621496913534467 ,
        0.2651076753193767 ,
        0.2680631664259264 ,
        0.2710161368820341 ,
        0.2739665589203406 ,
        0.2769144047974497 ,
        0.2798596467941893 ,
        0.2828022572158723 ,
        0.2857422083925568 ,
        0.2886794726793061 ,
        0.2916140224564491 ,
        0.2945458301298395 ,
        0.2974748681311158 ,
        0.3004011089179602 ,
        0.3033245249743575 ,
        0.3062450888108542 ,
        0.3091627729648165 ,
        0.3120775500006892 ,
        0.3149893925102530 ,
        0.3178982731128827 ,
        0.3208041644558044 ,
        0.3237070392143528 ,
        0.3266068700922282 ,
        0.3295036298217529 ,
        0.3323972911641281 ,
        0.3352878269096896 ,
        0.3381752098781638 ,
        0.3410594129189233 ,
        0.3439404089112421 ,
        0.3468181707645508 ,
        0.3496926714186912 ,
        0.3525638838441709 ,
        0.3554317810424171 ,
        0.3582963360460311 ,
        0.3611575219190411 ,
        0.3640153117571563 ,
        0.3668696786880191 ,
        0.3697205958714585 ,
        0.3725680364997420 ,
        0.3754119737978276 ,
        0.3782523810236164 ,
        0.3810892314682028 ,
        0.3839224984561267 ,
        0.3867521553456238 ,
        0.3895781755288765 ,
        0.3924005324322634 ,
        0.3952191995166100 ,
        0.3980341502774379 ,
        0.4008453582452138 ,
        0.4036527969855987 ,
        0.4064564400996967 ,
        0.4092562612243023 ,
        0.4120522340321493 ,
        0.4148443322321581 ,
        0.4176325295696824 ,
        0.4204167998267569 ,
        0.4231971168223430 ,
        0.4259734544125758 ,
        0.4287457864910092 ,
        0.4315140869888618 ,
        0.4342783298752620 ,
        0.4370384891574928 ,
        0.4397945388812359 ,
        0.4425464531308161 ,
        0.4452942060294449 ,
        0.4480377717394637 ,
        0.4507771244625871 ,
        0.4535122384401449 ,
        0.4562430879533250 ,
        0.4589696473234145 ,
        0.4616918909120419 ,
        0.4644097931214176 ,
        0.4671233283945751 ,
        0.4698324712156108 ,
        0.4725371961099244 ,
        0.4752374776444580 ,
        0.4779332904279356 ,
        0.4806246091111018 ,
        0.4833114083869601 ,
        0.4859936629910107 ,
        0.4886713477014885 ,
        0.4913444373395997 ,
        0.4940129067697591 ,
        0.4966767308998263 ,
        0.4993358846813412 ,
        0.5019903431097602 ,
        0.5046400812246908 ,
        0.5072850741101270 ,
        0.5099252968946826 ,
        0.5125607247518258 ,
        0.5151913329001124 ,
        0.5178170966034189 ,
        0.5204379911711752 ,
        0.5230539919585964 ,
        0.5256650743669147 ,
        0.5282712138436112 ,
        0.5308723858826460 ,
        0.5334685660246892 ,
        0.5360597298573503 ,
        0.5386458530154088 ,
        0.5412269111810420 ,
        0.5438028800840546 ,
        0.5463737355021069 ,
        0.5489394532609416 ,
        0.5515000092346126 ,
        0.5540553793457105 ,
        0.5566055395655898 ,
        0.5591504659145947 ,
        0.5616901344622843 ,
        0.5642245213276582 ,
        0.5667536026793804 ,
        0.5692773547360035 ,
        0.5717957537661930 ,
        0.5743087760889496 ,
        0.5768163980738323 ,
        0.5793185961411806 ,
        0.5818153467623364 ,
        0.5843066264598643 ,
        0.5867924118077738 ,
        0.5892726794317383 ,
        0.5917474060093160 ,
        0.5942165682701681 ,
        0.5966801429962784 ,
        0.5991381070221715 ,
        0.6015904372351302 ,
        0.6040371105754135 ,
        0.6064781040364728 ,
        0.6089133946651687 ,
        0.6113429595619866 ,
        0.6137667758812519 ,
        0.6161848208313454 ,
        0.6185970716749167 ,
        0.6210035057290989 ,
        0.6234041003657216 ,
        0.6257988330115231 ,
        0.6281876811483634 ,
        0.6305706223134360 ,
        0.6329476340994783 ,
        0.6353186941549832 ,
        0.6376837801844086 ,
        0.6400428699483877 ,
        0.6423959412639373 ,
        0.6447429720046670 ,
        0.6470839401009875 ,
        0.6494188235403172 ,
        0.6517476003672900 ,
        0.6540702486839614 ,
        0.6563867466500144 ,
        0.6586970724829653 ,
        0.6610012044583676 ,
        0.6632991209100174 ,
        0.6655908002301564 ,
        0.6678762208696750 ,
        0.6701553613383155 ,
        0.6724282002048740 ,
        0.6746947160974015 ,
        0.6769548877034052 ,
        0.6792086937700489 ,
        0.6814561131043529 ,
        0.6836971245733933 ,
        0.6859317071045004 ,
        0.6881598396854568 ,
        0.6903815013646960 ,
        0.6925966712514979 ,
        0.6948053285161866 ,
        0.6970074523903251 ,
        0.6992030221669115 ,
        0.7013920172005735 ,
        0.7035744169077619 ,
        0.7057502007669451 ,
        0.7079193483188013 ,
        0.7100818391664115 ,
        0.7122376529754508 ,
        0.7143867694743797 ,
        0.7165291684546352 ,
        0.7186648297708200 ,
        0.7207937333408926 ,
        0.7229158591463559 ,
        0.7250311872324454 ,
        0.7271396977083170 ,
        0.7292413707472337 ,
        0.7313361865867526 ,
        0.7334241255289101 ,
        0.7355051679404074 ,
        0.7375792942527953 ,
        0.7396464849626581 ,
        0.7417067206317964 ,
        0.7437599818874112 ,
        0.7458062494222848 ,
        0.7478455039949627 ,
        0.7498777264299350 ,
        0.7519028976178163 ,
        0.7539209985155253 ,
        0.7559320101464641 ,
        0.7579359136006965 ,
        0.7599326900351260 ,
        0.7619223206736728 ,
        0.7639047868074506 ,
        0.7658800697949419 ,
        0.7678481510621742 ,
        0.7698090121028939 ,
        0.7717626344787407 ,
        0.7737089998194209 ,
        0.7756480898228799 ,
        0.7775798862554750 ,
        0.7795043709521460 ,
        0.7814215258165864 ,
        0.7833313328214137 ,
        0.7852337740083386 ,
        0.7871288314883342 ,
        0.7890164874418039 ,
        0.7908967241187492 ,
        0.7927695238389364 ,
        0.7946348689920631 ,
        0.7964927420379235 ,
        0.7983431255065738 ,
        0.8001860019984957 ,
        0.8020213541847606 ,
        0.8038491648071928 ,
        0.8056694166785310 ,
        0.8074820926825905 ,
        0.8092871757744238 ,
        0.8110846489804812 ,
        0.8128744953987702 ,
        0.8146566981990144 ,
        0.8164312406228120 ,
        0.8181981059837932 ,
        0.8199572776677768 ,
        0.8217087391329272 ,
        0.8234524739099092 ,
        0.8251884656020433 ,
        0.8269166978854597 ,
        0.8286371545092520 ,
        0.8303498192956295 ,
        0.8320546761400698 ,
        0.8337517090114703 ,
        0.8354409019522987 ,
        0.8371222390787428 ,
        0.8387957045808606 ,
        0.8404612827227282 ,
        0.8421189578425884 ,
        0.8437687143529972 ,
        0.8454105367409712 ,
        0.8470444095681330 ,
        0.8486703174708565 ,
        0.8502882451604115 ,
        0.8518981774231068 ,
        0.8535000991204343 ,
        0.8550939951892107 ,
        0.8566798506417190 ,
        0.8582576505658500 ,
        0.8598273801252420 ,
        0.8613890245594206 ,
        0.8629425691839373 ,
        0.8644879993905080 ,
        0.8660253006471499 ,
        0.8675544584983180 ,
        0.8690754585650419 ,
        0.8705882865450599 ,
        0.8720929282129546 ,
        0.8735893694202854 ,
        0.8750775960957229 ,
        0.8765575942451802 ,
        0.8780293499519449 ,
        0.8794928493768098 ,
        0.8809480787582035 ,
        0.8823950244123190 ,
        0.8838336727332431 ,
        0.8852640101930838 ,
        0.8866860233420980 ,
        0.8880996988088177 ,
        0.8895050233001756 ,
        0.8909019836016303 ,
        0.8922905665772906 ,
        0.8936707591700388 ,
        0.8950425484016540 ,
        0.8964059213729331 ,
        0.8977608652638133 ,
        0.8991073673334917 ,
        0.9004454149205460 ,
        0.9017749954430525 ,
        0.9030960963987054 ,
        0.9044087053649336 ,
        0.9057128099990178 ,
        0.9070083980382072 ,
        0.9082954572998335 ,
        0.9095739756814265 ,
        0.9108439411608276 ,
        0.9121053417963026 ,
        0.9133581657266545 ,
        0.9146024011713345 ,
        0.9158380364305532 ,
        0.9170650598853900 ,
        0.9182834599979034 ,
        0.9194932253112384 ,
        0.9206943444497352 ,
        0.9218868061190350 ,
        0.9230705991061873 ,
        0.9242457122797550 ,
        0.9254121345899188 ,
        0.9265698550685812 ,
        0.9277188628294700 ,
        0.9288591470682402 ,
        0.9299906970625760 ,
        0.9311135021722909 ,
        0.9322275518394288 ,
        0.9333328355883627 ,
        0.9344293430258929 ,
        0.9355170638413453 ,
        0.9365959878066681 ,
        0.9376661047765279 ,
        0.9387274046884055 ,
        0.9397798775626901 ,
        0.9408235135027729 ,
        0.9418583026951410 ,
        0.9428842354094690 ,
        0.9439013019987107 ,
        0.9449094928991898 ,
        0.9459087986306899 ,
        0.9468992097965435 ,
        0.9478807170837206 ,
        0.9488533112629158 ,
        0.9498169831886358 ,
        0.9507717237992849 ,
        0.9517175241172499 ,
        0.9526543752489854 ,
        0.9535822683850969 ,
        0.9545011948004233 ,
        0.9554111458541198 ,
        0.9563121129897385 ,
        0.9572040877353089 ,
        0.9580870617034180 ,
        0.9589610265912885 ,
        0.9598259741808576 ,
        0.9606818963388538 ,
        0.9615287850168734 ,
        0.9623666322514564 ,
        0.9631954301641612 ,
        0.9640151709616388 ,
        0.9648258469357061 ,
        0.9656274504634180 ,
        0.9664199740071397 ,
        0.9672034101146173 ,
        0.9679777514190476 ,
        0.9687429906391477 ,
        0.9694991205792236 ,
        0.9702461341292372 ,
        0.9709840242648741 ,
        0.9717127840476089 ,
        0.9724324066247705 ,
        0.9731428852296072 ,
        0.9738442131813496 ,
        0.9745363838852737 ,
        0.9752193908327629 ,
        0.9758932276013692 ,
        0.9765578878548735 ,
        0.9772133653433457 ,
        0.9778596539032024 ,
        0.9784967474572661 ,
        0.9791246400148212 ,
        0.9797433256716714 ,
        0.9803527986101944 ,
        0.9809530530993970 ,
        0.9815440834949686 ,
        0.9821258842393351 ,
        0.9826984498617104 ,
        0.9832617749781478 ,
        0.9838158542915914 ,
        0.9843606825919249 ,
        0.9848962547560215 ,
        0.9854225657477916 ,
        0.9859396106182301 ,
        0.9864473845054632 ,
        0.9869458826347941 ,
        0.9874351003187474 ,
        0.9879150329571141 ,
        0.9883856760369940 ,
        0.9888470251328386 ,
        0.9892990759064927 ,
        0.9897418241072349 ,
        0.9901752655718179 ,
        0.9905993962245077 ,
        0.9910142120771213 ,
        0.9914197092290653 ,
        0.9918158838673715 ,
        0.9922027322667337 ,
        0.9925802507895418 ,
        0.9929484358859171 ,
        0.9933072840937446 ,
        0.9936567920387066 ,
        0.9939969564343137 ,
        0.9943277740819362 ,
        0.9946492418708341 ,
        0.9949613567781865 ,
        0.9952641158691200 ,
        0.9955575162967363 ,
        0.9958415553021396 ,
        0.9961162302144619 ,
        0.9963815384508895 ,
        0.9966374775166863 ,
        0.9968840450052184 ,
        0.9971212385979773 ,
        0.9973490560646014 ,
        0.9975674952628989 ,
        0.9977765541388681 ,
        0.9979762307267186 ,
        0.9981665231488915 ,
        0.9983474296160800 ,
        0.9985189484272492 ,
        0.9986810779696582 ,
        0.9988338167188826 ,
        0.9989771632388403 ,
        0.9991111161818228 ,
        0.9992356742885348 ,
        0.9993508363881507 ,
        0.9994566013984001 ,
        0.9995529683257071 ,
        0.9996399362654382 ,
        0.9997175044023747 ,
        0.9997856720116890 ,
        0.9998444384611712 ,
        0.9998938032169420 ,
        0.9999337658606178 ,
        0.9999643261538894 ,
        0.9999854843850284 ,
        0.9999972450545584 };
const double weights_n1024[] = {
        0.0000070700764102 ,
        0.0000164577275799 ,
        0.0000258591246765 ,
        0.0000352614859872 ,
        0.0000446637581286 ,
        0.0000540656828939 ,
        0.0000634671268598 ,
        0.0000728679863190 ,
        0.0000822681667165 ,
        0.0000916675768614 ,
        0.0001010661269730 ,
        0.0001104637279257 ,
        0.0001198602909255 ,
        0.0001292557273595 ,
        0.0001386499487220 ,
        0.0001480428665748 ,
        0.0001574343925265 ,
        0.0001668244382203 ,
        0.0001762129153275 ,
        0.0001855997355432 ,
        0.0001949848105846 ,
        0.0002043680521896 ,
        0.0002137493721167 ,
        0.0002231286821443 ,
        0.0002325058940716 ,
        0.0002418809197187 ,
        0.0002512536709271 ,
        0.0002606240595604 ,
        0.0002699919975049 ,
        0.0002793573966705 ,
        0.0002887201689909 ,
        0.0002980802264253 ,
        0.0003074374809581 ,
        0.0003167918446006 ,
        0.0003261432293913 ,
        0.0003354915473966 ,
        0.0003448367107121 ,
        0.0003541786314631 ,
        0.0003635172218052 ,
        0.0003728523939256 ,
        0.0003821840600437 ,
        0.0003915121324117 ,
        0.0004008365233158 ,
        0.0004101571450768 ,
        0.0004194739100509 ,
        0.0004287867306307 ,
        0.0004380955192457 ,
        0.0004474001883635 ,
        0.0004567006504904 ,
        0.0004659968181723 ,
        0.0004752886039954 ,
        0.0004845759205872 ,
        0.0004938586806172 ,
        0.0005031367967978 ,
        0.0005124101818849 ,
        0.0005216787486791 ,
        0.0005309424100261 ,
        0.0005402010788181 ,
        0.0005494546679937 ,
        0.0005587030905398 ,
        0.0005679462594916 ,
        0.0005771840879336 ,
        0.0005864164890009 ,
        0.0005956433758792 ,
        0.0006048646618065 ,
        0.0006140802600730 ,
        0.0006232900840228 ,
        0.0006324940470539 ,
        0.0006416920626198 ,
        0.0006508840442298 ,
        0.0006600699054497 ,
        0.0006692495599031 ,
        0.0006784229212720 ,
        0.0006875899032974 ,
        0.0006967504197803 ,
        0.0007059043845828 ,
        0.0007150517116281 ,
        0.0007241923149022 ,
        0.0007333261084543 ,
        0.0007424530063975 ,
        0.0007515729229097 ,
        0.0007606857722346 ,
        0.0007697914686822 ,
        0.0007788899266300 ,
        0.0007879810605234 ,
        0.0007970647848766 ,
        0.0008061410142736 ,
        0.0008152096633688 ,
        0.0008242706468880 ,
        0.0008333238796289 ,
        0.0008423692764623 ,
        0.0008514067523324 ,
        0.0008604362222581 ,
        0.0008694576013336 ,
        0.0008784708047291 ,
        0.0008874757476915 ,
        0.0008964723455458 ,
        0.0009054605136951 ,
        0.0009144401676219 ,
        0.0009234112228888 ,
        0.0009323735951392 ,
        0.0009413272000981 ,
        0.0009502719535730 ,
        0.0009592077714547 ,
        0.0009681345697180 ,
        0.0009770522644223 ,
        0.0009859607717129 ,
        0.0009948600078213 ,
        0.0010037498890662 ,
        0.0010126303318544 ,
        0.0010215012526814 ,
        0.0010303625681320 ,
        0.0010392141948817 ,
        0.0010480560496969 ,
        0.0010568880494358 ,
        0.0010657101110494 ,
        0.0010745221515822 ,
        0.0010833240881729 ,
        0.0010921158380550 ,
        0.0011008973185580 ,
        0.0011096684471080 ,
        0.0011184291412284 ,
        0.0011271793185405 ,
        0.0011359188967648 ,
        0.0011446477937213 ,
        0.0011533659273305 ,
        0.0011620732156140 ,
        0.0011707695766956 ,
        0.0011794549288016 ,
        0.0011881291902619 ,
        0.0011967922795108 ,
        0.0012054441150876 ,
        0.0012140846156374 ,
        0.0012227136999118 ,
        0.0012313312867699 ,
        0.0012399372951788 ,
        0.0012485316442145 ,
        0.0012571142530627 ,
        0.0012656850410194 ,
        0.0012742439274919 ,
        0.0012827908319992 ,
        0.0012913256741731 ,
        0.0012998483737589 ,
        0.0013083588506160 ,
        0.0013168570247185 ,
        0.0013253428161567 ,
        0.0013338161451368 ,
        0.0013422769319825 ,
        0.0013507250971354 ,
        0.0013591605611558 ,
        0.0013675832447233 ,
        0.0013759930686377 ,
        0.0013843899538199 ,
        0.0013927738213123 ,
        0.0014011445922798 ,
        0.0014095021880103 ,
        0.0014178465299157 ,
        0.0014261775395326 ,
        0.0014344951385229 ,
        0.0014427992486745 ,
        0.0014510897919022 ,
        0.0014593666902485 ,
        0.0014676298658841 ,
        0.0014758792411086 ,
        0.0014841147383517 ,
        0.0014923362801733 ,
        0.0015005437892646 ,
        0.0015087371884489 ,
        0.0015169164006820 ,
        0.0015250813490532 ,
        0.0015332319567858 ,
        0.0015413681472381 ,
        0.0015494898439039 ,
        0.0015575969704133 ,
        0.0015656894505335 ,
        0.0015737672081691 ,
        0.0015818301673636 ,
        0.0015898782522992 ,
        0.0015979113872983 ,
        0.0016059294968238 ,
        0.0016139325054798 ,
        0.0016219203380124 ,
        0.0016298929193105 ,
        0.0016378501744064 ,
        0.0016457920284763 ,
        0.0016537184068416 ,
        0.0016616292349689 ,
        0.0016695244384711 ,
        0.0016774039431081 ,
        0.0016852676747874 ,
        0.0016931155595648 ,
        0.0017009475236450 ,
        0.0017087634933827 ,
        0.0017165633952826 ,
        0.0017243471560008 ,
        0.0017321147023451 ,
        0.0017398659612757 ,
        0.0017476008599059 ,
        0.0017553193255031 ,
        0.0017630212854890 ,
        0.0017707066674405 ,
        0.0017783753990905 ,
        0.0017860274083284 ,
        0.0017936626232009 ,
        0.0018012809719125 ,
        0.0018088823828265 ,
        0.0018164667844652 ,
        0.0018240341055111 ,
        0.0018315842748071 ,
        0.0018391172213576 ,
        0.0018466328743287 ,
        0.0018541311630493 ,
        0.0018616120170116 ,
        0.0018690753658715 ,
        0.0018765211394498 ,
        0.0018839492677324 ,
        0.0018913596808711 ,
        0.0018987523091845 ,
        0.0019061270831581 ,
        0.0019134839334455 ,
        0.0019208227908688 ,
        0.0019281435864193 ,
        0.0019354462512581 ,
        0.0019427307167168 ,
        0.0019499969142982 ,
        0.0019572447756768 ,
        0.0019644742326996 ,
        0.0019716852173865 ,
        0.0019788776619312 ,
        0.0019860514987018 ,
        0.0019932066602413 ,
        0.0020003430792682 ,
        0.0020074606886776 ,
        0.0020145594215410 ,
        0.0020216392111077 ,
        0.0020286999908050 ,
        0.0020357416942391 ,
        0.0020427642551955 ,
        0.0020497676076395 ,
        0.0020567516857174 ,
        0.0020637164237565 ,
        0.0020706617562660 ,
        0.0020775876179375 ,
        0.0020844939436459 ,
        0.0020913806684495 ,
        0.0020982477275912 ,
        0.0021050950564987 ,
        0.0021119225907852 ,
        0.0021187302662501 ,
        0.0021255180188793 ,
        0.0021322857848465 ,
        0.0021390335005130 ,
        0.0021457611024285 ,
        0.0021524685273323 ,
        0.0021591557121531 ,
        0.0021658225940099 ,
        0.0021724691102129 ,
        0.0021790951982633 ,
        0.0021857007958550 ,
        0.0021922858408741 ,
        0.0021988502714002 ,
        0.0022053940257066 ,
        0.0022119170422612 ,
        0.0022184192597268 ,
        0.0022249006169616 ,
        0.0022313610530203 ,
        0.0022378005071542 ,
        0.0022442189188116 ,
        0.0022506162276392 ,
        0.0022569923734817 ,
        0.0022633472963830 ,
        0.0022696809365864 ,
        0.0022759932345357 ,
        0.0022822841308748 ,
        0.0022885535664494 ,
        0.0022948014823068 ,
        0.0023010278196964 ,
        0.0023072325200709 ,
        0.0023134155250863 ,
        0.0023195767766025 ,
        0.0023257162166841 ,
        0.0023318337876007 ,
        0.0023379294318276 ,
        0.0023440030920463 ,
        0.0023500547111449 ,
        0.0023560842322190 ,
        0.0023620915985717 ,
        0.0023680767537146 ,
        0.0023740396413681 ,
        0.0023799802054619 ,
        0.0023858983901359 ,
        0.0023917941397402 ,
        0.0023976673988359 ,
        0.0024035181121955 ,
        0.0024093462248037 ,
        0.0024151516818576 ,
        0.0024209344287673 ,
        0.0024266944111566 ,
        0.0024324315748631 ,
        0.0024381458659393 ,
        0.0024438372306525 ,
        0.0024495056154857 ,
        0.0024551509671380 ,
        0.0024607732325250 ,
        0.0024663723587795 ,
        0.0024719482932517 ,
        0.0024775009835101 ,
        0.0024830303773417 ,
        0.0024885364227525 ,
        0.0024940190679680 ,
        0.0024994782614338 ,
        0.0025049139518162 ,
        0.0025103260880022 ,
        0.0025157146191005 ,
        0.0025210794944416 ,
        0.0025264206635786 ,
        0.0025317380762874 ,
        0.0025370316825673 ,
        0.0025423014326416 ,
        0.0025475472769577 ,
        0.0025527691661879 ,
        0.0025579670512298 ,
        0.0025631408832067 ,
        0.0025682906134680 ,
        0.0025734161935898 ,
        0.0025785175753752 ,
        0.0025835947108549 ,
        0.0025886475522877 ,
        0.0025936760521607 ,
        0.0025986801631900 ,
        0.0026036598383208 ,
        0.0026086150307284 ,
        0.0026135456938180 ,
        0.0026184517812258 ,
        0.0026233332468187 ,
        0.0026281900446955 ,
        0.0026330221291866 ,
        0.0026378294548551 ,
        0.0026426119764968 ,
        0.0026473696491406 ,
        0.0026521024280492 ,
        0.0026568102687194 ,
        0.0026614931268825 ,
        0.0026661509585045 ,
        0.0026707837197870 ,
        0.0026753913671673 ,
        0.0026799738573187 ,
        0.0026845311471511 ,
        0.0026890631938115 ,
        0.0026935699546842 ,
        0.0026980513873912 ,
        0.0027025074497927 ,
        0.0027069380999875 ,
        0.0027113432963133 ,
        0.0027157229973471 ,
        0.0027200771619059 ,
        0.0027244057490466 ,
        0.0027287087180665 ,
        0.0027329860285041 ,
        0.0027372376401389 ,
        0.0027414635129922 ,
        0.0027456636073273 ,
        0.0027498378836499 ,
        0.0027539863027084 ,
        0.0027581088254945 ,
        0.0027622054132432 ,
        0.0027662760274336 ,
        0.0027703206297889 ,
        0.0027743391822769 ,
        0.0027783316471102 ,
        0.0027822979867471 ,
        0.0027862381638913 ,
        0.0027901521414924 ,
        0.0027940398827466 ,
        0.0027979013510967 ,
        0.0028017365102326 ,
        0.0028055453240915 ,
        0.0028093277568583 ,
        0.0028130837729662 ,
        0.0028168133370965 ,
        0.0028205164141795 ,
        0.0028241929693944 ,
        0.0028278429681698 ,
        0.0028314663761840 ,
        0.0028350631593656 ,
        0.0028386332838931 ,
        0.0028421767161960 ,
        0.0028456934229547 ,
        0.0028491833711010 ,
        0.0028526465278182 ,
        0.0028560828605415 ,
        0.0028594923369584 ,
        0.0028628749250090 ,
        0.0028662305928861 ,
        0.0028695593090357 ,
        0.0028728610421573 ,
        0.0028761357612039 ,
        0.0028793834353829 ,
        0.0028826040341556 ,
        0.0028857975272381 ,
        0.0028889638846014 ,
        0.0028921030764717 ,
        0.0028952150733305 ,
        0.0028982998459150 ,
        0.0029013573652185 ,
        0.0029043876024907 ,
        0.0029073905292375 ,
        0.0029103661172219 ,
        0.0029133143384639 ,
        0.0029162351652407 ,
        0.0029191285700872 ,
        0.0029219945257962 ,
        0.0029248330054185 ,
        0.0029276439822634 ,
        0.0029304274298986 ,
        0.0029331833221510 ,
        0.0029359116331062 ,
        0.0029386123371095 ,
        0.0029412854087656 ,
        0.0029439308229391 ,
        0.0029465485547546 ,
        0.0029491385795971 ,
        0.0029517008731121 ,
        0.0029542354112058 ,
        0.0029567421700455 ,
        0.0029592211260597 ,
        0.0029616722559381 ,
        0.0029640955366324 ,
        0.0029664909453560 ,
        0.0029688584595844 ,
        0.0029711980570554 ,
        0.0029735097157693 ,
        0.0029757934139891 ,
        0.0029780491302407 ,
        0.0029802768433133 ,
        0.0029824765322592 ,
        0.0029846481763942 ,
        0.0029867917552980 ,
        0.0029889072488141 ,
        0.0029909946370502 ,
        0.0029930539003780 ,
        0.0029950850194339 ,
        0.0029970879751189 ,
        0.0029990627485989 ,
        0.0030010093213046 ,
        0.0030029276749320 ,
        0.0030048177914426 ,
        0.0030066796530630 ,
        0.0030085132422860 ,
        0.0030103185418699 ,
        0.0030120955348391 ,
        0.0030138442044842 ,
        0.0030155645343621 ,
        0.0030172565082963 ,
        0.0030189201103767 ,
        0.0030205553249602 ,
        0.0030221621366705 ,
        0.0030237405303985 ,
        0.0030252904913022 ,
        0.0030268120048071 ,
        0.0030283050566060 ,
        0.0030297696326596 ,
        0.0030312057191960 ,
        0.0030326133027115 ,
        0.0030339923699704 ,
        0.0030353429080049 ,
        0.0030366649041157 ,
        0.0030379583458719 ,
        0.0030392232211108 ,
        0.0030404595179388 ,
        0.0030416672247305 ,
        0.0030428463301298 ,
        0.0030439968230492 ,
        0.0030451186926704 ,
        0.0030462119284444 ,
        0.0030472765200911 ,
        0.0030483124576000 ,
        0.0030493197312300 ,
        0.0030502983315095 ,
        0.0030512482492366 ,
        0.0030521694754789 ,
        0.0030530620015739 ,
        0.0030539258191292 ,
        0.0030547609200221 ,
        0.0030555672963998 ,
        0.0030563449406800 ,
        0.0030570938455503 ,
        0.0030578140039685 ,
        0.0030585054091630 ,
        0.0030591680546322 ,
        0.0030598019341452 ,
        0.0030604070417414 ,
        0.0030609833717310 ,
        0.0030615309186947 ,
        0.0030620496774836 ,
        0.0030625396432198 ,
        0.0030630008112962 ,
        0.0030634331773761 ,
        0.0030638367373940 ,
        0.0030642114875552 ,
        0.0030645574243358 ,
        0.0030648745444829 ,
        0.0030651628450145 ,
        0.0030654223232197 ,
        0.0030656529766586 ,
        0.0030658548031623 ,
        0.0030660278008329 ,
        0.0030661719680438 ,
        0.0030662873034393 ,
        0.0030663738059349 ,
        0.0030664314747172 ,
        0.0030664603092439 ,
        0.0030664603092439 ,
        0.0030664314747172 ,
        0.0030663738059349 ,
        0.0030662873034393 ,
        0.0030661719680438 ,
        0.0030660278008329 ,
        0.0030658548031623 ,
        0.0030656529766586 ,
        0.0030654223232197 ,
        0.0030651628450145 ,
        0.0030648745444829 ,
        0.0030645574243358 ,
        0.0030642114875552 ,
        0.0030638367373940 ,
        0.0030634331773761 ,
        0.0030630008112962 ,
        0.0030625396432198 ,
        0.0030620496774836 ,
        0.0030615309186947 ,
        0.0030609833717310 ,
        0.0030604070417414 ,
        0.0030598019341452 ,
        0.0030591680546322 ,
        0.0030585054091630 ,
        0.0030578140039685 ,
        0.0030570938455503 ,
        0.0030563449406800 ,
        0.0030555672963998 ,
        0.0030547609200221 ,
        0.0030539258191292 ,
        0.0030530620015739 ,
        0.0030521694754789 ,
        0.0030512482492366 ,
        0.0030502983315095 ,
        0.0030493197312300 ,
        0.0030483124576000 ,
        0.0030472765200911 ,
        0.0030462119284444 ,
        0.0030451186926704 ,
        0.0030439968230492 ,
        0.0030428463301298 ,
        0.0030416672247305 ,
        0.0030404595179388 ,
        0.0030392232211108 ,
        0.0030379583458719 ,
        0.0030366649041157 ,
        0.0030353429080049 ,
        0.0030339923699704 ,
        0.0030326133027115 ,
        0.0030312057191960 ,
        0.0030297696326596 ,
        0.0030283050566060 ,
        0.0030268120048071 ,
        0.0030252904913022 ,
        0.0030237405303985 ,
        0.0030221621366705 ,
        0.0030205553249602 ,
        0.0030189201103767 ,
        0.0030172565082963 ,
        0.0030155645343621 ,
        0.0030138442044842 ,
        0.0030120955348391 ,
        0.0030103185418699 ,
        0.0030085132422860 ,
        0.0030066796530630 ,
        0.0030048177914426 ,
        0.0030029276749320 ,
        0.0030010093213046 ,
        0.0029990627485989 ,
        0.0029970879751189 ,
        0.0029950850194339 ,
        0.0029930539003780 ,
        0.0029909946370502 ,
        0.0029889072488141 ,
        0.0029867917552980 ,
        0.0029846481763942 ,
        0.0029824765322592 ,
        0.0029802768433133 ,
        0.0029780491302407 ,
        0.0029757934139891 ,
        0.0029735097157693 ,
        0.0029711980570554 ,
        0.0029688584595844 ,
        0.0029664909453560 ,
        0.0029640955366324 ,
        0.0029616722559381 ,
        0.0029592211260597 ,
        0.0029567421700455 ,
        0.0029542354112058 ,
        0.0029517008731121 ,
        0.0029491385795971 ,
        0.0029465485547546 ,
        0.0029439308229391 ,
        0.0029412854087656 ,
        0.0029386123371095 ,
        0.0029359116331062 ,
        0.0029331833221510 ,
        0.0029304274298986 ,
        0.0029276439822634 ,
        0.0029248330054185 ,
        0.0029219945257962 ,
        0.0029191285700872 ,
        0.0029162351652407 ,
        0.0029133143384639 ,
        0.0029103661172219 ,
        0.0029073905292375 ,
        0.0029043876024907 ,
        0.0029013573652185 ,
        0.0028982998459150 ,
        0.0028952150733305 ,
        0.0028921030764717 ,
        0.0028889638846014 ,
        0.0028857975272381 ,
        0.0028826040341556 ,
        0.0028793834353829 ,
        0.0028761357612039 ,
        0.0028728610421573 ,
        0.0028695593090357 ,
        0.0028662305928861 ,
        0.0028628749250090 ,
        0.0028594923369584 ,
        0.0028560828605415 ,
        0.0028526465278182 ,
        0.0028491833711010 ,
        0.0028456934229547 ,
        0.0028421767161960 ,
        0.0028386332838931 ,
        0.0028350631593656 ,
        0.0028314663761840 ,
        0.0028278429681698 ,
        0.0028241929693944 ,
        0.0028205164141795 ,
        0.0028168133370965 ,
        0.0028130837729662 ,
        0.0028093277568583 ,
        0.0028055453240915 ,
        0.0028017365102326 ,
        0.0027979013510967 ,
        0.0027940398827466 ,
        0.0027901521414924 ,
        0.0027862381638913 ,
        0.0027822979867471 ,
        0.0027783316471102 ,
        0.0027743391822769 ,
        0.0027703206297889 ,
        0.0027662760274336 ,
        0.0027622054132432 ,
        0.0027581088254945 ,
        0.0027539863027084 ,
        0.0027498378836499 ,
        0.0027456636073273 ,
        0.0027414635129922 ,
        0.0027372376401389 ,
        0.0027329860285041 ,
        0.0027287087180665 ,
        0.0027244057490466 ,
        0.0027200771619059 ,
        0.0027157229973471 ,
        0.0027113432963133 ,
        0.0027069380999875 ,
        0.0027025074497927 ,
        0.0026980513873912 ,
        0.0026935699546842 ,
        0.0026890631938115 ,
        0.0026845311471511 ,
        0.0026799738573187 ,
        0.0026753913671673 ,
        0.0026707837197870 ,
        0.0026661509585045 ,
        0.0026614931268825 ,
        0.0026568102687194 ,
        0.0026521024280492 ,
        0.0026473696491406 ,
        0.0026426119764968 ,
        0.0026378294548551 ,
        0.0026330221291866 ,
        0.0026281900446955 ,
        0.0026233332468187 ,
        0.0026184517812258 ,
        0.0026135456938180 ,
        0.0026086150307284 ,
        0.0026036598383208 ,
        0.0025986801631900 ,
        0.0025936760521607 ,
        0.0025886475522877 ,
        0.0025835947108549 ,
        0.0025785175753752 ,
        0.0025734161935898 ,
        0.0025682906134680 ,
        0.0025631408832067 ,
        0.0025579670512298 ,
        0.0025527691661879 ,
        0.0025475472769577 ,
        0.0025423014326416 ,
        0.0025370316825673 ,
        0.0025317380762874 ,
        0.0025264206635786 ,
        0.0025210794944416 ,
        0.0025157146191005 ,
        0.0025103260880022 ,
        0.0025049139518162 ,
        0.0024994782614338 ,
        0.0024940190679680 ,
        0.0024885364227525 ,
        0.0024830303773417 ,
        0.0024775009835101 ,
        0.0024719482932517 ,
        0.0024663723587795 ,
        0.0024607732325250 ,
        0.0024551509671380 ,
        0.0024495056154857 ,
        0.0024438372306525 ,
        0.0024381458659393 ,
        0.0024324315748631 ,
        0.0024266944111566 ,
        0.0024209344287673 ,
        0.0024151516818576 ,
        0.0024093462248037 ,
        0.0024035181121955 ,
        0.0023976673988359 ,
        0.0023917941397402 ,
        0.0023858983901359 ,
        0.0023799802054619 ,
        0.0023740396413681 ,
        0.0023680767537146 ,
        0.0023620915985717 ,
        0.0023560842322190 ,
        0.0023500547111449 ,
        0.0023440030920463 ,
        0.0023379294318276 ,
        0.0023318337876007 ,
        0.0023257162166841 ,
        0.0023195767766025 ,
        0.0023134155250863 ,
        0.0023072325200709 ,
        0.0023010278196964 ,
        0.0022948014823068 ,
        0.0022885535664494 ,
        0.0022822841308748 ,
        0.0022759932345357 ,
        0.0022696809365864 ,
        0.0022633472963830 ,
        0.0022569923734817 ,
        0.0022506162276392 ,
        0.0022442189188116 ,
        0.0022378005071542 ,
        0.0022313610530203 ,
        0.0022249006169616 ,
        0.0022184192597268 ,
        0.0022119170422612 ,
        0.0022053940257066 ,
        0.0021988502714002 ,
        0.0021922858408741 ,
        0.0021857007958550 ,
        0.0021790951982633 ,
        0.0021724691102129 ,
        0.0021658225940099 ,
        0.0021591557121531 ,
        0.0021524685273323 ,
        0.0021457611024285 ,
        0.0021390335005130 ,
        0.0021322857848465 ,
        0.0021255180188793 ,
        0.0021187302662501 ,
        0.0021119225907852 ,
        0.0021050950564987 ,
        0.0020982477275912 ,
        0.0020913806684495 ,
        0.0020844939436459 ,
        0.0020775876179375 ,
        0.0020706617562660 ,
        0.0020637164237565 ,
        0.0020567516857174 ,
        0.0020497676076395 ,
        0.0020427642551955 ,
        0.0020357416942391 ,
        0.0020286999908050 ,
        0.0020216392111077 ,
        0.0020145594215410 ,
        0.0020074606886776 ,
        0.0020003430792682 ,
        0.0019932066602413 ,
        0.0019860514987018 ,
        0.0019788776619312 ,
        0.0019716852173865 ,
        0.0019644742326996 ,
        0.0019572447756768 ,
        0.0019499969142982 ,
        0.0019427307167168 ,
        0.0019354462512581 ,
        0.0019281435864193 ,
        0.0019208227908688 ,
        0.0019134839334455 ,
        0.0019061270831581 ,
        0.0018987523091845 ,
        0.0018913596808711 ,
        0.0018839492677324 ,
        0.0018765211394498 ,
        0.0018690753658715 ,
        0.0018616120170116 ,
        0.0018541311630493 ,
        0.0018466328743287 ,
        0.0018391172213576 ,
        0.0018315842748071 ,
        0.0018240341055111 ,
        0.0018164667844652 ,
        0.0018088823828265 ,
        0.0018012809719125 ,
        0.0017936626232009 ,
        0.0017860274083284 ,
        0.0017783753990905 ,
        0.0017707066674405 ,
        0.0017630212854890 ,
        0.0017553193255031 ,
        0.0017476008599059 ,
        0.0017398659612757 ,
        0.0017321147023451 ,
        0.0017243471560008 ,
        0.0017165633952826 ,
        0.0017087634933827 ,
        0.0017009475236450 ,
        0.0016931155595648 ,
        0.0016852676747874 ,
        0.0016774039431081 ,
        0.0016695244384711 ,
        0.0016616292349689 ,
        0.0016537184068416 ,
        0.0016457920284763 ,
        0.0016378501744064 ,
        0.0016298929193105 ,
        0.0016219203380124 ,
        0.0016139325054798 ,
        0.0016059294968238 ,
        0.0015979113872983 ,
        0.0015898782522992 ,
        0.0015818301673636 ,
        0.0015737672081691 ,
        0.0015656894505335 ,
        0.0015575969704133 ,
        0.0015494898439039 ,
        0.0015413681472381 ,
        0.0015332319567858 ,
        0.0015250813490532 ,
        0.0015169164006820 ,
        0.0015087371884489 ,
        0.0015005437892646 ,
        0.0014923362801733 ,
        0.0014841147383517 ,
        0.0014758792411086 ,
        0.0014676298658841 ,
        0.0014593666902485 ,
        0.0014510897919022 ,
        0.0014427992486745 ,
        0.0014344951385229 ,
        0.0014261775395326 ,
        0.0014178465299157 ,
        0.0014095021880103 ,
        0.0014011445922798 ,
        0.0013927738213123 ,
        0.0013843899538199 ,
        0.0013759930686377 ,
        0.0013675832447233 ,
        0.0013591605611558 ,
        0.0013507250971354 ,
        0.0013422769319825 ,
        0.0013338161451368 ,
        0.0013253428161567 ,
        0.0013168570247185 ,
        0.0013083588506160 ,
        0.0012998483737589 ,
        0.0012913256741731 ,
        0.0012827908319992 ,
        0.0012742439274919 ,
        0.0012656850410194 ,
        0.0012571142530627 ,
        0.0012485316442145 ,
        0.0012399372951788 ,
        0.0012313312867699 ,
        0.0012227136999118 ,
        0.0012140846156374 ,
        0.0012054441150876 ,
        0.0011967922795108 ,
        0.0011881291902619 ,
        0.0011794549288016 ,
        0.0011707695766956 ,
        0.0011620732156140 ,
        0.0011533659273305 ,
        0.0011446477937213 ,
        0.0011359188967648 ,
        0.0011271793185405 ,
        0.0011184291412284 ,
        0.0011096684471080 ,
        0.0011008973185580 ,
        0.0010921158380550 ,
        0.0010833240881729 ,
        0.0010745221515822 ,
        0.0010657101110494 ,
        0.0010568880494358 ,
        0.0010480560496969 ,
        0.0010392141948817 ,
        0.0010303625681320 ,
        0.0010215012526814 ,
        0.0010126303318544 ,
        0.0010037498890662 ,
        0.0009948600078213 ,
        0.0009859607717129 ,
        0.0009770522644223 ,
        0.0009681345697180 ,
        0.0009592077714547 ,
        0.0009502719535730 ,
        0.0009413272000981 ,
        0.0009323735951392 ,
        0.0009234112228888 ,
        0.0009144401676219 ,
        0.0009054605136951 ,
        0.0008964723455458 ,
        0.0008874757476915 ,
        0.0008784708047291 ,
        0.0008694576013336 ,
        0.0008604362222581 ,
        0.0008514067523324 ,
        0.0008423692764623 ,
        0.0008333238796289 ,
        0.0008242706468880 ,
        0.0008152096633688 ,
        0.0008061410142736 ,
        0.0007970647848766 ,
        0.0007879810605234 ,
        0.0007788899266300 ,
        0.0007697914686822 ,
        0.0007606857722346 ,
        0.0007515729229097 ,
        0.0007424530063975 ,
        0.0007333261084543 ,
        0.0007241923149022 ,
        0.0007150517116281 ,
        0.0007059043845828 ,
        0.0006967504197803 ,
        0.0006875899032974 ,
        0.0006784229212720 ,
        0.0006692495599031 ,
        0.0006600699054497 ,
        0.0006508840442298 ,
        0.0006416920626198 ,
        0.0006324940470539 ,
        0.0006232900840228 ,
        0.0006140802600730 ,
        0.0006048646618065 ,
        0.0005956433758792 ,
        0.0005864164890009 ,
        0.0005771840879336 ,
        0.0005679462594916 ,
        0.0005587030905398 ,
        0.0005494546679937 ,
        0.0005402010788181 ,
        0.0005309424100261 ,
        0.0005216787486791 ,
        0.0005124101818849 ,
        0.0005031367967978 ,
        0.0004938586806172 ,
        0.0004845759205872 ,
        0.0004752886039954 ,
        0.0004659968181723 ,
        0.0004567006504904 ,
        0.0004474001883635 ,
        0.0004380955192457 ,
        0.0004287867306307 ,
        0.0004194739100509 ,
        0.0004101571450768 ,
        0.0004008365233158 ,
        0.0003915121324117 ,
        0.0003821840600437 ,
        0.0003728523939256 ,
        0.0003635172218052 ,
        0.0003541786314631 ,
        0.0003448367107121 ,
        0.0003354915473966 ,
        0.0003261432293913 ,
        0.0003167918446006 ,
        0.0003074374809581 ,
        0.0002980802264253 ,
        0.0002887201689909 ,
        0.0002793573966705 ,
        0.0002699919975049 ,
        0.0002606240595604 ,
        0.0002512536709271 ,
        0.0002418809197187 ,
        0.0002325058940716 ,
        0.0002231286821443 ,
        0.0002137493721167 ,
        0.0002043680521896 ,
        0.0001949848105846 ,
        0.0001855997355432 ,
        0.0001762129153275 ,
        0.0001668244382203 ,
        0.0001574343925265 ,
        0.0001480428665748 ,
        0.0001386499487220 ,
        0.0001292557273595 ,
        0.0001198602909255 ,
        0.0001104637279257 ,
        0.0001010661269730 ,
        0.0000916675768614 ,
        0.0000822681667165 ,
        0.0000728679863190 ,
        0.0000634671268598 ,
        0.0000540656828939 ,
        0.0000446637581286 ,
        0.0000352614859872 ,
        0.0000258591246765 ,
        0.0000164577275799 ,
        0.0000070700764102 } /* 2.000000000000000 */ ;


const double * const points[] =
  { 0 , points_n1 , points_n2 , points_n3 , points_n4 , points_n5 , points_n6 , points_n7 , points_n8 ,
        points_n9 , points_n10 , points_n11 , points_n12 , points_n13 , points_n14 , points_n15 , points_n16 ,
        points_n17 , points_n18 , points_n19 , points_n20 };

const double * const weights[] =
  { 0 , weights_n1 , weights_n2 , weights_n3 , weights_n4 , weights_n5 , weights_n6 , weights_n7 , weights_n8 ,
        weights_n9 , weights_n10 , weights_n11 , weights_n12 , weights_n13 , weights_n14 , weights_n15 , weights_n16 ,
        weights_n17 , weights_n18 , weights_n19 , weights_n20 };

}

unsigned guass_legendre_available( unsigned n )
{
  if     ( 1024 < n ) { n =    0 ; }
  else if ( 512 < n ) { n = 1024 ; }
  else if ( 256 < n ) { n =  512 ; }
  else if ( 128 < n ) { n =  256 ; }
  else if (  64 < n ) { n =  128 ; }
  else if (  32 < n ) { n =   64 ; }
  else if (  20 < n ) { n =   32 ; }
  return n ;
}

void gauss_legendre( unsigned n , double pt[] , double wgt[] )
{
  if ( n <= 20 ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points[n][i] ;
      wgt[i] = weights[n][i] ;
    }
  }
  else if ( 32 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n32[i] ;
      wgt[i] = weights_n32[i] ;
    }
  }
  else if ( 64 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n64[i] ;
      wgt[i] = weights_n64[i] ;
    }
  }
  else if ( 128 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n128[i] ;
      wgt[i] = weights_n128[i] ;
    }
  }
  else if ( 256 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n256[i] ;
      wgt[i] = weights_n256[i] ;
    }
  }
  else if ( 512 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n512[i] ;
      wgt[i] = weights_n512[i] ;
    }
  }
  else if ( 1024 == n ) {
    for ( unsigned i = 0 ; i < n ; ++i ) {
      pt[i] = points_n1024[i] ;
      wgt[i] = weights_n1024[i] ;
    }
  }
  else {
    std::ostringstream msg ;
    msg << "KokkosArray::Impl::gauss_legendre( " << n << " > maximum(512) )" ;
    throw std::runtime_error( msg.str() );
  }
}

}
}

