//@HEADER
// ************************************************************************
// 
//          Kokkos: Node API and Parallel Node Kernels
//              Copyright (2008) Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Michael A. Heroux (maherou@sandia.gov) 
// 
// ************************************************************************
//@HEADER

#ifndef __Kokkos_Raw_SparseMatVec_decl_hpp
#define __Kokkos_Raw_SparseMatVec_decl_hpp

/// \file Kokkos_Raw_SparseMatVec_decl.hpp
/// \brief Declarations of "raw" sequential and OpenMP-parallel
///   sparse matrix-(multi)vector multiply routines.
/// \warning This code was generated by the SparseMatVec.py script.  
///   If you edit this header by hand, your edits will disappear the 
///   next time you run the generator script.

namespace Kokkos {
namespace Raw {

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor4Unrolled (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForfor4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhile1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhile2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhile3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhile4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForif1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForif2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForif3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForif4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor4Unrolled (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor4UnrolledOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor1VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor2VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor3VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForfor4VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhile1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhile2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhile3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhile4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForif1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForif2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForif3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForif4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj4Unrolled (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForforConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhileConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhileConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhileConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForwhileConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForifConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForifConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForifConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSC sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of
///   column i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCscColMajorForifConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConjOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj4Unrolled (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X or Y (must be the same
///   for both).
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj4UnrolledOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj1VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj2VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj3VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForforConj4VecOmp (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhileConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhileConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhileConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForwhileConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForifConj1Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForifConj2Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForifConj3Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

/// CSR sparse matrix-(multi)vector multiply
///   with column-major input / output (multi)vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input multivector Y.
///   This may differ from the type of entries in the output multivector X.
/// \tparam RangeScalar The type of entries in the output multivector X.
///
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of
///   row i (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
matVecCsrColMajorForifConj4Vec (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  const RangeScalar& beta,
  RangeScalar Y[],
  const Ordinal colStrideY,
  const RangeScalar& alpha,
  const size_t  ptr[],
  const Ordinal ind[],
  const MatrixScalar val[],
  const DomainScalar X[],
  const Ordinal colStrideX);

} // namespace Raw
} // namespace Kokkos

#endif // #ifndef __Kokkos_Raw_SparseMatVec_decl_hpp
