//@HEADER
// ************************************************************************
// 
//          Kokkos: Node API and Parallel Node Kernels
//              Copyright (2008) Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Michael A. Heroux (maherou@sandia.gov) 
// 
// ************************************************************************
//@HEADER

#ifndef __Kokkos_Raw_SparseTriangularSolve_decl_hpp
#define __Kokkos_Raw_SparseTriangularSolve_decl_hpp

/// \file Kokkos_Raw_SparseTriangularSolve_decl.hpp
/// \brief Declarations of "raw" sequential sparse triangular solve routines.
/// \warning This code was generated by the SparseTriSolve.py script.  
///   If you edit this header by hand, your edits will disappear the 
///   next time you run the generator script.

namespace Kokkos {

/// \namespace Raw
/// \brief "Raw" intranode computational routines.
///
/// "Raw" means first that the routines only use standard data structures,
/// rather than Kokkos data structures.  Second, it means that the routines
/// do not depend on the Kokkos Node API (a generic intranode parallel
/// programming model).  They are either sequential, or directly use a 
/// standard shared-memory programming model, such as Pthreads, Intel's
/// Threading Building Blocks, or the like.
///
/// The sparse matrix-vector multiply and sparse triangular solve routines
/// defined in this namespace accept multiple vectors at a time.  These are
/// really just dense matrices, but we sometimes call them "multivectors,"
/// to highlight that we are considering them as collections of one or more
/// vectors.
namespace Raw {

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrColMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrRowMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrColMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrRowMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscColMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrColMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrRowMajor (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrColMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrRowMajorUnitDiag (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorUnitDiagInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorUnitDiagInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorUnitDiagInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorUnitDiagInPlace (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrColMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrRowMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrColMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
lowerTriSolveCsrRowMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrColMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrRowMajorConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with column-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in column-major order.
/// \param LDY [in] Stride between columns of Y.  We assume unit
///   stride between rows of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrColMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal colStrideY);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Upper triangular solve of a CSR-format sparse matrix
///   with row-major input / output vectors
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \tparam DomainScalar The type of entries in the input matrix Y.
///   This may differ from the type of entries in the output matrix X.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [out] Output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numRows+1) array of index offsets 
///   between rows of the sparse matrix.
/// \param ind [in] Array of column indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the column indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of row i
///   (zero-based) of the sparse matrix.
/// \param Y [in] Input multivector, stored in row-major order.
/// \param LDY [in] Stride between rows of Y.  We assume unit
///   stride between columns of Y.

template<class Ordinal,
         class MatrixScalar,
         class DomainScalar,
         class RangeScalar>
void
upperTriSolveCsrRowMajorUnitDiagConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val,
  const DomainScalar* const Y,
  const Ordinal rowStrideY);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscColMajorUnitDiagInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Lower triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
lowerTriSolveCscRowMajorUnitDiagInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with column-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in column-major order.
/// \param LDX [in] Stride between columns of X.  We assume unit
///   stride between rows of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscColMajorUnitDiagInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal colStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

/// Upper triangular solve of a CSC-format sparse matrix
///   with row-major input / output vectors
///   (overwriting input with output)
///   and implicitly stored unit diagonal entries
///   using conjugate of sparse matrix entries
///
/// \tparam Ordinal The type of indices used to access the entries of
///   the sparse and dense matrices.  Any signed or unsigned integer
///   type which can be used in pointer arithmetic with raw arrays 
///   will do.
/// \tparam MatrixScalar The type of entries in the sparse matrix.
///   This may differ from the type of entries in the input/output
///   matrices.
/// \param numRows [in] Number of rows in the sparse matrix.
/// \param numCols [in] Number of columns in the sparse matrix.
/// \param numVecs [in] Number of columns in X.
/// \param X [in/out] Input/output multivector, stored in row-major order.
/// \param LDX [in] Stride between rows of X.  We assume unit
///   stride between columns of X.
/// \param ptr [in] Length (numCols+1) array of index offsets 
///   between columns of the sparse matrix.
/// \param ind [in] Array of row indices of the sparse matrix.
///   ind[ptr[i] .. ptr[i+1]-1] are the row indices of row i
///   (zero-based) of the sparse matrix.
/// \param val [in] Array of entries of the sparse matrix.
///   val[ptr[i] .. ptr[i+1]-1] are the entries of column i
///   (zero-based) of the sparse matrix.

template<class Ordinal,
         class MatrixScalar,
         class RangeScalar>
void
upperTriSolveCscRowMajorUnitDiagInPlaceConj (
  const Ordinal numRows,
  const Ordinal numCols,
  const Ordinal numVecs,
  RangeScalar* const X,
  const Ordinal rowStrideX,
  const  size_t* const ptr,
  const Ordinal* const ind,
  const MatrixScalar* const val);

} // namespace Raw
} // namespace Kokkos

#endif // #ifndef __Kokkos_Raw_SparseTriangularSolve_decl_hpp
