
########## CHECK FOR HEADER FILES ############

INCLUDE(CheckIncludeFiles)

# Probe for timer header files
CHECK_INCLUDE_FILES("mach/mach_time.h" HAVE_TRIOS_MACH_TIME_H)
CHECK_INCLUDE_FILES("time.h" HAVE_TRIOS_TIME_H)
CHECK_INCLUDE_FILES("sys/time.h" HAVE_TRIOS_SYS_TIME_H)

if (TPL_ENABLE_PAPI)
  CHECK_INCLUDE_FILES("papi.h" HAVE_TRIOS_PAPI_H)
endif (TPL_ENABLE_PAPI)

########## CHECK FOR FUNCTIONS ############

INCLUDE(CheckLibraryExists)
INCLUDE(CheckFunctionExists)
INCLUDE(CheckCSourceCompiles)
INCLUDE(CheckCXXSourceCompiles)

# clock_gettime
IF (HAVE_TRIOS_TIME_H)
  CHECK_LIBRARY_EXISTS(rt clock_gettime "" HAVE_TRIOS_CLOCK_GETTIME)
  IF (HAVE_TRIOS_CLOCK_GETTIME)
    SET(CMAKE_REQUIRED_LIBRARIES "rt;${CMAKE_REQUIRED_LIBRARIES}")
  ENDIF (HAVE_TRIOS_CLOCK_GETTIME)
ENDIF(HAVE_TRIOS_TIME_H)

# gettimeofday
IF (HAVE_TRIOS_SYS_TIME_H)
  CHECK_FUNCTION_EXISTS(gettimeofday HAVE_TRIOS_GETTIMEOFDAY)
ENDIF (HAVE_TRIOS_SYS_TIME_H)

# papi
IF (HAVE_TRIOS_PAPI_H)
  CHECK_FUNCTION_EXISTS(PAPI_get_real_usec HAVE_TRIOS_PAPI_GET_REAL_USEC)
  SET(HAVE_TRIOS_PAPI ${HAVE_TRIOS_PAPI_GET_REAL_USEC})
ENDIF (HAVE_TRIOS_PAPI_H)

# mach_absolute_time (on apple)
IF (HAVE_TRIOS_MACH_TIME_H)
  CHECK_FUNCTION_EXISTS(mach_absolute_time HAVE_TRIOS_MACH_ABSOLUTE_TIME)
ENDIF (HAVE_TRIOS_MACH_TIME_H)