CMAKE_MINIMUM_REQUIRED(VERSION 2.8)

set(CTEST_SITE "faraway.kitware")
set(CTEST_BUILD_NAME "Linux gcc-4.1.3 cvshead")

set(CTEST_PROJECT_NAME "radiance")
set(CTEST_DASHBOARD_ROOT "/home/zack/dashboards")
set(CTEST_NOTES_FILES "${CTEST_SCRIPT_DIRECTORY}/${CTEST_SCRIPT_NAME}")
set(CTEST_SOURCE_DIRECTORY "${CTEST_DASHBOARD_ROOT}/radiance-CVSHEAD-src")
set(CTEST_BINARY_DIRECTORY "${CTEST_DASHBOARD_ROOT}/radiance-CVSHEAD-src")

set(CTEST_CMAKE_GENERATOR "Unix Makefiles")
set(CTEST_TEST_TIMEOUT 120)
set(CTEST_BUILD_CONFIGURATION "Debug")

set(CTEST_UPDATE_COMMAND "git")
set(CTEST_CONFIGURE_COMMAND "/bin/csh ${CTEST_SOURCE_DIRECTORY}/makeall clean")
set(CTEST_BUILD_COMMAND "/bin/bash ${CTEST_SCRIPT_DIRECTORY}/RadianceCVS.sh")

ctest_start(Nightly)
ctest_update(SOURCE "${CTEST_SOURCE_DIRECTORY}")
ctest_configure(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_build(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_test(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_submit()
