CMAKE_MINIMUM_REQUIRED(VERSION 2.8)

set(CTEST_SITE "dash2win64.kitware")
set(CTEST_BUILD_NAME "Win64 NMake")

set(CTEST_PROJECT_NAME "radiance")
set(CTEST_DASHBOARD_ROOT "C:/Dashboards")
set(CTEST_NOTES_FILES "${CTEST_SCRIPT_DIRECTORY}/${CTEST_SCRIPT_NAME}")
set(CTEST_SOURCE_DIRECTORY "${CTEST_DASHBOARD_ROOT}/radiance-nightly-src")
set(CTEST_BINARY_DIRECTORY "${CTEST_DASHBOARD_ROOT}/radiance-nightly-bin")

set(CTEST_CMAKE_GENERATOR "NMake Makefiles")
set(CTEST_TEST_TIMEOUT 120)
set(CTEST_BUILD_CONFIGURATION "Debug")

set(CTEST_UPDATE_COMMAND "C:/cygwin/bin/git")

ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})

file(WRITE "${CTEST_BINARY_DIRECTORY}/CMakeCache.txt" "
QT_QMAKE_EXECUTABLE:FILEPATH=C:/Dashboards/Support/qt-build/Qt/bin/qmake.exe
PERL_EXECUTABLE:FILEPATH=C:/MinGW/msys/1.0/bin/perl.exe
")

ctest_start(Nightly)
ctest_update(SOURCE "${CTEST_SOURCE_DIRECTORY}")
ctest_configure(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_build(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_test(BUILD "${CTEST_BINARY_DIRECTORY}")
ctest_submit()