/*-
 * Copyright (c) 2003-2007 Tim Kientzle
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "test.h"
__FBSDID("$FreeBSD: src/lib/libarchive/test/test_write_format_cpio_empty.c,v 1.3 2008/09/01 05:38:33 kientzle Exp $");

/*
 * Check that an "empty" cpio archive is correctly created.
 */

/* Here's what an empty cpio archive should look like. */
static char ref[] =
"070707"  /* Magic number */
"000000"  /* Dev = 0 */
"000000"  /* ino = 0 */
"000000"  /* mode = 0 */
"000000"  /* uid = 0 */
"000000"  /* gid = 0 */
"000001"  /* nlink = 1 */
"000000"  /* rdev = 0 */
"00000000000" /* mtime = 0 */
"000013"  /* Namesize = 11 */
"00000000000" /* filesize = 0 */
"TRAILER!!!\0"; /* Name */

DEFINE_TEST(test_write_format_cpio_empty)
{
    struct archive *a;
    char buff[2048];
    size_t used;

    /* Create a new archive in memory. */
    assert((a = archive_write_new()) != NULL);
    assertA(0 == archive_write_set_format_cpio(a));
    assertA(0 == archive_write_set_compression_none(a));
    /* 1-byte block size ensures we see only the required bytes. */
    /* We're not testing the padding here. */
    assertA(0 == archive_write_set_bytes_per_block(a, 1));
    assertA(0 == archive_write_set_bytes_in_last_block(a, 1));
    assertA(0 == archive_write_open_memory(a, buff, sizeof(buff), &used));

    /* Close out the archive. */
    assertA(0 == archive_write_close(a));
#if ARCHIVE_VERSION_NUMBER < 2000000
    archive_write_finish(a);
#else
    assertA(0 == archive_write_finish(a));
#endif

    failure("Empty cpio archive should be exactly 87 bytes, was %d.", used);
    assert(used == 87);
    failure("Empty cpio archive is incorrectly formatted.");
    assert(memcmp(buff, ref, 87) == 0);
}
