TOP_DIR=`cd \`echo "$0" | sed -n '/\//{s/\/[^\/]*$//;p;}'\`;pwd`

# create build directory
mkdirs()
{
  (
  mkdir -p "$TOP_DIR/cmake-3.3.1/.build"
  )
}

# cd into
# untar source tree and apply patch
prep()
{
  (
  cd "$TOP_DIR" &&
  tar xvfj cmake-3.3.1.tar.bz2
  patch -p0 < "cmake-3.3.1-1.patch" &&
  mkdirs
  )
}

conf()
{
  (
  cd "$TOP_DIR/cmake-3.3.1/.build" &&
  ../bootstrap --parallel=2
  )
}

build()
{
  (
  cd "$TOP_DIR/cmake-3.3.1/.build" &&
  make -j2 &&
  make test
  )
}

clean()
{
  (
  cd "$TOP_DIR/cmake-3.3.1/.build" &&
  make clean
  )
}

pkg()
{
  (
  cd "$TOP_DIR/cmake-3.3.1/.build" &&
  ./bin/cpack &&
  mv cmake-3.3.1-1.tar.bz2 "$TOP_DIR"
  )
}

spkg()
{
 (
  cd "$TOP_DIR/cmake-3.3.1/.build" &&
  ./bin/cpack --config  CPackSourceConfig.cmake &&
  mv cmake-3.3.1-1-src.tar.bz2 "$TOP_DIR"
  )
}

finish()
{
  (
  rm -rf "cmake-3.3.1"
  )
}

case $1 in
  prep)         prep    ; STATUS=$? ;;
  mkdirs)       mkdirs  ; STATUS=$? ;;
  conf)         conf    ; STATUS=$? ;;
  build)        build   ; STATUS=$? ;;
  clean)        clean   ; STATUS=$? ;;
  package)      pkg     ; STATUS=$? ;;
  pkg)          pkg     ; STATUS=$? ;;
  src-package)  spkg    ; STATUS=$? ;;
  spkg)         spkg    ; STATUS=$? ;;
  finish)       finish  ; STATUS=$? ;;
  all) (
       prep && conf && build && pkg && spkg && finish ;
       STATUS=$?
       ) ;;
  *) echo "Error: bad argument (all or one of these: prep mkdirs conf build clean package pkg src-package spkg finish)" ; exit 1 ;;
esac
exit 
