"""
The following notifications are currently supported:
    - run_ended - Triggered when a run is ended and includes final status e.g. success/abort/failure
    - remaining_step_operators - Triggered when someone manually chooses to notify operators that a
                                 signoff is needed from them
    - reviewers - Triggered when someone manually chooses to notify a role/user that a procedure review is needed
    - automation - Triggered when an automated procedure is paused and requires manual intervention

This client will be updated as more notifications are added.
The `response` property only supports setting to an object { 'received': True/False } which is used
as a feedback indicator on the UI.

For more information on notifications see https://docs.epsilon3.io/#notifications-api
"""

async def notifications_response(request):
    response = { 'received': False }

    if (request['subtype'] == 'run_ended'):
        print('Run ended notification received:', request)
        response = { 'received': True }
    elif (request['subtype'] == 'remaining_step_operators'):
        print('Remaining step operators signoff notification received:', request)
        response = { 'received': True }
    elif (request['subtype'] == 'reviewers'):
        print('Role/User required for review notification received:', request)
        response = { 'received': True }
    elif (request['subtype'] == 'automation'):
        print('Automated procedure paused notification received:', request)
        response = { 'received': True }
    else:
        print('Notification received:', request)
        response = { 'received': True }

    return response
