# Overview

Sample Webhook Epsilon3 API client for realtime data exchange.
This client provides integrations for the following modules:

- Commanding
- External Data
- Notifications
- Telemetry

For more information, see individual modules under the `src` directory
and our API documentation at https://docs.epsilon3.io/.

## Dependencies

- Python 3.8
- Pipenv (recommended)
- Flask (required to run the webhooks server)

This example uses Pipenv to manage dependencies, however, you can
manage them using a different dependency manager of your choosing. If needed, see
the following references for installing and configuring Pyenv and Pipenv:

- Pyenv [https://github.com/pyenv/pyenv]
- Pipenv [https://pipenv.pypa.io/en/latest/]

## Environment variables

Add your webhook key as an environment variable
```
export EPSILON3_WEBHOOK_KEY=your_webhook_key
```

(Optional) If you are in the United Kingdom instance you will also need to set the correct URL
```
export EPSILON3_API_URL='https://api.uk.epsilon3.io'
```

## Running

Install project dependencies
```
pipenv install
```

Activate the project's python environment
```
pipenv shell
```

Run the application
```
flask aiorun
```

Now that the application is up and running, check out our API docs (https://docs.epsilon3.io/) for more
information on how to create telemetry, commanding, and external-data to interact with it.
