import json
import hmac
import hashlib

# Returns true if webhook signature is valid, false otherwise.
def verify_webhook_signature(key, body, signature):
    t, v1 = _parse_signature(signature)
    hmac_computed = _generate_hmac_signature(body, t, key)
    return v1 == hmac_computed

def _parse_signature(signature):
    kv_strings = signature.split(',')
    t, v1 = [s.split('=')[1] for s in kv_strings]
    return t, v1

def _generate_hmac_signature(body, timestamp, key):
    body_str = json.dumps(body, separators=(',', ':'))
    payload = timestamp + '.' + body_str
    hmac_obj = hmac.new(key.encode(), payload.encode(), hashlib.sha256)
    return hmac_obj.hexdigest()
