/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.google.common.io.Closeables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class StreamUtil {
    private static final int BUFFER_SIZE = 16384;

    public static void copyStreams(InputStream inStream, OutputStream outStream) throws IOException {
        byte[] buf = new byte[16384];
        int size = -1;
        while ((size = inStream.read(buf)) != -1) {
            outStream.write(buf, 0, size);
        }
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    public static void drainAndClose(Reader reader) {
        try {
            while (reader.read() >= 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Closeables.closeQuietly((Reader)reader);
    }
}

