/*
 * Decompiled with CFR 0.152.
 */
package com.android.helper.aoa;

import java.util.Objects;
import java.util.Set;

public class AoaKey {
    static final AoaKey NOOP = new AoaKey(0, new Modifier[0]);
    private final int mUsage;
    private final Set<Modifier> mModifiers;

    public AoaKey(int usage, Modifier ... modifiers) {
        this.mUsage = usage;
        this.mModifiers = Set.of(modifiers);
    }

    byte[] toHidData() {
        int modifier = this.mModifiers.stream().map(m -> m.mValue).reduce(0, (a, b) -> a | b);
        return new byte[]{(byte)modifier, (byte)this.mUsage};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AoaKey)) {
            return false;
        }
        AoaKey key = (AoaKey)object;
        return this.mUsage == key.mUsage && Objects.equals(this.mModifiers, key.mModifiers);
    }

    public int hashCode() {
        return Objects.hash(this.mUsage, this.mModifiers);
    }

    public String toString() {
        return String.format("AoaKey{%d, %s}", this.mUsage, this.mModifiers);
    }

    public static enum Modifier {
        CTRL(1),
        SHIFT(2),
        ALT(4),
        GUI(8);

        private final int mValue;

        private Modifier(int value) {
            this.mValue = value;
        }
    }
}

