/*
 * Decompiled with CFR 0.152.
 */
package com.android.helper.aoa;

import com.android.helper.aoa.IUsbNative;
import com.android.helper.aoa.UsbHelper;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UsbDevice
implements AutoCloseable {
    private final UsbHelper mHelper;
    private final IUsbNative mUsb;
    private final byte[] mDescriptor = new byte[18];
    private Pointer mHandle;

    UsbDevice(@Nonnull UsbHelper helper, @Nonnull Pointer devicePointer) {
        this.mHelper = helper;
        this.mUsb = helper.getUsb();
        this.mUsb.libusb_get_device_descriptor(devicePointer, this.mDescriptor);
        PointerByReference handle = new PointerByReference();
        this.mUsb.libusb_open(devicePointer, handle);
        this.mHandle = handle.getValue();
    }

    public int controlTransfer(byte requestType, byte request, int value, int index, byte[] data) {
        int timeout = (int)this.mHelper.getTransferTimeout().toMillis();
        return this.controlTransfer(requestType, request, value, index, data, timeout);
    }

    public int controlTransfer(byte requestType, byte request, int value, int index, byte[] data, int timeout) {
        return this.mUsb.libusb_control_transfer(Preconditions.checkNotNull(this.mHandle), requestType, request, (short)value, (short)index, data, (short)data.length, timeout);
    }

    public int reset() {
        return this.mUsb.libusb_reset_device(Preconditions.checkNotNull(this.mHandle));
    }

    public boolean isValid() {
        return this.mHandle != null;
    }

    @Nullable
    public String getSerialNumber() {
        if (!this.isValid() || this.mDescriptor[16] <= 0) {
            return null;
        }
        byte[] data = new byte[64];
        int length = this.mUsb.libusb_get_string_descriptor_ascii(this.mHandle, this.mDescriptor[16], data, 64);
        return length > 0 ? new String(data, 0, length) : null;
    }

    public int getVendorId() {
        return Shorts.fromBytes(this.mDescriptor[9], this.mDescriptor[8]);
    }

    public int getProductId() {
        return Shorts.fromBytes(this.mDescriptor[11], this.mDescriptor[10]);
    }

    public boolean isAoaCompatible() {
        return this.isValid() && this.controlTransfer((byte)-64, (byte)51, 0, 0, new byte[2]) >= 2;
    }

    @Override
    public void close() {
        if (this.isValid()) {
            this.mUsb.libusb_close(this.mHandle);
            this.mHandle = null;
        }
    }
}

