/*
 * Decompiled with CFR 0.152.
 */
package com.android.helper.aoa;

import com.android.helper.aoa.AoaDevice;
import com.android.helper.aoa.IUsbNative;
import com.android.helper.aoa.UsbDevice;
import com.android.helper.aoa.UsbException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UsbHelper
implements AutoCloseable {
    private static final Duration POLL_INTERVAL = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_TRANSFER_TIMEOUT = Duration.ofSeconds(10L);
    private final IUsbNative mUsb;
    private Pointer mContext;
    private Duration mTransferTimeout = DEFAULT_TRANSFER_TIMEOUT;

    public UsbHelper() {
        this((IUsbNative)Native.loadLibrary("usb-1.0", IUsbNative.class));
    }

    @VisibleForTesting
    UsbHelper(@Nonnull IUsbNative usb) {
        this.mUsb = usb;
        PointerByReference context = new PointerByReference();
        this.checkResult(this.mUsb.libusb_init(context));
        this.mContext = context.getValue();
    }

    IUsbNative getUsb() {
        return this.mUsb;
    }

    public Duration getTransferTimeout() {
        return this.mTransferTimeout;
    }

    public void setTransferTimeout(@Nonnull Duration transferTimeout) {
        this.mTransferTimeout = transferTimeout;
    }

    public int checkResult(int value) {
        if (value < 0) {
            throw new UsbException(this.mUsb.libusb_strerror(value), new Object[0]);
        }
        return value;
    }

    @Nonnull
    public Set<String> getSerialNumbers(boolean aoaOnly) {
        HashSet<String> serialNumbers = new HashSet<String>();
        try (DeviceList list2 = new DeviceList();){
            for (Pointer devicePointer : list2) {
                UsbDevice device = this.connect(devicePointer);
                try {
                    String serialNumber = device.getSerialNumber();
                    if (serialNumber == null || aoaOnly && !device.isAoaCompatible()) continue;
                    serialNumbers.add(serialNumber);
                }
                finally {
                    if (device == null) continue;
                    device.close();
                }
            }
        }
        return serialNumbers;
    }

    @Nullable
    public UsbDevice getDevice(@Nonnull String serialNumber) {
        try (DeviceList list2 = new DeviceList();){
            for (Pointer devicePointer : list2) {
                UsbDevice device = this.connect(devicePointer);
                if (serialNumber.equals(device.getSerialNumber())) {
                    UsbDevice usbDevice = device;
                    return usbDevice;
                }
                device.close();
            }
        }
        return null;
    }

    @Nullable
    public UsbDevice getDevice(@Nonnull String serialNumber, @Nonnull Duration timeout) {
        Instant start = Instant.now();
        UsbDevice device = this.getDevice(serialNumber);
        while (device == null && timeout.compareTo(Duration.between(start, Instant.now())) > 0) {
            Uninterruptibles.sleepUninterruptibly(POLL_INTERVAL.toNanos(), TimeUnit.NANOSECONDS);
            device = this.getDevice(serialNumber);
        }
        return device;
    }

    @VisibleForTesting
    UsbDevice connect(@Nonnull Pointer devicePointer) {
        return new UsbDevice(this, devicePointer);
    }

    @Nullable
    public AoaDevice getAoaDevice(@Nonnull String serialNumber) {
        return this.getAoaDevice(serialNumber, Duration.ZERO);
    }

    @Nullable
    public AoaDevice getAoaDevice(@Nonnull String serialNumber, @Nonnull Duration timeout) {
        UsbDevice device = this.getDevice(serialNumber, timeout);
        return device != null && device.isAoaCompatible() ? new AoaDevice(this, device) : null;
    }

    @Override
    public void close() {
        if (this.mContext != null) {
            this.mUsb.libusb_exit(this.mContext);
            this.mContext = null;
        }
    }

    private class DeviceList
    implements Iterable<Pointer>,
    AutoCloseable {
        private final Pointer list;
        private final int count;

        private DeviceList() {
            PointerByReference list2 = new PointerByReference();
            this.count = UsbHelper.this.checkResult(UsbHelper.this.mUsb.libusb_get_device_list(Preconditions.checkNotNull(UsbHelper.this.mContext), list2));
            this.list = list2.getValue();
        }

        @Override
        @Nonnull
        public Iterator<Pointer> iterator() {
            Pointer[] devices = this.list.getPointerArray(0L, this.count);
            return Arrays.stream(devices).iterator();
        }

        @Override
        public void close() {
            UsbHelper.this.mUsb.libusb_free_device_list(this.list, true);
        }
    }
}

