/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.google.common.base.Splitter;
import java.util.List;

public abstract class AndroidTargetHash {
    public static final String PLATFORM_HASH_PREFIX = "android-";

    public static String getPlatformHashString(AndroidVersion version) {
        return PLATFORM_HASH_PREFIX + version.getApiString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AndroidVersion getPlatformVersion(String hashString) {
        if (hashString.startsWith(PLATFORM_HASH_PREFIX)) {
            String suffix = hashString.substring(PLATFORM_HASH_PREFIX.length());
            if (suffix.isEmpty()) return null;
            if (!Character.isDigit(suffix.charAt(0))) {
                int apiFeatureLevel = SdkVersionInfo.getApiByPreviewName(suffix, true);
                int apiLevel = apiFeatureLevel - 1;
                if (apiLevel >= 1) return new AndroidVersion(apiLevel, suffix);
                apiLevel = 1;
                return new AndroidVersion(apiLevel, suffix);
            }
            try {
                int api = Integer.parseInt(suffix);
                return new AndroidVersion(api, null);
            }
            catch (NumberFormatException api) {
                return null;
            }
        }
        if (hashString.isEmpty()) return null;
        if (!Character.isDigit(hashString.charAt(0))) return null;
        try {
            int api = Integer.parseInt(hashString);
            return new AndroidVersion(api, null);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static AndroidVersion getAddOnVersion(String hashString) {
        List<String> parts = Splitter.on(':').splitToList(hashString);
        if (parts.size() != 3) {
            return null;
        }
        String apiLevelPart = parts.get(2);
        try {
            int apiLevel = Integer.parseInt(apiLevelPart);
            return new AndroidVersion(apiLevel, null);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static AndroidVersion getVersionFromHash(String hashString) {
        if (AndroidTargetHash.isPlatform(hashString)) {
            return AndroidTargetHash.getPlatformVersion(hashString);
        }
        return AndroidTargetHash.getAddOnVersion(hashString);
    }

    public static String getAddonHashString(String addonVendorDisplay, String addonNameDisplay, AndroidVersion version) {
        return addonVendorDisplay + ":" + addonNameDisplay + ":" + version.getApiString();
    }

    public static String getTargetHashString(IAndroidTarget target) {
        if (target.isPlatform()) {
            return AndroidTargetHash.getPlatformHashString(target.getVersion());
        }
        return AndroidTargetHash.getAddonHashString(target.getVendor(), target.getName(), target.getVersion());
    }

    public static boolean isPlatform(String hashString) {
        return hashString.startsWith(PLATFORM_HASH_PREFIX);
    }
}

