/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import com.android.io.StreamException;
import com.android.repository.io.FileOp;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileOpFileWrapper
implements IAbstractFile,
IAbstractFolder {
    private final FileOp mFileOp;
    private final File mFile;
    private final boolean mIsFolder;

    public FileOpFileWrapper(File file2, FileOp fop, boolean isFolder) {
        this.mFile = file2;
        this.mFileOp = fop;
        this.mIsFolder = isFolder;
    }

    @Override
    public InputStream getContents() throws StreamException {
        try {
            return this.mFileOp.newFileInputStream(this.mFile);
        }
        catch (IOException e) {
            throw new StreamException(e, this);
        }
    }

    @Override
    public void setContents(InputStream source) throws StreamException {
        OutputStream fos = null;
        try {
            fos = this.mFileOp.newFileOutputStream(this.mFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new StreamException(e, this);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new StreamException(e, this);
                }
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws StreamException {
        try {
            return this.mFileOp.newFileOutputStream(this.mFile);
        }
        catch (IOException ex) {
            throw new StreamException(ex, this);
        }
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        return IAbstractFile.PreferredWriteMode.OUTPUTSTREAM;
    }

    public long getModificationStamp() {
        return this.mFile.lastModified();
    }

    public String getName() {
        return this.mFile.getName();
    }

    @Override
    public String getOsLocation() {
        return this.mFile.getAbsolutePath();
    }

    public String getPath() {
        return this.mFile.getPath();
    }

    @Override
    public boolean exists() {
        return this.mIsFolder ? this.mFileOp.isDirectory(this.mFile) : this.mFileOp.isFile(this.mFile);
    }

    public IAbstractFolder getParentFolder() {
        return new FileOpFileWrapper(this.mFile.getParentFile(), this.mFileOp, true);
    }

    public boolean delete() {
        return this.mFileOp.delete(this.mFile);
    }

    public boolean hasFile(String name) {
        return false;
    }

    @Override
    public IAbstractFile getFile(String name) {
        return new FileOpFileWrapper(new File(this.mFile, name), this.mFileOp, false);
    }

    public IAbstractFolder getFolder(String name) {
        return new FileOpFileWrapper(new File(this.mFile, name), this.mFileOp, true);
    }

    public IAbstractResource[] listMembers() {
        File[] files = this.mFileOp.listFiles(this.mFile);
        int count = files.length;
        IAbstractResource[] afiles = new IAbstractResource[count];
        for (int i = 0; i < count; ++i) {
            File f = files[i];
            afiles[i] = new FileOpFileWrapper(f, this.mFileOp, f.isDirectory());
        }
        return afiles;
    }

    public String[] list(final IAbstractFolder.FilenameFilter filter) {
        return this.mFileOp.list(this.mFile, new FilenameFilter(){

            @Override
            public boolean accept(File file2, String s) {
                return filter.accept(new FileOpFileWrapper(file2, FileOpFileWrapper.this.mFileOp, true), s);
            }
        });
    }
}

