/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.testframework.MockFileOp;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.FileOpFileWrapper;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AvdManager {
    private File mBaseAvdFolder;
    private static final Pattern INI_LINE_PATTERN = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INI_ENCODING = "avd.ini.encoding";
    public static final String AVD_INFO_ABS_PATH = "path";
    public static final String AVD_INFO_REL_PATH = "path.rel";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_TAG_ID = "tag.id";
    public static final String AVD_INI_TAG_DISPLAY = "tag.display";
    public static final String AVD_INI_ABI_TYPE = "abi.type";
    public static final String AVD_INI_AVD_ID = "AvdId";
    public static final String AVD_INI_PLAYSTORE_ENABLED = "PlayStore.enabled";
    public static final String AVD_INI_CPU_ARCH = "hw.cpu.arch";
    public static final String AVD_INI_CPU_MODEL = "hw.cpu.model";
    public static final String AVD_INI_CPU_CORES = "hw.cpu.ncore";
    public static final String AVD_INI_DEVICE_MANUFACTURER = "hw.device.manufacturer";
    public static final String AVD_INI_DEVICE_NAME = "hw.device.name";
    public static final String AVD_INI_ARC = "hw.arc";
    public static final String AVD_INI_DISPLAY_NAME = "avd.ini.displayname";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_BACKUP_SKIN_PATH = "skin.path.backup";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SKIN_DYNAMIC = "skin.dynamic";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final String AVD_INI_SNAPSHOT_PRESENT = "snapshot.present";
    public static final String AVD_INI_GPU_EMULATION = "hw.gpu.enabled";
    public static final String AVD_INI_GPU_MODE = "hw.gpu.mode";
    public static final String AVD_INI_FORCE_COLD_BOOT_MODE = "fastboot.forceColdBoot";
    public static final String AVD_INI_FORCE_CHOSEN_SNAPSHOT_BOOT_MODE = "fastboot.forceChosenSnapshotBoot";
    public static final String AVD_INI_FORCE_FAST_BOOT_MODE = "fastboot.forceFastBoot";
    public static final String AVD_INI_CHOSEN_SNAPSHOT_FILE = "fastboot.chosenSnapshotFile";
    public static final String AVD_INI_COLD_BOOT_ONCE = "once";
    public static final String AVD_INI_CAMERA_FRONT = "hw.camera.front";
    public static final String AVD_INI_CAMERA_BACK = "hw.camera.back";
    public static final String AVD_INI_RAM_SIZE = "hw.ramSize";
    public static final String AVD_INI_VM_HEAP_SIZE = "vm.heapSize";
    public static final String AVD_INI_DATA_PARTITION_SIZE = "disk.dataPartition.size";
    public static final String AVD_INI_DEVICE_HASH_V1 = "hw.device.hash";
    public static final String AVD_INI_DEVICE_HASH_V2 = "hw.device.hash2";
    public static final String AVD_INI_ANDROID_API = "image.androidVersion.api";
    public static final String AVD_INI_ANDROID_CODENAME = "image.androidVersion.codename";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    public static final String DATA_FOLDER = "data";
    public static final String USERDATA_IMG = "userdata.img";
    public static final String USERDATA_QEMU_IMG = "userdata-qemu.img";
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    private static final String BOOT_PROP = "boot.prop";
    static final String CONFIG_INI = "config.ini";
    private static final String HARDWARE_QEMU_INI = "hardware-qemu.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    private static final String SNAPSHOTS_IMG = "snapshots.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    private static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;
    public static final int SDCARD_SIZE_NOT_IN_RANGE = 0;
    public static final int SDCARD_SIZE_INVALID = -1;
    public static final int SDCARD_NOT_SIZE_PATTERN = -2;
    public static final String HARDWARE_INI = "hardware.ini";
    private static final Table<String, FileOp, WeakReference<AvdManager>> mManagers = HashBasedTable.create();
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final AndroidSdkHandler mSdkHandler;
    private final Map<ILogger, DeviceManager> mDeviceManagers = new HashMap<ILogger, DeviceManager>();
    private final FileOp mFop;

    protected AvdManager(AndroidSdkHandler sdkHandler, File baseAvdFolder, ILogger log, FileOp fop) throws AndroidLocation.AndroidLocationException {
        this.mSdkHandler = sdkHandler;
        this.mFop = fop;
        this.mBaseAvdFolder = baseAvdFolder;
        this.buildAvdList(this.mAllAvdList, log);
    }

    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, ILogger log) throws AndroidLocation.AndroidLocationException {
        return AvdManager.getInstance(sdkHandler, new File(AndroidLocation.getAvdFolder()), log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, File baseAvdFolder, ILogger log) throws AndroidLocation.AndroidLocationException {
        if (sdkHandler.getLocation() == null) {
            throw new AndroidLocation.AndroidLocationException("Local SDK path not set!");
        }
        Table<String, FileOp, WeakReference<AvdManager>> table = mManagers;
        synchronized (table) {
            AvdManager manager;
            FileOp fop = sdkHandler.getFileOp();
            WeakReference<AvdManager> ref = mManagers.get(sdkHandler.getLocation().getPath(), fop);
            if (ref != null && (manager = (AvdManager)ref.get()) != null) {
                return manager;
            }
            try {
                manager = new AvdManager(sdkHandler, baseAvdFolder, log, fop);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw e;
            }
            catch (Exception e) {
                log.warning("Exception during AvdManager initialization: %1$s", e);
                return null;
            }
            mManagers.put(sdkHandler.getLocation().getPath(), fop, new WeakReference<AvdManager>(manager));
            return manager;
        }
    }

    public File getBaseAvdFolder() throws AndroidLocation.AndroidLocationException {
        return this.mBaseAvdFolder;
    }

    public static long parseSdcardSize(String sdcard, String[] parsedStrings) {
        Matcher m;
        if (parsedStrings != null) {
            assert (parsedStrings.length == 2);
            parsedStrings[0] = null;
            parsedStrings[1] = null;
        }
        if ((m = SDCARD_SIZE_PATTERN.matcher(sdcard)).matches()) {
            if (parsedStrings != null) {
                assert (parsedStrings.length == 2);
                parsedStrings[0] = m.group(1);
                parsedStrings[1] = m.group(2);
            }
            try {
                long sdcardSize = Long.parseLong(m.group(1));
                String sdcardSizeModifier = m.group(2);
                if ("K".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 10;
                } else if ("M".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 20;
                } else if ("G".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 30;
                }
                if (sdcardSize < 0x900000L || sdcardSize > 0xFFC0000000L) {
                    return 0L;
                }
                return sdcardSize;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> list2 = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    list2.add(avd);
                }
                this.mValidAvdList = list2.toArray(new AvdInfo[0]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public boolean isAvdRunning(AvdInfo info, ILogger logger) {
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException e) {
            logger.error(e, "IOException while getting PID", new Object[0]);
            return true;
        }
        if (pid != null) {
            String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
            try {
                Process p = Runtime.getRuntime().exec(command);
                return p.waitFor() == 0;
            }
            catch (IOException e) {
                logger.warning("Got IOException while checking running processes:\n%s", Arrays.toString(e.getStackTrace()));
                return true;
            }
            catch (InterruptedException e) {
                logger.warning("Got InterruptedException while checking running processes:\n%s", Arrays.toString(e.getStackTrace()));
                return true;
            }
        }
        return false;
    }

    public void logRunningAvdInfo(AvdInfo info, ILogger logger) {
        int numTermChars;
        String command;
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException ex) {
            logger.error(ex, "AVD not launched but got IOException while getting PID", new Object[0]);
            return;
        }
        if (pid == null) {
            logger.warning("AVD not launched but PID is null. Should not have indicated that the AVD is running.", new Object[0]);
            return;
        }
        logger.warning("AVD not launched because an instance appears to be running on PID " + pid, new Object[0]);
        if (SdkConstants.currentPlatform() == 2) {
            command = "cmd /c \"tasklist /FI \"PID eq " + pid + "\" /FO csv /V /NH\"";
            numTermChars = 2;
        } else {
            command = "ps -o pid= -o user= -o pcpu= -o tty= -o stat= -o time= -o etime= -o cmd= -p " + pid;
            numTermChars = 1;
        }
        try {
            Process proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                logger.warning("Could not get info for that AVD process", new Object[0]);
            } else {
                InputStream procInfoStream = proc.getInputStream();
                int strMax = 256;
                byte[] procInfo = new byte[256];
                int nRead = procInfoStream.read(procInfo, 0, 256);
                if (nRead <= numTermChars) {
                    logger.warning("Info for that AVD process is null", new Object[0]);
                } else {
                    logger.warning("AVD process info: [" + new String(procInfo, 0, nRead - numTermChars) + "]", new Object[0]);
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.warning("Got exception when getting info on that AVD process:\n%s", Arrays.toString(ex.getStackTrace()));
        }
    }

    public void stopAvd(AvdInfo info) {
        try {
            String pid = this.getAvdPid(info);
            if (pid != null) {
                String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"taskkill /PID " + pid + "\"" : "kill " + pid;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAvdPid(AvdInfo info) throws IOException {
        File f = new File(info.getDataFolderPath(), "hardware-qemu.ini.lock");
        if (SdkConstants.currentPlatform() == 2) {
            f = new File(f, "pid");
        }
        File alternative = new File(info.getDataFolderPath(), "userdata-qemu.img.lock");
        if (SdkConstants.currentPlatform() == 2) {
            alternative = new File(alternative, "pid");
        }
        if (this.mFop.exists(f)) {
            return this.mFop.toString(f, Charsets.UTF_8).trim();
        }
        if (this.mFop.exists(alternative)) {
            return this.mFop.toString(alternative, Charsets.UTF_8).trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAvds(ILogger log) throws AndroidLocation.AndroidLocationException {
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList, log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo reloadAvd(AvdInfo avdInfo, ILogger log) throws AndroidLocation.AndroidLocationException {
        AvdInfo newInfo = this.parseAvdInfo(avdInfo.getIniFile(), log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            int index = this.mAllAvdList.indexOf(avdInfo);
            if (index >= 0) {
                this.replaceAvd(avdInfo, newInfo);
            }
        }
        return newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AvdInfo createAvd(File avdFolder, String avdName, ISystemImage systemImage, File skinFolder, String skinName, String sdcard, Map<String, String> hardwareConfig, Map<String, String> bootProps, boolean deviceHasPlayStore, boolean createSnapshot, boolean removePrevious, boolean editExisting, ILogger log) {
        block38: {
            block37: {
                block35: {
                    block36: {
                        block40: {
                            block39: {
                                if (log == null) {
                                    throw new IllegalArgumentException("log cannot be null");
                                }
                                iniFile = null;
                                needCleanup = false;
                                newAvdInfo = null;
                                configValues = new HashMap<String, String>();
                                if (this.mFop.exists(avdFolder)) break block39;
                                this.mFop.mkdirs(avdFolder);
                                AvdManager.inhibitCopyOnWrite(avdFolder, log);
                                editExisting = false;
                                ** GOTO lbl51
                            }
                            if (!removePrevious) break block40;
                            try {
                                this.deleteContentOf(avdFolder);
                                AvdManager.inhibitCopyOnWrite(avdFolder, log);
                            }
                            catch (SecurityException e) {
                                log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                            }
                            ** GOTO lbl51
                        }
                        if (editExisting) ** GOTO lbl51
                        oldAvdFolderPath = avdFolder.getAbsolutePath();
                        newAvdInfo = this.duplicateAvd(avdFolder, avdName, systemImage, log);
                        if (newAvdInfo != null) break block35;
                        var19_24 = null;
                        if (!needCleanup) break block36;
                        if (iniFile != null && this.mFop.exists(iniFile)) {
                            this.mFop.delete(iniFile);
                        }
                        try {
                            this.deleteContentOf(avdFolder);
                            this.mFop.delete(avdFolder);
                        }
                        catch (SecurityException e) {
                            log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                        }
                    }
                    return var19_24;
                }
                avdFolder = new File(newAvdInfo.getDataFolderPath());
                configValues.putAll(newAvdInfo.getProperties());
                if (hardwareConfig != null && (oldSdCardPath = hardwareConfig.get("sdcard.path")) != null && oldSdCardPath.startsWith(oldAvdFolderPath)) {
                    hardwareConfig.put("sdcard.path", oldSdCardPath.replace(oldAvdFolderPath, newAvdInfo.getDataFolderPath()));
                }
lbl51:
                // 7 sources

                iniFile = this.createAvdIniFile(avdName, avdFolder, removePrevious, systemImage.getAndroidVersion());
                needCleanup = true;
                this.createAvdUserdata(systemImage, avdFolder, log);
                this.createAvdConfigFile(systemImage, configValues, log);
                this.createAvdSnapshot(createSnapshot, editExisting, configValues, avdFolder, log);
                tag = systemImage.getTag();
                configValues.put("tag.id", tag.getId());
                configValues.put("tag.display", tag.getDisplay());
                configValues.put("abi.type", systemImage.getAbiType());
                configValues.put("PlayStore.enabled", Boolean.toString(deviceHasPlayStore != false && systemImage.hasPlayStore() != false));
                configValues.put("hw.arc", Boolean.toString(SystemImage.CHROMEOS_TAG.equals(tag)));
                this.createAvdSkin(skinFolder, skinName, configValues, log);
                this.createAvdSdCard(sdcard, editExisting, configValues, avdFolder, log);
                if (hardwareConfig == null) {
                    hardwareConfig = new HashMap<String, String>();
                }
                this.writeCpuArch(systemImage, hardwareConfig, log);
                this.addHardwareConfig(systemImage, skinFolder, avdFolder, hardwareConfig, configValues, log);
                if (bootProps != null && !bootProps.isEmpty()) {
                    bootPropsFile = new File(avdFolder, "boot.prop");
                    this.writeIniFile(bootPropsFile, bootProps, false);
                }
                oldAvdInfo = this.getAvd(avdName, false);
                if (newAvdInfo == null) {
                    newAvdInfo = this.createAvdInfoObject(systemImage, avdName, removePrevious, editExisting, iniFile, avdFolder, oldAvdInfo, configValues);
                }
                if ((removePrevious || editExisting) && oldAvdInfo != null && !oldAvdInfo.getDataFolderPath().equals(newAvdInfo.getDataFolderPath())) {
                    log.warning("Removing previous AVD directory at %s", new Object[]{oldAvdInfo.getDataFolderPath()});
                    dir = new File(oldAvdInfo.getDataFolderPath());
                    try {
                        this.deleteContentOf(dir);
                        this.mFop.delete(dir);
                    }
                    catch (SecurityException e) {
                        log.warning("Failed to delete %1$s: %2$s", new Object[]{dir.getAbsolutePath(), e});
                    }
                }
                needCleanup = false;
                var20_27 = newAvdInfo;
                if (!needCleanup) break block37;
                if (iniFile != null && this.mFop.exists(iniFile)) {
                    this.mFop.delete(iniFile);
                }
                try {
                    this.deleteContentOf(avdFolder);
                    this.mFop.delete(avdFolder);
                }
                catch (SecurityException e) {
                    log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                }
            }
            return var20_27;
            catch (AvdMgrException newAvdInfo) {
                if (needCleanup) {
                    if (iniFile != null && this.mFop.exists(iniFile)) {
                        this.mFop.delete(iniFile);
                    }
                    try {
                        this.deleteContentOf(avdFolder);
                        this.mFop.delete(avdFolder);
                    }
                    catch (SecurityException e) {
                        log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                    }
                }
                break block38;
            }
            catch (AndroidLocation.AndroidLocationException | IOException | SecurityException e) {
                log.warning("%1$s", new Object[]{e});
                ** if (!needCleanup) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (iniFile != null && this.mFop.exists(iniFile)) {
                        this.mFop.delete(iniFile);
                    }
                    try {
                        this.deleteContentOf(avdFolder);
                        this.mFop.delete(avdFolder);
                    }
                    catch (SecurityException e) {
                        log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
                {
                    catch (Throwable var22_30) {
                        if (needCleanup) {
                            if (iniFile != null && this.mFop.exists(iniFile)) {
                                this.mFop.delete(iniFile);
                            }
                            try {
                                this.deleteContentOf(avdFolder);
                                this.mFop.delete(avdFolder);
                            }
                            catch (SecurityException e) {
                                log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.getAbsolutePath(), e});
                            }
                        }
                        throw var22_30;
                    }
                }
            }
        }
        return null;
    }

    private AvdInfo duplicateAvd(File origAvd, String newAvdName, ISystemImage systemImage, ILogger log) {
        try {
            File destAvdFolder = new File(origAvd.getParent(), newAvdName + AVD_FOLDER_EXTENSION);
            AvdManager.inhibitCopyOnWrite(destAvdFolder, log);
            ConsoleProgressIndicator progInd = new ConsoleProgressIndicator();
            progInd.setText("Copying files");
            progInd.setIndeterminate(true);
            FileOpUtils.recursiveCopy((File)origAvd, (File)destAvdFolder, (FileOp)this.mFop, (ProgressIndicator)progInd);
            File configIni = new File(destAvdFolder, CONFIG_INI);
            Map<String, String> configVals = AvdManager.parseIniFile(new FileOpFileWrapper(configIni, this.mFop, false), log);
            configVals.put(AVD_INI_AVD_ID, newAvdName);
            configVals.put(AVD_INI_DISPLAY_NAME, newAvdName);
            this.writeIniFile(configIni, configVals, true);
            String origAvdName = origAvd.getName().replace(AVD_FOLDER_EXTENSION, "");
            String origAvdPath = origAvd.getAbsolutePath();
            String newAvdPath = destAvdFolder.getAbsolutePath();
            configVals = this.updateNameAndIniPaths(configIni, origAvdName, origAvdPath, newAvdName, newAvdPath, log);
            File hwQemu = new File(destAvdFolder, HARDWARE_QEMU_INI);
            this.updateNameAndIniPaths(hwQemu, origAvdName, origAvdPath, newAvdName, newAvdPath, log);
            File iniFile = this.createAvdIniFile(newAvdName, destAvdFolder, false, systemImage.getAndroidVersion());
            return new AvdInfo(newAvdName, iniFile, destAvdFolder.getAbsolutePath(), systemImage, configVals);
        }
        catch (AndroidLocation.AndroidLocationException | IOException e) {
            log.warning("Exception while duplicating an AVD: %1$s", e);
            return null;
        }
    }

    private Map<String, String> updateNameAndIniPaths(File iniFile, String oldName, String oldPath, String newName, String newPath, ILogger log) throws IOException {
        Map<String, String> iniVals = AvdManager.parseIniFile(new FileOpFileWrapper(iniFile, this.mFop, false), log);
        if (iniVals != null) {
            for (Map.Entry<String, String> iniEntry : iniVals.entrySet()) {
                String origIniValue = iniEntry.getValue();
                if (origIniValue.equals(oldName)) {
                    iniVals.put(iniEntry.getKey(), newName);
                }
                if (!origIniValue.startsWith(oldPath)) continue;
                String newIniValue = origIniValue.replace(oldPath, newPath);
                iniVals.put(iniEntry.getKey(), newIniValue);
            }
            this.writeIniFile(iniFile, iniVals, true);
        }
        return iniVals;
    }

    private String getImageRelativePath(ISystemImage systemImage) throws InvalidTargetPathException {
        String[] list2;
        String sdkLocation;
        File folder = systemImage.getLocation();
        String imageFullPath = folder.getAbsolutePath();
        if (!imageFullPath.startsWith(sdkLocation = this.mSdkHandler.getLocation().getAbsolutePath())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        if (this.mFop.isDirectory(folder) && (list2 = this.mFop.list(folder, (dir, name) -> IMAGE_NAME_PATTERN.matcher(name).matches())).length > 0) {
            if ((imageFullPath = imageFullPath.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
                imageFullPath = imageFullPath.substring(1);
            }
            if (!imageFullPath.endsWith(File.separator)) {
                imageFullPath = imageFullPath + File.separator;
            }
            return imageFullPath;
        }
        return null;
    }

    private File createAvdIniFile(String name, File avdFolder, boolean removePrevious, AndroidVersion version) throws AndroidLocation.AndroidLocationException, IOException {
        File iniFile = AvdInfo.getDefaultIniFile(this, name);
        if (removePrevious) {
            if (this.mFop.isFile(iniFile)) {
                this.mFop.delete(iniFile);
            } else if (this.mFop.isDirectory(iniFile)) {
                this.deleteContentOf(iniFile);
                this.mFop.delete(iniFile);
            }
        }
        String absPath = avdFolder.getAbsolutePath();
        String relPath = null;
        File androidFolder = this.mSdkHandler.getAndroidFolder();
        if (androidFolder == null) {
            throw new AndroidLocation.AndroidLocationException("Can't locate Android SDK installation directory for the AVD .ini file.");
        }
        String androidPath = androidFolder.getAbsolutePath() + File.separator;
        if (absPath.startsWith(androidPath)) {
            assert (androidPath.endsWith(File.separator));
            relPath = absPath.substring(androidPath.length());
        }
        HashMap<String, String> values2 = new HashMap<String, String>();
        if (relPath != null) {
            values2.put(AVD_INFO_REL_PATH, relPath);
        }
        values2.put(AVD_INFO_ABS_PATH, absPath);
        values2.put(AVD_INFO_TARGET, AndroidTargetHash.getPlatformHashString(version));
        this.writeIniFile(iniFile, values2, true);
        return iniFile;
    }

    private File createAvdIniFile(AvdInfo info) throws AndroidLocation.AndroidLocationException, IOException {
        return this.createAvdIniFile(info.getName(), new File(info.getDataFolderPath()), false, info.getAndroidVersion());
    }

    public boolean deleteAvd(AvdInfo avdInfo, ILogger log) {
        try {
            String path;
            boolean error = false;
            File f = avdInfo.getIniFile();
            if (f != null && this.mFop.exists(f)) {
                log.info("Deleting file %1$s\n", f.getCanonicalPath());
                if (!this.mFop.delete(f)) {
                    log.warning("Failed to delete %1$s\n", f.getCanonicalPath());
                    error = true;
                }
            }
            if ((path = avdInfo.getDataFolderPath()) != null && this.mFop.exists(f = new File(path))) {
                log.info("Deleting folder %1$s\n", f.getCanonicalPath());
                if (!this.deleteContentOf(f) || !this.mFop.delete(f)) {
                    log.warning("Failed to delete %1$s\n", f.getCanonicalPath());
                    error = true;
                }
            }
            this.removeAvd(avdInfo);
            if (!error) {
                log.info("\nAVD '%1$s' deleted.\n", avdInfo.getName());
                return true;
            }
            log.info("\nAVD '%1$s' deleted with errors. See errors above.\n", avdInfo.getName());
        }
        catch (IOException | SecurityException e) {
            log.warning("%1$s", e);
        }
        return false;
    }

    public boolean moveAvd(AvdInfo avdInfo, String newName, String paramFolderPath, ILogger log) {
        try {
            if (paramFolderPath != null) {
                File f = new File(avdInfo.getDataFolderPath());
                log.info("Moving '%1$s' to '%2$s'.\n", avdInfo.getDataFolderPath(), paramFolderPath);
                if (!this.mFop.renameTo(f, new File(paramFolderPath))) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.\n", avdInfo.getDataFolderPath(), paramFolderPath);
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), paramFolderPath, avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newName != null) {
                File oldIniFile = avdInfo.getIniFile();
                File newIniFile = AvdInfo.getDefaultIniFile(this, newName);
                log.warning("Moving '%1$s' to '%2$s'.", oldIniFile.getPath(), newIniFile.getPath());
                if (!this.mFop.renameTo(oldIniFile, newIniFile)) {
                    log.warning(null, "Failed to move '%1$s' to '%2$s'.", oldIniFile.getPath(), newIniFile.getPath());
                    return false;
                }
                AvdInfo info = new AvdInfo(newName, avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
            }
            log.info("AVD '%1$s' moved.\n", avdInfo.getName());
        }
        catch (AndroidLocation.AndroidLocationException | IOException e) {
            log.warning("$1%s", e);
            return false;
        }
        return true;
    }

    private boolean deleteContentOf(File folder) throws SecurityException {
        File[] files = this.mFop.listFiles(folder);
        if (files != null) {
            for (File f : files) {
                if (this.mFop.isDirectory(f) && !this.deleteContentOf(f)) {
                    return false;
                }
                if (this.mFop.delete(f)) continue;
                return false;
            }
        }
        return true;
    }

    private File[] buildAvdFilesList() throws AndroidLocation.AndroidLocationException {
        if (this.mFop.isFile(this.mBaseAvdFolder)) {
            throw new AndroidLocation.AndroidLocationException(String.format("%1$s is not a valid folder.", this.mBaseAvdFolder.getAbsolutePath()));
        }
        if (!this.mFop.exists(this.mBaseAvdFolder)) {
            this.mFop.mkdirs(this.mBaseAvdFolder);
            return null;
        }
        File[] avds = this.mFop.listFiles(this.mBaseAvdFolder, (parent, name) -> {
            if (INI_NAME_PATTERN.matcher(name).matches()) {
                return this.mFop.isFile(new File(parent, name));
            }
            return false;
        });
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList, ILogger log) throws AndroidLocation.AndroidLocationException {
        File[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (File avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd, log);
                if (info == null || allList.contains(info)) continue;
                allList.add(info);
            }
        }
    }

    private DeviceManager getDeviceManager(ILogger logger) {
        DeviceManager manager = this.mDeviceManagers.get(logger);
        if (manager == null) {
            manager = DeviceManager.createInstance(this.mSdkHandler, logger);
            manager.registerListener(this.mDeviceManagers::clear);
            this.mDeviceManagers.put(logger, manager);
        }
        return manager;
    }

    @VisibleForTesting
    public AvdInfo parseAvdInfo(File iniPath, ILogger log) {
        String targetHash;
        AndroidVersion version;
        File androidFolder;
        File f;
        String relPath;
        Map<String, String> map = AvdManager.parseIniFile(new FileOpFileWrapper(iniPath, this.mFop, false), log);
        String avdPath = null;
        if (map != null && ((avdPath = map.get(AVD_INFO_ABS_PATH)) == null || !this.mFop.isDirectory(new File(avdPath))) && (relPath = map.get(AVD_INFO_REL_PATH)) != null && this.mFop.isDirectory(f = new File(androidFolder = this.mSdkHandler.getAndroidFolder(), relPath))) {
            avdPath = f.getAbsolutePath();
        }
        if (avdPath == null || !this.mFop.isDirectory(new File(avdPath))) {
            String avdName = iniPath.getName();
            if (avdName.endsWith(INI_EXTENSION)) {
                avdName = avdName.substring(0, avdName.length() - 4);
            }
            return new AvdInfo(avdName, iniPath, iniPath.getPath(), null, null, AvdInfo.AvdStatus.ERROR_CORRUPTED_INI);
        }
        FileOpFileWrapper configIniFile = null;
        Map<String, String> properties = null;
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(log){

            @Override
            public void logVerbose(String s) {
            }
        };
        if (avdPath != null) {
            configIniFile = new FileOpFileWrapper(new File(avdPath, CONFIG_INI), this.mFop, false);
        }
        if (configIniFile != null) {
            if (!configIniFile.exists()) {
                log.warning("Missing file '%1$s'.", configIniFile.getOsLocation());
            } else {
                properties = AvdManager.parseIniFile(configIniFile, log);
            }
        }
        String name = iniPath.getName();
        Matcher matcher = INI_NAME_PATTERN.matcher(iniPath.getName());
        if (matcher.matches()) {
            name = matcher.group(1);
        }
        boolean validImageSysdir = true;
        String imageSysDir = null;
        ISystemImage sysImage = null;
        if (properties != null && (imageSysDir = properties.get(AVD_INI_IMAGES_1)) != null) {
            sysImage = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(new File(this.mSdkHandler.getLocation(), imageSysDir));
        }
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get(AVD_INI_DEVICE_NAME);
            String deviceMfctr = properties.get(AVD_INI_DEVICE_MANUFACTURER);
            if (deviceName != null && deviceMfctr != null) {
                DeviceManager devMan = this.getDeviceManager(log);
                Device d = devMan.getDevice(deviceName, deviceMfctr);
                DeviceManager.DeviceStatus deviceStatus2 = deviceStatus = d == null ? DeviceManager.DeviceStatus.MISSING : DeviceManager.DeviceStatus.EXISTS;
                if (d != null) {
                    String hashV1;
                    updateHashV2 = true;
                    String hashV2 = properties.get(AVD_INI_DEVICE_HASH_V2);
                    if (hashV2 != null) {
                        String newHashV2 = DeviceManager.hasHardwarePropHashChanged(d, hashV2);
                        if (newHashV2 == null) {
                            updateHashV2 = false;
                        } else {
                            properties.put(AVD_INI_DEVICE_HASH_V2, newHashV2);
                        }
                    }
                    if ((hashV1 = properties.get(AVD_INI_DEVICE_HASH_V1)) != null) {
                        properties.remove(AVD_INI_DEVICE_HASH_V1);
                    }
                }
            }
        }
        AvdInfo.AvdStatus status = avdPath == null ? AvdInfo.AvdStatus.ERROR_PATH : (configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (properties == null || imageSysDir == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!validImageSysdir ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : (deviceStatus == DeviceManager.DeviceStatus.CHANGED ? AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : (sysImage == null ? AvdInfo.AvdStatus.ERROR_IMAGE_MISSING : AvdInfo.AvdStatus.OK))))));
        if (properties == null) {
            properties = Maps.newHashMap();
        }
        if (!properties.containsKey(AVD_INI_ANDROID_API) && !properties.containsKey(AVD_INI_ANDROID_CODENAME) && (version = AndroidTargetHash.getVersionFromHash(targetHash = map.get(AVD_INFO_TARGET))) != null) {
            properties.put(AVD_INI_ANDROID_API, Integer.toString(version.getApiLevel()));
            if (version.getCodename() != null) {
                properties.put(AVD_INI_ANDROID_CODENAME, version.getCodename());
            }
        }
        AvdInfo info = new AvdInfo(name, iniPath, avdPath, sysImage, properties, status);
        if (updateHashV2) {
            try {
                return this.updateDeviceChanged(info, log);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    private void writeIniFile(File iniFile, Map<String, String> values2, boolean addEncoding) throws IOException {
        Charset charset = Charsets.UTF_8;
        try (OutputStreamWriter writer = new OutputStreamWriter(this.mFop.newFileOutputStream(iniFile), charset);){
            if (addEncoding) {
                values2.put(AVD_INI_ENCODING, charset.name());
            }
            ArrayList<String> keys = new ArrayList<String>(values2.keySet());
            keys.remove(AVD_INI_ANDROID_API);
            keys.remove(AVD_INI_ANDROID_CODENAME);
            Collections.sort(keys);
            for (String key : keys) {
                String value = values2.get(key);
                if (value == null) continue;
                writer.write(String.format("%1$s=%2$s\n", key, value));
            }
        }
    }

    public static Map<String, String> parseIniFile(IAbstractFile propFile, ILogger log) {
        return AvdManager.parseIniFileImpl(propFile, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseIniFileImpl(IAbstractFile propFile, ILogger log, Charset charset) {
        reader = null;
        try {
            canChangeCharset = false;
            if (charset == null) {
                canChangeCharset = true;
                charset = Charsets.ISO_8859_1;
            }
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), charset));
            line = null;
            map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                block26: {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    m = AvdManager.INI_LINE_PATTERN.matcher(line);
                    if (!m.matches()) break block26;
                    key = m.group(1);
                    value = m.group(2);
                    if (canChangeCharset && "avd.ini.encoding".equals(key) && !charset.name().equals(value) && Charset.isSupported(value)) {
                        charset = Charset.forName(value);
                        var10_16 = AvdManager.parseIniFileImpl(propFile, log, charset);
                        ** try [egrp 1[TRYBLOCK] [0 : 170->178)] { 
lbl20:
                        // 1 sources

                    } else {
                        map.put(key, value);
                        continue;
                    }
                }
                if (log != null) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                }
                var8_12 = null;
                ** try [egrp 3[TRYBLOCK] [1 : 232->240)] { 
lbl29:
                // 1 sources

                ** GOTO lbl-1000
            }
            var7_11 = map;
            ** try [egrp 5[TRYBLOCK] [2 : 252->260)] { 
lbl32:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (FileNotFoundException canChangeCharset) {
            try {
                Closeables.close(reader, true);
                return null;
            }
            catch (IOException canChangeCharset) {
                return null;
            }
        }
        catch (StreamException | IOException e) {
            if (log == null) return null;
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
        }
        {
            Closeables.close(reader, true);
            return var10_16;
        }
lbl48:
        // 1 sources

        catch (IOException var11_17) {
            // empty catch block
        }
        return var10_16;
lbl-1000:
        // 1 sources

        {
            Closeables.close(reader, true);
            return var8_12;
        }
lbl53:
        // 1 sources

        catch (IOException var9_15) {
            // empty catch block
        }
        return var8_12;
lbl-1000:
        // 1 sources

        {
            Closeables.close(reader, true);
            return var7_11;
        }
lbl58:
        // 1 sources

        catch (IOException var8_13) {
            // empty catch block
        }
        return var7_11;
        finally {
            try {
                Closeables.close(reader, true);
            }
            catch (IOException var4_8) {}
        }
    }

    @VisibleForTesting
    protected boolean createSdCard(String toolLocation, String size, String location, ILogger log) {
        try {
            String[] command = new String[]{toolLocation, size, location};
            Process process = Runtime.getRuntime().exec(command);
            final ArrayList errorOutput = new ArrayList();
            final ArrayList stdOutput = new ArrayList();
            int status = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_READERS, new GrabProcessOutput.IProcessOutput(){

                @Override
                public void out(String line) {
                    if (line != null) {
                        stdOutput.add(line);
                    }
                }

                @Override
                public void err(String line) {
                    if (line != null) {
                        errorOutput.add(line);
                    }
                }
            });
            if (status == 0) {
                return true;
            }
            for (String error : errorOutput) {
                log.warning("%1$s", error);
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        log.warning("Failed to create the SD card.", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    public AvdInfo updateAvd(AvdInfo avd, Map<String, String> newProperties) throws IOException {
        File configIniFile = new File(avd.getDataFolderPath(), CONFIG_INI);
        this.writeIniFile(configIniFile, newProperties, true);
        AvdInfo newAvd = new AvdInfo(avd.getName(), avd.getIniFile(), avd.getDataFolderPath(), avd.getSystemImage(), newProperties);
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    public AvdInfo updateDeviceChanged(AvdInfo avd, ILogger log) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(avd.getProperties());
        DeviceManager devMan = this.getDeviceManager(log);
        Collection<Device> devices = devMan.getDevices(DeviceManager.ALL_DEVICES);
        String name = (String)properties.get(AVD_INI_DEVICE_NAME);
        String manufacturer = (String)properties.get(AVD_INI_DEVICE_MANUFACTURER);
        if (name != null && manufacturer != null) {
            for (Device d : devices) {
                if (!d.getId().equals(name) || !d.getManufacturer().equals(manufacturer)) continue;
                Map<String, String> deviceHwProperties = DeviceManager.getHardwareProperties(d);
                deviceHwProperties.remove(AVD_INI_RAM_SIZE);
                properties.putAll(deviceHwProperties);
                try {
                    return this.updateAvd(avd, properties);
                }
                catch (IOException e) {
                    log.warning("%1$s", e);
                }
            }
        } else {
            log.warning("Base device information incomplete or missing.", new Object[0]);
        }
        return null;
    }

    private boolean setImagePathProperties(ISystemImage image, Map<String, String> properties, ILogger log) {
        properties.remove(AVD_INI_IMAGES_1);
        properties.remove(AVD_INI_IMAGES_2);
        try {
            String property = AVD_INI_IMAGES_1;
            String imagePath = this.getImageRelativePath(image);
            if (imagePath != null) {
                properties.put(property, imagePath);
                return true;
            }
        }
        catch (InvalidTargetPathException e) {
            log.warning("%1$s", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    @Deprecated
    public AndroidSdkHandler getSdkHandler() {
        return this.mSdkHandler;
    }

    private void createAvdUserdata(ISystemImage systemImage, File avdFolder, ILogger log) throws IOException, AvdMgrException {
        File imageFolder = systemImage.getLocation();
        File userdataSrc = new File(imageFolder, USERDATA_IMG);
        String abiType = systemImage.getAbiType();
        if (!this.mFop.exists(userdataSrc)) {
            if (this.mFop.isDirectory(new File(imageFolder, DATA_FOLDER))) {
                return;
            }
            log.warning("Unable to find a '%1$s' file for ABI %2$s to copy into the AVD folder.", USERDATA_IMG, abiType);
            throw new AvdMgrException();
        }
        File userdataDest = new File(avdFolder, USERDATA_IMG);
        if (!this.mFop.exists(userdataDest)) {
            this.mFop.copyFile(userdataSrc, userdataDest);
            if (!this.mFop.exists(userdataDest)) {
                log.warning("Unable to create '%1$s' file in the AVD folder.", userdataDest);
                throw new AvdMgrException();
            }
        }
    }

    private void createAvdConfigFile(ISystemImage systemImage, HashMap<String, String> values2, ILogger log) throws AvdMgrException {
        if (!this.setImagePathProperties(systemImage, values2, log)) {
            log.warning("Failed to set image path properties in the AVD folder.", new Object[0]);
            throw new AvdMgrException();
        }
    }

    private void createAvdSnapshot(boolean createSnapshot, boolean editExisting, Map<String, String> values2, File avdFolder, ILogger log) throws IOException, AvdMgrException {
        if (!createSnapshot) {
            return;
        }
        File snapshotDest = new File(avdFolder, SNAPSHOTS_IMG);
        if (this.mFop.isFile(snapshotDest) && editExisting) {
            log.info("Snapshot image already present, was not changed.\n", new Object[0]);
        } else {
            File toolsLib = new File(this.mSdkHandler.getLocation(), SdkConstants.OS_SDK_TOOLS_LIB_EMULATOR_FOLDER);
            File snapshotBlank = new File(toolsLib, SNAPSHOTS_IMG);
            if (!this.mFop.exists(snapshotBlank)) {
                log.warning("Unable to find a '%2$s%1$s' file to copy into the AVD folder.", SNAPSHOTS_IMG, toolsLib);
                throw new AvdMgrException();
            }
            this.mFop.copyFile(snapshotBlank, snapshotDest);
        }
        values2.put(AVD_INI_SNAPSHOT_PRESENT, "true");
    }

    private void writeCpuArch(ISystemImage systemImage, Map<String, String> values2, ILogger log) throws AvdMgrException {
        String abiType = systemImage.getAbiType();
        Abi abi = Abi.getEnum(abiType);
        if (abi != null) {
            String arch = abi.getCpuArch();
            if (arch.equals("x86") && SystemImage.CHROMEOS_TAG.equals(systemImage.getTag())) {
                arch = "x86_64";
            }
            values2.put(AVD_INI_CPU_ARCH, arch);
            String model = abi.getCpuModel();
            if (model != null) {
                values2.put(AVD_INI_CPU_MODEL, model);
            }
        } else {
            log.warning("ABI %1$s is not supported by this version of the SDK Tools", abiType);
            throw new AvdMgrException();
        }
    }

    private void createAvdSkin(File skinFolder, String skinName, Map<String, String> values2, ILogger log) throws AvdMgrException {
        String skinPath = null;
        if (skinFolder == null && skinName != null && NUMERIC_SKIN_SIZE.matcher(skinName).matches()) {
            skinPath = skinName;
        } else if (skinFolder != null && skinName == null) {
            skinName = skinFolder.getName();
        }
        if (skinFolder != null) {
            if (!this.mFop.exists(skinFolder)) {
                log.warning("Skin '%1$s' does not exist at %2$s.", skinName, skinFolder.getPath());
                throw new AvdMgrException();
            }
            if (skinFolder.getPath().startsWith(this.mSdkHandler.getLocation().getPath())) {
                try {
                    skinPath = FileOpUtils.makeRelative((File)this.mSdkHandler.getLocation(), (File)skinFolder, (FileOp)this.mFop);
                }
                catch (IOException e) {
                    skinPath = skinFolder.getAbsolutePath();
                }
            } else {
                skinPath = skinFolder.getAbsolutePath();
            }
        }
        if (skinName != null) {
            values2.put(AVD_INI_SKIN_NAME, skinName);
        }
        if (skinPath != null) {
            values2.put(AVD_INI_SKIN_PATH, skinPath);
        }
    }

    private void createAvdSdCard(String sdcard, boolean editExisting, Map<String, String> values2, File avdFolder, ILogger log) throws AvdMgrException {
        if (sdcard == null || sdcard.isEmpty()) {
            return;
        }
        long sdcardSize = AvdManager.parseSdcardSize(sdcard, null);
        if (sdcardSize == 0L) {
            log.warning("SD Card size must be in the range 9 MiB..1023 GiB.", new Object[0]);
            throw new AvdMgrException();
        }
        if (sdcardSize == -1L) {
            log.warning("Unable to parse SD Card size", new Object[0]);
            throw new AvdMgrException();
        }
        if (sdcardSize == -2L) {
            File sdcardFile = new File(sdcard);
            if (!this.mFop.isFile(sdcardFile)) {
                log.warning("'%1$s' is not recognized as a valid sdcard value.\nValue should be:\n1. path to an sdcard.\n2. size of the sdcard to create: <size>[K|M]", sdcard);
                throw new AvdMgrException();
            }
            values2.put(AVD_INI_SDCARD_PATH, sdcard);
            return;
        }
        File sdcardFile = new File(avdFolder, SDCARD_IMG);
        boolean runMkSdcard = true;
        if (this.mFop.exists(sdcardFile) && sdcardFile.length() == sdcardSize && editExisting) {
            runMkSdcard = false;
            log.info("SD Card already present with same size, was not changed.\n", new Object[0]);
        }
        if (this.mFop instanceof MockFileOp) {
            runMkSdcard = false;
        }
        if (runMkSdcard) {
            String path = sdcardFile.getAbsolutePath();
            LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(log);
            LocalPackage p = this.mSdkHandler.getLocalPackage("emulator", (ProgressIndicator)progress);
            if (p == null) {
                p = this.mSdkHandler.getLocalPackage("tools", (ProgressIndicator)progress);
            }
            if (p == null) {
                progress.logWarning(String.format("Unable to find %1$s in the %2$s or %3$s components", SdkConstants.mkSdCardCmdName(), "emulator", "tools"));
                throw new AvdMgrException();
            }
            File mkSdCard = new File(p.getLocation(), SdkConstants.mkSdCardCmdName());
            if (!this.mFop.isFile(mkSdCard)) {
                log.warning("'%1$s' is missing from the SDK tools folder.", mkSdCard.getName());
                throw new AvdMgrException();
            }
            if (!this.createSdCard(mkSdCard.getAbsolutePath(), sdcard, path, log)) {
                log.warning("Failed to create sdcard in the AVD folder.", new Object[0]);
                throw new AvdMgrException();
            }
        }
        values2.put(AVD_INI_SDCARD_SIZE, sdcard);
    }

    private void addHardwareConfig(ISystemImage systemImage, File skinFolder, File avdFolder, Map<String, String> hardwareConfig, Map<String, String> values2, ILogger log) throws IOException {
        Map<String, String> skinHardwareConfig;
        FileOpFileWrapper skinHardwareFile;
        Map<String, String> imageHardwardConfig;
        HashMap<String, String> finalHardwareValues = new HashMap<String, String>();
        FileOpFileWrapper sysImgHardwareFile = new FileOpFileWrapper(new File(systemImage.getLocation(), HARDWARE_INI), this.mFop, false);
        if (sysImgHardwareFile.exists() && (imageHardwardConfig = ProjectProperties.parsePropertyFile(sysImgHardwareFile, log)) != null) {
            finalHardwareValues.putAll(imageHardwardConfig);
        }
        if (skinFolder != null && (skinHardwareFile = new FileOpFileWrapper(new File(skinFolder, HARDWARE_INI), this.mFop, false)).exists() && (skinHardwareConfig = ProjectProperties.parsePropertyFile(skinHardwareFile, log)) != null) {
            finalHardwareValues.putAll(skinHardwareConfig);
        }
        if (hardwareConfig != null) {
            finalHardwareValues.putAll(hardwareConfig);
        }
        if (values2 == null) {
            values2 = new HashMap<String, String>();
        }
        values2.putAll(finalHardwareValues);
        File configIniFile = new File(avdFolder, CONFIG_INI);
        this.writeIniFile(configIniFile, values2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvdInfo createAvdInfoObject(ISystemImage systemImage, String avdName, boolean removePrevious, boolean editExisting, File iniFile, File avdFolder, AvdInfo oldAvdInfo, Map<String, String> values2) throws AvdMgrException {
        AvdInfo theAvdInfo = new AvdInfo(avdName, iniFile, avdFolder.getAbsolutePath(), systemImage, values2);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (oldAvdInfo != null && (removePrevious || editExisting)) {
                this.mAllAvdList.remove(oldAvdInfo);
            }
            this.mAllAvdList.add(theAvdInfo);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
        return theAvdInfo;
    }

    private static void inhibitCopyOnWrite(File avdFolder, ILogger log) {
        if (SdkConstants.CURRENT_PLATFORM != 1) {
            return;
        }
        try {
            String[] chattrCommand = new String[]{"chattr", "+C", avdFolder.getAbsolutePath()};
            Process chattrProcess = Runtime.getRuntime().exec(chattrCommand);
            final ArrayList errorOutput = new ArrayList();
            GrabProcessOutput.grabProcessOutput(chattrProcess, GrabProcessOutput.Wait.WAIT_FOR_READERS, new GrabProcessOutput.IProcessOutput(){

                @Override
                public void out(String line) {
                }

                @Override
                public void err(String line) {
                    if (line != null && !line.startsWith("chattr: Operation not supported")) {
                        errorOutput.add(line);
                    }
                }
            });
            if (!errorOutput.isEmpty()) {
                log.warning("Failed 'chattr' for %1$s:", avdFolder.getAbsolutePath());
                for (String error : errorOutput) {
                    log.warning(" -- %1$s", error);
                }
            }
        }
        catch (IOException | InterruptedException ee) {
            log.warning("Failed 'chattr' for %1$s: %2$s", avdFolder.getAbsolutePath(), ee);
        }
    }

    private class AvdMgrException
    extends Exception {
        private AvdMgrException() {
        }
    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message2) {
            super(message2);
        }
    }
}

