/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.legacy.remote.internal.DownloadCache;
import com.android.utils.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;

public class LegacyDownloader
implements Downloader {
    private DownloadCache mDownloadCache;
    private FileOp mFileOp;
    private SettingsController mSettingsController;
    private static final int BUF_SIZE = 8192;

    public LegacyDownloader(FileOp fop, SettingsController settings) {
        this.mDownloadCache = DownloadCache.inUserHome(fop, DownloadCache.Strategy.FRESH_CACHE, settings);
        this.mFileOp = fop;
        this.mSettingsController = settings;
    }

    public InputStream downloadAndStream(URL url, ProgressIndicator indicator) throws IOException {
        return this.mDownloadCache.openCachedUrl(this.getUrl(url));
    }

    public Path downloadFully(URL url, ProgressIndicator indicator) throws IOException {
        File target = File.createTempFile("LegacyDownloader", null);
        this.downloadFully(url, target, null, indicator);
        return target.toPath();
    }

    public void downloadFully(URL url, File target, String checksum, ProgressIndicator indicator) throws IOException {
        if (this.mFileOp.exists(target) && checksum != null) {
            indicator.setText("Verifying previous download...");
            try (BufferedInputStream in = new BufferedInputStream(this.mFileOp.newFileInputStream(target));){
                if (checksum.equals(Downloader.hash((InputStream)in, (long)this.mFileOp.length(target), (ProgressIndicator)indicator.createSubProgress(0.3)))) {
                    return;
                }
            }
            indicator = indicator.createSubProgress(1.0);
        }
        this.mFileOp.mkdirs(target.getParentFile());
        OutputStream out = this.mFileOp.newFileOutputStream(target);
        Pair<InputStream, URLConnection> downloadedResult = this.mDownloadCache.openDirectUrl(this.getUrl(url));
        URLConnection connection = downloadedResult.getSecond();
        if (!(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200) {
            int r;
            indicator.setText(String.format("Downloading %s...", new File(url.getFile()).getName()));
            long total = connection.getContentLengthLong();
            long done = 0L;
            InputStream from = downloadedResult.getFirst();
            byte[] buf = new byte[8192];
            int prevPercent = 0;
            while ((r = from.read(buf)) != -1) {
                out.write(buf, 0, r);
                int percent = (int)((double)(done += (long)r) * 100.0 / (double)total);
                if (percent == prevPercent) continue;
                indicator.setFraction((double)done / (double)total);
                prevPercent = percent;
            }
            indicator.setFraction(1.0);
            out.close();
        }
    }

    private String getUrl(URL url) {
        String urlStr = url.toString();
        if (this.mSettingsController.getForceHttp()) {
            urlStr = urlStr.replaceAll("^https://", "http://");
        }
        return urlStr;
    }
}

