/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.local;

import com.android.repository.io.FileOp;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.Adler32;

@Deprecated
class LocalDirInfo {
    private final FileOp mFileOp;
    private final File mDir;
    private final long mDirModifiedTS;
    private final long mDirChecksum;
    private final long mPropsModifiedTS;
    private final long mPropsChecksum;

    LocalDirInfo(FileOp fileOp, File dir) {
        this.mFileOp = fileOp;
        this.mDir = dir;
        this.mDirModifiedTS = this.mFileOp.lastModified(dir);
        long propsChecksum = 0L;
        long propsModifiedTS = 0L;
        File props = new File(dir, "source.properties");
        if (this.mFileOp.isFile(props)) {
            propsModifiedTS = this.mFileOp.lastModified(props);
            propsChecksum = this.getFileChecksum(props);
        }
        this.mPropsModifiedTS = propsModifiedTS;
        this.mPropsChecksum = propsChecksum;
        this.mDirChecksum = this.getDirChecksum(this.mDir);
    }

    boolean hasChanged() {
        boolean hadProps;
        if (!this.mFileOp.isDirectory(this.mDir)) {
            return true;
        }
        if (this.mDirModifiedTS != this.mFileOp.lastModified(this.mDir)) {
            return true;
        }
        File props = new File(this.mDir, "source.properties");
        boolean bl = hadProps = this.mPropsModifiedTS != 0L;
        if (hadProps != this.mFileOp.isFile(props)) {
            return true;
        }
        if (hadProps) {
            if (this.mPropsModifiedTS != this.mFileOp.lastModified(props)) {
                return true;
            }
            if (this.mPropsChecksum != this.getFileChecksum(props)) {
                return true;
            }
        }
        return this.mDirChecksum != this.getDirChecksum(this.mDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFileChecksum(File file2) {
        InputStream fis = null;
        try {
            int n;
            fis = this.mFileOp.newFileInputStream(file2);
            Adler32 a = new Adler32();
            byte[] buf = new byte[1024];
            while ((n = fis.read(buf)) > 0) {
                a.update(buf, 0, n);
            }
            long l = a.getValue();
            return l;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return 0L;
    }

    private long getDirChecksum(File dir) {
        long checksum = this.mFileOp.lastModified(dir);
        File[] files = this.mFileOp.listFiles(dir);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (File file2 : files) {
            checksum = 31L * checksum | this.mFileOp.lastModified(file2);
        }
        return checksum;
    }

    public String toString() {
        String s = String.format("<DirInfo %1$s TS=%2$d", this.mDir, this.mDirModifiedTS);
        if (this.mPropsModifiedTS != 0L) {
            s = s + String.format(" | Props TS=%1$d, Chksum=%2$s", this.mPropsModifiedTS, this.mPropsChecksum);
        }
        return s + ">";
    }

    public int hashCode() {
        return this.mDir.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof File) {
            return this.mDir.equals(obj);
        }
        if (obj instanceof LocalDirInfo) {
            return this.mDir.equals(((LocalDirInfo)obj).mDir);
        }
        if (obj instanceof MapComparator) {
            return this.mDir.equals(((MapComparator)obj).mDir);
        }
        return false;
    }

    static class MapComparator {
        private final File mDir;

        public MapComparator(File dir) {
            this.mDir = dir;
        }

        public int hashCode() {
            return this.mDir.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof File) {
                return this.mDir.equals(obj);
            }
            if (obj instanceof LocalDirInfo) {
                return this.mDir.equals(((LocalDirInfo)obj).mDir);
            }
            if (obj instanceof MapComparator) {
                return this.mDir.equals(((MapComparator)obj).mDir);
            }
            return false;
        }
    }
}

