/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal;

import com.android.prefs.AndroidLocation;
import com.android.repository.api.SettingsController;
import com.android.repository.io.FileOp;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

@Deprecated
public class DownloadCache {
    private static final boolean DEBUG = System.getenv("SDKMAN_DEBUG_CACHE") != null;
    private static final String KEY_STATUS_CODE = "Status-Code";
    private static final String KEY_URL = "URL";
    private static final String BIN_FILE_PREFIX = "sdkbin";
    private static final String INFO_FILE_PREFIX = "sdkinf";
    private static final String REV_FILE_PREFIX = "-1_";
    private static final long MIN_TIME_EXPIRED_MS = 600000L;
    private static final long MAX_TIME_EXPIRED_MS = 14400000L;
    private static final int MAX_SMALL_FILE_SIZE = 655360;
    private static final String[] INFO_HTTP_HEADERS = new String[]{"Last-Modified", "ETag", "Content-Length", "Date"};
    private final FileOp mFileOp;
    private final File mCacheRoot;
    private final Strategy mStrategy;
    private final SettingsController mSettings;

    public File getCacheRoot() {
        return this.mCacheRoot;
    }

    public static DownloadCache inUserHome(FileOp fileOp, Strategy strategy, SettingsController settings) {
        File androidFolder;
        try {
            androidFolder = new File(AndroidLocation.getFolder());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            androidFolder = null;
        }
        return new DownloadCache(androidFolder, fileOp, strategy, settings);
    }

    public DownloadCache(File androidFolder, FileOp fileOp, Strategy strategy, SettingsController settings) {
        this.mFileOp = fileOp;
        this.mSettings = settings;
        this.mCacheRoot = this.initCacheRoot(androidFolder);
        if (System.getenv("SDKMAN_DISABLE_CACHE") != null) {
            strategy = Strategy.DIRECT;
        }
        this.mStrategy = this.mCacheRoot == null ? Strategy.DIRECT : strategy;
    }

    public Strategy getStrategy() {
        return this.mStrategy;
    }

    private File initCacheRoot(File androidFolder) {
        if (androidFolder == null) {
            return null;
        }
        File cacheRoot = new File(androidFolder, "cache");
        if (!this.mFileOp.exists(cacheRoot)) {
            this.mFileOp.mkdirs(cacheRoot);
        }
        return cacheRoot;
    }

    @VisibleForTesting
    protected Pair<InputStream, URLConnection> openUrl(String url, boolean needsMarkResetSupport, Header[] headers) throws IOException {
        URLConnection connection = new URL(url).openConnection(this.mSettings.getProxy());
        if (headers != null) {
            for (Header header : headers) {
                connection.setRequestProperty(header.getName(), header.getValue());
            }
        }
        connection.connect();
        InputStream is = connection.getInputStream();
        if (needsMarkResetSupport) {
            is = this.ensureMarkReset(is);
        }
        return Pair.of(is, connection);
    }

    private InputStream ensureMarkReset(InputStream is) {
        block5: {
            if (is != null && !is.markSupported()) {
                try {
                    InputStream is2 = DownloadCache.toByteArrayInputStream(is);
                    if (is2 == null) break block5;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return is2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return is;
    }

    private static InputStream toByteArrayInputStream(InputStream is) throws IOException {
        int n;
        int inc = 4096;
        int curr = 0;
        byte[] result = new byte[inc];
        while ((n = is.read(result, curr, result.length - curr)) != -1) {
            if ((curr += n) != result.length) continue;
            byte[] temp = new byte[curr + inc];
            System.arraycopy(result, 0, temp, 0, curr);
            result = temp;
        }
        return new ByteArrayInputStream(result, 0, curr);
    }

    public Pair<InputStream, URLConnection> openDirectUrl(String urlString) throws IOException {
        if (DEBUG) {
            System.out.println(String.format("%s : Direct download", urlString));
        }
        return this.openUrl(urlString, false, null);
    }

    public InputStream openCachedUrl(String urlString) throws IOException {
        if (this.mStrategy == Strategy.DIRECT) {
            Pair<InputStream, URLConnection> result = this.openUrl(urlString, true, null);
            return result.getFirst();
        }
        File cached = new File(this.mCacheRoot, this.getCacheFilename(urlString));
        File info = new File(this.mCacheRoot, this.getInfoFilename(cached.getName()));
        boolean useCached = this.mFileOp.exists(cached);
        if (useCached && this.mStrategy == Strategy.FRESH_CACHE) {
            long cacheModifiedMs = this.mFileOp.lastModified(cached);
            boolean checkCache = true;
            Properties props = this.readInfo(info);
            if (props == null) {
                useCached = false;
            } else {
                long minExpiration = System.currentTimeMillis() - 600000L;
                boolean bl = checkCache = cacheModifiedMs < minExpiration;
                if (!checkCache && DEBUG) {
                    System.out.println(String.format("%s : Too fresh [%,d ms], not checking yet.", urlString, cacheModifiedMs - minExpiration));
                }
            }
            if (useCached && checkCache) {
                assert (props != null);
                String code = props.getProperty(KEY_STATUS_CODE, "");
                useCached = Integer.toString(200).equals(code);
                if (!useCached && DEBUG) {
                    System.out.println(String.format("%s : cache disabled by code %s", urlString, code));
                }
                if (useCached) {
                    try {
                        long length = Long.parseLong(props.getProperty("Content-Length", "-1"));
                        if (length >= 0L) {
                            boolean bl = useCached = length == this.mFileOp.length(cached);
                            if (!useCached && DEBUG) {
                                System.out.println(String.format("%s : cache disabled by length mismatch %d, expected %d", urlString, length, cached.length()));
                            }
                        }
                    }
                    catch (NumberFormatException length) {
                        // empty catch block
                    }
                }
                if (useCached) {
                    String etag = props.getProperty("ETag");
                    String lastMod = props.getProperty("Last-Modified");
                    if (etag != null || lastMod != null) {
                        AtomicInteger statusCode = new AtomicInteger(0);
                        InputStream is = null;
                        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(2);
                        if (etag != null) {
                            headers.add(new BasicHeader("If-None-Match", etag));
                        }
                        if (lastMod != null) {
                            headers.add(new BasicHeader("If-Modified-Since", lastMod));
                        }
                        if (!headers.isEmpty()) {
                            is = this.downloadAndCache(urlString, cached, info, headers.toArray(new Header[0]), statusCode);
                        }
                        if (is != null && statusCode.get() == 200) {
                            return is;
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            is = null;
                        }
                        if (statusCode.get() == 304) {
                            cached.setLastModified(System.currentTimeMillis());
                        } else {
                            useCached = false;
                            if (statusCode.get() == 404) {
                                return null;
                            }
                        }
                    } else {
                        long maxExpiration = System.currentTimeMillis() - 14400000L;
                        boolean bl = useCached = cacheModifiedMs >= maxExpiration;
                        if (!useCached && DEBUG) {
                            System.out.println(String.format("[%1$s] cache disabled by timestamp %2$tD %2$tT < %3$tD %3$tT", urlString, cacheModifiedMs, maxExpiration));
                        }
                    }
                }
            }
        }
        if (useCached) {
            try {
                InputStream is = this.readCachedFile(cached);
                if (is != null) {
                    if (DEBUG) {
                        System.out.println(String.format("%s : Use cached file", urlString));
                    }
                    return is;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!useCached && this.mStrategy == Strategy.ONLY_CACHE) {
            if (DEBUG) {
                System.out.println(String.format("%s : file not in cache", urlString));
            }
            return null;
        }
        try {
            this.mFileOp.delete(cached);
            this.mFileOp.delete(info);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.downloadAndCache(urlString, cached, info, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readCachedFile(File cached) throws IOException {
        InputStream is = null;
        int inc = 65536;
        int curr = 0;
        long len = cached.length();
        assert (len < Integer.MAX_VALUE);
        if (len >= 655360L) {
            return null;
        }
        byte[] result = new byte[(int)(len > 0L ? len : (long)inc)];
        try {
            int n;
            is = this.mFileOp.newFileInputStream(cached);
            while ((n = is.read(result, curr, result.length - curr)) != -1) {
                if ((curr += n) != result.length) continue;
                byte[] temp = new byte[curr + inc];
                System.arraycopy(result, 0, temp, 0, curr);
                result = temp;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
            return byteArrayInputStream;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream downloadAndCache(String urlString, File cached, File info, Header[] headers, AtomicInteger outStatusCode) throws IOException {
        int n;
        int code;
        InputStream is = null;
        OutputStream os = null;
        int inc = 65536;
        int curr = 0;
        byte[] result = new byte[inc];
        Pair<InputStream, URLConnection> r = this.openUrl(urlString, true, headers);
        is = r.getFirst();
        URLConnection connection = r.getSecond();
        if (DEBUG) {
            String message2 = null;
            if (connection instanceof HttpURLConnection) {
                message2 = ((HttpURLConnection)connection).getResponseMessage();
            }
            System.out.println(String.format("%s : fetch: %s => %s", urlString, headers == null ? "" : Arrays.toString(headers), message2));
        }
        int n2 = code = connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : 200;
        if (outStatusCode != null) {
            outStatusCode.set(code);
        }
        if (code != 200) {
            InputStream inputStream = null;
            return inputStream;
        }
        os = this.mFileOp.newFileOutputStream(cached);
        while ((n = is.read(result, curr, result.length - curr)) != -1) {
            if (os != null && n > 0) {
                os.write(result, curr, n);
            }
            if (os != null && (curr += n) > 655360) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    cached.delete();
                    info.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                os = null;
            }
            if (curr != result.length) continue;
            byte[] temp = new byte[curr + inc];
            System.arraycopy(result, 0, temp, 0, curr);
            result = temp;
        }
        if (os != null) {
            try {
                os.close();
                os = null;
                if (connection instanceof HttpURLConnection) {
                    this.saveInfo(urlString, (HttpURLConnection)connection, info);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
        return byteArrayInputStream;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                try {
                    this.mFileOp.delete(cached);
                    this.mFileOp.delete(info);
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    private void saveInfo(String urlString, HttpURLConnection connection, File info) throws IOException {
        Properties props = new Properties();
        props.setProperty(KEY_URL, urlString);
        props.setProperty(KEY_STATUS_CODE, Integer.toString(connection.getResponseCode()));
        for (String name : INFO_HTTP_HEADERS) {
            String h = connection.getHeaderField(name);
            if (h == null) continue;
            props.setProperty(name, h);
        }
        DownloadCache.saveProperties(info, props, "## Meta data for SDK Manager cache. Do not modify.", this.mFileOp);
    }

    private Properties readInfo(File info) {
        if (this.mFileOp.exists(info)) {
            return DownloadCache.loadProperties(info, this.mFileOp);
        }
        return null;
    }

    private String getCacheFilename(String urlString) {
        int code = 0;
        int j = urlString.length();
        for (int i = 0; i < j; ++i) {
            code = code * 31 + urlString.charAt(i);
        }
        String hash = String.format("%08x", code);
        String leaf = urlString.toLowerCase(Locale.US);
        if (leaf.length() >= 2) {
            int index = urlString.lastIndexOf(47, leaf.length() - 2);
            leaf = urlString.substring(index + 1);
        }
        leaf = leaf.replaceAll("[^a-z0-9_-]+", "_");
        leaf = leaf.replaceAll("__+", "_");
        leaf = hash + '-' + leaf;
        String prefix = "sdkbin-1_";
        int n = 64 - prefix.length();
        if (leaf.length() > n) {
            leaf = leaf.substring(0, n);
        }
        return prefix + leaf;
    }

    private String getInfoFilename(String cacheFilename) {
        return cacheFilename.replaceFirst(BIN_FILE_PREFIX, INFO_FILE_PREFIX);
    }

    private static Properties loadProperties(File file2, FileOp fop) {
        Properties props = new Properties();
        try (InputStream is = fop.newFileInputStream(file2);){
            props.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private static void saveProperties(File file2, Properties props, String comments, FileOp fop) throws IOException {
        try (OutputStream fos = fop.newFileOutputStream(file2);){
            props.store(fos, comments);
        }
    }

    public static enum Strategy {
        ONLY_CACHE,
        SERVE_CACHE,
        FRESH_CACHE,
        DIRECT;

    }
}

