/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.meta;

import com.android.SdkConstants;
import com.android.sdklib.OptionalLibrary;
import com.google.common.base.Objects;
import java.io.File;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class Library
implements OptionalLibrary {
    @XmlTransient
    private File mPackagePath;

    public void setPackagePath(File packagePath) {
        this.mPackagePath = packagePath;
    }

    @Override
    public File getJar() {
        assert (this.mPackagePath != null);
        String localPath = this.getLocalJarPath();
        if (localPath == null) {
            return null;
        }
        localPath = localPath.replace('/', File.separatorChar);
        return new File(this.mPackagePath, SdkConstants.OS_ADDON_LIBS_FOLDER + localPath);
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getDescription();

    @Override
    public abstract boolean isManifestEntryRequired();

    public abstract void setLocalJarPath(String var1);

    public abstract void setDescription(String var1);

    public abstract void setName(String var1);

    public boolean equals(Object o) {
        if (!(o instanceof OptionalLibrary)) {
            return false;
        }
        OptionalLibrary lib = (OptionalLibrary)o;
        return Objects.equal(lib.getLocalJarPath(), this.getLocalJarPath()) && lib.getName().equals(this.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getLocalJarPath(), this.getName());
    }

    public String toString() {
        return String.format("OptionalLibrary[name=\"%1$s\" description=\"%2$s\" jar=\"%3$s\"]", this.getName(), this.getDescription(), this.getLocalJarPath());
    }

    public abstract void setManifestEntryRequired(Boolean var1);
}

