/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemImageManager {
    private final FileOp mFop;
    private final RepoManager mRepoManager;
    private final DetailsTypes.SysImgDetailsType mValidator;
    public static final String SYS_IMG_NAME = "system.img";
    private static final int MAX_DEPTH = 4;
    private Multimap<LocalPackage, SystemImage> mPackageToImage;
    private Map<File, SystemImage> mPathToImage;
    private Table<IdDisplay, AndroidVersion, Multimap<IdDisplay, SystemImage>> mValuesToImage;

    public SystemImageManager(RepoManager mgr, SysImgFactory factory, FileOp fop) {
        this.mFop = fop;
        this.mRepoManager = mgr;
        this.mValidator = factory.createSysImgDetailsType();
    }

    public Collection<SystemImage> getImages() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage.values();
    }

    public Multimap<LocalPackage, SystemImage> getImageMap() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage;
    }

    public Collection<SystemImage> lookup(IdDisplay tag, AndroidVersion version, IdDisplay vendor) {
        Multimap<IdDisplay, SystemImage> m;
        if (this.mValuesToImage == null) {
            this.init();
        }
        return (m = this.mValuesToImage.get(tag, version)) == null ? ImmutableList.of() : m.get(vendor);
    }

    private void init() {
        Multimap<LocalPackage, SystemImage> images = this.buildImageMap();
        HashBasedTable<IdDisplay, AndroidVersion, Multimap<IdDisplay, SystemImage>> valuesToImage = HashBasedTable.create();
        HashMap<File, SystemImage> pathToImages = Maps.newHashMap();
        for (SystemImage img : images.values()) {
            AndroidVersion version;
            IdDisplay vendor = img.getAddonVendor();
            IdDisplay tag = img.getTag();
            HashMultimap<IdDisplay, SystemImage> vendorImageMap = (HashMultimap<IdDisplay, SystemImage>)valuesToImage.get(tag, version = img.getAndroidVersion());
            if (vendorImageMap == null) {
                vendorImageMap = HashMultimap.create();
                valuesToImage.put(tag, version, vendorImageMap);
            }
            vendorImageMap.put(vendor, img);
            pathToImages.put(img.getLocation(), img);
        }
        this.mValuesToImage = valuesToImage;
        this.mPackageToImage = images;
        this.mPathToImage = pathToImages;
    }

    private Multimap<LocalPackage, SystemImage> buildImageMap() {
        HashMultimap<LocalPackage, SystemImage> result = HashMultimap.create();
        HashMap<AndroidVersion, File> platformSkins = Maps.newHashMap();
        Collection packages = this.mRepoManager.getPackages().getLocalPackages().values();
        for (LocalPackage p : packages) {
            File skinDir;
            if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType) || !this.mFop.exists(skinDir = new File(p.getLocation(), "skins"))) continue;
            platformSkins.put(((DetailsTypes.PlatformDetailsType)p.getTypeDetails()).getAndroidVersion(), skinDir);
        }
        for (LocalPackage p : packages) {
            TypeDetails typeDetails = p.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.SysImgDetailsType) && !(typeDetails instanceof DetailsTypes.PlatformDetailsType) && !(typeDetails instanceof DetailsTypes.AddonDetailsType)) continue;
            this.collectImages(p.getLocation(), p, 0, platformSkins, result);
        }
        return result;
    }

    private void collectImages(File dir, LocalPackage p, int depth, Map<AndroidVersion, File> platformSkins, Multimap<LocalPackage, SystemImage> collector) {
        for (File f : this.mFop.listFiles(dir)) {
            String name;
            if (f.getPath().endsWith(SYS_IMG_NAME) && f.getName().equals(SYS_IMG_NAME)) {
                collector.put(p, this.createSysImg(p, dir, platformSkins));
            }
            if (depth >= 4 || !this.mFop.isDirectory(f) || (name = f.getName()).equals("data") || name.equals("samples") || name.equals("skins")) continue;
            this.collectImages(f, p, depth + 1, platformSkins, collector);
        }
    }

    private SystemImage createSysImg(LocalPackage p, File dir, Map<AndroidVersion, File> platformSkins) {
        File[] skins;
        String containingDir = dir.getName();
        TypeDetails details = p.getTypeDetails();
        AndroidVersion version = null;
        if (details instanceof DetailsTypes.ApiDetailsType) {
            version = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
        }
        String abi = details instanceof DetailsTypes.SysImgDetailsType ? ((DetailsTypes.SysImgDetailsType)details).getAbi() : (this.mValidator.isValidAbi(containingDir) ? containingDir : "armeabi");
        IdDisplay vendor = null;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            vendor = ((DetailsTypes.AddonDetailsType)details).getVendor();
        } else if (details instanceof DetailsTypes.SysImgDetailsType) {
            vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
        }
        IdDisplay tag = details instanceof DetailsTypes.SysImgDetailsType ? ((DetailsTypes.SysImgDetailsType)details).getTag() : (details instanceof DetailsTypes.AddonDetailsType ? ((DetailsTypes.AddonDetailsType)details).getTag() : SystemImage.DEFAULT_TAG);
        File skinDir = new File(dir, "skins");
        if (!this.mFop.exists(skinDir) && version != null) {
            skinDir = platformSkins.get(version);
        }
        if (skinDir != null) {
            List<File> skinList = PackageParserUtils.parseSkinFolder(skinDir, this.mFop);
            skins = skinList.toArray(new File[0]);
        } else {
            skins = new File[]{};
        }
        return new SystemImage(dir, tag, vendor, abi, skins, (RepoPackage)p);
    }

    public ISystemImage getImageAt(File imageDir) {
        if (this.mPathToImage == null) {
            this.init();
        }
        return this.mPathToImage.get(imageDir);
    }
}

