/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCli;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

class LicensesAction
extends SdkAction {
    private static final String LICENSES_ARG = "--licenses";

    private LicensesAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    public static void register(Map<String, Function<SdkManagerCliSettings, SdkAction>> argToFactory) {
        argToFactory.put(LICENSES_ARG, LicensesAction::new);
    }

    @Override
    public void execute(ProgressIndicator progress) throws SdkManagerCli.CommandFailedException {
        this.getRepoManager().loadSynchronously(0L, progress, this.getDownloader(), (SettingsController)this.mSettings);
        Set licenses = this.getRepoManager().getPackages().getRemotePackages().values().stream().map(RepoPackage::getLicense).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
        ImmutableList.Builder licensesNotYetAcceptedBuilder = ImmutableList.builder();
        for (License license : licenses) {
            boolean accepted = license.checkAccepted(this.getSdkHandler().getLocation(), this.getSdkHandler().getFileOp());
            if (!accepted) {
                licensesNotYetAcceptedBuilder.add(license);
            }
            if (!this.mSettings.isVerbose()) continue;
            SdkManagerCli.printLicense(license, this.getOutputStream());
            this.getOutputStream().format(accepted ? "Accepted%n%n" : "Not yet accepted%n%n", new Object[0]);
        }
        ImmutableCollection licensesNotYetAccepted = licensesNotYetAcceptedBuilder.build();
        if (licensesNotYetAccepted.isEmpty()) {
            this.getOutputStream().println("All SDK package licenses accepted.");
            return;
        }
        this.getOutputStream().format("%1$d of %2$d SDK package license%3$s not accepted.%nReview license%3$s that ha%4$s not been accepted (y/N)? ", licensesNotYetAccepted.size(), licenses.size(), licensesNotYetAccepted.size() == 1 ? "" : "s", licensesNotYetAccepted.size() == 1 ? "s" : "ve");
        if (!SdkManagerCli.askYesNo(this.getInputReader())) {
            return;
        }
        int newlyAcceptedCount = 0;
        for (int i = 0; i < licensesNotYetAccepted.size(); ++i) {
            this.getOutputStream().format("%n%1$d/%2$d: ", i + 1, licensesNotYetAccepted.size());
            License license = (License)licensesNotYetAccepted.get(i);
            if (!SdkManagerCli.askForLicense(license, this.getOutputStream(), this.getInputReader())) continue;
            license.setAccepted(this.getRepoManager().getLocalPath(), this.getSdkHandler().getFileOp());
            ++newlyAcceptedCount;
        }
        if (newlyAcceptedCount == licensesNotYetAccepted.size()) {
            this.getOutputStream().println("All SDK package licenses accepted");
        } else {
            int notAccepted = licensesNotYetAccepted.size() - newlyAcceptedCount;
            this.getOutputStream().format("%1$d license%2$s not accepted%n", notAccepted, notAccepted == 1 ? "" : "s");
        }
    }
}

