/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.tool.sdkmanager.InstallAction;
import com.android.sdklib.tool.sdkmanager.LicensesAction;
import com.android.sdklib.tool.sdkmanager.ListAction;
import com.android.sdklib.tool.sdkmanager.QuietProgressIndicator;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCli;
import com.android.sdklib.tool.sdkmanager.ShowVersionAction;
import com.android.sdklib.tool.sdkmanager.UninstallAction;
import com.android.sdklib.tool.sdkmanager.UpdateAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@VisibleForTesting
class SdkManagerCliSettings
implements SettingsController {
    private static final String CHANNEL_ARG = "--channel=";
    private static final String SDK_ROOT_ARG = "--sdk_root=";
    private static final String INCLUDE_OBSOLETE_ARG = "--include_obsolete";
    private static final String HELP_ARG = "--help";
    private static final String NO_HTTPS_ARG = "--no_https";
    private static final String VERBOSE_ARG = "--verbose";
    private static final String PROXY_TYPE_ARG = "--proxy=";
    private static final String PROXY_HOST_ARG = "--proxy_host=";
    private static final String PROXY_PORT_ARG = "--proxy_port=";
    private static final String NO_PROXY_ARG = "--no_proxy";
    private static final String TOOLSDIR = "com.android.sdklib.toolsdir";
    private static final Map<String, Function<SdkManagerCliSettings, SdkAction>> ARG_TO_ACTION = new HashMap<String, Function<SdkManagerCliSettings, SdkAction>>();
    public static final String STUDIO_UNITTEST_DO_NOT_RESOLVE_PROXY_ENV = "STUDIO_UNITTEST_DO_NOT_RESOLVE_PROXY";
    public static final String HTTP_PROXY_ENV = "HTTP_PROXY";
    public static final String HTTPS_PROXY_ENV = "HTTPS_PROXY";
    private Path mLocalPath;
    private SdkAction mAction;
    private int mChannel = 0;
    private boolean mIncludeObsolete = false;
    private boolean mForceHttp = false;
    private boolean mDisableSdkPatches = false;
    private boolean mForceNoProxy = false;
    private boolean mVerbose = false;
    private Proxy.Type mProxyType;
    private SocketAddress mProxyHost;
    private String mProxyHostStr;
    private AndroidSdkHandler mHandler;
    private RepoManager mRepoManager;
    private PrintStream mOut;
    private BufferedReader mIn;
    private Downloader mDownloader;
    private FileSystem mFileSystem;
    private Map<String, String> mEnvironment;

    public void setDownloader(Downloader downloader) {
        this.mDownloader = downloader;
    }

    public void setSdkHandler(AndroidSdkHandler handler) {
        this.mHandler = handler;
        this.mRepoManager = handler == null ? null : handler.getSdkManager((ProgressIndicator)new QuietProgressIndicator(this.getProgressIndicator()));
    }

    public void setOutputStream(PrintStream out) {
        this.mOut = out;
    }

    public void setInputStream(InputStream in) {
        this.mIn = in == null ? null : new BufferedReader(new InputStreamReader(in));
    }

    public static SdkManagerCliSettings createSettings(List<String> args, FileSystem fileSystem) {
        return SdkManagerCliSettings.createSettings(args, fileSystem, System.getenv());
    }

    @VisibleForTesting
    static SdkManagerCliSettings createSettings(List<String> args, FileSystem fileSystem, Map<String, String> environment) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator(){

            public void logInfo(String s) {
            }

            public void logVerbose(String s) {
            }
        };
        try {
            return new SdkManagerCliSettings(args, fileSystem, environment, (ProgressIndicator)progress);
        }
        catch (Exception e) {
            progress.logWarning("Could not create settings", (Throwable)e);
            return null;
        }
    }

    private boolean setAction(SdkAction action, ProgressIndicator progress) {
        if (this.mAction != null) {
            progress.logError("Only one of " + Joiner.on(", ").join(ARG_TO_ACTION.keySet()) + " can be specified.");
            return false;
        }
        this.mAction = action;
        return true;
    }

    private SocketAddress createAddress(String host, int port) {
        if ("1".equals(this.mEnvironment.get(STUDIO_UNITTEST_DO_NOT_RESOLVE_PROXY_ENV))) {
            return InetSocketAddress.createUnresolved(host, port);
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            return new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e) {
            this.getProgressIndicator().logWarning("Failed to resolve host " + host);
            return null;
        }
    }

    public Channel getChannel() {
        return Channel.create((int)this.mChannel);
    }

    public boolean getForceHttp() {
        return this.mForceHttp;
    }

    public void setForceHttp(boolean force) {
        this.mForceHttp = force;
    }

    public boolean getDisableSdkPatches() {
        return this.mDisableSdkPatches;
    }

    public void setDisableSdkPatches(boolean disable) {
        this.mDisableSdkPatches = disable;
    }

    @VisibleForTesting
    public boolean getForceNoProxy() {
        return this.mForceNoProxy;
    }

    public Path getLocalPath() {
        return this.mLocalPath;
    }

    public SdkAction getAction() {
        return this.mAction;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public boolean includeObsolete() {
        return this.mIncludeObsolete;
    }

    public ProgressIndicator getProgressIndicator() {
        PrintStream out = this.getOutputStream();
        if (out == null) {
            out = System.out;
        }
        return new ConsoleProgressIndicator(out, System.err){

            public void logWarning(String s, Throwable e) {
                if (SdkManagerCliSettings.this.mVerbose) {
                    super.logWarning(s, e);
                } else {
                    super.logWarning(s, null);
                }
            }

            public void logError(String s, Throwable e) {
                if (SdkManagerCliSettings.this.mVerbose) {
                    super.logWarning(s, e);
                } else {
                    super.logWarning(s, null);
                }
                throw new SdkManagerCli.UncheckedCommandFailedException();
            }

            public void logInfo(String s) {
                if (SdkManagerCliSettings.this.mVerbose) {
                    super.logInfo(s);
                }
            }

            public void logVerbose(String s) {
                if (SdkManagerCliSettings.this.mVerbose) {
                    super.logVerbose(s);
                }
            }
        };
    }

    public Proxy getProxy() {
        return this.mProxyType == null ? Proxy.NO_PROXY : new Proxy(this.mProxyType, this.mProxyHost);
    }

    @VisibleForTesting
    String getProxyHostStr() {
        return this.mProxyHostStr;
    }

    public RepoManager getRepoManager() {
        return this.mRepoManager;
    }

    public Downloader getDownloader() {
        return this.mDownloader;
    }

    public BufferedReader getInputReader() {
        return this.mIn;
    }

    public PrintStream getOutputStream() {
        return this.mOut;
    }

    public AndroidSdkHandler getSdkHandler() {
        return this.mHandler;
    }

    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }

    private static Proxy.Type extractProxyType(String type, ProgressIndicator progress) {
        if (type.equals("socks")) {
            return Proxy.Type.SOCKS;
        }
        if (type.equals("http") || type.equals("https")) {
            return Proxy.Type.HTTP;
        }
        progress.logWarning("Valid proxy types are \"socks\" and \"http\".");
        throw new IllegalArgumentException();
    }

    private SdkManagerCliSettings(List<String> args, FileSystem fileSystem, Map<String, String> environment, ProgressIndicator progress) {
        this.mFileSystem = fileSystem;
        this.mEnvironment = environment;
        String proxyHost = null;
        int proxyPort = -1;
        String toolsDir = System.getProperty(TOOLSDIR);
        if (toolsDir != null) {
            this.mLocalPath = fileSystem.getPath(toolsDir, new String[0]).normalize().getParent();
        }
        args = new LinkedList<String>(args);
        Iterator<String> argIter = args.iterator();
        while (argIter.hasNext()) {
            String value;
            String arg = argIter.next();
            if (ARG_TO_ACTION.containsKey(arg)) {
                if (!this.setAction(ARG_TO_ACTION.get(arg).apply(this), progress)) {
                    throw new IllegalArgumentException();
                }
                argIter.remove();
                continue;
            }
            if (arg.equals(HELP_ARG)) {
                throw new IllegalArgumentException();
            }
            if (arg.equals(NO_HTTPS_ARG)) {
                this.setForceHttp(true);
                argIter.remove();
                continue;
            }
            if (arg.equals(NO_PROXY_ARG)) {
                this.mForceNoProxy = true;
                argIter.remove();
                continue;
            }
            if (arg.equals(VERBOSE_ARG)) {
                this.mVerbose = true;
                argIter.remove();
                continue;
            }
            if (arg.equals(INCLUDE_OBSOLETE_ARG)) {
                this.mIncludeObsolete = true;
                argIter.remove();
                continue;
            }
            if (arg.startsWith(PROXY_HOST_ARG)) {
                proxyHost = arg.substring(PROXY_HOST_ARG.length());
                argIter.remove();
                continue;
            }
            if (arg.startsWith(PROXY_PORT_ARG)) {
                value = arg.substring(PROXY_PORT_ARG.length());
                try {
                    proxyPort = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    progress.logWarning(String.format("Invalid port \"%s\"", value));
                    throw new IllegalArgumentException();
                }
                argIter.remove();
                continue;
            }
            if (arg.startsWith(PROXY_TYPE_ARG)) {
                String type = arg.substring(PROXY_TYPE_ARG.length());
                this.mProxyType = SdkManagerCliSettings.extractProxyType(type, progress);
                argIter.remove();
                continue;
            }
            if (arg.startsWith(CHANNEL_ARG)) {
                value = arg.substring(CHANNEL_ARG.length());
                try {
                    this.mChannel = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    progress.logWarning(String.format("Invalid channel id \"%s\"", value));
                    throw new IllegalArgumentException();
                }
                argIter.remove();
                continue;
            }
            if (!arg.startsWith(SDK_ROOT_ARG)) continue;
            this.mLocalPath = fileSystem.getPath(arg.substring(SDK_ROOT_ARG.length()), new String[0]);
            argIter.remove();
        }
        if (this.mAction == null) {
            this.mAction = new InstallAction(this);
        }
        for (String arg : args) {
            if (this.mAction.consumeArgument(arg, progress)) continue;
            progress.logWarning(String.format("Unknown argument %s", arg));
            throw new IllegalArgumentException();
        }
        if (!this.mAction.validate(progress)) {
            throw new IllegalArgumentException();
        }
        if (this.mLocalPath == null) {
            throw new IllegalArgumentException();
        }
        if (this.mForceNoProxy && (proxyHost != null || proxyPort != -1 || this.mProxyType != null)) {
            progress.logWarning(String.format("None of %1$s, %2$s, and %3$s must be specified if %4$s is.", PROXY_HOST_ARG, PROXY_PORT_ARG, PROXY_TYPE_ARG, NO_PROXY_ARG));
            throw new IllegalArgumentException();
        }
        if (proxyHost == null ^ this.mProxyType == null || proxyPort == -1 ^ this.mProxyType == null) {
            progress.logWarning(String.format("All of %1$s, %2$s, and %3$s must be specified if any are.", PROXY_HOST_ARG, PROXY_PORT_ARG, PROXY_TYPE_ARG));
            throw new IllegalArgumentException();
        }
        if (this.mForceNoProxy) {
            return;
        }
        if (proxyHost == null) {
            String proxyEnv;
            if (this.mForceHttp) {
                proxyEnv = this.mEnvironment.get(HTTP_PROXY_ENV);
            } else {
                proxyEnv = this.mEnvironment.get(HTTPS_PROXY_ENV);
                if (proxyEnv == null) {
                    proxyEnv = this.mEnvironment.get(HTTP_PROXY_ENV);
                }
            }
            if (proxyEnv != null) {
                try {
                    URL url = new URL(proxyEnv);
                    this.mProxyType = SdkManagerCliSettings.extractProxyType(url.getProtocol(), progress);
                    proxyHost = url.getHost();
                    proxyPort = url.getPort();
                }
                catch (MalformedURLException e) {
                    progress.logWarning("The proxy server URL extracted from HTTP_PROXY or HTTPS_PROXY environment variable could not be parsed. Either specify the correct URL or unset the environment variable.", (Throwable)e);
                    throw new IllegalArgumentException();
                }
            }
        }
        if (proxyHost != null) {
            SocketAddress address = this.createAddress(proxyHost, proxyPort);
            if (address == null) {
                throw new IllegalArgumentException();
            }
            this.mProxyHost = address;
            this.mProxyHostStr = proxyHost;
        }
    }

    static {
        InstallAction.register(ARG_TO_ACTION);
        UninstallAction.register(ARG_TO_ACTION);
        LicensesAction.register(ARG_TO_ACTION);
        UpdateAction.register(ARG_TO_ACTION);
        ShowVersionAction.register(ARG_TO_ACTION);
        ListAction.register(ARG_TO_ACTION);
    }
}

