/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.auth;

import com.android.tradefed.auth.ICredentialFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.gson.GsonFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="service-account-key-credential-factory", global_namespace=false)
public class ServiceAccountKeyCredentialFactory
implements ICredentialFactory {
    @Option(name="json-key-file", description="Service account json key file.")
    private File mKeyFile;
    private static final String CLIENT_EMAIL_KEY = "client_email";
    private static final String TYPE_KEY = "type";
    private static final String PRIVATE_KEY_ID_KEY = "private_key_id";
    private static final String ERROR_KEY = "error";
    private Map<String, String> mInfo = null;

    @Override
    public Credential createCredential(Collection<String> scopes) throws IOException {
        try {
            GoogleCredential credential = GoogleCredential.fromStream(new FileInputStream(this.mKeyFile), GoogleNetHttpTransport.newTrustedTransport(), GsonFactory.getDefaultInstance()).createScoped(scopes);
            return credential;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, String> getInfo() {
        if (this.mInfo == null) {
            this.mInfo = this.parseKeyFile(this.mKeyFile);
        }
        return new HashMap<String, String>(this.mInfo);
    }

    Map<String, String> parseKeyFile(File keyFile) {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            String keyContent = FileUtil.readStringFromFile(keyFile);
            JSONObject jsonObject = new JSONObject(keyContent);
            info.put(CLIENT_EMAIL_KEY, jsonObject.getString(CLIENT_EMAIL_KEY));
            info.put(TYPE_KEY, jsonObject.getString(TYPE_KEY));
            info.put(PRIVATE_KEY_ID_KEY, jsonObject.getString(PRIVATE_KEY_ID_KEY));
        }
        catch (IOException | JSONException e) {
            LogUtil.CLog.e("Failed to read %s:", keyFile.getAbsolutePath());
            LogUtil.CLog.e(e);
            info.put(ERROR_KEY, e.getMessage());
        }
        return info;
    }
}

