/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.IDeviceBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.BuildInfoUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

@OptionClass(alias="bootstrap-build")
public class BootstrapBuildProvider
implements IDeviceBuildProvider {
    @Option(name="build-target", description="build target name to supply.")
    private String mBuildTargetName = "bootstrapped";
    @Option(name="branch", description="build branch name to supply.")
    private String mBranch = null;
    @Option(name="build-id", description="Specify the build id to report instead of the one from the device.")
    private String mBuildId = null;
    @Option(name="shell-available-timeout", description="Time to wait in seconds for device shell to become available. Default to 300 seconds.")
    private long mShellAvailableTimeout = 300L;
    @Option(name="tests-dir", description="Path to top directory of expanded tests zip")
    private File mTestsDir = null;
    @Option(name="extra-file", description="The extra file to be added to the Build Provider. Can be repeated. For example --extra-file file_key_1=/path/to/file")
    private Map<String, File> mExtraFiles = new LinkedHashMap<String, File>();
    @Option(name="collect-build-attribute", description="Whether to collect build attributes from the device to build-info.")
    private boolean mCollectBuildAttribute = true;
    private boolean mCreatedTestDir = false;

    @Override
    public void cleanUp(IBuildInfo info) {
        if (this.mCreatedTestDir) {
            FileUtil.recursiveDelete(this.mTestsDir);
            info.cleanUp();
        }
    }

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        throw new UnsupportedOperationException("Call getBuild(ITestDevice)");
    }

    @Override
    public IBuildInfo getBuild(ITestDevice device) throws BuildRetrievalError, DeviceNotAvailableException {
        DeviceBuildInfo info;
        block21: {
            info = new DeviceBuildInfo(this.mBuildId, this.mBuildTargetName);
            this.addFiles(info, this.mExtraFiles);
            if (!(device.getIDevice() instanceof StubDevice) && !SystemUtil.isLocalMode()) {
                try (CloseableTraceScope ignored = new CloseableTraceScope("wait_for_shell");){
                    if (!device.waitForDeviceShell(this.mShellAvailableTimeout * 1000L)) {
                        throw new DeviceNotAvailableException(String.format("Shell did not become available in %d seconds", this.mShellAvailableTimeout), device.getSerialNumber());
                    }
                    break block21;
                }
            }
            if (this.mBranch == null) {
                this.mBranch = "stub";
            }
        }
        if (this.mCollectBuildAttribute) {
            try (CloseableTraceScope bootstrapAttributes = new CloseableTraceScope("bootstrapDeviceBuildAttributes");){
                BuildInfoUtil.bootstrapDeviceBuildAttributes(info, device, this.mBuildId, null, this.mBranch, null);
            }
        } else {
            info.setBuildBranch(this.mBranch);
            info.setBuildFlavor(this.mBuildTargetName);
        }
        if (this.mTestsDir != null && this.mTestsDir.isDirectory()) {
            info.setFile("testsdir", this.mTestsDir, info.getBuildId());
        }
        this.mCreatedTestDir = false;
        if (this.mTestsDir == null) {
            this.mCreatedTestDir = true;
            try {
                this.mTestsDir = FileUtil.createTempDir("bootstrap-test-dir", CurrentInvocation.getInfo(CurrentInvocation.InvocationInfo.WORK_FOLDER));
            }
            catch (IOException e) {
                throw new BuildRetrievalError(e.getMessage(), (Throwable)e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
            }
            ((IDeviceBuildInfo)info).setTestsDir(this.mTestsDir, "1");
        } else {
            info.setProperties(IBuildInfo.BuildInfoProperties.DO_NOT_COPY_ON_SHARDING);
        }
        if (this.getInvocationFiles() != null) {
            this.getInvocationFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, this.mTestsDir, !this.mCreatedTestDir);
        }
        return info;
    }

    private void addFiles(IBuildInfo buildInfo, Map<String, File> fileMaps) {
        for (Map.Entry<String, File> entry : fileMaps.entrySet()) {
            buildInfo.setFile(entry.getKey(), entry.getValue(), "0");
        }
    }

    ExecutionFiles getInvocationFiles() {
        return CurrentInvocation.getInvocationFiles();
    }

    public final File getTestsDir() {
        return this.mTestsDir;
    }
}

