/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.build.proto.BuildInformation;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BuildInfo
implements IBuildInfo {
    private static final long serialVersionUID = 1L;
    private static final String BUILD_ALIAS_KEY = "build_alias";
    private String mBuildId = "-1";
    private String mTestTag = "stub";
    private String mBuildTargetName = "stub";
    private final UniqueMultiMap<String, String> mBuildAttributes = new UniqueMultiMap();
    private Map<String, VersionedFile> mVersionedFileMap;
    private transient MultiMap<String, VersionedFile> mVersionedFileMultiMap;
    private String mBuildFlavor = null;
    private String mBuildBranch = null;
    private String mDeviceSerial = null;
    private final Set<IBuildInfo.BuildInfoProperties> mProperties = new HashSet<IBuildInfo.BuildInfoProperties>();
    private static final String[] FILE_NOT_TO_CLONE = new String[]{BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE.getFileKey(), BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR.getFileKey(), BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR.getFileKey()};

    public BuildInfo() {
        this.mVersionedFileMap = new Hashtable<String, VersionedFile>();
        this.mVersionedFileMultiMap = new MultiMap();
    }

    public BuildInfo(String buildId, String buildTargetName) {
        this();
        this.mBuildId = buildId;
        this.mBuildTargetName = buildTargetName;
    }

    BuildInfo(BuildInfo buildToCopy) {
        this(buildToCopy.getBuildId(), buildToCopy.getBuildTargetName());
        this.addAllBuildAttributes(buildToCopy);
        try {
            this.addAllFiles(buildToCopy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBuildId() {
        return this.mBuildId;
    }

    @Override
    public void setBuildId(String buildId) {
        this.mBuildId = buildId;
    }

    @Override
    public void setTestTag(String testTag) {
        this.mTestTag = testTag;
    }

    @Override
    public String getTestTag() {
        return this.mTestTag;
    }

    @Override
    public String getDeviceSerial() {
        return this.mDeviceSerial;
    }

    @Override
    public Map<String, String> getBuildAttributes() {
        return this.mBuildAttributes.getUniqueMap();
    }

    @Override
    public void setProperties(IBuildInfo.BuildInfoProperties ... properties) {
        this.mProperties.clear();
        this.mProperties.addAll(Arrays.asList(properties));
    }

    @Override
    public Set<IBuildInfo.BuildInfoProperties> getProperties() {
        return new HashSet<IBuildInfo.BuildInfoProperties>(this.mProperties);
    }

    @Override
    public String getBuildTargetName() {
        return this.mBuildTargetName;
    }

    @Override
    public void addBuildAttribute(String attributeName, String attributeValue) {
        if (attributeValue == null) {
            attributeValue = "";
        }
        this.mBuildAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void removeBuildAttribute(String attributeName) {
        this.mBuildAttributes.remove(attributeName);
    }

    @Override
    public void addBuildAttributes(Map<String, String> buildAttributes) {
        this.mBuildAttributes.putAll(buildAttributes);
    }

    protected void addAllBuildAttributes(BuildInfo build) {
        this.mBuildAttributes.putAll(build.getAttributesMultiMap());
        this.setBuildFlavor(build.getBuildFlavor());
        this.setBuildBranch(build.getBuildBranch());
        this.setTestTag(build.getTestTag());
    }

    protected MultiMap<String, String> getAttributesMultiMap() {
        return this.mBuildAttributes;
    }

    protected void addAllFiles(BuildInfo build) throws IOException {
        for (Map.Entry<String, VersionedFile> fileEntry : build.getVersionedFileMap().entrySet()) {
            File copyFile;
            File origFile = fileEntry.getValue().getFile();
            if (this.applyBuildProperties(fileEntry.getValue(), build, this)) continue;
            if (fileEntry.getKey().startsWith("remote_file:")) {
                this.setFile(fileEntry.getKey(), new File(fileEntry.getValue().getFile().getPath()), fileEntry.getValue().getVersion());
                continue;
            }
            if (origFile.isDirectory()) {
                copyFile = FileUtil.createTempDir(fileEntry.getKey());
                FileUtil.recursiveHardlink(origFile, copyFile, false);
            } else {
                copyFile = FileUtil.createTempFile(fileEntry.getKey(), FileUtil.getExtension(origFile.getName()));
                copyFile.delete();
                FileUtil.hardlinkFile(origFile, copyFile);
            }
            this.setFile(fileEntry.getKey(), copyFile, fileEntry.getValue().getVersion());
        }
    }

    protected boolean applyBuildProperties(VersionedFile origFileConsidered, IBuildInfo build, IBuildInfo receiver) {
        if (this.getProperties().contains((Object)IBuildInfo.BuildInfoProperties.DO_NOT_COPY_ON_SHARDING)) {
            for (String name : FILE_NOT_TO_CLONE) {
                if (!origFileConsidered.getFile().equals(build.getFile(name))) continue;
                receiver.setFile(name, origFileConsidered.getFile(), origFileConsidered.getVersion());
                return true;
            }
        }
        if (this.getProperties().contains((Object)IBuildInfo.BuildInfoProperties.DO_NOT_COPY_IMAGE_FILE) && origFileConsidered.equals(build.getVersionedFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE))) {
            LogUtil.CLog.d("Skip copying of device_image.");
            return true;
        }
        return false;
    }

    protected Map<String, VersionedFile> getVersionedFileMap() {
        return this.mVersionedFileMultiMap.getUniqueMap();
    }

    protected MultiMap<String, VersionedFile> getVersionedFileMapFull() {
        return new MultiMap<String, VersionedFile>(this.mVersionedFileMultiMap);
    }

    @Override
    public Set<String> getVersionedFileKeys() {
        return this.mVersionedFileMultiMap.keySet();
    }

    @Override
    public File getFile(String name) {
        List<VersionedFile> fileRecords = this.mVersionedFileMultiMap.get(name);
        if (fileRecords == null || fileRecords.isEmpty()) {
            return null;
        }
        return fileRecords.get(0).getFile();
    }

    @Override
    public File getFile(BuildInfoKey.BuildInfoFileKey key) {
        return this.getFile(key.getFileKey());
    }

    @Override
    public final VersionedFile getVersionedFile(String name) {
        List<VersionedFile> fileRecords = this.mVersionedFileMultiMap.get(name);
        if (fileRecords == null || fileRecords.isEmpty()) {
            return null;
        }
        return fileRecords.get(0);
    }

    @Override
    public VersionedFile getVersionedFile(BuildInfoKey.BuildInfoFileKey key) {
        return this.getVersionedFile(key.getFileKey());
    }

    @Override
    public final List<VersionedFile> getVersionedFiles(BuildInfoKey.BuildInfoFileKey key) {
        if (!key.isList()) {
            throw new UnsupportedOperationException(String.format("Key %s does not support list of files.", key.getFileKey()));
        }
        return this.mVersionedFileMultiMap.get(key.getFileKey());
    }

    @Override
    public Collection<VersionedFile> getFiles() {
        return this.mVersionedFileMultiMap.values();
    }

    @Override
    public String getVersion(String name) {
        List<VersionedFile> fileRecords = this.mVersionedFileMultiMap.get(name);
        if (fileRecords == null || fileRecords.isEmpty()) {
            return null;
        }
        return fileRecords.get(0).getVersion();
    }

    @Override
    public String getVersion(BuildInfoKey.BuildInfoFileKey key) {
        return this.getVersion(key.getFileKey());
    }

    @Override
    public void setFile(String name, File file2, String version) {
        BuildInfoKey.BuildInfoFileKey key;
        if (file2 == null) {
            LogUtil.CLog.w("Tried to add to build info file name '%s' which is null.", name);
            return;
        }
        if (!this.mVersionedFileMap.containsKey(name)) {
            this.mVersionedFileMap.put(name, new VersionedFile(file2, version));
        }
        if (this.mVersionedFileMultiMap.containsKey(name) && ((key = BuildInfoKey.BuildInfoFileKey.fromString(name)) == null || !key.isList())) {
            LogUtil.CLog.e("Device build already contains a file for %s in thread %s", name, Thread.currentThread().getName());
            return;
        }
        this.mVersionedFileMultiMap.put(name, new VersionedFile(file2, version));
    }

    @Override
    public void setFile(BuildInfoKey.BuildInfoFileKey key, File file2, String version) {
        this.setFile(key.getFileKey(), file2, version);
    }

    @Override
    public List<VersionedFile> getAppPackageFiles() {
        List<VersionedFile> origList = this.getVersionedFiles(BuildInfoKey.BuildInfoFileKey.PACKAGE_FILES);
        ArrayList<VersionedFile> listCopy = new ArrayList<VersionedFile>();
        if (origList != null) {
            listCopy.addAll(origList);
        }
        return listCopy;
    }

    @Override
    public void addAppPackageFile(File appPackageFile, String version) {
        this.setFile(BuildInfoKey.BuildInfoFileKey.PACKAGE_FILES, appPackageFile, version);
    }

    @Override
    public void cleanUp() {
        for (VersionedFile fileRecord : this.mVersionedFileMultiMap.values()) {
            FileUtil.recursiveDelete(fileRecord.getFile());
        }
        this.mVersionedFileMultiMap.clear();
    }

    @Override
    public void cleanUp(List<File> doNotClean) {
        if (doNotClean == null) {
            this.cleanUp();
        }
        for (VersionedFile fileRecord : this.mVersionedFileMultiMap.values()) {
            if (doNotClean.contains(fileRecord.getFile())) continue;
            FileUtil.recursiveDelete(fileRecord.getFile());
        }
        this.refreshVersionedFiles();
    }

    private void refreshVersionedFiles() {
        HashSet<String> keys = new HashSet<String>(this.mVersionedFileMultiMap.keySet());
        for (String key : keys) {
            for (VersionedFile file2 : this.mVersionedFileMultiMap.get(key)) {
                if (file2.getFile().exists()) continue;
                this.mVersionedFileMultiMap.remove(key);
            }
        }
    }

    @Override
    public IBuildInfo clone() {
        BuildInfo copy = null;
        try {
            copy = (BuildInfo)this.getClass().getDeclaredConstructor(String.class, String.class).newInstance(this.getBuildId(), this.getBuildTargetName());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LogUtil.CLog.e("Failed to clone the build info.");
            throw new RuntimeException(e);
        }
        copy.addAllBuildAttributes(this);
        copy.setProperties(this.getProperties().toArray(new IBuildInfo.BuildInfoProperties[0]));
        try {
            copy.addAllFiles(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        copy.setBuildBranch(this.mBuildBranch);
        copy.setBuildFlavor(this.mBuildFlavor);
        copy.setDeviceSerial(this.mDeviceSerial);
        return copy;
    }

    @Override
    public String getBuildFlavor() {
        return this.mBuildFlavor;
    }

    @Override
    public void setBuildFlavor(String buildFlavor) {
        this.mBuildFlavor = buildFlavor;
    }

    @Override
    public String getBuildBranch() {
        return this.mBuildBranch;
    }

    @Override
    public void setBuildBranch(String branch) {
        this.mBuildBranch = branch;
    }

    @Override
    public void setDeviceSerial(String serial) {
        this.mDeviceSerial = serial;
    }

    public int hashCode() {
        return Objects.hashCode(this.mBuildAttributes, this.mBuildBranch, this.mBuildFlavor, this.mBuildId, this.mBuildTargetName, this.mTestTag, this.mDeviceSerial);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildInfo other = (BuildInfo)obj;
        return Objects.equal(this.mBuildAttributes, other.mBuildAttributes) && Objects.equal(this.mBuildBranch, other.mBuildBranch) && Objects.equal(this.mBuildFlavor, other.mBuildFlavor) && Objects.equal(this.mBuildId, other.mBuildId) && Objects.equal(this.mBuildTargetName, other.mBuildTargetName) && Objects.equal(this.mTestTag, other.mTestTag) && Objects.equal(this.mDeviceSerial, other.mDeviceSerial);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add(BUILD_ALIAS_KEY, this.getBuildAttributes().get(BUILD_ALIAS_KEY)).add("bid", this.mBuildId).add("target", this.mBuildTargetName).add("build_flavor", this.mBuildFlavor).add("branch", this.mBuildBranch).add("serial", this.mDeviceSerial).toString();
    }

    @Override
    public BuildInformation.BuildInfo toProto() {
        BuildInformation.BuildInfo.Builder protoBuilder = BuildInformation.BuildInfo.newBuilder();
        if (this.getBuildId() != null) {
            protoBuilder.setBuildId(this.getBuildId());
        }
        if (this.getBuildFlavor() != null) {
            protoBuilder.setBuildFlavor(this.getBuildFlavor());
        }
        if (this.getBuildBranch() != null) {
            protoBuilder.setBranch(this.getBuildBranch());
        }
        protoBuilder.putAllAttributes(this.getBuildAttributes());
        for (String fileKey : this.mVersionedFileMultiMap.keySet()) {
            BuildInformation.KeyBuildFilePair.Builder buildFile = BuildInformation.KeyBuildFilePair.newBuilder();
            buildFile.setBuildFileKey(fileKey);
            for (VersionedFile vFile : this.mVersionedFileMultiMap.get(fileKey)) {
                BuildInformation.BuildFile.Builder fileInformation = BuildInformation.BuildFile.newBuilder();
                fileInformation.setVersion(vFile.getVersion());
                if (fileKey.startsWith("remote_file:")) {
                    fileInformation.setLocalPath(vFile.getFile().toString());
                } else {
                    fileInformation.setLocalPath(vFile.getFile().getAbsolutePath());
                }
                buildFile.addFile(fileInformation);
            }
            protoBuilder.addVersionedFile(buildFile);
        }
        protoBuilder.setBuildInfoClass(this.getClass().getCanonicalName());
        return protoBuilder.build();
    }

    public final void copyAllFileFrom(BuildInfo build) {
        MultiMap<String, VersionedFile> versionedMap = build.getVersionedFileMapFull();
        for (String versionedFile : versionedMap.keySet()) {
            for (VersionedFile vFile : versionedMap.get(versionedFile)) {
                this.setFile(versionedFile, vFile.getFile(), vFile.getVersion());
            }
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        outputStream.writeObject(this.mVersionedFileMultiMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.mVersionedFileMultiMap = (MultiMap)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            this.mVersionedFileMultiMap = new MultiMap();
        }
    }

    public static IBuildInfo fromProto(BuildInformation.BuildInfo protoBuild) {
        IBuildInfo buildInfo;
        String buildClass = protoBuild.getBuildInfoClass();
        if (buildClass.isEmpty()) {
            buildInfo = new BuildInfo();
        } else {
            try {
                buildInfo = Class.forName(buildClass).asSubclass(BuildInfo.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (!protoBuild.getBuildId().isEmpty()) {
            buildInfo.setBuildId(protoBuild.getBuildId());
        }
        if (!protoBuild.getBuildFlavor().isEmpty()) {
            buildInfo.setBuildFlavor(protoBuild.getBuildFlavor());
        }
        if (!protoBuild.getBranch().isEmpty()) {
            buildInfo.setBuildBranch(protoBuild.getBranch());
        }
        for (String key : protoBuild.getAttributesMap().keySet()) {
            buildInfo.addBuildAttribute(key, protoBuild.getAttributesMap().get(key));
        }
        for (BuildInformation.KeyBuildFilePair filePair : protoBuild.getVersionedFileList()) {
            for (BuildInformation.BuildFile buildFile : filePair.getFileList()) {
                buildInfo.setFile(filePair.getBuildFileKey(), new File(buildFile.getLocalPath()), buildFile.getVersion());
            }
        }
        return buildInfo;
    }

    @Override
    public Set<File> getRemoteFiles() {
        HashSet<File> remoteFiles = new HashSet<File>();
        for (String fileKey : this.mVersionedFileMultiMap.keySet()) {
            if (!fileKey.startsWith("remote_file:")) continue;
            remoteFiles.add(this.mVersionedFileMultiMap.get(fileKey).get(0).getFile());
        }
        return remoteFiles;
    }

    @Override
    public File stageRemoteFile(String fileName, File workingDir) {
        if (this.getRemoteFiles().isEmpty()) {
            return null;
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.STAGE_TESTS_INDIVIDUAL_DOWNLOADS, fileName);
        List<String> includeFilters = Arrays.asList(String.format("/%s?($|/)", fileName));
        try (CloseableTraceScope stage = new CloseableTraceScope("stageRemoteFile:" + fileName);
             TradefedFeatureClient client = new TradefedFeatureClient();){
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("destination_dir", workingDir.getAbsolutePath());
            args.put("include_filters", String.join((CharSequence)";", includeFilters));
            args.put("exclude_filters", "doesntmatch");
            String remotePaths = this.getRemoteFiles().stream().map(p -> p.toString()).collect(Collectors.joining(";"));
            args.put("remote_paths", remotePaths);
            long startTime = System.currentTimeMillis();
            FeatureResponse rep = client.triggerFeature("resolvePartialDownload", args);
            InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.STAGE_REMOTE_TIME, startTime, System.currentTimeMillis());
            if (rep.hasErrorInfo()) {
                throw new HarnessRuntimeException(rep.getErrorInfo().getErrorTrace(), InfraErrorIdentifier.ARTIFACT_DOWNLOAD_ERROR);
            }
        }
        return FileUtil.findFile(workingDir, fileName);
    }
}

