/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import java.util.HashSet;
import java.util.Set;

public class BuildInfoKey {
    public static final Set<BuildInfoFileKey> SHARED_KEY = new HashSet<BuildInfoFileKey>();

    static {
        SHARED_KEY.add(BuildInfoFileKey.PACKAGE_FILES);
        SHARED_KEY.add(BuildInfoFileKey.TESTDIR_IMAGE);
        SHARED_KEY.add(BuildInfoFileKey.ROOT_DIRECTORY);
    }

    public static enum BuildInfoFileKey {
        DEVICE_IMAGE("device", false),
        USERDATA_IMAGE("userdata", false),
        TESTDIR_IMAGE("testsdir", false),
        BASEBAND_IMAGE("baseband", false),
        BOOTLOADER_IMAGE("bootloader", false),
        OTA_IMAGE("ota", false),
        MKBOOTIMG_IMAGE("mkbootimg", false),
        RAMDISK_IMAGE("ramdisk", false),
        ROOT_DIRECTORY("rootdirectory", false),
        TARGET_LINKED_DIR("target_testcases", false),
        HOST_LINKED_DIR("host_testcases", false),
        PACKAGE_FILES("package_files", true);

        private final String mFileKey;
        private final boolean mCanBeList;

        private BuildInfoFileKey(String fileKey, boolean canBeList) {
            this.mFileKey = fileKey;
            this.mCanBeList = canBeList;
        }

        public String getFileKey() {
            return this.mFileKey;
        }

        public boolean isList() {
            return this.mCanBeList;
        }

        public String toString() {
            return this.mFileKey;
        }

        public static BuildInfoFileKey fromString(String keyName) {
            for (BuildInfoFileKey v : BuildInfoFileKey.values()) {
                if (!v.getFileKey().equals(keyName)) continue;
                return v;
            }
            return null;
        }
    }
}

