/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.IDeviceBuildProvider;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.dependency.TestDependencyResolver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.DeviceFlashPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.FlashingResourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DependenciesResolver
implements IBuildProvider,
IDeviceBuildProvider,
IInvocationContextReceiver,
IConfigurationReceiver {
    @Option(name="build-id", description="build id to supply.")
    private String mBuildId = "0";
    @Option(name="branch", description="build branch name to supply.")
    private String mBranch = null;
    @Option(name="build-flavor", description="build flavor name to supply.")
    private String mBuildFlavor = null;
    @Option(name="build-os", description="build os name to supply.")
    private String mBuildOs = "linux";
    @Option(name="dependency", description="The set of dependency to provide for the test")
    private Map<String, File> mDependencies = new LinkedHashMap<String, File>();
    private File mTestsDir;
    private IInvocationContext mInvocationContext;
    private IConfiguration mConfiguration;

    @Override
    public IBuildInfo getBuild(ITestDevice device) throws BuildRetrievalError, DeviceNotAvailableException {
        DeviceBuildInfo build = new DeviceBuildInfo(this.mBuildId, String.format("%s-%s-%s", this.mBranch, this.mBuildOs, this.mBuildFlavor));
        build.setBuildBranch(this.mBranch);
        build.setBuildFlavor(this.mBuildFlavor);
        LinkedHashMap<String, File> mCopiedDependencies = new LinkedHashMap<String, File>(this.mDependencies);
        if (this.isFlasherEnabled(this.mConfiguration.getTargetPreparers())) {
            this.completeFlashingDependencies(mCopiedDependencies);
        }
        FlashingResourceUtil.setUpFlashingResources(build, mCopiedDependencies);
        for (Map.Entry dependency : mCopiedDependencies.entrySet()) {
            File f = TestDependencyResolver.resolveDependencyFromContext((File)dependency.getValue(), build, this.mInvocationContext);
            if (f == null) continue;
            this.getInvocationFiles().put((String)dependency.getKey(), f);
            String version = "1";
            if (f instanceof ExtendedFile) {
                version = ((ExtendedFile)f).getBuildId();
            }
            build.setFile((String)dependency.getKey(), f, version);
        }
        if (build.getTestsDir() == null) {
            try {
                this.mTestsDir = FileUtil.createTempDir("bootstrap-dep-test-dir", CurrentInvocation.getInfo(CurrentInvocation.InvocationInfo.WORK_FOLDER));
            }
            catch (IOException e) {
                throw new BuildRetrievalError(e.getMessage(), (Throwable)e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
            }
            build.setTestsDir(this.mTestsDir, "1");
        }
        return build;
    }

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        throw new IllegalArgumentException("Should not be called");
    }

    @Override
    public void cleanUp(IBuildInfo info) {
        info.cleanUp();
    }

    @Override
    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mInvocationContext = invocationContext;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public final Map<String, File> getDependencies() {
        return this.mDependencies;
    }

    ExecutionFiles getInvocationFiles() {
        return CurrentInvocation.getInvocationFiles();
    }

    private boolean isFlasherEnabled(List<ITargetPreparer> preparers) {
        boolean flashing = false;
        for (ITargetPreparer p : preparers) {
            if (!(p instanceof DeviceFlashPreparer) || ((DeviceFlashPreparer)p).isDisabled()) continue;
            flashing = true;
        }
        return flashing;
    }

    private void completeFlashingDependencies(Map<String, File> dependencies) {
        if (dependencies.containsKey(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey())) {
            return;
        }
        String baseLink = String.format("ab://%s/%s/%s/", this.mBranch, this.mBuildFlavor, this.mBuildId);
        dependencies.put(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey(), new File(baseLink + ".*-img-.*.zip"));
        dependencies.put(BuildInfoKey.BuildInfoFileKey.BOOTLOADER_IMAGE.getFileKey(), new File(baseLink + ".*bootloader.img"));
        dependencies.put(BuildInfoKey.BuildInfoFileKey.BASEBAND_IMAGE.getFileKey(), new File(baseLink + ".*radio.img"));
        dependencies.put(BuildInfoKey.BuildInfoFileKey.RAMDISK_IMAGE.getFileKey(), new File(baseLink + ".*ramdisk.img"));
    }
}

