/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;

public class DeviceBuildDescriptor {
    public static final String DEVICE_BUILD_ID = "device_build_id";
    public static final String DEVICE_BUILD_ALIAS = "device_build_alias";
    public static final String DEVICE_BUILD_FLAVOR = "device_build_flavor";
    public static final String DEVICE_BUILD_BRANCH = "device_build_branch";
    public static final String DEVICE_DESC = "device_description";
    public static final String DEVICE_PRODUCT = "device_product";
    private final IBuildInfo mBuild;

    public DeviceBuildDescriptor(IBuildInfo build) {
        this.mBuild = build;
    }

    public static boolean describesDeviceBuild(IBuildInfo build) {
        return build.getBuildAttributes().containsKey(DEVICE_BUILD_ID);
    }

    public String getDeviceBuildId() {
        return this.mBuild.getBuildAttributes().get(DEVICE_BUILD_ID);
    }

    public String getDeviceBuildAlias() {
        return this.mBuild.getBuildAttributes().get(DEVICE_BUILD_ALIAS);
    }

    public String getDeviceBuildFlavor() {
        return this.mBuild.getBuildAttributes().get(DEVICE_BUILD_FLAVOR);
    }

    public String getDeviceBuildBranch() {
        return this.mBuild.getBuildAttributes().get(DEVICE_BUILD_BRANCH);
    }

    public String getDeviceUserDescription() {
        return this.mBuild.getBuildAttributes().get(DEVICE_DESC);
    }

    public String getDeviceProduct() {
        return this.mBuild.getBuildAttributes().get(DEVICE_PRODUCT);
    }

    public static void injectDeviceAttributes(ITestDevice device, IBuildInfo b) throws DeviceNotAvailableException {
        b.addBuildAttribute(DEVICE_BUILD_ID, device.getBuildId());
        b.addBuildAttribute(DEVICE_BUILD_ALIAS, device.getBuildAlias());
        String buildFlavor = String.format("%s-%s", device.getProperty("ro.product.name"), device.getProperty("ro.build.type"));
        b.addBuildAttribute(DEVICE_BUILD_FLAVOR, buildFlavor);
        b.addBuildAttribute(DEVICE_DESC, DeviceBuildDescriptor.generateDeviceDesc(device));
        b.addBuildAttribute(DEVICE_PRODUCT, DeviceBuildDescriptor.generateDeviceProduct(device));
    }

    public static String generateDeviceDesc(ITestDevice device) throws DeviceNotAvailableException {
        String brand = device.getProperty("ro.product.brand");
        if (brand.length() > 1) {
            brand = String.format("%s%s", brand.substring(0, 1).toUpperCase(), brand.substring(1));
        }
        return String.format("%s %s %s", brand, device.getProperty("ro.product.model"), device.getProperty("ro.build.version.release"));
    }

    public static String generateDeviceProduct(ITestDevice device) throws DeviceNotAvailableException {
        return String.format("%s:%s", device.getProductType(), device.getProductVariant());
    }
}

