/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.FuseUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DeviceFolderBuildInfo
extends DeviceBuildInfo
implements IDeviceBuildInfo,
IFolderBuildInfo {
    private static final long serialVersionUID = 1L;
    private boolean mUseFuseZip;
    private transient FuseUtil mFuseUtil = new FuseUtil();

    public DeviceFolderBuildInfo(String buildId, String buildName) {
        super(buildId, buildName);
        this.mUseFuseZip = false;
    }

    public DeviceFolderBuildInfo(String buildId, String buildName, boolean useFuseZip) {
        super(buildId, buildName);
        this.mUseFuseZip = useFuseZip;
    }

    public DeviceFolderBuildInfo() {
        this.mUseFuseZip = false;
    }

    @Override
    public File getRootDir() {
        return this.getFile(BuildInfoKey.BuildInfoFileKey.ROOT_DIRECTORY);
    }

    @Override
    public void setRootDir(File rootDir) {
        this.setFile(BuildInfoKey.BuildInfoFileKey.ROOT_DIRECTORY, rootDir, BuildInfoKey.BuildInfoFileKey.ROOT_DIRECTORY.getFileKey());
    }

    @Override
    public boolean shouldUseFuseZip() {
        return this.mUseFuseZip;
    }

    public void setFolderBuild(IFolderBuildInfo folderBuild) {
        this.copyAllFileFrom((BuildInfo)((Object)folderBuild));
    }

    public void setDeviceBuild(IDeviceBuildInfo deviceBuild) {
        this.copyAllFileFrom((BuildInfo)((Object)deviceBuild));
    }

    @VisibleForTesting
    FuseUtil getFuseUtil() {
        return this.mFuseUtil;
    }

    @VisibleForTesting
    void setFuseUtil(FuseUtil fuseUtil) {
        this.mFuseUtil = fuseUtil;
    }

    @Override
    protected void addAllFiles(BuildInfo build) throws IOException {
        DeviceFolderBuildInfo folderBuildInfo = (DeviceFolderBuildInfo)build;
        this.mUseFuseZip = folderBuildInfo.shouldUseFuseZip();
        if (!this.mUseFuseZip) {
            super.addAllFiles(build);
            return;
        }
        File rootDir = folderBuildInfo.getRootDir();
        for (Map.Entry<String, VersionedFile> fileEntry : folderBuildInfo.getVersionedFileMap().entrySet()) {
            File copyFile;
            boolean isFuseMountedDir;
            File origFile = fileEntry.getValue().getFile();
            boolean bl = isFuseMountedDir = rootDir != null && rootDir.equals(origFile);
            if (this.applyBuildProperties(fileEntry.getValue(), build, this)) continue;
            if (origFile.isDirectory()) {
                copyFile = FileUtil.createTempDir(fileEntry.getKey());
                if (isFuseMountedDir) {
                    FileUtil.recursiveSymlink(origFile, copyFile);
                } else {
                    FileUtil.recursiveHardlink(origFile, copyFile, false);
                }
            } else {
                copyFile = FileUtil.createTempFile(fileEntry.getKey(), FileUtil.getExtension(origFile.getName()));
                copyFile.delete();
                if (isFuseMountedDir) {
                    FileUtil.symlinkFile(origFile, copyFile);
                } else {
                    FileUtil.hardlinkFile(origFile, copyFile);
                }
            }
            this.setFile(fileEntry.getKey(), copyFile, fileEntry.getValue().getVersion());
        }
    }

    @Override
    public void cleanUp() {
        if (this.mUseFuseZip) {
            File rootDir = this.getRootDir();
            FuseUtil fuseUtil = this.getFuseUtil();
            fuseUtil.unmountZip(rootDir);
            FileUtil.recursiveDelete(rootDir);
        }
        super.cleanUp();
    }
}

