/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class FileDownloadCache {
    private static final char REL_PATH_SEPARATOR = '/';
    private final File mCacheRoot;
    private final Map<String, File> mCacheMap = new CollapsedKeyMap<File>();
    private final ReentrantLock mCacheMapLock = new ReentrantLock();
    private final Map<String, ReentrantLock> mFileLocks = new CollapsedKeyMap<ReentrantLock>();
    private final Map<String, FileLock> mJvmLocks = new CollapsedKeyMap<FileLock>();
    private long mCurrentCacheSize = 0L;
    private long mMaxFileCacheSize = GlobalConfiguration.getInstance().getHostOptions().getCacheSizeLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDownloadCache(File cacheRoot) {
        this.mCacheRoot = cacheRoot;
        if (!this.mCacheRoot.exists()) {
            LogUtil.CLog.d("Creating file cache at %s", this.mCacheRoot.getAbsolutePath());
            if (!this.mCacheRoot.mkdirs()) {
                throw new FatalHostError(String.format("Could not create cache directory at %s", this.mCacheRoot.getAbsolutePath()), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
            }
        } else {
            this.mCacheMapLock.lock();
            try {
                LogUtil.CLog.d("Building file cache from contents at %s", this.mCacheRoot.getAbsolutePath());
                LinkedList<FilePair> cacheEntryList = new LinkedList<FilePair>();
                this.addFiles(this.mCacheRoot, new Stack<String>(), cacheEntryList);
                Collections.sort(cacheEntryList, new FileTimeComparator());
                for (FilePair cacheEntry : cacheEntryList) {
                    this.mCacheMap.put(cacheEntry.mRelPath, cacheEntry.mFile);
                    this.mCurrentCacheSize += cacheEntry.mFile.length();
                }
                if (this.mCurrentCacheSize > this.getMaxFileCacheSize()) {
                    this.incrementAndAdjustCache(0L);
                }
            }
            finally {
                this.mCacheMapLock.unlock();
            }
        }
    }

    private void addFiles(File dir, Stack<String> relPathSegments, List<FilePair> cacheEntryList) {
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            LogUtil.CLog.e("Unable to list files in cache dir %s", dir.getAbsolutePath());
            return;
        }
        for (File childFile : fileList) {
            if (childFile.isDirectory()) {
                relPathSegments.push(childFile.getName());
                this.addFiles(childFile, relPathSegments, cacheEntryList);
                relPathSegments.pop();
                continue;
            }
            if (childFile.isFile()) {
                StringBuffer relPath = new StringBuffer();
                for (String pathSeg : relPathSegments) {
                    relPath.append(pathSeg);
                    relPath.append('/');
                }
                relPath.append(childFile.getName());
                cacheEntryList.add(new FilePair(relPath.toString(), childFile));
                continue;
            }
            LogUtil.CLog.w("Unrecognized file type %s in cache", childFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockFile(String remoteFilePath) {
        ReentrantLock fileLock;
        Map<String, FileLock> map = this.mJvmLocks;
        synchronized (map) {
            File f;
            FileLock fLock = this.mJvmLocks.get(remoteFilePath);
            if (fLock == null && !(f = new File(this.mCacheRoot, this.convertPath(remoteFilePath))).isDirectory()) {
                try {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                    fLock = FileChannel.open(f.toPath(), StandardOpenOption.WRITE).lock();
                    this.mJvmLocks.put(remoteFilePath, fLock);
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
            }
        }
        Map<String, ReentrantLock> map2 = this.mFileLocks;
        synchronized (map2) {
            fileLock = this.mFileLocks.get(remoteFilePath);
            if (fileLock == null) {
                fileLock = new ReentrantLock();
                this.mFileLocks.put(remoteFilePath, fileLock);
            }
        }
        fileLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryLockFile(String remoteFilePath) {
        Map<String, Object> map = this.mJvmLocks;
        synchronized (map) {
            File f;
            FileLock fLock = this.mJvmLocks.get(remoteFilePath);
            if (fLock == null && (f = new File(this.mCacheRoot, this.convertPath(remoteFilePath))).exists() && !f.isDirectory()) {
                try {
                    fLock = FileChannel.open(f.toPath(), StandardOpenOption.WRITE).tryLock();
                    this.mJvmLocks.put(remoteFilePath, fLock);
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (fLock == null) {
                return false;
            }
        }
        map = this.mFileLocks;
        synchronized (map) {
            ReentrantLock fileLock = this.mFileLocks.get(remoteFilePath);
            if (fileLock == null) {
                fileLock = new ReentrantLock();
                this.mFileLocks.put(remoteFilePath, fileLock);
            }
            try {
                return fileLock.tryLock(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockFile(String remoteFilePath) {
        Map<String, Object> map = this.mFileLocks;
        synchronized (map) {
            ReentrantLock fileLock = this.mFileLocks.get(remoteFilePath);
            if (fileLock != null) {
                if (!fileLock.hasQueuedThreads()) {
                    this.mFileLocks.remove(remoteFilePath);
                }
                if (fileLock.isHeldByCurrentThread()) {
                    fileLock.unlock();
                }
            }
        }
        map = this.mJvmLocks;
        synchronized (map) {
            FileLock fLock = this.mJvmLocks.get(remoteFilePath);
            if (fLock != null) {
                this.mJvmLocks.remove(remoteFilePath);
                try {
                    fLock.release();
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
                finally {
                    StreamUtil.close(fLock.channel());
                }
            }
        }
    }

    public void setMaxCacheSize(long numBytes) {
        this.mCacheMapLock.lock();
        this.mMaxFileCacheSize = numBytes;
        this.mCacheMapLock.unlock();
    }

    public void fetchRemoteFile(IFileDownloader downloader, String remoteFilePath, File destFile) throws BuildRetrievalError {
        this.internalfetchRemoteFile(downloader, remoteFilePath, destFile);
    }

    public File fetchRemoteFile(IFileDownloader downloader, String remoteFilePath) throws BuildRetrievalError {
        return this.internalfetchRemoteFile(downloader, remoteFilePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File internalfetchRemoteFile(IFileDownloader downloader, String remotePath, File destFile) throws BuildRetrievalError {
        File copyFile;
        boolean download = false;
        if (remotePath == null) {
            throw new BuildRetrievalError("remote path was null.", (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_REMOTE_PATH_NULL);
        }
        long start = System.currentTimeMillis();
        CloseableTraceScope scope = new CloseableTraceScope("cache_lock");
        this.lockFile(remotePath);
        try {
            File cachedFile;
            this.mCacheMapLock.lock();
            try {
                cachedFile = this.mCacheMap.remove(remotePath);
                if (cachedFile == null) {
                    download = true;
                    String localRelativePath = this.convertPath(remotePath);
                    cachedFile = new File(this.mCacheRoot, localRelativePath);
                }
                this.mCacheMap.put(remotePath, cachedFile);
            }
            finally {
                this.mCacheMapLock.unlock();
            }
            scope.close();
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CACHE_WAIT_FOR_LOCK, System.currentTimeMillis() - start);
            try {
                if (!(download || !cachedFile.exists() || cachedFile.length() != 0L && downloader.isFresh(cachedFile, remotePath))) {
                    LogUtil.CLog.d("Cached file %s for %s is out of date, re-download.", cachedFile, remotePath);
                    FileUtil.recursiveDelete(cachedFile);
                    download = true;
                }
                if (download || !cachedFile.exists()) {
                    cachedFile.getParentFile().mkdirs();
                    if (cachedFile.exists()) {
                        cachedFile.delete();
                    }
                    this.downloadFile(downloader, remotePath, cachedFile);
                } else {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CACHE_HIT_COUNT, 1L);
                    LogUtil.CLog.d("Retrieved remote file %s from cached file %s", remotePath, cachedFile.getAbsolutePath());
                }
                copyFile = this.copyFile(remotePath, cachedFile, destFile);
            }
            catch (BuildRetrievalError | RuntimeException e) {
                this.deleteCacheEntry(remotePath);
                throw e;
            }
            if (download) {
                this.incrementAndAdjustCache(cachedFile.length());
            }
        }
        finally {
            this.unlockFile(remotePath);
        }
        return copyFile;
    }

    private void downloadFile(IFileDownloader downloader, String remotePath, File cachedFile) throws BuildRetrievalError {
        LogUtil.CLog.d("Downloading %s to cache", remotePath);
        downloader.downloadFile(remotePath, cachedFile);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ARTIFACTS_DOWNLOAD_SIZE, cachedFile.length());
    }

    @VisibleForTesting
    File copyFile(String remotePath, File cachedFile, File destFile) throws BuildRetrievalError {
        File hardlinkFile = destFile;
        try {
            if (hardlinkFile == null) {
                hardlinkFile = FileUtil.createTempFileForRemote(remotePath, this.getWorkFolder());
            }
            hardlinkFile.delete();
            LogUtil.CLog.d("Creating hardlink '%s' to '%s'", hardlinkFile.getAbsolutePath(), cachedFile.getAbsolutePath());
            if (cachedFile.isDirectory()) {
                FileUtil.recursiveHardlink(cachedFile, hardlinkFile, false);
            } else {
                FileUtil.hardlinkFile(cachedFile, hardlinkFile);
            }
            return hardlinkFile;
        }
        catch (IOException e) {
            FileUtil.deleteFile(hardlinkFile);
            FileUtil.deleteFile(cachedFile);
            throw new BuildRetrievalError(String.format("Failed to copy cached file %s", cachedFile), (Throwable)e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
        }
    }

    @VisibleForTesting
    File getWorkFolder() {
        return CurrentInvocation.getInfo(CurrentInvocation.InvocationInfo.WORK_FOLDER);
    }

    private String convertPath(String remotePath) {
        if ('/' != File.separatorChar) {
            return remotePath.replace('/', File.separatorChar);
        }
        return remotePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementAndAdjustCache(long length) {
        this.mCacheMapLock.lock();
        try {
            this.mCurrentCacheSize += length;
            Iterator<String> keyIterator = this.mCacheMap.keySet().iterator();
            while (this.mCurrentCacheSize > this.getMaxFileCacheSize() && keyIterator.hasNext()) {
                String remotePath = keyIterator.next();
                if (this.tryLockFile(remotePath)) {
                    try {
                        File file2 = this.mCacheMap.get(remotePath);
                        this.mCurrentCacheSize -= file2.length();
                        file2.delete();
                        keyIterator.remove();
                        continue;
                    }
                    finally {
                        this.unlockFile(remotePath);
                        continue;
                    }
                }
                LogUtil.CLog.i(String.format("File %s is being used by another invocation. Skipping.", remotePath));
            }
            if (this.mCurrentCacheSize < 0L) {
                LogUtil.CLog.e("Cache size is less than 0!");
            } else if (this.mCurrentCacheSize > this.getMaxFileCacheSize()) {
                LogUtil.CLog.w("File cache is over-capacity.");
            }
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    File getCachedFile(String remoteFilePath) {
        this.mCacheMapLock.lock();
        try {
            File file2 = this.mCacheMap.get(remoteFilePath);
            return file2;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    void empty() {
        long currentMax = this.getMaxFileCacheSize();
        this.setMaxCacheSize(0L);
        this.incrementAndAdjustCache(0L);
        this.setMaxCacheSize(currentMax);
    }

    String getOldestEntry() {
        this.mCacheMapLock.lock();
        try {
            if (!this.mCacheMap.isEmpty()) {
                String string = this.mCacheMap.keySet().iterator().next();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    long getMaxFileCacheSize() {
        return this.mMaxFileCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCacheEntry(String remoteFilePath) {
        this.lockFile(remoteFilePath);
        try {
            this.mCacheMapLock.lock();
            try {
                File file2 = this.mCacheMap.remove(remoteFilePath);
                if (file2 != null) {
                    FileUtil.recursiveDelete(file2);
                } else {
                    LogUtil.CLog.i("No cache entry to delete for %s", remoteFilePath);
                }
            }
            finally {
                this.mCacheMapLock.unlock();
            }
        }
        finally {
            this.unlockFile(remoteFilePath);
        }
    }

    private static class CollapsedKeyMap<V>
    extends LinkedHashMap<String, V> {
        private CollapsedKeyMap() {
        }

        @Override
        public V put(String key, V value) {
            return super.put(new File(key).getPath(), value);
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                return super.get(new File((String)key).getPath());
            }
            return super.get(key);
        }

        @Override
        public V remove(Object key) {
            if (key instanceof String) {
                return super.remove(new File((String)key).getPath());
            }
            return super.remove(key);
        }
    }

    private static class FileTimeComparator
    implements Comparator<FilePair> {
        private FileTimeComparator() {
        }

        @Override
        public int compare(FilePair o1, FilePair o2) {
            Long timestamp1 = o1.mFile.lastModified();
            Long timestamp2 = o2.mFile.lastModified();
            return timestamp1.compareTo(timestamp2);
        }
    }

    private static class FilePair {
        final String mRelPath;
        final File mFile;

        FilePair(String relPath, File file2) {
            this.mRelPath = relPath;
            this.mFile = file2;
        }
    }
}

