/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.FileDownloadCache;
import com.android.tradefed.build.FileDownloadCacheFactory;
import com.android.tradefed.build.IFileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FileDownloadCacheWrapper
implements IFileDownloader {
    private final FileDownloadCache mCache;
    private final IFileDownloader mDelegateDownloader;

    public FileDownloadCacheWrapper(File cacheDir, IFileDownloader delegateDownloader) {
        this.mCache = FileDownloadCacheFactory.getInstance().getCache(cacheDir);
        this.mDelegateDownloader = delegateDownloader;
    }

    @Override
    public File downloadFile(String remoteFilePath) throws BuildRetrievalError {
        return this.mCache.fetchRemoteFile(this.mDelegateDownloader, remoteFilePath);
    }

    @Override
    public void downloadFile(String remoteFilePath, File destFile) throws BuildRetrievalError {
        this.mCache.fetchRemoteFile(this.mDelegateDownloader, remoteFilePath, destFile);
    }

    @Override
    public boolean isFresh(File localFile, String remoteFilePath) throws BuildRetrievalError {
        return this.mDelegateDownloader.isFresh(localFile, remoteFilePath);
    }

    @Override
    public void downloadZippedFiles(File destDir, String remoteFilePath, List<String> includeFilters, List<String> excludeFilters) throws BuildRetrievalError, IOException {
        this.mDelegateDownloader.downloadZippedFiles(destDir, remoteFilePath, includeFilters, excludeFilters);
    }
}

