/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="local-app")
public class LocalAppBuildProvider
extends StubBuildProvider {
    private static final String APP_OPTION_NAME = "app-path";
    @Option(name="app-path", description="the local filesystem path to apk.", importance=Option.Importance.IF_UNSET, mandatory=true)
    private Collection<File> mApkPaths = new ArrayList<File>();

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        IBuildInfo parentBuild = super.getBuild();
        for (File apkPath : this.mApkPaths) {
            if (!apkPath.exists()) {
                throw new IllegalArgumentException(String.format("path '%s' does not exist. Please provide a valid file via --%s", apkPath.getAbsolutePath(), APP_OPTION_NAME));
            }
            parentBuild.addAppPackageFile(apkPath, parentBuild.getBuildId());
        }
        return parentBuild;
    }

    @Override
    public void cleanUp(IBuildInfo info) {
    }
}

