/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.FlashingResourcesParser;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

@OptionClass(alias="local-device-build")
public class LocalDeviceBuildProvider
extends StubBuildProvider {
    private static final String BUILD_INFO_FILE = "android-info.txt";
    private static final String BUILD_DIR_OPTION_NAME = "build-dir";
    private String mBootloaderVersion = null;
    private String mRadioVersion = null;
    @Option(name="build-dir", description="the directory containing device files.")
    private File mBuildDir = SystemUtil.getProductOutputDir();
    @Option(name="device-img-pattern", description="the regex use to find device system image zip file within --build-dir.")
    private String mImgPattern = ".*-img-.*\\.zip";
    @Option(name="test-dir", description="the directory containing test artifacts.")
    private File mTestDir = null;
    @Option(name="test-dir-pattern", description="the regex use to find optional test artifact directory within --build-dir. Will be ignored if a test-dir is set.")
    private String mTestDirPattern = ".*-tests-.*";
    @Option(name="bootloader-pattern", description="the regex use to find device bootloader image file within --build-dir.")
    private String mBootloaderPattern = "bootloader.*\\.img";
    @Option(name="radio-pattern", description="the regex use to find device radio image file within --build-dir.")
    private String mRadioPattern = "radio.*\\.img";

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        if (this.mBuildDir == null) {
            throw new BuildRetrievalError("Product output directory is not specified. If running from a Android source tree, make sure `lunch` has been run; if outside, provide a valid path via --build-dir", (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        if (!this.mBuildDir.exists()) {
            throw new BuildRetrievalError(String.format("Directory '%s' does not exist. Please provide a valid path via --%s", this.mBuildDir.getAbsolutePath(), BUILD_DIR_OPTION_NAME), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        if (!this.mBuildDir.isDirectory()) {
            throw new BuildRetrievalError(String.format("Path '%s' is not a directory. Please provide a valid path via --%s", this.mBuildDir.getAbsolutePath(), BUILD_DIR_OPTION_NAME), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        LogUtil.CLog.d("Using device build files from %s", this.mBuildDir.getAbsolutePath());
        BuildInfo stubBuild = (BuildInfo)super.getBuild();
        DeviceBuildInfo buildInfo = new DeviceBuildInfo(stubBuild.getBuildId(), stubBuild.getBuildTargetName());
        buildInfo.addAllBuildAttributes(stubBuild);
        this.setDeviceImageFile(buildInfo);
        this.parseBootloaderAndRadioVersions(buildInfo);
        this.setTestsDir(buildInfo);
        this.setBootloaderImage(buildInfo);
        this.setRadioImage(buildInfo);
        return buildInfo;
    }

    void parseBootloaderAndRadioVersions(DeviceBuildInfo buildInfo) throws BuildRetrievalError {
        try {
            FlashingResourcesParser flashingResourcesParser = new FlashingResourcesParser(buildInfo.getDeviceImageFile());
            this.mBootloaderVersion = flashingResourcesParser.getRequiredBootloaderVersion();
            this.mRadioVersion = flashingResourcesParser.getRequiredBasebandVersion();
        }
        catch (TargetSetupError e) {
            throw new BuildRetrievalError("Unable parse bootloader and radio versions", e);
        }
    }

    @VisibleForTesting
    void setDeviceImageFile(DeviceBuildInfo buildInfo) throws BuildRetrievalError {
        File deviceImgFile = this.findFileInDir(this.mImgPattern);
        if (deviceImgFile == null) {
            LogUtil.CLog.i("Unable to find build image zip on %s", this.mBuildDir.getAbsolutePath());
            deviceImgFile = this.createBuildImageZip();
            if (deviceImgFile == null) {
                throw new BuildRetrievalError(String.format("Could not find device image file matching matching '%s' in '%s'.", this.mImgPattern, this.mBuildDir.getAbsolutePath()), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
            }
        }
        LogUtil.CLog.i("Set build image zip to %s", deviceImgFile.getAbsolutePath());
        buildInfo.setDeviceImageFile(deviceImgFile, buildInfo.getBuildId());
    }

    @VisibleForTesting
    File createBuildImageZip() throws BuildRetrievalError {
        File zipFile = null;
        File[] imageFiles = this.mBuildDir.listFiles(new PatternFilenameFilter(".*\\.img"));
        File buildInfo = this.findFileInDir(BUILD_INFO_FILE);
        ArrayList<File> buildFiles = new ArrayList<File>(Arrays.asList(imageFiles));
        buildFiles.add(buildInfo);
        try {
            zipFile = ZipUtil.createZip(buildFiles);
        }
        catch (IOException e) {
            throw new BuildRetrievalError("Unable to create build image zip file", e);
        }
        LogUtil.CLog.i("Created build image zip on: %s", zipFile.getAbsolutePath());
        return zipFile;
    }

    void setRadioImage(DeviceBuildInfo buildInfo) throws BuildRetrievalError {
        File radioImgFile = this.findFileInDir(this.mRadioPattern);
        if (radioImgFile != null) {
            buildInfo.setBasebandImage(radioImgFile, this.mRadioVersion);
        }
    }

    void setBootloaderImage(DeviceBuildInfo buildInfo) throws BuildRetrievalError {
        File bootloaderImgFile = this.findFileInDir(this.mBootloaderPattern);
        if (bootloaderImgFile != null) {
            buildInfo.setBootloaderImageFile(bootloaderImgFile, this.mBootloaderVersion);
        }
    }

    @VisibleForTesting
    void setTestsDir(DeviceBuildInfo buildInfo) throws BuildRetrievalError {
        File testsDir = null;
        if (this.mTestDir != null) {
            LogUtil.CLog.i("Looking for tests on %s", this.mTestDir.getAbsolutePath());
            testsDir = this.mTestDir;
        } else {
            LogUtil.CLog.i("Looking for tests on %s matching %s", this.mBuildDir.getAbsolutePath(), this.mTestDirPattern);
            testsDir = this.findFileInDir(this.mTestDirPattern);
        }
        if (testsDir != null) {
            buildInfo.setTestsDir(testsDir, buildInfo.getBuildId());
            LogUtil.CLog.d("Using test files from %s", testsDir.getAbsolutePath());
        }
    }

    @VisibleForTesting
    File findFileInDir(String regex) throws BuildRetrievalError {
        return this.findFileInDir(regex, this.mBuildDir);
    }

    @VisibleForTesting
    File findFileInDir(String regex, File dir) throws BuildRetrievalError {
        File[] files = dir.listFiles(new PatternFilenameFilter(regex));
        if (files.length == 0) {
            return null;
        }
        if (files.length > 1) {
            throw new BuildRetrievalError(String.format("Found more than one file matching '%s' in '%s'.", regex, this.mBuildDir.getAbsolutePath()), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        return files[0];
    }

    @Override
    public void cleanUp(IBuildInfo info) {
    }

    String getBootloaderVersion() {
        return this.mBootloaderVersion;
    }

    void setBootloaderVersion(String bootloaderVersion) {
        this.mBootloaderVersion = bootloaderVersion;
    }

    String getRadioVersion() {
        return this.mRadioVersion;
    }

    void setRadioVersion(String radioVersion) {
        this.mRadioVersion = radioVersion;
    }

    File getBuildDir() {
        return this.mBuildDir;
    }

    void setBuildDir(File buildDir) {
        this.mBuildDir = buildDir;
    }

    public File getTestDir() {
        return this.mTestDir;
    }

    void setTestDir(File testDir) {
        this.mTestDir = testDir;
    }

    String getTestDirPattern() {
        return this.mTestDirPattern;
    }

    void setTestDirPattern(String testDirPattern) {
        this.mTestDirPattern = testDirPattern;
    }
}

