/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.FolderBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import java.io.File;

@OptionClass(alias="local-folder")
public class LocalFolderBuildProvider
extends StubBuildProvider {
    private static final String FOLDER_OPTION_NAME = "folder-path";
    @Option(name="folder-path", description="the local filesystem path to build root directory to test.", importance=Option.Importance.IF_UNSET)
    private File mLocalFolder = null;

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        if (this.mLocalFolder == null) {
            throw new IllegalArgumentException(String.format("missing --%s option", FOLDER_OPTION_NAME));
        }
        if (!this.mLocalFolder.exists()) {
            throw new IllegalArgumentException(String.format("path '%s' does not exist. Please provide a valid folder via --%s", this.mLocalFolder.getAbsolutePath(), FOLDER_OPTION_NAME));
        }
        IBuildInfo parentBuild = super.getBuild();
        FolderBuildInfo folderBuild = new FolderBuildInfo((BuildInfo)parentBuild);
        folderBuild.setRootDir(this.mLocalFolder);
        return folderBuild;
    }

    @Override
    public void cleanUp(IBuildInfo info) {
    }
}

