/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.VersionedFile;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class OtaDeviceBuildInfo
extends DeviceBuildInfo {
    private static final long serialVersionUID = 1L;
    private static final String OTA_TOOLS_DIR_KEY_NAME = "otatools-dir";
    private static final String BASELINE_TARGET_FILE_KEY_NAME = "baseline-target-file";
    private static final String TARGET_TARGET_FILE_KEY_NAME = "target-target-file";
    private static final String BASELINE_OTA_TOOLS_KEY_NAME = "baseline-otatools";
    private static final String TARGET_OTA_TOOLS_KEY_NAME = "target-otatools";
    protected IDeviceBuildInfo mOtaBuild;
    protected boolean mReportTargetBuild = false;

    public OtaDeviceBuildInfo() {
    }

    public OtaDeviceBuildInfo(IDeviceBuildInfo buildInfo) {
        super((BuildInfo)((Object)buildInfo));
    }

    public void setOtaBuild(IDeviceBuildInfo otaBuild) {
        this.mOtaBuild = otaBuild;
    }

    public IDeviceBuildInfo getOtaBuild() {
        return this.mOtaBuild;
    }

    public String getBaselineBuildId() {
        return super.getBuildId();
    }

    @Override
    public String getBuildId() {
        if (this.mReportTargetBuild) {
            return this.mOtaBuild.getBuildId();
        }
        return super.getBuildId();
    }

    @Override
    public String getBuildTargetName() {
        if (this.mReportTargetBuild) {
            return this.mOtaBuild.getBuildTargetName();
        }
        return super.getBuildTargetName();
    }

    @Override
    public String getBuildFlavor() {
        if (this.mReportTargetBuild) {
            return this.mOtaBuild.getBuildFlavor();
        }
        return super.getBuildFlavor();
    }

    @Override
    public String getBuildBranch() {
        if (this.mReportTargetBuild) {
            return this.mOtaBuild.getBuildBranch();
        }
        return super.getBuildBranch();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.mOtaBuild != null) {
            this.mOtaBuild.cleanUp();
        }
    }

    @Override
    public void cleanUp(List<File> doNotDelete) {
        super.cleanUp();
        this.mOtaBuild.cleanUp(doNotDelete);
    }

    @Override
    public IBuildInfo clone() {
        OtaDeviceBuildInfo clone = (OtaDeviceBuildInfo)super.clone();
        if (this.mOtaBuild != null) {
            clone.setOtaBuild((IDeviceBuildInfo)this.mOtaBuild.clone());
        }
        return clone;
    }

    @Override
    public Collection<VersionedFile> getFiles() {
        Collection<VersionedFile> combinedFiles = super.getFiles();
        combinedFiles.addAll(this.mOtaBuild.getFiles());
        return combinedFiles;
    }

    public void setReportTargetBuild(boolean downgrade) {
        this.mReportTargetBuild = downgrade;
    }

    public void setOtaTools(File otaTools, String version) {
        this.setFile(OTA_TOOLS_DIR_KEY_NAME, otaTools, version);
    }

    public File getOtaTools() {
        return this.getFile(OTA_TOOLS_DIR_KEY_NAME);
    }

    public void setBaselineTargetFileZip(File file2, String version) {
        this.setFile(BASELINE_TARGET_FILE_KEY_NAME, file2, version);
    }

    public void setTargetTargetFileZip(File file2, String version) {
        this.setFile(TARGET_TARGET_FILE_KEY_NAME, file2, version);
    }

    public File getBaselineTargetFileZip() {
        return this.getFile(BASELINE_TARGET_FILE_KEY_NAME);
    }

    public File getTargetTargetFileZip() {
        return this.getFile(TARGET_TARGET_FILE_KEY_NAME);
    }

    public void setBaselineOtatoolsZip(File file2, String version) {
        this.setFile(BASELINE_OTA_TOOLS_KEY_NAME, file2, version);
    }

    public void setTargetOtatoolsZip(File file2, String version) {
        this.setFile(TARGET_OTA_TOOLS_KEY_NAME, file2, version);
    }

    public File getBaselineOtatoolsZip() {
        return this.getFile(BASELINE_OTA_TOOLS_KEY_NAME);
    }

    public File getTargetOtatoolsZip() {
        return this.getFile(TARGET_OTA_TOOLS_KEY_NAME);
    }
}

