/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="stub")
public class StubBuildProvider
implements IBuildProvider {
    @Option(name="build-id", description="build id to supply.")
    private String mBuildId = "0";
    @Option(name="build-target", description="build target name to supply.")
    private String mBuildTargetName = "stub";
    @Option(name="branch", description="build branch name to supply.")
    private String mBranch = null;
    @Option(name="build-flavor", description="build flavor name to supply.")
    private String mBuildFlavor = null;
    @Option(name="build-os", description="build os name to supply.")
    private String mBuildOs = "linux";
    @Option(name="build-attribute", description="build attributes to supply.")
    private Map<String, String> mBuildAttributes = new HashMap<String, String>();
    @Option(name="return-null", description="force the stub provider to return a null build. Used for testing.")
    private boolean mReturnNull = false;
    @Option(name="throw-build-error", description="force the stub provider to throw a BuildRetrievalError. Used for testing.")
    private boolean mThrowError = false;
    private static final Set<String> STANDARD_PLATFORMS = new HashSet<String>(Arrays.asList("linux", "mac"));

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        if (this.mReturnNull) {
            LogUtil.CLog.d("Returning a null build.");
            return null;
        }
        if (this.mThrowError) {
            throw new BuildRetrievalError("stub failed to get build.", (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        LogUtil.CLog.d("skipping build provider step");
        BuildInfo stubBuild = new BuildInfo(this.mBuildId, this.mBuildTargetName);
        stubBuild.setBuildBranch(this.mBranch);
        stubBuild.setBuildFlavor(this.mBuildFlavor);
        String buildTarget = this.mBuildFlavor;
        if (!STANDARD_PLATFORMS.contains(this.mBuildOs)) {
            buildTarget = buildTarget + "_" + this.mBuildOs;
        }
        if (buildTarget != null) {
            stubBuild.addBuildAttribute("build_target", buildTarget);
        }
        for (Map.Entry<String, String> attributeEntry : this.mBuildAttributes.entrySet()) {
            stubBuild.addBuildAttribute(attributeEntry.getKey(), attributeEntry.getValue());
        }
        return stubBuild;
    }

    @Override
    public void cleanUp(IBuildInfo info) {
    }
}

