/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build.cache;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PartialZipDownloadCache {
    private static PartialZipDownloadCache sDefaultInstance;
    private final LoadingCache<String, File> mFileCache;
    private final File mCacheDir;

    public static PartialZipDownloadCache getDefaultCache() {
        if (sDefaultInstance == null) {
            sDefaultInstance = new PartialZipDownloadCache();
        }
        return sDefaultInstance;
    }

    protected PartialZipDownloadCache() {
        try {
            this.mCacheDir = FileUtil.createTempDir("partial_download_cache_dir");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LoadingCache<String, File> loadingCache = PartialZipDownloadCache.this.mFileCache;
                    synchronized (loadingCache) {
                        FileUtil.recursiveDelete(PartialZipDownloadCache.this.mCacheDir);
                        PartialZipDownloadCache.this.mFileCache.invalidateAll();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RemovalListener<String, File> listener = new RemovalListener<String, File>(){

            @Override
            public void onRemoval(RemovalNotification<String, File> n) {
                if (n.wasEvicted()) {
                    FileUtil.deleteFile((File)n.getValue());
                }
            }
        };
        this.mFileCache = CacheBuilder.newBuilder().maximumSize(20000L).expireAfterAccess(3L, TimeUnit.HOURS).removalListener(listener).build(new CacheLoader<String, File>(){

            @Override
            public File load(String key) throws IOException {
                File cachedFile = new File(PartialZipDownloadCache.this.mCacheDir, key);
                if (cachedFile.exists()) {
                    return cachedFile;
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCachedFile(File targetFile, String fileName, String crc) {
        String key = String.format("%s:%s", fileName, crc);
        try {
            LoadingCache<String, File> loadingCache = this.mFileCache;
            synchronized (loadingCache) {
                File cachedFile = (File)this.mFileCache.getIfPresent(key);
                if (cachedFile != null) {
                    targetFile.getParentFile().mkdirs();
                    FileUtil.hardlinkFile(cachedFile, targetFile, true);
                    return true;
                }
                this.mFileCache.invalidate(key);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCacheFile(File toCache, String fileName, String crc) {
        LoadingCache<String, File> loadingCache = this.mFileCache;
        synchronized (loadingCache) {
            String key = String.format("%s:%s", fileName, crc);
            File cacheDestination = new File(this.mCacheDir, key);
            cacheDestination.getParentFile().mkdirs();
            FileUtil.deleteFile(cacheDestination);
            try {
                FileUtil.hardlinkFile(toCache, cacheDestination, true);
                this.mFileCache.put(key, cacheDestination);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    protected void cleanUpCache() {
        this.mFileCache.invalidateAll();
        FileUtil.recursiveDelete(this.mCacheDir);
    }
}

