/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build.gcs;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.FileDownloadCache;
import com.android.tradefed.build.FileDownloadCacheFactory;
import com.android.tradefed.build.FileDownloadCacheWrapper;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.util.GCSFileDownloader;
import java.io.File;

public class GCSDownloaderHelper {
    private IFileDownloader mFileDownloader = null;

    public void fetchTestResource(File destFile, String gsPath) throws BuildRetrievalError {
        try {
            this.getGCSFileDownloader().downloadFile(gsPath, destFile);
        }
        catch (BuildRetrievalError e) {
            this.deleteCacheEntry(gsPath);
            throw e;
        }
    }

    public File fetchTestResource(String gsPath) throws BuildRetrievalError {
        try {
            return this.getGCSFileDownloader().downloadFile(gsPath);
        }
        catch (BuildRetrievalError e) {
            this.deleteCacheEntry(gsPath);
            throw e;
        }
    }

    private IFileDownloader getGCSFileDownloader() {
        if (this.mFileDownloader == null) {
            this.mFileDownloader = new FileDownloadCacheWrapper(this.getHostOptions().getDownloadCacheDir(), new GCSFileDownloader());
        }
        return this.mFileDownloader;
    }

    private IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    private void deleteCacheEntry(String remoteFilePath) {
        if (remoteFilePath != null) {
            FileDownloadCache cache = FileDownloadCacheFactory.getInstance().getCache(this.getHostOptions().getDownloadCacheDir());
            cache.deleteCacheEntry(remoteFilePath);
        }
    }
}

