/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cache;

import com.android.tradefed.util.FileUtil;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModifiedFilesParser {
    private static final Set<String> INOP_IMAGE_CHANGES = ImmutableSet.of("build.prop", "prop.default");
    private final File mModifiedFilesJson;
    private final boolean mIsDeviceImage;
    private final List<String> added;
    private final List<String> changed;
    private final List<String> removed;
    private boolean mParsingDone = false;

    public ModifiedFilesParser(File modifiedFilesJson, boolean isDeviceImage) {
        this.mModifiedFilesJson = modifiedFilesJson;
        this.mIsDeviceImage = isDeviceImage;
        this.added = new ArrayList<String>();
        this.changed = new ArrayList<String>();
        this.removed = new ArrayList<String>();
    }

    public void parse() throws IOException, JSONException {
        if (this.mParsingDone) {
            throw new IllegalStateException("parse() was called twice.");
        }
        JSONObject content = new JSONObject(FileUtil.readStringFromFile(this.mModifiedFilesJson));
        JSONArray addedArray = content.getJSONArray("added");
        for (int i = 0; i < addedArray.length(); ++i) {
            String file2 = (String)addedArray.opt(i);
            this.added.add(file2);
        }
        JSONArray changedArray = content.getJSONArray("changed");
        for (int i = 0; i < changedArray.length(); ++i) {
            String file3 = (String)changedArray.opt(i);
            this.changed.add(file3);
        }
        JSONArray removedArray = content.getJSONArray("removed");
        for (int i = 0; i < removedArray.length(); ++i) {
            String file4 = (String)removedArray.opt(i);
            this.removed.add(file4);
        }
        this.mParsingDone = true;
    }

    public boolean hasImageChanged() {
        if (!this.mParsingDone) {
            throw new IllegalStateException("parse() hasn't been called yet.");
        }
        if (!this.mIsDeviceImage) {
            throw new IllegalStateException("modified_files was not marked as device image.");
        }
        if (!this.added.isEmpty() || !this.removed.isEmpty()) {
            return true;
        }
        for (String files : this.changed) {
            if (INOP_IMAGE_CHANGES.contains(new File(files).getName())) continue;
            return true;
        }
        return false;
    }
}

