/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.clearcut;

import com.android.asuite.clearcut.Clientanalytics;
import com.android.asuite.clearcut.Common;
import com.android.tradefed.clearcut.ClearcutEventHelper;
import com.android.tradefed.clearcut.NoticeMessageUtil;
import com.android.tradefed.internal.protobuf.util.JsonFormat;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.net.HttpHelper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ClearcutClient {
    public static final String DISABLE_CLEARCUT_KEY = "DISABLE_CLEARCUT";
    private static final String CLEARCUT_SUB_TOOL_NAME = "CLEARCUT_SUB_TOOL_NAME";
    private static final String CLEARCUT_PROD_URL = "https://play.googleapis.com/log";
    private static final int CLIENT_TYPE = 1;
    private static final int INTERNAL_LOG_SOURCE = 971;
    private static final int EXTERNAL_LOG_SOURCE = 934;
    private static final long SCHEDULER_INITIAL_DELAY_MILLISECONDS = 1000L;
    private static final long SCHEDULER_PERDIOC_MILLISECONDS = 250L;
    private static final String GOOGLE_EMAIL = "@google.com";
    private static final String GOOGLE_HOSTNAME = ".google.com";
    private File mCachedUuidFile = new File(System.getProperty("user.home"), ".tradefed");
    private String mRunId;
    private long mSessionStartTime = 0L;
    private final int mLogSource;
    private final String mUrl;
    private final Common.UserType mUserType;
    private final String mSubToolName;
    private List<Clientanalytics.LogRequest> mExternalEventQueue;
    private ScheduledThreadPoolExecutor mExecutor;
    private boolean mDisabled = this.isClearcutDisabled();

    public ClearcutClient(String subToolName) {
        this(null, subToolName);
    }

    protected ClearcutClient(String url, String subToolName) {
        if (!this.mDisabled && this.isGoogleUser()) {
            this.mLogSource = 971;
            this.mUserType = Common.UserType.GOOGLE;
        } else {
            this.mLogSource = 934;
            this.mUserType = Common.UserType.EXTERNAL;
        }
        this.mUrl = url == null ? CLEARCUT_PROD_URL : url;
        this.mRunId = UUID.randomUUID().toString();
        this.mExternalEventQueue = new ArrayList<Clientanalytics.LogRequest>();
        this.mSubToolName = Strings.isNullOrEmpty(subToolName) && System.getenv(CLEARCUT_SUB_TOOL_NAME) != null ? System.getenv(CLEARCUT_SUB_TOOL_NAME) : subToolName;
        if (this.mDisabled) {
            return;
        }
        System.out.println(NoticeMessageUtil.getNoticeMessage(this.mUserType));
        this.mExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("clearcut-client-thread");
                return t;
            }
        });
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ClearcutClient.this.flushEvents();
            }
        };
        this.mExecutor.scheduleAtFixedRate(command, 1000L, 250L, TimeUnit.MILLISECONDS);
    }

    public void notifyTradefedStartEvent() {
        if (this.mDisabled) {
            return;
        }
        this.mSessionStartTime = System.nanoTime();
        long eventTimeMs = System.currentTimeMillis();
        CompletableFuture.supplyAsync(() -> this.createStartEvent(eventTimeMs));
    }

    private boolean createStartEvent(long eventTimeMs) {
        Clientanalytics.LogRequest.Builder request = this.createBaseLogRequest();
        Clientanalytics.LogEvent.Builder logEvent = Clientanalytics.LogEvent.newBuilder();
        logEvent.setEventTimeMs(eventTimeMs);
        logEvent.setSourceExtension(ClearcutEventHelper.createStartEvent(this.getGroupingKey(), this.mRunId, this.mUserType, this.mSubToolName));
        request.addLogEvent(logEvent);
        this.queueEvent(request.build());
        return true;
    }

    public void notifyTradefedFinishedEvent() {
        if (this.mDisabled) {
            return;
        }
        Duration duration = Duration.ofNanos(System.nanoTime() - this.mSessionStartTime);
        Clientanalytics.LogRequest.Builder request = this.createBaseLogRequest();
        Clientanalytics.LogEvent.Builder logEvent = Clientanalytics.LogEvent.newBuilder();
        logEvent.setEventTimeMs(System.currentTimeMillis());
        logEvent.setSourceExtension(ClearcutEventHelper.createFinishedEvent(this.getGroupingKey(), this.mRunId, this.mUserType, this.mSubToolName, duration));
        request.addLogEvent(logEvent);
        this.queueEvent(request.build());
    }

    public void notifyTradefedInvocationStartEvent() {
        if (this.mDisabled) {
            return;
        }
        Clientanalytics.LogRequest.Builder request = this.createBaseLogRequest();
        Clientanalytics.LogEvent.Builder logEvent = Clientanalytics.LogEvent.newBuilder();
        logEvent.setEventTimeMs(System.currentTimeMillis());
        logEvent.setSourceExtension(ClearcutEventHelper.createRunStartEvent(this.getGroupingKey(), this.mRunId, this.mUserType, this.mSubToolName));
        request.addLogEvent(logEvent);
        this.queueEvent(request.build());
    }

    public void notifyTestRunFinished(long startTimeNano) {
        if (this.mDisabled) {
            return;
        }
        Duration duration = Duration.ofNanos(System.nanoTime() - startTimeNano);
        Clientanalytics.LogRequest.Builder request = this.createBaseLogRequest();
        Clientanalytics.LogEvent.Builder logEvent = Clientanalytics.LogEvent.newBuilder();
        logEvent.setEventTimeMs(System.currentTimeMillis());
        logEvent.setSourceExtension(ClearcutEventHelper.creatRunTestFinished(this.getGroupingKey(), this.mRunId, this.mUserType, this.mSubToolName, duration));
        request.addLogEvent(logEvent);
        this.queueEvent(request.build());
    }

    public void stop() {
        if (this.mExecutor != null) {
            this.mExecutor.setRemoveOnCancelPolicy(true);
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
        this.flushEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(Clientanalytics.LogRequest event) {
        List<Clientanalytics.LogRequest> list2 = this.mExternalEventQueue;
        synchronized (list2) {
            this.mExternalEventQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getQueueSize() {
        List<Clientanalytics.LogRequest> list2 = this.mExternalEventQueue;
        synchronized (list2) {
            return this.mExternalEventQueue.size();
        }
    }

    public void setCachedUuidFile(File uuidFile) {
        this.mCachedUuidFile = uuidFile;
    }

    String getGroupingKey() {
        String uuid = null;
        if (this.mCachedUuidFile.exists()) {
            try {
                uuid = FileUtil.readStringFromFile(this.mCachedUuidFile);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        if (uuid == null || uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
            try {
                FileUtil.writeToFile(uuid, this.mCachedUuidFile);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        return uuid;
    }

    public boolean isClearcutDisabled() {
        return "1".equals(System.getenv(DISABLE_CLEARCUT_KEY));
    }

    boolean isGoogleUser() {
        String stdout;
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            if (hostname.contains(GOOGLE_HOSTNAME)) {
                return true;
            }
        }
        catch (UnknownHostException hostname) {
            // empty catch block
        }
        CommandResult gitRes = RunUtil.getDefault().runTimedCmdSilently(60000L, "git", "config", "--get", "user.email");
        return CommandStatus.SUCCESS.equals((Object)gitRes.getStatus()) && (stdout = gitRes.getStdout()) != null && stdout.trim().endsWith(GOOGLE_EMAIL);
    }

    private Clientanalytics.LogRequest.Builder createBaseLogRequest() {
        Clientanalytics.LogRequest.Builder request = Clientanalytics.LogRequest.newBuilder();
        request.setLogSource(this.mLogSource);
        request.setClientInfo(Clientanalytics.ClientInfo.newBuilder().setClientType(1));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEvents() {
        ArrayList<Clientanalytics.LogRequest> copy = new ArrayList<Clientanalytics.LogRequest>();
        List<Clientanalytics.LogRequest> list2 = this.mExternalEventQueue;
        synchronized (list2) {
            copy.addAll(this.mExternalEventQueue);
            this.mExternalEventQueue.clear();
        }
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        while (!copy.isEmpty()) {
            Clientanalytics.LogRequest event = (Clientanalytics.LogRequest)copy.remove(0);
            futures.add(CompletableFuture.supplyAsync(() -> this.sendToClearcut(event)));
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendToClearcut(Clientanalytics.LogRequest event) {
        block12: {
            HttpHelper helper = new HttpHelper();
            InputStream inputStream = null;
            InputStream errorStream = null;
            OutputStream outputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                try (CloseableTraceScope ignored = new CloseableTraceScope("sendToClearcut");){
                    HttpURLConnection connection = helper.createConnection(new URL(this.mUrl), "POST", "text");
                    outputStream = connection.getOutputStream();
                    outputStreamWriter = new OutputStreamWriter(outputStream);
                    String jsonObject = JsonFormat.printer().preservingProtoFieldNames().print(event);
                    outputStreamWriter.write(jsonObject.toString());
                    outputStreamWriter.flush();
                    inputStream = connection.getInputStream();
                    Clientanalytics.LogResponse response = Clientanalytics.LogResponse.parseFrom(inputStream);
                    errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        String message2 = StreamUtil.getStringFromStream(errorStream);
                        LogUtil.CLog.e("Error posting clearcut event: '%s'. LogResponse: '%s'", message2, response);
                    }
                }
                StreamUtil.close(outputStream);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                break block12;
            }
            finally {
                StreamUtil.close(outputStream);
                StreamUtil.close(inputStream);
                StreamUtil.close(outputStreamWriter);
                StreamUtil.close(errorStream);
            }
            StreamUtil.close(inputStream);
            StreamUtil.close(outputStreamWriter);
            StreamUtil.close(errorStream);
        }
        return true;
    }
}

