/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.clearcut;

import com.android.asuite.clearcut.Common;
import com.android.asuite.clearcut.ExternalUserLog;
import com.android.asuite.clearcut.InternalUserLog;
import com.android.tradefed.internal.protobuf.ByteString;
import java.time.Duration;

public class ClearcutEventHelper {
    private static final String TOOL_NAME = "Tradefed";

    public static ByteString createStartEvent(String userKey, String runId, Common.UserType userType, String subToolName) {
        if (Common.UserType.GOOGLE.equals(userType)) {
            InternalUserLog.AtestLogEventInternal.Builder builder = ClearcutEventHelper.createBaseInternalEventBuilder(userKey, runId, userType, subToolName);
            InternalUserLog.AtestLogEventInternal.AtestStartEvent.Builder startEventBuilder = InternalUserLog.AtestLogEventInternal.AtestStartEvent.newBuilder();
            builder.setAtestStartEvent(startEventBuilder.build());
            return builder.build().toByteString();
        }
        ExternalUserLog.AtestLogEventExternal.Builder builder = ClearcutEventHelper.createBaseExternalEventBuilder(userKey, runId, userType, subToolName);
        ExternalUserLog.AtestLogEventExternal.AtestStartEvent.Builder startBuilder = ExternalUserLog.AtestLogEventExternal.AtestStartEvent.newBuilder();
        builder.setAtestStartEvent(startBuilder.build());
        return builder.build().toByteString();
    }

    public static ByteString createFinishedEvent(String userKey, String runId, Common.UserType userType, String subToolName, Duration sessionDuration) {
        if (Common.UserType.GOOGLE.equals(userType)) {
            InternalUserLog.AtestLogEventInternal.Builder builder = ClearcutEventHelper.createBaseInternalEventBuilder(userKey, runId, userType, subToolName);
            InternalUserLog.AtestLogEventInternal.AtestExitEvent.Builder exitEventBuilder = InternalUserLog.AtestLogEventInternal.AtestExitEvent.newBuilder();
            Common.Duration duration = Common.Duration.newBuilder().setSeconds(sessionDuration.getSeconds()).setNanos(sessionDuration.getNano()).build();
            exitEventBuilder.setDuration(duration);
            builder.setAtestExitEvent(exitEventBuilder.build());
            return builder.build().toByteString();
        }
        ExternalUserLog.AtestLogEventExternal.Builder builder = ClearcutEventHelper.createBaseExternalEventBuilder(userKey, runId, userType, subToolName);
        ExternalUserLog.AtestLogEventExternal.AtestExitEvent.Builder startBuilder = ExternalUserLog.AtestLogEventExternal.AtestExitEvent.newBuilder();
        builder.setAtestExitEvent(startBuilder.build());
        return builder.build().toByteString();
    }

    public static ByteString createRunStartEvent(String userKey, String runId, Common.UserType userType, String subToolName) {
        if (Common.UserType.GOOGLE.equals(userType)) {
            InternalUserLog.AtestLogEventInternal.Builder builder = ClearcutEventHelper.createBaseInternalEventBuilder(userKey, runId, userType, subToolName);
            InternalUserLog.AtestLogEventInternal.RunnerFinishEvent.Builder startRunEventBuilder = InternalUserLog.AtestLogEventInternal.RunnerFinishEvent.newBuilder();
            builder.setRunnerFinishEvent(startRunEventBuilder.build());
            return builder.build().toByteString();
        }
        ExternalUserLog.AtestLogEventExternal.Builder builder = ClearcutEventHelper.createBaseExternalEventBuilder(userKey, runId, userType, subToolName);
        ExternalUserLog.AtestLogEventExternal.RunnerFinishEvent.Builder startBuilder = ExternalUserLog.AtestLogEventExternal.RunnerFinishEvent.newBuilder();
        builder.setRunnerFinishEvent(startBuilder.build());
        return builder.build().toByteString();
    }

    public static ByteString creatRunTestFinished(String userKey, String runId, Common.UserType userType, String subToolName, Duration testDuration) {
        if (Common.UserType.GOOGLE.equals(userType)) {
            InternalUserLog.AtestLogEventInternal.Builder builder = ClearcutEventHelper.createBaseInternalEventBuilder(userKey, runId, userType, subToolName);
            InternalUserLog.AtestLogEventInternal.RunTestsFinishEvent.Builder runTestsFinished = InternalUserLog.AtestLogEventInternal.RunTestsFinishEvent.newBuilder();
            Common.Duration duration = Common.Duration.newBuilder().setSeconds(testDuration.getSeconds()).setNanos(testDuration.getNano()).build();
            runTestsFinished.setDuration(duration);
            builder.setRunTestsFinishEvent(runTestsFinished.build());
            return builder.build().toByteString();
        }
        ExternalUserLog.AtestLogEventExternal.Builder builder = ClearcutEventHelper.createBaseExternalEventBuilder(userKey, runId, userType, subToolName);
        ExternalUserLog.AtestLogEventExternal.RunTestsFinishEvent.Builder startBuilder = ExternalUserLog.AtestLogEventExternal.RunTestsFinishEvent.newBuilder();
        builder.setRunTestsFinishEvent(startBuilder.build());
        return builder.build().toByteString();
    }

    private static ExternalUserLog.AtestLogEventExternal.Builder createBaseExternalEventBuilder(String userKey, String runId, Common.UserType userType, String subToolName) {
        ExternalUserLog.AtestLogEventExternal.Builder builder = ExternalUserLog.AtestLogEventExternal.newBuilder();
        builder.setUserKey(userKey);
        builder.setRunId(runId);
        builder.setUserType(userType);
        builder.setToolName(TOOL_NAME);
        builder.setSubToolName(subToolName);
        return builder;
    }

    private static InternalUserLog.AtestLogEventInternal.Builder createBaseInternalEventBuilder(String userKey, String runId, Common.UserType userType, String subToolName) {
        InternalUserLog.AtestLogEventInternal.Builder builder = InternalUserLog.AtestLogEventInternal.newBuilder();
        builder.setUserKey(userKey);
        builder.setRunId(runId);
        builder.setUserType(userType);
        builder.setToolName(TOOL_NAME);
        builder.setSubToolName(subToolName);
        return builder;
    }
}

