/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.cluster.ClusterBuildInfo;
import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.cluster.TestResourceDownloader;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.logger.InvocationLocal;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.FuseUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="cluster", global_namespace=false)
public class ClusterBuildProvider
implements IBuildProvider {
    private static final String DEFAULT_FILE_VERSION = "0";
    @Option(name="root-dir", description="A root directory", mandatory=true)
    private File mRootDir;
    @Option(name="test-resource", description="A list of JSON-serialized test resource objects", mandatory=true)
    private List<String> mTestResources = new ArrayList<String>();
    @Option(name="build-id", description="Build ID")
    private String mBuildId = "-1";
    @Option(name="build-target", description="Build target name")
    private String mBuildTarget = "stub";
    static final InvocationLocal<ConcurrentHashMap<String, File>> sDownloadCache = new InvocationLocal<ConcurrentHashMap<String, File>>(){

        @Override
        protected ConcurrentHashMap<String, File> initialValue() {
            return new ConcurrentHashMap<String, File>();
        }
    };
    static final InvocationLocal<ConcurrentHashMap<String, File>> sCreatedResources = new InvocationLocal<ConcurrentHashMap<String, File>>(){

        @Override
        protected ConcurrentHashMap<String, File> initialValue() {
            return new ConcurrentHashMap<String, File>();
        }
    };

    private List<TestResource> parseTestResources() {
        ArrayList<TestResource> objs = new ArrayList<TestResource>();
        for (String s : this.mTestResources) {
            try {
                JSONObject json = new JSONObject(s);
                TestResource obj = TestResource.fromJson(json);
                objs.add(obj);
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse a test resource option: " + s, e);
            }
        }
        return objs;
    }

    @Override
    public IBuildInfo getBuild() throws BuildRetrievalError {
        this.mRootDir.mkdirs();
        ClusterBuildInfo buildInfo = new ClusterBuildInfo(this.mRootDir, this.mBuildId, this.mBuildTarget);
        TestResourceDownloader downloader = this.createTestResourceDownloader();
        ConcurrentHashMap<String, File> cache = sDownloadCache.get();
        ConcurrentHashMap<String, File> createdResources = sCreatedResources.get();
        List<TestResource> testResources = this.parseTestResources();
        for (TestResource resource : testResources) {
            File file2;
            if (resource.getName().endsWith(".zip") && !resource.getDecompress()) {
                resource = new TestResource(resource.getName(), resource.getUrl(), true, new File(resource.getName()).getParent(), resource.mountZip(), resource.getDecompressFiles());
            }
            File resourceFile = resource.getFile(this.mRootDir);
            ClusterBuildProvider.validateTestResourceFile(this.mRootDir, resourceFile);
            if (resource.getDecompress()) {
                File dir = resource.getDecompressDir(this.mRootDir);
                ClusterBuildProvider.validateTestResourceFile(this.mRootDir, dir);
                for (String name : resource.getDecompressFiles()) {
                    ClusterBuildProvider.validateTestResourceFile(dir, new File(dir, name));
                }
            }
            try {
                File cachedFile = this.retrieveFile(resource.getUrl(), cache, downloader, resourceFile);
                file2 = this.prepareTestResource(resource, createdResources, cachedFile, buildInfo);
            }
            catch (UncheckedIOException e) {
                throw new BuildRetrievalError("failed to get test resources", e);
            }
            buildInfo.setFile(resource.getName(), file2, DEFAULT_FILE_VERSION);
        }
        return buildInfo;
    }

    private static void validateTestResourceFile(File workDir, File file2) throws BuildRetrievalError {
        if (!file2.toPath().normalize().startsWith(workDir.toPath().normalize())) {
            throw new BuildRetrievalError(file2 + " is outside of working directory.");
        }
    }

    private File retrieveFile(String downloadUrl, ConcurrentHashMap<String, File> cache, TestResourceDownloader downloader, File downloadDest) {
        return cache.computeIfAbsent(downloadUrl, url -> {
            LogUtil.CLog.i("Download %s from %s.", downloadDest, url);
            try {
                downloader.download((String)url, downloadDest);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return downloadDest;
        });
    }

    private File prepareTestResource(TestResource resource, ConcurrentHashMap<String, File> createdResources, File source, ClusterBuildInfo buildInfo) {
        return createdResources.computeIfAbsent(resource.getName(), name -> {
            File file2 = resource.getFile(this.mRootDir);
            if (!source.equals(file2)) {
                if (file2.exists()) {
                    LogUtil.CLog.w("Overwrite %s.", name);
                    file2.delete();
                } else {
                    LogUtil.CLog.i("Create %s.", name);
                    file2.getParentFile().mkdirs();
                }
                try {
                    FileUtil.hardlinkFile(source, file2);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (resource.getDecompress()) {
                File dir = resource.getDecompressDir(this.mRootDir);
                try {
                    this.decompressArchive(file2, dir, resource.mountZip(), resource.getDecompressFiles(), buildInfo);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return dir;
            }
            return file2;
        });
    }

    FuseUtil getFuseUtil() {
        return new FuseUtil();
    }

    private void decompressArchive(File archive, File destDir, boolean mountZip, List<String> fileNames, ClusterBuildInfo buildInfo) throws IOException {
        if (!destDir.exists() && !destDir.mkdirs()) {
            LogUtil.CLog.e("Cannot create %s.", destDir);
        }
        if (TarUtil.isGzip(archive)) {
            this.decompressTarGzip(archive, destDir, fileNames);
            return;
        }
        if (mountZip) {
            FuseUtil fuseUtil = this.getFuseUtil();
            if (fuseUtil.canMountZip()) {
                File mountDir = this.mountZip(fuseUtil, archive, buildInfo);
                this.symlinkFiles(mountDir, destDir, fileNames);
                return;
            }
            LogUtil.CLog.w("Mounting zip requested but not supported; falling back to extracting...");
        }
        this.decompressZip(archive, destDir, fileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompressTarGzip(File archive, File destDir, List<String> fileNames) throws IOException {
        File unGzipDir = FileUtil.createTempDir("ClusterBuildProviderUnGzip");
        try {
            File tar = TarUtil.unGzip(archive, unGzipDir);
            if (fileNames.isEmpty()) {
                TarUtil.unTar(tar, destDir);
            } else {
                TarUtil.unTar(tar, destDir, fileNames);
            }
        }
        finally {
            FileUtil.recursiveDelete(unGzipDir);
        }
    }

    private File mountZip(FuseUtil fuseUtil, File archive, ClusterBuildInfo buildInfo) throws IOException {
        File mountDir = FileUtil.createTempDir("ClusterBuildProviderZipMount");
        buildInfo.addZipMount(mountDir);
        LogUtil.CLog.i("Mounting %s to %s...", archive, mountDir);
        fuseUtil.mountZip(archive, mountDir);
        return mountDir;
    }

    private void symlinkFiles(File origDir, File destDir, List<String> fileNames) throws IOException {
        if (fileNames.isEmpty()) {
            LogUtil.CLog.i("Recursive symlink %s to %s...", origDir, destDir);
            FileUtil.recursiveSymlink(origDir, destDir);
        } else {
            for (String name : fileNames) {
                File origFile = new File(origDir, name);
                if (!origFile.exists()) {
                    throw new IOException(String.format("%s does not exist.", origFile));
                }
                File destFile = new File(destDir, name);
                LogUtil.CLog.i("Symlink %s to %s", origFile, destFile);
                destFile.getParentFile().mkdirs();
                FileUtil.symlinkFile(origFile, destFile);
            }
        }
    }

    private void decompressZip(File archive, File destDir, List<String> fileNames) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            if (fileNames.isEmpty()) {
                LogUtil.CLog.i("Extracting %s to %s...", archive, destDir);
                ZipUtil2.extractZip(zip, destDir);
            } else {
                for (String name : fileNames) {
                    File destFile = new File(destDir, name);
                    LogUtil.CLog.i("Extracting %s from %s to %s", name, archive, destFile);
                    destFile.getParentFile().mkdirs();
                    if (ZipUtil2.extractFileFromZip(zip, name, destFile)) continue;
                    throw new IOException(String.format("%s is not found in %s", name, archive));
                }
            }
        }
    }

    @Override
    public void buildNotTested(IBuildInfo info) {
    }

    @Override
    public void cleanUp(IBuildInfo info) {
        if (!(info instanceof ClusterBuildInfo)) {
            throw new IllegalArgumentException("info is not an instance of ClusterBuildInfo");
        }
        FuseUtil fuseUtil = this.getFuseUtil();
        for (File dir : ((ClusterBuildInfo)info).getZipMounts()) {
            fuseUtil.unmountZip(dir);
            FileUtil.recursiveDelete(dir);
        }
    }

    TestResourceDownloader createTestResourceDownloader() {
        return new TestResourceDownloader();
    }

    void setRootDir(File rootDir) {
        this.mRootDir = rootDir;
    }

    void addTestResource(TestResource resource) throws JSONException {
        this.mTestResources.add(resource.toJson().toString());
    }

    List<TestResource> getTestResources() {
        return this.parseTestResources();
    }
}

