/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterCommand;
import com.android.tradefed.cluster.ClusterCommandEvent;
import com.android.tradefed.cluster.ClusterCommandStatus;
import com.android.tradefed.cluster.ClusterDeviceInfo;
import com.android.tradefed.cluster.ClusterEventUploader;
import com.android.tradefed.cluster.ClusterHostEvent;
import com.android.tradefed.cluster.IClusterClient;
import com.android.tradefed.cluster.IClusterEvent;
import com.android.tradefed.cluster.IClusterEventUploader;
import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.cluster.TestContext;
import com.android.tradefed.cluster.TestEnvironment;
import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRestApiHelper;
import com.android.tradefed.util.RestApiHelper;
import com.android.tradefed.util.StreamUtil;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterClient
implements IClusterClient {
    private static final String DEFAULT_TFC_URL_BASE = "https://tradefed-cluster.googleplex.com/_ah/api/tradefed_cluster/v1/";
    private IClusterOptions mClusterOptions;
    private IHostOptions mHostOptions;
    private IRestApiHelper mApiHelper = null;
    private IClusterEventUploader<ClusterCommandEvent> mCommandEventUploader = null;
    private IClusterEventUploader<ClusterHostEvent> mHostEventUploader = null;

    @Override
    public List<ClusterCommand> leaseHostCommands(String clusterId, String hostname, List<ClusterDeviceInfo> deviceInfos, List<String> nextClusterIds, int maxTasksTolease) throws JSONException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("cluster", clusterId);
        options.put("hostname", hostname);
        options.put("num_tasks", Integer.toString(maxTasksTolease));
        JSONObject data = new JSONObject();
        if (nextClusterIds != null && !nextClusterIds.isEmpty()) {
            JSONArray ids = new JSONArray();
            for (String id : nextClusterIds) {
                ids.put(id);
            }
            data.put("next_cluster_ids", ids);
        }
        JSONArray deviceInfoJsons = new JSONArray();
        for (ClusterDeviceInfo d : deviceInfos) {
            deviceInfoJsons.put(d.toJSON());
        }
        data.put("device_infos", deviceInfoJsons);
        try {
            HttpResponse httpResponse = this.getApiHelper().execute("POST", new String[]{"tasks", "leasehosttasks"}, options, data);
            return ClusterClient.parseCommandTasks(httpResponse);
        }
        catch (IOException e) {
            LogUtil.CLog.w("Failed to lease commands: %s", e);
            return Collections.emptyList();
        }
    }

    @Override
    public TestEnvironment getTestEnvironment(String requestId) throws IOException, JSONException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        HttpResponse response = this.getApiHelper().execute("GET", new String[]{"requests", requestId, "test_environment"}, options, null);
        String content = StreamUtil.getStringFromStream(response.getContent());
        LogUtil.CLog.d(content);
        return TestEnvironment.fromJson(new JSONObject(content));
    }

    @Override
    public List<TestResource> getTestResources(String requestId) throws IOException, JSONException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        HttpResponse response = this.getApiHelper().execute("GET", new String[]{"requests", requestId, "test_resources"}, options, null);
        String content = StreamUtil.getStringFromStream(response.getContent());
        LogUtil.CLog.d(content);
        JSONArray jsonArray = new JSONObject(content).optJSONArray("test_resources");
        if (jsonArray == null) {
            return new ArrayList<TestResource>();
        }
        return TestResource.fromJsonArray(jsonArray);
    }

    @Override
    public TestContext getTestContext(String requestId, String commandId) throws IOException, JSONException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        HttpResponse response = this.getApiHelper().execute("GET", new String[]{"requests", requestId, "commands", commandId, "test_context"}, options, null);
        String content = StreamUtil.getStringFromStream(response.getContent());
        LogUtil.CLog.d(content);
        return TestContext.fromJson(new JSONObject(content));
    }

    @Override
    public void updateTestContext(String requestId, String commandId, TestContext testContext) throws IOException, JSONException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        HttpResponse response = this.getApiHelper().execute("POST", new String[]{"requests", requestId, "commands", commandId, "test_context"}, options, testContext.toJson());
        String content = StreamUtil.getStringFromStream(response.getContent());
        LogUtil.CLog.d(content);
    }

    @Override
    public ClusterCommand.State getCommandState(String requestId, String commandId) {
        return this.getCommandStatus(requestId, commandId).getState();
    }

    @Override
    public ClusterCommandStatus getCommandStatus(String requestId, String commandId) {
        try {
            HttpResponse response = this.getApiHelper().execute("GET", new String[]{"requests", requestId, "commands", commandId}, new HashMap<String, Object>(), null);
            String content = StreamUtil.getStringFromStream(response.getContent());
            JSONObject jsonContent = new JSONObject(content);
            String value = jsonContent.getString("state");
            String cancelReason = jsonContent.optString("cancel_reason", "");
            return new ClusterCommandStatus(ClusterCommand.State.valueOf(value), cancelReason);
        }
        catch (IOException | IllegalArgumentException | JSONException e) {
            LogUtil.CLog.w("Failed to get state of request %s command %s", requestId, commandId);
            LogUtil.CLog.e(e);
            return new ClusterCommandStatus(ClusterCommand.State.UNKNOWN, "");
        }
    }

    private static List<ClusterCommand> parseCommandTasks(HttpResponse httpResponse) throws IOException {
        String response = "";
        InputStream content = httpResponse.getContent();
        if (content == null) {
            throw new IOException("null response");
        }
        response = StreamUtil.getStringFromStream(content);
        try {
            JSONObject jsonResponse = new JSONObject(response);
            if (jsonResponse.has("tasks")) {
                JSONArray jsonCommands = jsonResponse.getJSONArray("tasks");
                ArrayList<ClusterCommand> commandTasks = new ArrayList<ClusterCommand>(jsonCommands.length());
                for (int i = 0; i < jsonCommands.length(); ++i) {
                    JSONObject jsonCommand = jsonCommands.getJSONObject(i);
                    commandTasks.add(ClusterCommand.fromJson(jsonCommand));
                }
                return commandTasks;
            }
            return Collections.emptyList();
        }
        catch (JSONException e) {
            LogUtil.CLog.w("Failed to parse response from server: %s", response);
            return Collections.emptyList();
        }
    }

    private static JSONObject buildPostData(List<? extends IClusterEvent> events, String key) throws JSONException {
        JSONArray array = new JSONArray();
        for (IClusterEvent iClusterEvent : events) {
            array.put(iClusterEvent.toJSON());
        }
        JSONObject postData = new JSONObject();
        postData.put(key, array);
        return postData;
    }

    @Override
    public IClusterEventUploader<ClusterCommandEvent> getCommandEventUploader() {
        if (this.mCommandEventUploader == null) {
            this.mCommandEventUploader = new ClusterCommandEventUploader();
        }
        return this.mCommandEventUploader;
    }

    @Override
    public IClusterEventUploader<ClusterHostEvent> getHostEventUploader() {
        if (this.mHostEventUploader == null) {
            this.mHostEventUploader = new ClusterHostEventUploader();
        }
        return this.mHostEventUploader;
    }

    @VisibleForTesting
    IRestApiHelper getApiHelper() {
        if (this.mApiHelper == null) {
            NetHttpTransport transport = null;
            transport = new NetHttpTransport();
            HttpRequestFactory requestFactory = transport.createRequestFactory();
            String baseUrl = this.getClusterOptions().getServiceUrl();
            if (baseUrl == null) {
                baseUrl = DEFAULT_TFC_URL_BASE;
            }
            this.mApiHelper = new RestApiHelper(requestFactory, baseUrl);
        }
        return this.mApiHelper;
    }

    IClusterOptions getClusterOptions() {
        if (this.mClusterOptions == null) {
            this.mClusterOptions = (IClusterOptions)GlobalConfiguration.getInstance().getConfigurationObject("cluster_options");
            if (this.mClusterOptions == null) {
                throw new IllegalStateException("cluster_options not defined. You must add this object to your global config. See google/atp/cluster.xml.");
            }
        }
        return this.mClusterOptions;
    }

    IHostOptions getHostOptions() {
        if (this.mHostOptions == null) {
            this.mHostOptions = GlobalConfiguration.getInstance().getHostOptions();
        }
        return this.mHostOptions;
    }

    private class ClusterCommandEventUploader
    extends ClusterEventUploader<ClusterCommandEvent> {
        private static final String REST_API_METHOD = "command_events";
        private static final String DATA_KEY = "command_events";

        private ClusterCommandEventUploader() {
        }

        @Override
        protected void doUploadEvents(List<ClusterCommandEvent> events) throws IOException {
            try {
                JSONObject eventData = ClusterClient.buildPostData(events, "command_events");
                ClusterClient.this.getApiHelper().execute("POST", new String[]{"command_events"}, null, eventData);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
    }

    private class ClusterHostEventUploader
    extends ClusterEventUploader<ClusterHostEvent> {
        private static final String REST_API_METHOD = "host_events";
        private static final String DATA_KEY = "host_events";

        private ClusterHostEventUploader() {
        }

        @Override
        protected void doUploadEvents(List<ClusterHostEvent> events) throws IOException {
            try {
                JSONObject eventData = ClusterClient.buildPostData(events, "host_events");
                ClusterClient.this.getApiHelper().execute("POST", new String[]{"host_events"}, null, eventData);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
    }
}

